/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.bridge;

import com.facebook.infer.annotation.Assertions;
import com.facebook.jni.HybridData;
import com.facebook.proguard.annotations.DoNotStrip;
import com.facebook.react.bridge.Dynamic;
import com.facebook.react.bridge.DynamicFromMap;
import com.facebook.react.bridge.NativeMap;
import com.facebook.react.bridge.NoSuchKeyException;
import com.facebook.react.bridge.ReactBridge;
import com.facebook.react.bridge.ReadableArray;
import com.facebook.react.bridge.ReadableMap;
import com.facebook.react.bridge.ReadableMapKeySetIterator;
import com.facebook.react.bridge.ReadableNativeArray;
import com.facebook.react.bridge.ReadableType;
import com.facebook.react.config.ReactFeatureFlags;
import java.util.HashMap;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@DoNotStrip
public class ReadableNativeMap
extends NativeMap
implements ReadableMap {
    @Nullable
    private String[] mKeys;
    @Nullable
    private HashMap<String, Object> mLocalMap;
    @Nullable
    private HashMap<String, ReadableType> mLocalTypeMap;
    private static int mJniCallCounter;

    protected ReadableNativeMap(HybridData hybridData) {
        super(hybridData);
    }

    public static void setUseNativeAccessor(boolean useNativeAccessor) {
        ReactFeatureFlags.useMapNativeAccessor = useNativeAccessor;
    }

    public static int getJNIPassCounter() {
        return mJniCallCounter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HashMap<String, Object> getLocalMap() {
        if (this.mLocalMap != null) {
            return this.mLocalMap;
        }
        ReadableNativeMap readableNativeMap = this;
        synchronized (readableNativeMap) {
            if (this.mKeys == null) {
                this.mKeys = (String[])Assertions.assertNotNull((Object)this.importKeys());
                ++mJniCallCounter;
            }
            if (this.mLocalMap == null) {
                Object[] values = (Object[])Assertions.assertNotNull((Object)this.importValues());
                ++mJniCallCounter;
                int length = this.mKeys.length;
                this.mLocalMap = new HashMap(length);
                for (int i = 0; i < length; ++i) {
                    this.mLocalMap.put(this.mKeys[i], values[i]);
                }
            }
        }
        return this.mLocalMap;
    }

    private native String[] importKeys();

    private native Object[] importValues();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    private HashMap<String, ReadableType> getLocalTypeMap() {
        if (this.mLocalTypeMap != null) {
            return this.mLocalTypeMap;
        }
        ReadableNativeMap readableNativeMap = this;
        synchronized (readableNativeMap) {
            if (this.mKeys == null) {
                this.mKeys = (String[])Assertions.assertNotNull((Object)this.importKeys());
                ++mJniCallCounter;
            }
            if (this.mLocalTypeMap == null) {
                Object[] types = (Object[])Assertions.assertNotNull((Object)this.importTypes());
                ++mJniCallCounter;
                int length = this.mKeys.length;
                this.mLocalTypeMap = new HashMap(length);
                for (int i = 0; i < length; ++i) {
                    this.mLocalTypeMap.put(this.mKeys[i], (ReadableType)((Object)types[i]));
                }
            }
        }
        return this.mLocalTypeMap;
    }

    private native Object[] importTypes();

    @Override
    public boolean hasKey(@Nonnull String name) {
        if (ReactFeatureFlags.useMapNativeAccessor) {
            ++mJniCallCounter;
            return this.hasKeyNative(name);
        }
        return this.getLocalMap().containsKey(name);
    }

    private native boolean hasKeyNative(String var1);

    @Override
    public boolean isNull(@Nonnull String name) {
        if (ReactFeatureFlags.useMapNativeAccessor) {
            ++mJniCallCounter;
            return this.isNullNative(name);
        }
        if (this.getLocalMap().containsKey(name)) {
            return this.getLocalMap().get(name) == null;
        }
        throw new NoSuchKeyException(name);
    }

    private native boolean isNullNative(@Nonnull String var1);

    @Nonnull
    private Object getValue(@Nonnull String name) {
        if (this.hasKey(name) && !this.isNull(name)) {
            return Assertions.assertNotNull((Object)this.getLocalMap().get(name));
        }
        throw new NoSuchKeyException(name);
    }

    private <T> T getValue(String name, Class<T> type) {
        Object value = this.getValue(name);
        this.checkInstance(name, value, type);
        return (T)value;
    }

    @Nullable
    private Object getNullableValue(String name) {
        if (this.hasKey(name)) {
            return this.getLocalMap().get(name);
        }
        throw new NoSuchKeyException(name);
    }

    @Nullable
    private <T> T getNullableValue(String name, Class<T> type) {
        Object value = this.getNullableValue(name);
        this.checkInstance(name, value, type);
        return (T)value;
    }

    private void checkInstance(String name, Object value, Class type) {
        if (value != null && !type.isInstance(value)) {
            throw new ClassCastException("Value for " + name + " cannot be cast from " + value.getClass().getSimpleName() + " to " + type.getSimpleName());
        }
    }

    @Override
    public boolean getBoolean(@Nonnull String name) {
        if (ReactFeatureFlags.useMapNativeAccessor) {
            ++mJniCallCounter;
            return this.getBooleanNative(name);
        }
        return this.getValue(name, Boolean.class);
    }

    private native boolean getBooleanNative(String var1);

    @Override
    public double getDouble(@Nonnull String name) {
        if (ReactFeatureFlags.useMapNativeAccessor) {
            ++mJniCallCounter;
            return this.getDoubleNative(name);
        }
        return this.getValue(name, Double.class);
    }

    private native double getDoubleNative(String var1);

    @Override
    public int getInt(@Nonnull String name) {
        if (ReactFeatureFlags.useMapNativeAccessor) {
            ++mJniCallCounter;
            return this.getIntNative(name);
        }
        return this.getValue(name, Double.class).intValue();
    }

    private native int getIntNative(String var1);

    @Override
    @Nullable
    public String getString(@Nonnull String name) {
        if (ReactFeatureFlags.useMapNativeAccessor) {
            ++mJniCallCounter;
            return this.getStringNative(name);
        }
        return this.getNullableValue(name, String.class);
    }

    private native String getStringNative(String var1);

    @Override
    @Nullable
    public ReadableArray getArray(@Nonnull String name) {
        if (ReactFeatureFlags.useMapNativeAccessor) {
            ++mJniCallCounter;
            return this.getArrayNative(name);
        }
        return this.getNullableValue(name, ReadableArray.class);
    }

    private native ReadableNativeArray getArrayNative(String var1);

    @Override
    @Nullable
    public ReadableNativeMap getMap(@Nonnull String name) {
        if (ReactFeatureFlags.useMapNativeAccessor) {
            ++mJniCallCounter;
            return this.getMapNative(name);
        }
        return this.getNullableValue(name, ReadableNativeMap.class);
    }

    private native ReadableNativeMap getMapNative(String var1);

    @Override
    @Nonnull
    public ReadableType getType(@Nonnull String name) {
        if (ReactFeatureFlags.useMapNativeAccessor) {
            ++mJniCallCounter;
            return this.getTypeNative(name);
        }
        if (this.getLocalTypeMap().containsKey(name)) {
            return (ReadableType)((Object)Assertions.assertNotNull((Object)((Object)this.getLocalTypeMap().get(name))));
        }
        throw new NoSuchKeyException(name);
    }

    private native ReadableType getTypeNative(String var1);

    @Override
    @Nonnull
    public Dynamic getDynamic(@Nonnull String name) {
        return DynamicFromMap.create(this, name);
    }

    @Override
    @Nonnull
    public ReadableMapKeySetIterator keySetIterator() {
        return new ReadableNativeMapKeySetIterator(this);
    }

    @Override
    @Nonnull
    public HashMap<String, Object> toHashMap() {
        if (ReactFeatureFlags.useMapNativeAccessor) {
            ReadableMapKeySetIterator iterator = this.keySetIterator();
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            block13: while (iterator.hasNextKey()) {
                ++mJniCallCounter;
                String key = iterator.nextKey();
                ++mJniCallCounter;
                switch (this.getType(key)) {
                    case Null: {
                        hashMap.put(key, null);
                        continue block13;
                    }
                    case Boolean: {
                        hashMap.put(key, this.getBoolean(key));
                        continue block13;
                    }
                    case Number: {
                        hashMap.put(key, this.getDouble(key));
                        continue block13;
                    }
                    case String: {
                        hashMap.put(key, this.getString(key));
                        continue block13;
                    }
                    case Map: {
                        hashMap.put(key, ((ReadableNativeMap)Assertions.assertNotNull((Object)this.getMap(key))).toHashMap());
                        continue block13;
                    }
                    case Array: {
                        hashMap.put(key, ((ReadableArray)Assertions.assertNotNull((Object)this.getArray(key))).toArrayList());
                        continue block13;
                    }
                }
                throw new IllegalArgumentException("Could not convert object with key: " + key + ".");
            }
            return hashMap;
        }
        HashMap<String, Object> hashMap = new HashMap<String, Object>(this.getLocalMap());
        block14: for (String key : hashMap.keySet()) {
            switch (this.getType(key)) {
                case Null: 
                case Boolean: 
                case Number: 
                case String: {
                    continue block14;
                }
                case Map: {
                    hashMap.put(key, ((ReadableNativeMap)Assertions.assertNotNull((Object)this.getMap(key))).toHashMap());
                    continue block14;
                }
                case Array: {
                    hashMap.put(key, ((ReadableArray)Assertions.assertNotNull((Object)this.getArray(key))).toArrayList());
                    continue block14;
                }
            }
            throw new IllegalArgumentException("Could not convert object with key: " + key + ".");
        }
        return hashMap;
    }

    static {
        ReactBridge.staticInit();
    }

    @DoNotStrip
    private static class ReadableNativeMapKeySetIterator
    implements ReadableMapKeySetIterator {
        @DoNotStrip
        private final HybridData mHybridData;
        @DoNotStrip
        private final ReadableNativeMap mMap;

        public ReadableNativeMapKeySetIterator(ReadableNativeMap readableNativeMap) {
            this.mMap = readableNativeMap;
            this.mHybridData = ReadableNativeMapKeySetIterator.initHybrid(readableNativeMap);
        }

        @Override
        public native boolean hasNextKey();

        @Override
        public native String nextKey();

        private static native HybridData initHybrid(ReadableNativeMap var0);
    }
}

