/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.views.opengl;

import android.graphics.Canvas;
import android.graphics.SurfaceTexture;
import android.opengl.GLES20;
import android.opengl.GLSurfaceView;
import android.opengl.GLUtils;
import android.util.Log;
import android.view.Surface;
import com.facebook.react.views.opengl.DirectDrawer;
import com.facebook.react.views.opengl.ReactNativeGLRender;
import javax.microedition.khronos.egl.EGLConfig;
import javax.microedition.khronos.opengles.GL10;

public class ViewToGLRenderer
implements GLSurfaceView.Renderer,
ReactNativeGLRender {
    private static final String TAG = ViewToGLRenderer.class.getSimpleName();
    private SurfaceTexture mSurfaceTexture;
    private Surface mSurface;
    private int mGlSurfaceTexture;
    private Canvas mSurfaceCanvas;
    private DirectDrawer mDirectDrawer;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onDrawFrame(GL10 gl) {
        ViewToGLRenderer viewToGLRenderer = this;
        synchronized (viewToGLRenderer) {
            this.mSurfaceTexture.updateTexImage();
        }
        GLES20.glClearColor((float)0.0f, (float)0.0f, (float)1.0f, (float)1.0f);
        GLES20.glClear((int)16640);
        GLES20.glEnable((int)3042);
        GLES20.glBlendFunc((int)1, (int)771);
        float[] mtx = new float[16];
        this.mSurfaceTexture.getTransformMatrix(mtx);
        if (this.mDirectDrawer != null) {
            this.mDirectDrawer.draw(mtx);
        } else {
            this.mDirectDrawer = new DirectDrawer(this.mGlSurfaceTexture);
            this.mDirectDrawer.draw(mtx);
        }
    }

    public void onSurfaceChanged(GL10 gl, int width, int height) {
        this.releaseSurface();
        this.mGlSurfaceTexture = this.createTexture(width, height);
        if (this.mGlSurfaceTexture > 0) {
            this.mSurfaceTexture = new SurfaceTexture(this.mGlSurfaceTexture);
            this.mSurfaceTexture.setDefaultBufferSize(width, height);
            this.mSurface = new Surface(this.mSurfaceTexture);
            this.mDirectDrawer = new DirectDrawer(this.mGlSurfaceTexture);
        }
    }

    public void releaseSurface() {
        if (this.mSurface != null) {
            this.mSurface.release();
        }
        if (this.mSurfaceTexture != null) {
            this.mSurfaceTexture.release();
        }
        this.mSurface = null;
        this.mSurfaceTexture = null;
    }

    public void onSurfaceCreated(GL10 gl, EGLConfig config) {
        String extensions = GLES20.glGetString((int)7939);
        Log.d((String)TAG, (String)extensions);
    }

    private int createTexture(int width, int height) {
        int[] textures = new int[1];
        GLES20.glGenTextures((int)1, (int[])textures, (int)0);
        this.checkGlError("Texture generate");
        int glSurfaceTex = textures[0];
        if (glSurfaceTex > 0) {
            GLES20.glBindTexture((int)36197, (int)glSurfaceTex);
            GLES20.glTexImage2D((int)3553, (int)0, (int)6407, (int)width, (int)height, (int)0, (int)6407, (int)5121, null);
            GLES20.glTexParameteri((int)36197, (int)10241, (int)9728);
            GLES20.glTexParameteri((int)36197, (int)10240, (int)9728);
            GLES20.glTexParameteri((int)36197, (int)10242, (int)33071);
            GLES20.glTexParameteri((int)36197, (int)10243, (int)33071);
        }
        return glSurfaceTex;
    }

    public int getGLSurfaceTexture() {
        return this.mGlSurfaceTexture;
    }

    @Override
    public Canvas onDrawViewBegin() {
        this.mSurfaceCanvas = null;
        if (this.mSurface != null) {
            this.mSurface.release();
            this.mSurface = null;
            this.mSurface = new Surface(this.mSurfaceTexture);
        }
        if (this.mSurface != null) {
            try {
                this.mSurfaceCanvas = this.mSurface.lockCanvas(null);
            }
            catch (Exception e) {
                Log.e((String)TAG, (String)("error while rendering view to gl: " + e));
            }
        }
        return this.mSurfaceCanvas;
    }

    @Override
    public void onDrawViewEnd() {
        if (this.mSurfaceCanvas != null) {
            this.mSurface.unlockCanvasAndPost(this.mSurfaceCanvas);
        }
        this.mSurfaceCanvas = null;
    }

    public void checkGlError(String op) {
        int error;
        while ((error = GLES20.glGetError()) != 0) {
            Log.e((String)TAG, (String)(op + ": glError " + GLUtils.getEGLErrorString((int)error)));
        }
    }
}

