/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.views.text;

import android.content.Context;
import android.content.res.AssetManager;
import android.graphics.Typeface;
import android.text.TextUtils;
import android.util.SparseArray;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;

public class ReactFontManager {
    private static GetChannelPathListener mGetChannelPathListener;
    private static final String[] EXTENSIONS;
    private static final String[] FILE_EXTENSIONS;
    private static final String FONTS_ASSET_PATH = "fonts/";
    private static ReactFontManager sReactFontManagerInstance;
    private Map<String, FontFamily> mFontCache = new HashMap<String, FontFamily>();

    public static void setGetChannelPathListener(GetChannelPathListener listener) {
        mGetChannelPathListener = listener;
    }

    private ReactFontManager() {
    }

    public static ReactFontManager getInstance() {
        if (sReactFontManagerInstance == null) {
            sReactFontManagerInstance = new ReactFontManager();
        }
        return sReactFontManagerInstance;
    }

    @Nullable
    public Typeface getTypeface(String fontFamilyName, int style2, AssetManager assetManager) {
        return this.getTypeface(fontFamilyName, style2, null, assetManager);
    }

    @Nullable
    public Typeface getTypeface(String fontFamilyName, int style2, Context context, AssetManager assetManager) {
        Typeface typeface;
        FontFamily fontFamily = this.mFontCache.get(fontFamilyName);
        if (fontFamily == null) {
            fontFamily = new FontFamily();
            this.mFontCache.put(fontFamilyName, fontFamily);
        }
        if ((typeface = fontFamily.getTypeface(style2)) == null && (typeface = ReactFontManager.createTypeface(fontFamilyName, style2, context, assetManager)) != null) {
            fontFamily.setTypeface(style2, typeface);
        }
        return typeface;
    }

    public void setTypeface(String fontFamilyName, int style2, Typeface typeface) {
        if (typeface != null) {
            FontFamily fontFamily = this.mFontCache.get(fontFamilyName);
            if (fontFamily == null) {
                fontFamily = new FontFamily();
                this.mFontCache.put(fontFamilyName, fontFamily);
            }
            fontFamily.setTypeface(style2, typeface);
        }
    }

    @Nullable
    private static Typeface createTypeface(String fontFamilyName, int style2, Context context, AssetManager assetManager) {
        String extension = EXTENSIONS[style2];
        for (String fileExtension : FILE_EXTENSIONS) {
            String fileName = FONTS_ASSET_PATH + fontFamilyName + extension + fileExtension;
            try {
                return Typeface.createFromAsset((AssetManager)assetManager, (String)fileName);
            }
            catch (RuntimeException e) {
                try {
                    File fileDir;
                    File bundleFileDir;
                    if (context == null || (bundleFileDir = new File(fileDir = context.getFilesDir(), "bundles")) == null || !bundleFileDir.isDirectory()) continue;
                    for (File file : bundleFileDir.listFiles()) {
                        if (!file.isDirectory()) continue;
                        for (File channelDir : file.listFiles()) {
                            File fontFile;
                            if (!channelDir.isDirectory()) continue;
                            String channel = channelDir.getName();
                            String chanelPath = null;
                            if (mGetChannelPathListener != null) {
                                chanelPath = mGetChannelPathListener.getChannelPath(channel);
                            }
                            if (TextUtils.isEmpty(chanelPath) || !(fontFile = new File(chanelPath, fileName)).exists()) continue;
                            try {
                                return Typeface.createFromFile((File)fontFile);
                            }
                            catch (RuntimeException runtimeException) {
                                // empty catch block
                            }
                        }
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return Typeface.create((String)fontFamilyName, (int)style2);
    }

    static {
        EXTENSIONS = new String[]{"", "_bold", "_italic", "_bold_italic"};
        FILE_EXTENSIONS = new String[]{".ttf", ".otf"};
    }

    private static class FontFamily {
        private SparseArray<Typeface> mTypefaceSparseArray = new SparseArray(4);

        private FontFamily() {
        }

        public Typeface getTypeface(int style2) {
            return (Typeface)this.mTypefaceSparseArray.get(style2);
        }

        public void setTypeface(int style2, Typeface typeface) {
            this.mTypefaceSparseArray.put(style2, (Object)typeface);
        }
    }

    public static interface GetChannelPathListener {
        public String getChannelPath(String var1);
    }
}

