/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.views.slider;

import com.facebook.react.bridge.Arguments;
import com.facebook.react.bridge.WritableMap;
import com.facebook.react.uimanager.events.Event;
import com.facebook.react.uimanager.events.RCTEventEmitter;

public class ReactSliderEvent
extends Event<ReactSliderEvent> {
    public static final String EVENT_NAME = "topChange";
    private final double mValue;
    private final boolean mFromUser;

    public ReactSliderEvent(int viewId, double value, boolean fromUser) {
        super(viewId);
        this.mValue = value;
        this.mFromUser = fromUser;
    }

    public double getValue() {
        return this.mValue;
    }

    public boolean isFromUser() {
        return this.mFromUser;
    }

    @Override
    public String getEventName() {
        return EVENT_NAME;
    }

    @Override
    public short getCoalescingKey() {
        return 0;
    }

    @Override
    public void dispatch(RCTEventEmitter rctEventEmitter) {
        rctEventEmitter.receiveEvent(this.getViewTag(), this.getEventName(), this.serializeEventData());
    }

    private WritableMap serializeEventData() {
        WritableMap eventData = Arguments.createMap();
        eventData.putInt("target", this.getViewTag());
        eventData.putDouble("value", this.getValue());
        eventData.putBoolean("fromUser", this.isFromUser());
        return eventData;
    }
}

