/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.views.scroll;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Rect;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.util.Log;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.widget.OverScroller;
import android.widget.ScrollView;
import androidx.core.view.ViewCompat;
import com.facebook.infer.annotation.Assertions;
import com.facebook.react.bridge.ReactContext;
import com.facebook.react.uimanager.MeasureSpecAssertions;
import com.facebook.react.uimanager.ReactClippingViewGroup;
import com.facebook.react.uimanager.ReactClippingViewGroupHelper;
import com.facebook.react.uimanager.events.NativeGestureUtil;
import com.facebook.react.views.scroll.FpsListener;
import com.facebook.react.views.scroll.OnScrollDispatchHelper;
import com.facebook.react.views.scroll.ReactScrollViewHelper;
import com.facebook.react.views.scroll.VelocityHelper;
import com.facebook.react.views.view.ReactViewBackgroundManager;
import java.lang.reflect.Field;
import java.util.List;
import javax.annotation.Nullable;

public class ReactScrollView
extends ScrollView
implements ReactClippingViewGroup,
ViewGroup.OnHierarchyChangeListener,
View.OnLayoutChangeListener {
    @Nullable
    private static Field sScrollerField;
    private static boolean sTriedToGetScrollerField;
    private final OnScrollDispatchHelper mOnScrollDispatchHelper = new OnScrollDispatchHelper();
    @Nullable
    private final OverScroller mScroller;
    private final VelocityHelper mVelocityHelper = new VelocityHelper();
    private final Rect mRect = new Rect();
    private boolean mActivelyScrolling;
    @Nullable
    private Rect mClippingRect;
    @Nullable
    private String mOverflow = "hidden";
    private boolean mDragging;
    private boolean mPagingEnabled = false;
    @Nullable
    private Runnable mPostTouchRunnable;
    private boolean mRemoveClippedSubviews;
    private boolean mScrollEnabled = true;
    private boolean mSendMomentumEvents;
    @Nullable
    private FpsListener mFpsListener = null;
    @Nullable
    private String mScrollPerfTag;
    @Nullable
    private Drawable mEndBackground;
    private int mEndFillColor = 0;
    private int mSnapInterval = 0;
    private float mDecelerationRate = 0.985f;
    @Nullable
    private List<Integer> mSnapOffsets;
    private boolean mSnapToStart = true;
    private boolean mSnapToEnd = true;
    private View mContentView;
    private ReactViewBackgroundManager mReactBackgroundManager;

    public ReactScrollView(ReactContext context) {
        this(context, null);
    }

    public ReactScrollView(ReactContext context, @Nullable FpsListener fpsListener) {
        super((Context)context);
        this.mFpsListener = fpsListener;
        this.mReactBackgroundManager = new ReactViewBackgroundManager((View)this);
        this.mScroller = this.getOverScrollerFromParent();
        this.setOnHierarchyChangeListener(this);
        this.setScrollBarStyle(0x2000000);
    }

    @Nullable
    private OverScroller getOverScrollerFromParent() {
        OverScroller scroller;
        if (!sTriedToGetScrollerField) {
            sTriedToGetScrollerField = true;
            try {
                sScrollerField = ScrollView.class.getDeclaredField("mScroller");
                sScrollerField.setAccessible(true);
            }
            catch (NoSuchFieldException e) {
                Log.w((String)"ReactNative", (String)"Failed to get mScroller field for ScrollView! This app will exhibit the bounce-back scrolling bug :(");
            }
        }
        if (sScrollerField != null) {
            try {
                Object scrollerValue = sScrollerField.get(this);
                if (scrollerValue instanceof OverScroller) {
                    scroller = (OverScroller)scrollerValue;
                }
                Log.w((String)"ReactNative", (String)"Failed to cast mScroller field in ScrollView (probably due to OEM changes to AOSP)! This app will exhibit the bounce-back scrolling bug :(");
                scroller = null;
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException("Failed to get mScroller from ScrollView!", e);
            }
        } else {
            scroller = null;
        }
        return scroller;
    }

    public void setSendMomentumEvents(boolean sendMomentumEvents) {
        this.mSendMomentumEvents = sendMomentumEvents;
    }

    public void setScrollPerfTag(@Nullable String scrollPerfTag) {
        this.mScrollPerfTag = scrollPerfTag;
    }

    public void setScrollEnabled(boolean scrollEnabled) {
        this.mScrollEnabled = scrollEnabled;
    }

    public void setPagingEnabled(boolean pagingEnabled) {
        this.mPagingEnabled = pagingEnabled;
    }

    public void setDecelerationRate(float decelerationRate) {
        this.mDecelerationRate = decelerationRate;
        if (this.mScroller != null) {
            this.mScroller.setFriction(1.0f - this.mDecelerationRate);
        }
    }

    public void setSnapInterval(int snapInterval) {
        this.mSnapInterval = snapInterval;
    }

    public void setSnapOffsets(List<Integer> snapOffsets) {
        this.mSnapOffsets = snapOffsets;
    }

    public void setSnapToStart(boolean snapToStart) {
        this.mSnapToStart = snapToStart;
    }

    public void setSnapToEnd(boolean snapToEnd) {
        this.mSnapToEnd = snapToEnd;
    }

    public void flashScrollIndicators() {
        this.awakenScrollBars();
    }

    public void setOverflow(String overflow) {
        this.mOverflow = overflow;
        this.invalidate();
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        MeasureSpecAssertions.assertExplicitMeasureSpec(widthMeasureSpec, heightMeasureSpec);
        this.setMeasuredDimension(View.MeasureSpec.getSize((int)widthMeasureSpec), View.MeasureSpec.getSize((int)heightMeasureSpec));
    }

    protected void onLayout(boolean changed, int l, int t, int r, int b) {
        this.scrollTo(this.getScrollX(), this.getScrollY());
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        super.onSizeChanged(w, h, oldw, oldh);
        if (this.mRemoveClippedSubviews) {
            this.updateClippingRect();
        }
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        if (this.mRemoveClippedSubviews) {
            this.updateClippingRect();
        }
    }

    protected void onScrollChanged(int x, int y, int oldX, int oldY) {
        super.onScrollChanged(x, y, oldX, oldY);
        this.mActivelyScrolling = true;
        if (this.mOnScrollDispatchHelper.onScrollChanged(x, y)) {
            if (this.mRemoveClippedSubviews) {
                this.updateClippingRect();
            }
            ReactScrollViewHelper.emitScrollEvent((ViewGroup)this, this.mOnScrollDispatchHelper.getXFlingVelocity(), this.mOnScrollDispatchHelper.getYFlingVelocity());
        }
    }

    public boolean onInterceptTouchEvent(MotionEvent ev) {
        if (!this.mScrollEnabled) {
            return false;
        }
        try {
            if (super.onInterceptTouchEvent(ev)) {
                NativeGestureUtil.notifyNativeGestureStarted((View)this, ev);
                ReactScrollViewHelper.emitScrollBeginDragEvent((ViewGroup)this);
                this.mDragging = true;
                this.enableFpsListener();
                return true;
            }
        }
        catch (IllegalArgumentException e) {
            Log.w((String)"ReactNative", (String)"Error intercepting touch event.", (Throwable)e);
        }
        return false;
    }

    public boolean onTouchEvent(MotionEvent ev) {
        if (!this.mScrollEnabled) {
            return false;
        }
        this.mVelocityHelper.calculateVelocity(ev);
        int action = ev.getAction() & 0xFF;
        if (action == 1 && this.mDragging) {
            float velocityX = this.mVelocityHelper.getXVelocity();
            float velocityY = this.mVelocityHelper.getYVelocity();
            ReactScrollViewHelper.emitScrollEndDragEvent((ViewGroup)this, velocityX, velocityY);
            this.mDragging = false;
            this.handlePostTouchScrolling(Math.round(velocityX), Math.round(velocityY));
        }
        return super.onTouchEvent(ev);
    }

    @Override
    public void setRemoveClippedSubviews(boolean removeClippedSubviews) {
        if (removeClippedSubviews && this.mClippingRect == null) {
            this.mClippingRect = new Rect();
        }
        this.mRemoveClippedSubviews = removeClippedSubviews;
        this.updateClippingRect();
    }

    @Override
    public boolean getRemoveClippedSubviews() {
        return this.mRemoveClippedSubviews;
    }

    @Override
    public void updateClippingRect() {
        if (!this.mRemoveClippedSubviews) {
            return;
        }
        Assertions.assertNotNull((Object)this.mClippingRect);
        ReactClippingViewGroupHelper.calculateClippingRect((View)this, this.mClippingRect);
        View contentView = this.getChildAt(0);
        if (contentView instanceof ReactClippingViewGroup) {
            ((ReactClippingViewGroup)contentView).updateClippingRect();
        }
    }

    @Override
    public void getClippingRect(Rect outClippingRect) {
        outClippingRect.set((Rect)Assertions.assertNotNull((Object)this.mClippingRect));
    }

    public void fling(int velocityY) {
        int correctedVelocityY = (int)((float)Math.abs(velocityY) * Math.signum(this.mOnScrollDispatchHelper.getYFlingVelocity()));
        if (this.mPagingEnabled) {
            this.flingAndSnap(correctedVelocityY);
        } else if (this.mScroller != null) {
            int scrollWindowHeight = this.getHeight() - this.getPaddingBottom() - this.getPaddingTop();
            this.mScroller.fling(this.getScrollX(), this.getScrollY(), 0, correctedVelocityY, 0, 0, 0, Integer.MAX_VALUE, 0, scrollWindowHeight / 2);
            ViewCompat.postInvalidateOnAnimation((View)this);
        } else {
            super.fling(correctedVelocityY);
        }
        this.handlePostTouchScrolling(0, correctedVelocityY);
    }

    private void enableFpsListener() {
        if (this.isScrollPerfLoggingEnabled()) {
            Assertions.assertNotNull((Object)this.mFpsListener);
            Assertions.assertNotNull((Object)this.mScrollPerfTag);
            this.mFpsListener.enable(this.mScrollPerfTag);
        }
    }

    private void disableFpsListener() {
        if (this.isScrollPerfLoggingEnabled()) {
            Assertions.assertNotNull((Object)this.mFpsListener);
            Assertions.assertNotNull((Object)this.mScrollPerfTag);
            this.mFpsListener.disable(this.mScrollPerfTag);
        }
    }

    private boolean isScrollPerfLoggingEnabled() {
        return this.mFpsListener != null && this.mScrollPerfTag != null && !this.mScrollPerfTag.isEmpty();
    }

    private int getMaxScrollY() {
        int contentHeight = this.mContentView.getHeight();
        int viewportHeight = this.getHeight() - this.getPaddingBottom() - this.getPaddingTop();
        return Math.max(0, contentHeight - viewportHeight);
    }

    public void draw(Canvas canvas) {
        if (this.mEndFillColor != 0) {
            View content = this.getChildAt(0);
            if (this.mEndBackground != null && content != null && content.getBottom() < this.getHeight()) {
                this.mEndBackground.setBounds(0, content.getBottom(), this.getWidth(), this.getHeight());
                this.mEndBackground.draw(canvas);
            }
        }
        this.getDrawingRect(this.mRect);
        switch (this.mOverflow) {
            case "visible": {
                break;
            }
            default: {
                canvas.clipRect(this.mRect);
            }
        }
        super.draw(canvas);
    }

    private void handlePostTouchScrolling(int velocityX, int velocityY) {
        if (!(this.mSendMomentumEvents || this.mPagingEnabled || this.isScrollPerfLoggingEnabled())) {
            return;
        }
        if (this.mPostTouchRunnable != null) {
            return;
        }
        if (this.mSendMomentumEvents) {
            this.enableFpsListener();
            ReactScrollViewHelper.emitScrollMomentumBeginEvent((ViewGroup)this, velocityX, velocityY);
        }
        this.mActivelyScrolling = false;
        this.mPostTouchRunnable = new Runnable(){
            private boolean mSnappingToPage = false;

            @Override
            public void run() {
                if (ReactScrollView.this.mActivelyScrolling) {
                    ReactScrollView.this.mActivelyScrolling = false;
                    ViewCompat.postOnAnimationDelayed((View)ReactScrollView.this, (Runnable)this, (long)20L);
                } else if (ReactScrollView.this.mPagingEnabled && !this.mSnappingToPage) {
                    this.mSnappingToPage = true;
                    ReactScrollView.this.flingAndSnap(0);
                    ViewCompat.postOnAnimationDelayed((View)ReactScrollView.this, (Runnable)this, (long)20L);
                } else {
                    if (ReactScrollView.this.mSendMomentumEvents) {
                        ReactScrollViewHelper.emitScrollMomentumEndEvent((ViewGroup)ReactScrollView.this);
                    }
                    ReactScrollView.this.mPostTouchRunnable = null;
                    ReactScrollView.this.disableFpsListener();
                }
            }
        };
        ViewCompat.postOnAnimationDelayed((View)this, (Runnable)this.mPostTouchRunnable, (long)20L);
    }

    private int predictFinalScrollPosition(int velocityY) {
        OverScroller scroller = new OverScroller(this.getContext());
        scroller.setFriction(1.0f - this.mDecelerationRate);
        int maximumOffset = this.getMaxScrollY();
        int height = this.getHeight() - this.getPaddingBottom() - this.getPaddingTop();
        scroller.fling(this.getScrollX(), this.getScrollY(), 0, velocityY, 0, 0, 0, maximumOffset, 0, height / 2);
        return scroller.getFinalY();
    }

    private void smoothScrollAndSnap(int velocity) {
        double interval = this.getSnapInterval();
        double currentOffset = this.getScrollY();
        double targetOffset = this.predictFinalScrollPosition(velocity);
        int previousPage = (int)Math.floor(currentOffset / interval);
        int nextPage = (int)Math.ceil(currentOffset / interval);
        int currentPage = (int)Math.round(currentOffset / interval);
        int targetPage = (int)Math.round(targetOffset / interval);
        if (velocity > 0 && nextPage == previousPage) {
            ++nextPage;
        } else if (velocity < 0 && previousPage == nextPage) {
            --previousPage;
        }
        if (velocity > 0 && currentPage < nextPage && targetPage > previousPage) {
            currentPage = nextPage;
        } else if (velocity < 0 && currentPage > previousPage && targetPage < nextPage) {
            currentPage = previousPage;
        }
        targetOffset = (double)currentPage * interval;
        if (targetOffset != currentOffset) {
            this.mActivelyScrolling = true;
            this.smoothScrollTo(this.getScrollX(), (int)targetOffset);
        }
    }

    private void flingAndSnap(int velocityY) {
        int nearestOffset;
        if (this.getChildCount() <= 0) {
            return;
        }
        if (this.mSnapInterval == 0 && this.mSnapOffsets == null) {
            this.smoothScrollAndSnap(velocityY);
            return;
        }
        int maximumOffset = this.getMaxScrollY();
        int targetOffset = this.predictFinalScrollPosition(velocityY);
        int smallerOffset = 0;
        int largerOffset = maximumOffset;
        int firstOffset = 0;
        int lastOffset = maximumOffset;
        int height = this.getHeight() - this.getPaddingBottom() - this.getPaddingTop();
        if (this.mSnapOffsets != null) {
            firstOffset = this.mSnapOffsets.get(0);
            lastOffset = this.mSnapOffsets.get(this.mSnapOffsets.size() - 1);
            for (int i = 0; i < this.mSnapOffsets.size(); ++i) {
                int offset = this.mSnapOffsets.get(i);
                if (offset <= targetOffset && targetOffset - offset < targetOffset - smallerOffset) {
                    smallerOffset = offset;
                }
                if (offset < targetOffset || offset - targetOffset >= largerOffset - targetOffset) continue;
                largerOffset = offset;
            }
        } else {
            double interval = this.getSnapInterval();
            double ratio = (double)targetOffset / interval;
            smallerOffset = (int)(Math.floor(ratio) * interval);
            largerOffset = Math.min((int)(Math.ceil(ratio) * interval), maximumOffset);
        }
        int n = nearestOffset = targetOffset - smallerOffset < largerOffset - targetOffset ? smallerOffset : largerOffset;
        if (!this.mSnapToEnd && targetOffset >= lastOffset) {
            if (this.getScrollY() < lastOffset) {
                targetOffset = lastOffset;
            }
        } else if (!this.mSnapToStart && targetOffset <= firstOffset) {
            if (this.getScrollY() > firstOffset) {
                targetOffset = firstOffset;
            }
        } else if (velocityY > 0) {
            velocityY += (int)((double)(largerOffset - targetOffset) * 10.0);
            targetOffset = largerOffset;
        } else if (velocityY < 0) {
            velocityY -= (int)((double)(targetOffset - smallerOffset) * 10.0);
            targetOffset = smallerOffset;
        } else {
            targetOffset = nearestOffset;
        }
        targetOffset = Math.min(Math.max(0, targetOffset), maximumOffset);
        if (this.mScroller != null) {
            this.mActivelyScrolling = true;
            this.mScroller.fling(this.getScrollX(), this.getScrollY(), 0, velocityY != 0 ? velocityY : targetOffset - this.getScrollY(), 0, 0, targetOffset, targetOffset, 0, targetOffset == 0 || targetOffset == maximumOffset ? height / 2 : 0);
            this.postInvalidateOnAnimation();
        } else {
            this.smoothScrollTo(this.getScrollX(), targetOffset);
        }
    }

    private int getSnapInterval() {
        if (this.mSnapInterval != 0) {
            return this.mSnapInterval;
        }
        return this.getHeight();
    }

    public void setEndFillColor(int color) {
        if (color != this.mEndFillColor) {
            this.mEndFillColor = color;
            this.mEndBackground = new ColorDrawable(this.mEndFillColor);
        }
    }

    protected void onOverScrolled(int scrollX, int scrollY, boolean clampedX, boolean clampedY) {
        int scrollRange;
        if (this.mScroller != null && !this.mScroller.isFinished() && this.mScroller.getCurrY() != this.mScroller.getFinalY() && scrollY >= (scrollRange = this.getMaxScrollY())) {
            this.mScroller.abortAnimation();
            scrollY = scrollRange;
        }
        super.onOverScrolled(scrollX, scrollY, clampedX, clampedY);
    }

    public void onChildViewAdded(View parent, View child) {
        this.mContentView = child;
        this.mContentView.addOnLayoutChangeListener((View.OnLayoutChangeListener)this);
    }

    public void onChildViewRemoved(View parent, View child) {
        this.mContentView.removeOnLayoutChangeListener((View.OnLayoutChangeListener)this);
        this.mContentView = null;
    }

    public void onLayoutChange(View v, int left, int top, int right, int bottom, int oldLeft, int oldTop, int oldRight, int oldBottom) {
        int maxScrollY;
        if (this.mContentView == null) {
            return;
        }
        int currentScrollY = this.getScrollY();
        if (currentScrollY > (maxScrollY = this.getMaxScrollY())) {
            this.scrollTo(this.getScrollX(), maxScrollY);
        }
    }

    public void setBackgroundColor(int color) {
        this.mReactBackgroundManager.setBackgroundColor(color);
    }

    public void setBorderWidth(int position, float width) {
        this.mReactBackgroundManager.setBorderWidth(position, width);
    }

    public void setBorderColor(int position, float color, float alpha) {
        this.mReactBackgroundManager.setBorderColor(position, color, alpha);
    }

    public void setBorderRadius(float borderRadius) {
        this.mReactBackgroundManager.setBorderRadius(borderRadius);
    }

    public void setBorderRadius(float borderRadius, int position) {
        this.mReactBackgroundManager.setBorderRadius(borderRadius, position);
    }

    public void setBorderStyle(@Nullable String style2) {
        this.mReactBackgroundManager.setBorderStyle(style2);
    }

    static {
        sTriedToGetScrollerField = false;
    }
}

