/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.views.opengl;

import android.graphics.Canvas;
import android.graphics.SurfaceTexture;
import android.opengl.GLES20;
import android.opengl.GLSurfaceView;
import android.opengl.GLUtils;
import android.util.Log;
import android.view.Surface;
import com.facebook.react.views.opengl.ReactNativeGLRender;
import javax.microedition.khronos.egl.EGLConfig;
import javax.microedition.khronos.opengles.GL10;

public class ViewToGLRenderer
implements GLSurfaceView.Renderer,
ReactNativeGLRender {
    private static final String TAG = ViewToGLRenderer.class.getSimpleName();
    private static final int DEFAULT_TEXTURE_WIDTH = 500;
    private static final int DEFAULT_TEXTURE_HEIGHT = 500;
    private SurfaceTexture mSurfaceTexture;
    private Surface mSurface;
    private int mGlSurfaceTexture;
    private Canvas mSurfaceCanvas;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onDrawFrame(GL10 gl) {
        ViewToGLRenderer viewToGLRenderer = this;
        synchronized (viewToGLRenderer) {
            this.mSurfaceTexture.updateTexImage();
        }
    }

    public void onSurfaceChanged(GL10 gl, int width, int height) {
        this.releaseSurface();
        this.mGlSurfaceTexture = this.createTexture();
        if (this.mGlSurfaceTexture > 0) {
            this.mSurfaceTexture = new SurfaceTexture(this.mGlSurfaceTexture);
            this.mSurfaceTexture.setDefaultBufferSize(width, height);
            this.mSurface = new Surface(this.mSurfaceTexture);
        }
    }

    public void releaseSurface() {
        if (this.mSurface != null) {
            this.mSurface.release();
        }
        if (this.mSurfaceTexture != null) {
            this.mSurfaceTexture.release();
        }
        this.mSurface = null;
        this.mSurfaceTexture = null;
    }

    public void onSurfaceCreated(GL10 gl, EGLConfig config) {
        String extensions = GLES20.glGetString((int)7939);
        Log.d((String)TAG, (String)extensions);
    }

    private int createTexture() {
        int[] textures = new int[1];
        GLES20.glActiveTexture((int)33984);
        GLES20.glGenTextures((int)1, (int[])textures, (int)0);
        this.checkGlError("Texture generate");
        GLES20.glBindTexture((int)36197, (int)textures[0]);
        this.checkGlError("Texture bind");
        GLES20.glTexParameterf((int)36197, (int)10241, (float)9729.0f);
        GLES20.glTexParameterf((int)36197, (int)10240, (float)9729.0f);
        GLES20.glTexParameteri((int)36197, (int)10242, (int)33071);
        GLES20.glTexParameteri((int)36197, (int)10243, (int)33071);
        return textures[0];
    }

    public int getGLSurfaceTexture() {
        return this.mGlSurfaceTexture;
    }

    @Override
    public Canvas onDrawViewBegin() {
        this.mSurfaceCanvas = null;
        if (this.mSurface != null) {
            try {
                this.mSurfaceCanvas = this.mSurface.lockCanvas(null);
            }
            catch (Exception e) {
                Log.e((String)TAG, (String)("error while rendering view to gl: " + e));
            }
        }
        return this.mSurfaceCanvas;
    }

    @Override
    public void onDrawViewEnd() {
        if (this.mSurfaceCanvas != null) {
            this.mSurface.unlockCanvasAndPost(this.mSurfaceCanvas);
        }
        this.mSurfaceCanvas = null;
    }

    public void checkGlError(String op) {
        int error;
        while ((error = GLES20.glGetError()) != 0) {
            Log.e((String)TAG, (String)(op + ": glError " + GLUtils.getEGLErrorString((int)error)));
        }
    }
}

