/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.modules.fresco;

import android.app.ActivityManager;
import android.content.Context;
import android.os.Build;
import androidx.annotation.Nullable;
import com.facebook.common.internal.Supplier;
import com.facebook.common.logging.FLog;
import com.facebook.drawee.backends.pipeline.Fresco;
import com.facebook.imagepipeline.backends.okhttp3.OkHttpImagePipelineConfigFactory;
import com.facebook.imagepipeline.cache.MemoryCacheParams;
import com.facebook.imagepipeline.core.ImagePipelineConfig;
import com.facebook.imagepipeline.producers.NetworkFetcher;
import com.facebook.react.bridge.LifecycleEventListener;
import com.facebook.react.bridge.ReactApplicationContext;
import com.facebook.react.bridge.ReactContextBaseJavaModule;
import com.facebook.react.module.annotations.ReactModule;
import com.facebook.react.modules.common.ModuleDataCleaner;
import com.facebook.react.modules.fresco.ReactOkHttpNetworkFetcher;
import com.facebook.react.modules.fresco.SystraceRequestListener;
import com.facebook.react.modules.network.CookieJarContainer;
import com.facebook.react.modules.network.ForwardingCookieHandler;
import com.facebook.react.modules.network.OkHttpClientProvider;
import java.net.CookieHandler;
import java.util.HashSet;
import okhttp3.CookieJar;
import okhttp3.JavaNetCookieJar;
import okhttp3.OkHttpClient;

@ReactModule(name="FrescoModule", needsEagerInit=true)
public class FrescoModule
extends ReactContextBaseJavaModule
implements ModuleDataCleaner.Cleanable,
LifecycleEventListener {
    public static final String NAME = "FrescoModule";
    private final boolean mClearOnDestroy;
    @Nullable
    private static ImagePipelineConfig mConfig;
    private static boolean sHasBeenInitialized;

    public FrescoModule(ReactApplicationContext reactContext) {
        this(reactContext, true, null);
    }

    public FrescoModule(ReactApplicationContext reactContext, boolean clearOnDestroy) {
        this(reactContext, clearOnDestroy, null);
    }

    public FrescoModule(ReactApplicationContext reactContext, boolean clearOnDestroy, @Nullable ImagePipelineConfig config) {
        super(reactContext);
        this.mClearOnDestroy = clearOnDestroy;
        mConfig = config;
    }

    @Override
    public void initialize() {
        super.initialize();
        this.getReactApplicationContext().addLifecycleEventListener(this);
        if (!FrescoModule.hasBeenInitialized()) {
            FrescoModule.initFresco(this.getReactApplicationContext().getApplicationContext());
        } else if (mConfig != null) {
            FLog.w((String)"ReactNative", (String)"Fresco has already been initialized with a different config. The new Fresco configuration will be ignored!");
        }
        mConfig = null;
    }

    public static void initFresco(Context context) {
        if (context == null) {
            return;
        }
        if (!FrescoModule.hasBeenInitialized()) {
            if (mConfig == null) {
                mConfig = FrescoModule.getDefaultConfig(context);
            }
            Fresco.initialize((Context)context, (ImagePipelineConfig)mConfig);
            sHasBeenInitialized = true;
        }
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public void clearSensitiveData() {
        Fresco.getImagePipeline().clearCaches();
    }

    public static boolean hasBeenInitialized() {
        return sHasBeenInitialized;
    }

    private static ImagePipelineConfig getDefaultConfig(Context context) {
        return FrescoModule.getDefaultConfigBuilder(context).build();
    }

    public static ImagePipelineConfig.Builder getDefaultConfigBuilder(Context context) {
        HashSet<SystraceRequestListener> requestListeners = new HashSet<SystraceRequestListener>();
        requestListeners.add(new SystraceRequestListener());
        OkHttpClient client = OkHttpClientProvider.createClient();
        CookieJarContainer container = (CookieJarContainer)client.cookieJar();
        ForwardingCookieHandler handler = new ForwardingCookieHandler(context.getApplicationContext());
        container.setCookieJar((CookieJar)new JavaNetCookieJar((CookieHandler)handler));
        final int maxCacheSize = FrescoModule.getMaxCacheSize(context);
        Supplier<MemoryCacheParams> bitmapSupplier = new Supplier<MemoryCacheParams>(){

            public MemoryCacheParams get() {
                return new MemoryCacheParams(maxCacheSize, 100, 0, Integer.MAX_VALUE, Integer.MAX_VALUE);
            }
        };
        return OkHttpImagePipelineConfigFactory.newBuilder((Context)context.getApplicationContext(), (OkHttpClient)client).setNetworkFetcher((NetworkFetcher)new ReactOkHttpNetworkFetcher(client)).setDownsampleEnabled(true).setBitmapMemoryCacheParamsSupplier((Supplier)bitmapSupplier).setRequestListeners(requestListeners);
    }

    private static int getMaxCacheSize(Context context) {
        ActivityManager activityManager = (ActivityManager)context.getSystemService("activity");
        int maxMemory = Math.min(activityManager.getMemoryClass() * 0x100000, Integer.MAX_VALUE);
        if (maxMemory < 0x2000000) {
            return 0x400000;
        }
        if (maxMemory < 0x4000000) {
            return 0x600000;
        }
        if (Build.VERSION.SDK_INT < 11) {
            return 0x800000;
        }
        return maxMemory / 4;
    }

    @Override
    public void onHostResume() {
    }

    @Override
    public void onHostPause() {
    }

    @Override
    public void onHostDestroy() {
        if (FrescoModule.hasBeenInitialized() && this.mClearOnDestroy) {
            Fresco.getImagePipeline().clearMemoryCaches();
        }
    }

    public static void clearMemoryCache() {
        if (FrescoModule.hasBeenInitialized()) {
            Fresco.getImagePipeline().clearMemoryCaches();
        }
    }

    static {
        sHasBeenInitialized = false;
    }
}

