/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.uimanager;

import android.view.View;
import android.view.ViewParent;
import androidx.core.view.ViewCompat;
import com.facebook.react.R;
import com.facebook.react.bridge.ReadableArray;
import com.facebook.react.uimanager.AccessibilityDelegateUtil;
import com.facebook.react.uimanager.AccessibilityHelper;
import com.facebook.react.uimanager.DisplayMetricsHolder;
import com.facebook.react.uimanager.LayoutShadowNode;
import com.facebook.react.uimanager.MatrixMathHelper;
import com.facebook.react.uimanager.PixelUtil;
import com.facebook.react.uimanager.ReactZIndexedViewGroup;
import com.facebook.react.uimanager.TransformHelper;
import com.facebook.react.uimanager.ViewGroupManager;
import com.facebook.react.uimanager.ViewManager;
import com.facebook.react.uimanager.annotations.ReactProp;
import com.facebook.react.uimanager.util.ReactFindViewUtil;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public abstract class BaseViewManager<T extends View, C extends LayoutShadowNode>
extends ViewManager<T, C> {
    private static final String PROP_BACKGROUND_COLOR = "backgroundColor";
    private static final String PROP_TRANSFORM = "transform";
    private static final String PROP_ELEVATION = "elevation";
    private static final String PROP_Z_INDEX = "zIndex";
    private static final String PROP_RENDER_TO_HARDWARE_TEXTURE = "renderToHardwareTextureAndroid";
    private static final String PROP_ACCESSIBILITY_LABEL = "accessibilityLabel";
    private static final String PROP_ACCESSIBILITY_COMPONENT_TYPE = "accessibilityComponentType";
    private static final String PROP_ACCESSIBILITY_HINT = "accessibilityHint";
    private static final String PROP_ACCESSIBILITY_LIVE_REGION = "accessibilityLiveRegion";
    private static final String PROP_ACCESSIBILITY_ROLE = "accessibilityRole";
    private static final String PROP_ACCESSIBILITY_STATES = "accessibilityStates";
    private static final String PROP_IMPORTANT_FOR_ACCESSIBILITY = "importantForAccessibility";
    private static final String PROP_ROTATION = "rotation";
    private static final String PROP_SCALE_X = "scaleX";
    private static final String PROP_SCALE_Y = "scaleY";
    private static final String PROP_TRANSLATE_X = "translateX";
    private static final String PROP_TRANSLATE_Y = "translateY";
    private static final int PERSPECTIVE_ARRAY_INVERTED_CAMERA_DISTANCE_INDEX = 2;
    private static final float CAMERA_DISTANCE_NORMALIZATION_MULTIPLIER = (float)Math.sqrt(5.0);
    public static final String PROP_TEST_ID = "testID";
    public static final String PROP_NATIVE_ID = "nativeID";
    private static MatrixMathHelper.MatrixDecompositionContext sMatrixDecompositionContext = new MatrixMathHelper.MatrixDecompositionContext();
    private static double[] sTransformDecompositionArray = new double[16];

    @ReactProp(name="backgroundColor", defaultInt=0, customType="Color")
    public void setBackgroundColor(@Nonnull T view, int backgroundColor) {
        view.setBackgroundColor(backgroundColor);
    }

    @ReactProp(name="transform")
    public void setTransform(@Nonnull T view, @Nullable ReadableArray matrix) {
        if (matrix == null) {
            BaseViewManager.resetTransformProperty(view);
        } else {
            BaseViewManager.setTransformProperty(view, matrix);
        }
    }

    @ReactProp(name="opacity", defaultFloat=1.0f)
    public void setOpacity(@Nonnull T view, float opacity) {
        view.setAlpha(opacity);
    }

    @ReactProp(name="elevation")
    public void setElevation(@Nonnull T view, float elevation) {
        ViewCompat.setElevation(view, (float)PixelUtil.toPixelFromDIP(elevation));
    }

    @ReactProp(name="zIndex")
    public void setZIndex(@Nonnull T view, float zIndex) {
        int integerZIndex = Math.round(zIndex);
        ViewGroupManager.setViewZIndex(view, integerZIndex);
        ViewParent parent = view.getParent();
        if (parent != null && parent instanceof ReactZIndexedViewGroup) {
            ((ReactZIndexedViewGroup)parent).updateDrawingOrder();
        }
    }

    @ReactProp(name="renderToHardwareTextureAndroid")
    public void setRenderToHardwareTexture(@Nonnull T view, boolean useHWTexture) {
        view.setLayerType(useHWTexture ? 2 : 0, null);
    }

    @ReactProp(name="testID")
    public void setTestId(@Nonnull T view, String testId) {
        view.setTag(R.id.react_test_id, (Object)testId);
        view.setTag((Object)testId);
    }

    @ReactProp(name="nativeID")
    public void setNativeId(@Nonnull T view, String nativeId) {
        view.setTag(R.id.view_tag_native_id, (Object)nativeId);
        ReactFindViewUtil.notifyViewRendered(view);
    }

    @ReactProp(name="accessibilityLabel")
    public void setAccessibilityLabel(@Nonnull T view, String accessibilityLabel) {
        view.setContentDescription((CharSequence)accessibilityLabel);
    }

    @ReactProp(name="accessibilityComponentType")
    public void setAccessibilityComponentType(@Nonnull T view, String accessibilityComponentType) {
        AccessibilityHelper.updateAccessibilityComponentType(view, accessibilityComponentType);
    }

    @ReactProp(name="accessibilityHint")
    public void setAccessibilityHint(@Nonnull T view, String accessibilityHint) {
        view.setTag(R.id.accessibility_hint, (Object)accessibilityHint);
    }

    @ReactProp(name="accessibilityRole")
    public void setAccessibilityRole(@Nonnull T view, @Nullable String accessibilityRole) {
        if (accessibilityRole == null) {
            return;
        }
        view.setTag(R.id.accessibility_role, (Object)AccessibilityDelegateUtil.AccessibilityRole.fromValue(accessibilityRole));
    }

    @ReactProp(name="accessibilityStates")
    public void setViewStates(@Nonnull T view, @Nullable ReadableArray accessibilityStates) {
        view.setSelected(false);
        view.setEnabled(true);
        if (accessibilityStates == null) {
            return;
        }
        for (int i = 0; i < accessibilityStates.size(); ++i) {
            String state = accessibilityStates.getString(i);
            if (state.equals("selected")) {
                view.setSelected(true);
                continue;
            }
            if (!state.equals("disabled")) continue;
            view.setEnabled(false);
        }
    }

    @ReactProp(name="importantForAccessibility")
    public void setImportantForAccessibility(@Nonnull T view, @Nullable String importantForAccessibility) {
        if (importantForAccessibility == null || importantForAccessibility.equals("auto")) {
            ViewCompat.setImportantForAccessibility(view, (int)0);
        } else if (importantForAccessibility.equals("yes")) {
            ViewCompat.setImportantForAccessibility(view, (int)1);
        } else if (importantForAccessibility.equals("no")) {
            ViewCompat.setImportantForAccessibility(view, (int)2);
        } else if (importantForAccessibility.equals("no-hide-descendants")) {
            ViewCompat.setImportantForAccessibility(view, (int)4);
        }
    }

    @Deprecated
    @ReactProp(name="rotation")
    public void setRotation(@Nonnull T view, float rotation) {
        view.setRotation(rotation);
    }

    @Deprecated
    @ReactProp(name="scaleX", defaultFloat=1.0f)
    public void setScaleX(@Nonnull T view, float scaleX) {
        view.setScaleX(scaleX);
    }

    @Deprecated
    @ReactProp(name="scaleY", defaultFloat=1.0f)
    public void setScaleY(@Nonnull T view, float scaleY) {
        view.setScaleY(scaleY);
    }

    @Deprecated
    @ReactProp(name="translateX", defaultFloat=0.0f)
    public void setTranslateX(@Nonnull T view, float translateX) {
        view.setTranslationX(PixelUtil.toPixelFromDIP(translateX));
    }

    @Deprecated
    @ReactProp(name="translateY", defaultFloat=0.0f)
    public void setTranslateY(@Nonnull T view, float translateY) {
        view.setTranslationY(PixelUtil.toPixelFromDIP(translateY));
    }

    @ReactProp(name="accessibilityLiveRegion")
    public void setAccessibilityLiveRegion(@Nonnull T view, @Nullable String liveRegion) {
        if (liveRegion == null || liveRegion.equals("none")) {
            ViewCompat.setAccessibilityLiveRegion(view, (int)0);
        } else if (liveRegion.equals("polite")) {
            ViewCompat.setAccessibilityLiveRegion(view, (int)1);
        } else if (liveRegion.equals("assertive")) {
            ViewCompat.setAccessibilityLiveRegion(view, (int)2);
        }
    }

    private static void setTransformProperty(@Nonnull View view, ReadableArray transforms) {
        TransformHelper.processTransform(transforms, sTransformDecompositionArray);
        MatrixMathHelper.decomposeMatrix(sTransformDecompositionArray, sMatrixDecompositionContext);
        view.setTranslationX(PixelUtil.toPixelFromDIP((float)BaseViewManager.sMatrixDecompositionContext.translation[0]));
        view.setTranslationY(PixelUtil.toPixelFromDIP((float)BaseViewManager.sMatrixDecompositionContext.translation[1]));
        view.setRotation((float)BaseViewManager.sMatrixDecompositionContext.rotationDegrees[2]);
        view.setRotationX((float)BaseViewManager.sMatrixDecompositionContext.rotationDegrees[0]);
        view.setRotationY((float)BaseViewManager.sMatrixDecompositionContext.rotationDegrees[1]);
        view.setScaleX((float)BaseViewManager.sMatrixDecompositionContext.scale[0]);
        view.setScaleY((float)BaseViewManager.sMatrixDecompositionContext.scale[1]);
        double[] perspectiveArray = BaseViewManager.sMatrixDecompositionContext.perspective;
        if (perspectiveArray.length > 2) {
            float invertedCameraDistance = (float)perspectiveArray[2];
            if (invertedCameraDistance == 0.0f) {
                invertedCameraDistance = 7.8125E-4f;
            }
            float cameraDistance = -1.0f / invertedCameraDistance;
            float scale = DisplayMetricsHolder.getScreenDisplayMetrics().density;
            float normalizedCameraDistance = scale * scale * cameraDistance * CAMERA_DISTANCE_NORMALIZATION_MULTIPLIER;
            view.setCameraDistance(normalizedCameraDistance);
        }
    }

    private static void resetTransformProperty(@Nonnull View view) {
        view.setTranslationX(PixelUtil.toPixelFromDIP(0.0f));
        view.setTranslationY(PixelUtil.toPixelFromDIP(0.0f));
        view.setRotation(0.0f);
        view.setRotationX(0.0f);
        view.setRotationY(0.0f);
        view.setScaleX(1.0f);
        view.setScaleY(1.0f);
        view.setCameraDistance(0.0f);
    }

    private void updateViewAccessibility(@Nonnull T view) {
        AccessibilityDelegateUtil.setDelegate(view);
    }

    @Override
    protected void onAfterUpdateTransaction(@Nonnull T view) {
        super.onAfterUpdateTransaction(view);
        this.updateViewAccessibility(view);
    }
}

