/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.modules.network;

import android.content.Context;
import android.net.Uri;
import android.util.Base64;
import com.facebook.common.logging.FLog;
import com.facebook.react.bridge.Arguments;
import com.facebook.react.bridge.Callback;
import com.facebook.react.bridge.GuardedAsyncTask;
import com.facebook.react.bridge.ReactApplicationContext;
import com.facebook.react.bridge.ReactContext;
import com.facebook.react.bridge.ReactContextBaseJavaModule;
import com.facebook.react.bridge.ReactMethod;
import com.facebook.react.bridge.ReadableArray;
import com.facebook.react.bridge.ReadableMap;
import com.facebook.react.bridge.WritableMap;
import com.facebook.react.common.StandardCharsets;
import com.facebook.react.common.network.OkHttpCallUtil;
import com.facebook.react.module.annotations.ReactModule;
import com.facebook.react.modules.core.DeviceEventManagerModule;
import com.facebook.react.modules.network.CookieJarContainer;
import com.facebook.react.modules.network.ForwardingCookieHandler;
import com.facebook.react.modules.network.HeaderUtil;
import com.facebook.react.modules.network.NetworkInterceptorCreator;
import com.facebook.react.modules.network.OkHttpClientProvider;
import com.facebook.react.modules.network.ProgressListener;
import com.facebook.react.modules.network.ProgressResponseBody;
import com.facebook.react.modules.network.ProgressiveStringDecoder;
import com.facebook.react.modules.network.RequestBodyUtil;
import com.facebook.react.modules.network.ResponseUtil;
import java.io.IOException;
import java.io.InputStream;
import java.net.CookieHandler;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import okhttp3.Call;
import okhttp3.CookieJar;
import okhttp3.Headers;
import okhttp3.Interceptor;
import okhttp3.JavaNetCookieJar;
import okhttp3.MediaType;
import okhttp3.MultipartBody;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;
import okio.BufferedSource;
import okio.ByteString;
import okio.GzipSource;
import okio.Okio;
import okio.Source;

@ReactModule(name="Networking")
public final class NetworkingModule
extends ReactContextBaseJavaModule {
    protected static final String NAME = "Networking";
    private static final String TAG = "NetworkingModule";
    private static final String CONTENT_ENCODING_HEADER_NAME = "content-encoding";
    private static final String CONTENT_TYPE_HEADER_NAME = "content-type";
    private static final String REQUEST_BODY_KEY_STRING = "string";
    private static final String REQUEST_BODY_KEY_URI = "uri";
    private static final String REQUEST_BODY_KEY_FORMDATA = "formData";
    private static final String REQUEST_BODY_KEY_BASE64 = "base64";
    private static final String USER_AGENT_HEADER_NAME = "user-agent";
    private static final int CHUNK_TIMEOUT_NS = 100000000;
    private static final int MAX_CHUNK_SIZE_BETWEEN_FLUSHES = 8192;
    private final OkHttpClient mClient;
    private final ForwardingCookieHandler mCookieHandler;
    @Nullable
    private final String mDefaultUserAgent;
    private final CookieJarContainer mCookieJarContainer;
    private final Set<Integer> mRequestIds;
    private final List<RequestBodyHandler> mRequestBodyHandlers = new ArrayList<RequestBodyHandler>();
    private final List<UriHandler> mUriHandlers = new ArrayList<UriHandler>();
    private final List<ResponseHandler> mResponseHandlers = new ArrayList<ResponseHandler>();
    private boolean mShuttingDown;

    NetworkingModule(ReactApplicationContext reactContext, @Nullable String defaultUserAgent, OkHttpClient client, @Nullable List<NetworkInterceptorCreator> networkInterceptorCreators) {
        super(reactContext);
        if (networkInterceptorCreators != null) {
            OkHttpClient.Builder clientBuilder = client.newBuilder();
            for (NetworkInterceptorCreator networkInterceptorCreator : networkInterceptorCreators) {
                clientBuilder.addNetworkInterceptor(networkInterceptorCreator.create());
            }
            client = clientBuilder.build();
        }
        this.mClient = client;
        this.mCookieHandler = new ForwardingCookieHandler((Context)reactContext);
        this.mCookieJarContainer = (CookieJarContainer)this.mClient.cookieJar();
        this.mShuttingDown = false;
        this.mDefaultUserAgent = defaultUserAgent;
        this.mRequestIds = new HashSet<Integer>();
    }

    NetworkingModule(ReactApplicationContext context, @Nullable String defaultUserAgent, OkHttpClient client) {
        this(context, defaultUserAgent, client, null);
    }

    public NetworkingModule(ReactApplicationContext context) {
        this(context, null, OkHttpClientProvider.createClient((Context)context), null);
    }

    public NetworkingModule(ReactApplicationContext context, List<NetworkInterceptorCreator> networkInterceptorCreators) {
        this(context, null, OkHttpClientProvider.createClient((Context)context), networkInterceptorCreators);
    }

    public NetworkingModule(ReactApplicationContext context, String defaultUserAgent) {
        this(context, defaultUserAgent, OkHttpClientProvider.createClient((Context)context), null);
    }

    @Override
    public void initialize() {
        this.mCookieJarContainer.setCookieJar((CookieJar)new JavaNetCookieJar((CookieHandler)this.mCookieHandler));
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public void onCatalystInstanceDestroy() {
        this.mShuttingDown = true;
        this.cancelAllRequests();
        this.mCookieHandler.destroy();
        this.mCookieJarContainer.removeCookieJar();
        this.mRequestBodyHandlers.clear();
        this.mResponseHandlers.clear();
        this.mUriHandlers.clear();
    }

    public void addUriHandler(UriHandler handler) {
        this.mUriHandlers.add(handler);
    }

    public void addRequestBodyHandler(RequestBodyHandler handler) {
        this.mRequestBodyHandlers.add(handler);
    }

    public void addResponseHandler(ResponseHandler handler) {
        this.mResponseHandlers.add(handler);
    }

    public void removeUriHandler(UriHandler handler) {
        this.mUriHandlers.remove(handler);
    }

    public void removeRequestBodyHandler(RequestBodyHandler handler) {
        this.mRequestBodyHandlers.remove(handler);
    }

    public void removeResponseHandler(ResponseHandler handler) {
        this.mResponseHandlers.remove(handler);
    }

    @ReactMethod
    public void sendRequest(String method, String url, int requestId, ReadableArray headers, ReadableMap data, String responseType, boolean useIncrementalUpdates, int timeout, boolean withCredentials) {
        try {
            this.sendRequestInternal(method, url, requestId, headers, data, responseType, useIncrementalUpdates, timeout, withCredentials);
        }
        catch (Throwable th) {
            FLog.e((String)TAG, (String)("Failed to send url request: " + url), (Throwable)th);
            ResponseUtil.onRequestError(this.getEventEmitter(), requestId, th.getMessage(), th);
        }
    }

    public void sendRequestInternal(String method, String url, final int requestId, ReadableArray headers, ReadableMap data, final String responseType, final boolean useIncrementalUpdates, int timeout, boolean withCredentials) {
        RequestBody requestBody;
        Request.Builder requestBuilder;
        final DeviceEventManagerModule.RCTDeviceEventEmitter eventEmitter = this.getEventEmitter();
        try {
            Uri uri = Uri.parse((String)url);
            for (UriHandler handler : this.mUriHandlers) {
                if (!handler.supports(uri, responseType)) continue;
                WritableMap res = handler.fetch(uri);
                ResponseUtil.onDataReceived(eventEmitter, requestId, res);
                ResponseUtil.onRequestSuccess(eventEmitter, requestId);
                return;
            }
        }
        catch (IOException e) {
            ResponseUtil.onRequestError(eventEmitter, requestId, e.getMessage(), e);
            return;
        }
        try {
            requestBuilder = new Request.Builder().url(url);
        }
        catch (Exception e) {
            ResponseUtil.onRequestError(eventEmitter, requestId, e.getMessage(), null);
            return;
        }
        if (requestId != 0) {
            requestBuilder.tag((Object)requestId);
        }
        OkHttpClient.Builder clientBuilder = this.mClient.newBuilder();
        if (!withCredentials) {
            clientBuilder.cookieJar(CookieJar.NO_COOKIES);
        }
        if (useIncrementalUpdates) {
            clientBuilder.addNetworkInterceptor(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    ProgressResponseBody responseBody = new ProgressResponseBody(originalResponse.body(), new ProgressListener(){
                        long last = System.nanoTime();

                        @Override
                        public void onProgress(long bytesWritten, long contentLength, boolean done) {
                            long now = System.nanoTime();
                            if (!done && !NetworkingModule.shouldDispatch(now, this.last)) {
                                return;
                            }
                            if (responseType.equals("text")) {
                                return;
                            }
                            ResponseUtil.onDataReceivedProgress(eventEmitter, requestId, bytesWritten, contentLength);
                            this.last = now;
                        }
                    });
                    return originalResponse.newBuilder().body((ResponseBody)responseBody).build();
                }
            });
        }
        if (timeout != this.mClient.connectTimeoutMillis()) {
            clientBuilder.connectTimeout((long)timeout, TimeUnit.MILLISECONDS);
        }
        OkHttpClient client = clientBuilder.build();
        Headers requestHeaders = this.extractHeaders(headers, data);
        if (requestHeaders == null) {
            ResponseUtil.onRequestError(eventEmitter, requestId, "Unrecognized headers format", null);
            return;
        }
        String contentType = requestHeaders.get(CONTENT_TYPE_HEADER_NAME);
        String contentEncoding = requestHeaders.get(CONTENT_ENCODING_HEADER_NAME);
        requestBuilder.headers(requestHeaders);
        RequestBodyHandler handler = null;
        if (data != null) {
            for (RequestBodyHandler curHandler : this.mRequestBodyHandlers) {
                if (!curHandler.supports(data)) continue;
                handler = curHandler;
                break;
            }
        }
        if (data == null || method.toLowerCase().equals("get") || method.toLowerCase().equals("head")) {
            requestBody = RequestBodyUtil.getEmptyBody(method);
        } else if (handler != null) {
            requestBody = handler.toRequestBody(data, contentType);
        } else if (data.hasKey(REQUEST_BODY_KEY_STRING)) {
            if (contentType == null) {
                ResponseUtil.onRequestError(eventEmitter, requestId, "Payload is set but no content-type header specified", null);
                return;
            }
            String body = data.getString(REQUEST_BODY_KEY_STRING);
            MediaType contentMediaType = MediaType.parse((String)contentType);
            if (RequestBodyUtil.isGzipEncoding(contentEncoding)) {
                requestBody = RequestBodyUtil.createGzip(contentMediaType, body);
                if (requestBody == null) {
                    ResponseUtil.onRequestError(eventEmitter, requestId, "Failed to gzip request body", null);
                    return;
                }
            } else {
                Charset charset = contentMediaType == null ? StandardCharsets.UTF_8 : contentMediaType.charset(StandardCharsets.UTF_8);
                requestBody = RequestBody.create((MediaType)contentMediaType, (byte[])body.getBytes(charset));
            }
        } else if (data.hasKey(REQUEST_BODY_KEY_BASE64)) {
            if (contentType == null) {
                ResponseUtil.onRequestError(eventEmitter, requestId, "Payload is set but no content-type header specified", null);
                return;
            }
            String base64String = data.getString(REQUEST_BODY_KEY_BASE64);
            MediaType contentMediaType = MediaType.parse((String)contentType);
            requestBody = RequestBody.create((MediaType)contentMediaType, (ByteString)ByteString.decodeBase64((String)base64String));
        } else if (data.hasKey(REQUEST_BODY_KEY_URI)) {
            if (contentType == null) {
                ResponseUtil.onRequestError(eventEmitter, requestId, "Payload is set but no content-type header specified", null);
                return;
            }
            String uri = data.getString(REQUEST_BODY_KEY_URI);
            InputStream fileInputStream = RequestBodyUtil.getFileInputStream((Context)this.getReactApplicationContext(), uri);
            if (fileInputStream == null) {
                ResponseUtil.onRequestError(eventEmitter, requestId, "Could not retrieve file for uri " + uri, null);
                return;
            }
            requestBody = RequestBodyUtil.create(MediaType.parse((String)contentType), fileInputStream);
        } else if (data.hasKey(REQUEST_BODY_KEY_FORMDATA)) {
            ReadableArray parts;
            MultipartBody.Builder multipartBuilder;
            if (contentType == null) {
                contentType = "multipart/form-data";
            }
            if ((multipartBuilder = this.constructMultipartBody(parts = data.getArray(REQUEST_BODY_KEY_FORMDATA), contentType, requestId)) == null) {
                return;
            }
            requestBody = multipartBuilder.build();
        } else {
            requestBody = RequestBodyUtil.getEmptyBody(method);
        }
        requestBuilder.method(method, this.wrapRequestBodyWithProgressEmitter(requestBody, eventEmitter, requestId));
        this.addRequest(requestId);
        client.newCall(requestBuilder.build()).enqueue(new okhttp3.Callback(){

            public void onFailure(Call call, IOException e) {
                if (NetworkingModule.this.mShuttingDown) {
                    return;
                }
                NetworkingModule.this.removeRequest(requestId);
                String errorMessage = e.getMessage() != null ? e.getMessage() : "Error while executing request: " + e.getClass().getSimpleName();
                ResponseUtil.onRequestError(eventEmitter, requestId, errorMessage, e);
            }

            public void onResponse(Call call, Response response) throws IOException {
                if (NetworkingModule.this.mShuttingDown) {
                    return;
                }
                NetworkingModule.this.removeRequest(requestId);
                ResponseUtil.onResponseReceived(eventEmitter, requestId, response.code(), NetworkingModule.translateHeaders(response.headers()), response.request().url().toString());
                try {
                    ResponseBody responseBody = response.body();
                    if ("gzip".equalsIgnoreCase(response.header("Content-Encoding")) && responseBody != null) {
                        GzipSource gzipSource = new GzipSource((Source)responseBody.source());
                        String contentType = response.header("Content-Type");
                        responseBody = ResponseBody.create((MediaType)(contentType != null ? MediaType.parse((String)contentType) : null), (long)-1L, (BufferedSource)Okio.buffer((Source)gzipSource));
                    }
                    for (ResponseHandler handler : NetworkingModule.this.mResponseHandlers) {
                        if (!handler.supports(responseType)) continue;
                        WritableMap res = handler.toResponseData(responseBody);
                        ResponseUtil.onDataReceived(eventEmitter, requestId, res);
                        ResponseUtil.onRequestSuccess(eventEmitter, requestId);
                        return;
                    }
                    if (useIncrementalUpdates && responseType.equals("text")) {
                        NetworkingModule.this.readWithProgress(eventEmitter, requestId, responseBody);
                        ResponseUtil.onRequestSuccess(eventEmitter, requestId);
                        return;
                    }
                    String responseString = "";
                    if (responseType.equals("text")) {
                        try {
                            responseString = responseBody.string();
                        }
                        catch (IOException e) {
                            if (!response.request().method().equalsIgnoreCase("HEAD")) {
                                ResponseUtil.onRequestError(eventEmitter, requestId, e.getMessage(), e);
                            }
                        }
                    } else if (responseType.equals(NetworkingModule.REQUEST_BODY_KEY_BASE64)) {
                        responseString = Base64.encodeToString((byte[])responseBody.bytes(), (int)2);
                    }
                    ResponseUtil.onDataReceived(eventEmitter, requestId, responseString);
                    ResponseUtil.onRequestSuccess(eventEmitter, requestId);
                }
                catch (IOException e) {
                    ResponseUtil.onRequestError(eventEmitter, requestId, e.getMessage(), e);
                }
            }
        });
    }

    private RequestBody wrapRequestBodyWithProgressEmitter(RequestBody requestBody, final DeviceEventManagerModule.RCTDeviceEventEmitter eventEmitter, final int requestId) {
        if (requestBody == null) {
            return null;
        }
        return RequestBodyUtil.createProgressRequest(requestBody, new ProgressListener(){
            long last = System.nanoTime();

            @Override
            public void onProgress(long bytesWritten, long contentLength, boolean done) {
                long now = System.nanoTime();
                if (done || NetworkingModule.shouldDispatch(now, this.last)) {
                    ResponseUtil.onDataSend(eventEmitter, requestId, bytesWritten, contentLength);
                    this.last = now;
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readWithProgress(DeviceEventManagerModule.RCTDeviceEventEmitter eventEmitter, int requestId, ResponseBody responseBody) throws IOException {
        long totalBytesRead = -1L;
        long contentLength = -1L;
        try {
            ProgressResponseBody progressResponseBody = (ProgressResponseBody)responseBody;
            totalBytesRead = progressResponseBody.totalBytesRead();
            contentLength = progressResponseBody.contentLength();
        }
        catch (ClassCastException progressResponseBody) {
            // empty catch block
        }
        Charset charset = responseBody.contentType() == null ? StandardCharsets.UTF_8 : responseBody.contentType().charset(StandardCharsets.UTF_8);
        ProgressiveStringDecoder streamDecoder = new ProgressiveStringDecoder(charset);
        try (InputStream inputStream = responseBody.byteStream();){
            int read;
            byte[] buffer = new byte[8192];
            while ((read = inputStream.read(buffer)) != -1) {
                ResponseUtil.onIncrementalDataReceived(eventEmitter, requestId, streamDecoder.decodeNext(buffer, read), totalBytesRead, contentLength);
            }
        }
    }

    private static boolean shouldDispatch(long now, long last) {
        return last + 100000000L < now;
    }

    private synchronized void addRequest(int requestId) {
        this.mRequestIds.add(requestId);
    }

    private synchronized void removeRequest(int requestId) {
        this.mRequestIds.remove(requestId);
    }

    private synchronized void cancelAllRequests() {
        for (Integer requestId : this.mRequestIds) {
            this.cancelRequest(requestId);
        }
        this.mRequestIds.clear();
    }

    private static WritableMap translateHeaders(Headers headers) {
        WritableMap responseHeaders = Arguments.createMap();
        for (int i = 0; i < headers.size(); ++i) {
            String headerName = headers.name(i);
            if (responseHeaders.hasKey(headerName)) {
                responseHeaders.putString(headerName, responseHeaders.getString(headerName) + ", " + headers.value(i));
                continue;
            }
            responseHeaders.putString(headerName, headers.value(i));
        }
        return responseHeaders;
    }

    @ReactMethod
    public void abortRequest(int requestId) {
        this.cancelRequest(requestId);
        this.removeRequest(requestId);
    }

    private void cancelRequest(final int requestId) {
        new GuardedAsyncTask<Void, Void>((ReactContext)this.getReactApplicationContext()){

            protected void doInBackgroundGuarded(Void ... params) {
                OkHttpCallUtil.cancelTag(NetworkingModule.this.mClient, requestId);
            }
        }.execute(new Void[0]);
    }

    @ReactMethod
    public void clearCookies(Callback callback) {
        this.mCookieHandler.clearCookies(callback);
    }

    @Nullable
    private MultipartBody.Builder constructMultipartBody(ReadableArray body, String contentType, int requestId) {
        DeviceEventManagerModule.RCTDeviceEventEmitter eventEmitter = this.getEventEmitter();
        MultipartBody.Builder multipartBuilder = new MultipartBody.Builder();
        multipartBuilder.setType(MediaType.parse((String)contentType));
        int size = body.size();
        for (int i = 0; i < size; ++i) {
            ReadableMap bodyPart = body.getMap(i);
            ReadableArray headersArray = bodyPart.getArray("headers");
            Headers headers = this.extractHeaders(headersArray, null);
            if (headers == null) {
                ResponseUtil.onRequestError(eventEmitter, requestId, "Missing or invalid header format for FormData part.", null);
                return null;
            }
            MediaType partContentType = null;
            String partContentTypeStr = headers.get(CONTENT_TYPE_HEADER_NAME);
            if (partContentTypeStr != null) {
                partContentType = MediaType.parse((String)partContentTypeStr);
                headers = headers.newBuilder().removeAll(CONTENT_TYPE_HEADER_NAME).build();
            }
            if (bodyPart.hasKey(REQUEST_BODY_KEY_STRING)) {
                String bodyValue = bodyPart.getString(REQUEST_BODY_KEY_STRING);
                multipartBuilder.addPart(headers, RequestBody.create((MediaType)partContentType, (String)bodyValue));
                continue;
            }
            if (bodyPart.hasKey(REQUEST_BODY_KEY_URI)) {
                if (partContentType == null) {
                    ResponseUtil.onRequestError(eventEmitter, requestId, "Binary FormData part needs a content-type header.", null);
                    return null;
                }
                String fileContentUriStr = bodyPart.getString(REQUEST_BODY_KEY_URI);
                InputStream fileInputStream = RequestBodyUtil.getFileInputStream((Context)this.getReactApplicationContext(), fileContentUriStr);
                if (fileInputStream == null) {
                    ResponseUtil.onRequestError(eventEmitter, requestId, "Could not retrieve file for uri " + fileContentUriStr, null);
                    return null;
                }
                multipartBuilder.addPart(headers, RequestBodyUtil.create(partContentType, fileInputStream));
                continue;
            }
            ResponseUtil.onRequestError(eventEmitter, requestId, "Unrecognized FormData part.", null);
        }
        return multipartBuilder;
    }

    @Nullable
    private Headers extractHeaders(@Nullable ReadableArray headersArray, @Nullable ReadableMap requestData) {
        boolean isGzipSupported;
        if (headersArray == null) {
            return null;
        }
        Headers.Builder headersBuilder = new Headers.Builder();
        int size = headersArray.size();
        for (int headersIdx = 0; headersIdx < size; ++headersIdx) {
            ReadableArray header = headersArray.getArray(headersIdx);
            if (header == null || header.size() != 2) {
                return null;
            }
            String headerName = HeaderUtil.stripHeaderName(header.getString(0));
            String headerValue = HeaderUtil.stripHeaderValue(header.getString(1));
            if (headerName == null || headerValue == null) {
                return null;
            }
            headersBuilder.add(headerName, headerValue);
        }
        if (headersBuilder.get(USER_AGENT_HEADER_NAME) == null && this.mDefaultUserAgent != null) {
            headersBuilder.add(USER_AGENT_HEADER_NAME, this.mDefaultUserAgent);
        }
        boolean bl = isGzipSupported = requestData != null && requestData.hasKey(REQUEST_BODY_KEY_STRING);
        if (!isGzipSupported) {
            headersBuilder.removeAll(CONTENT_ENCODING_HEADER_NAME);
        }
        return headersBuilder.build();
    }

    private DeviceEventManagerModule.RCTDeviceEventEmitter getEventEmitter() {
        return this.getReactApplicationContext().getJSModule(DeviceEventManagerModule.RCTDeviceEventEmitter.class);
    }

    public static interface ResponseHandler {
        public boolean supports(String var1);

        public WritableMap toResponseData(ResponseBody var1) throws IOException;
    }

    public static interface RequestBodyHandler {
        public boolean supports(ReadableMap var1);

        public RequestBody toRequestBody(ReadableMap var1, String var2);
    }

    public static interface UriHandler {
        public boolean supports(Uri var1, String var2);

        public WritableMap fetch(Uri var1) throws IOException;
    }
}

