/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.modules.core;

import android.util.SparseArray;
import com.facebook.react.ReactInstanceManager;
import com.facebook.react.bridge.Arguments;
import com.facebook.react.bridge.LifecycleEventListener;
import com.facebook.react.bridge.ReactApplicationContext;
import com.facebook.react.bridge.ReactContextBaseJavaModule;
import com.facebook.react.bridge.ReactMethod;
import com.facebook.react.bridge.UiThreadUtil;
import com.facebook.react.bridge.WritableArray;
import com.facebook.react.common.SystemClock;
import com.facebook.react.devsupport.interfaces.DevSupportManager;
import com.facebook.react.jstasks.HeadlessJsTaskContext;
import com.facebook.react.jstasks.HeadlessJsTaskEventListener;
import com.facebook.react.module.annotations.ReactModule;
import com.facebook.react.modules.core.ChoreographerCompat;
import com.facebook.react.modules.core.JSTimers;
import com.facebook.react.modules.core.ReactChoreographer;
import java.util.Comparator;
import java.util.PriorityQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.Nullable;

@ReactModule(name="Timing")
public final class Timing
extends ReactContextBaseJavaModule
implements LifecycleEventListener,
HeadlessJsTaskEventListener {
    public static final String NAME = "Timing";
    private static final float IDLE_CALLBACK_FRAME_DEADLINE_MS = 1.0f;
    private static final float FRAME_DURATION_MS = 16.666666f;
    private final DevSupportManager mDevSupportManager;
    private final Object mTimerGuard = new Object();
    private final Object mIdleCallbackGuard = new Object();
    private final PriorityQueue<Timer> mTimers;
    private final SparseArray<Timer> mTimerIdsToTimers;
    private final AtomicBoolean isPaused = new AtomicBoolean(true);
    private final AtomicBoolean isRunningTasks = new AtomicBoolean(false);
    private final TimerFrameCallback mTimerFrameCallback = new TimerFrameCallback();
    private final IdleFrameCallback mIdleFrameCallback = new IdleFrameCallback();
    private final ReactChoreographer mReactChoreographer;
    @Nullable
    private IdleCallbackRunnable mCurrentIdleCallbackRunnable;
    private boolean mFrameCallbackPosted = false;
    private boolean mFrameIdleCallbackPosted = false;
    private boolean mSendIdleEvents = false;

    public Timing(ReactApplicationContext reactContext, DevSupportManager devSupportManager) {
        super(reactContext);
        this.mDevSupportManager = devSupportManager;
        this.mTimers = new PriorityQueue<Timer>(11, new Comparator<Timer>(){

            @Override
            public int compare(Timer lhs, Timer rhs) {
                long diff = lhs.mTargetTime - rhs.mTargetTime;
                if (diff == 0L) {
                    return 0;
                }
                if (diff < 0L) {
                    return -1;
                }
                return 1;
            }
        });
        this.mTimerIdsToTimers = new SparseArray();
        this.mReactChoreographer = ReactChoreographer.getInstance();
    }

    @Override
    public void initialize() {
        this.getReactApplicationContext().addLifecycleEventListener(this);
        HeadlessJsTaskContext headlessJsTaskContext = HeadlessJsTaskContext.getInstance(this.getReactApplicationContext());
        headlessJsTaskContext.addTaskEventListener(this);
    }

    @Override
    public void onHostPause() {
        this.isPaused.set(true);
        this.clearFrameCallback();
        this.maybeIdleCallback();
    }

    @Override
    public void onHostDestroy() {
        this.clearFrameCallback();
        this.maybeIdleCallback();
    }

    @Override
    public void onHostResume() {
        this.isPaused.set(false);
        if (!ReactInstanceManager.newUIFresh) {
            this.setChoreographerCallback();
            this.maybeSetChoreographerIdleCallback();
        } else if (!this.mTimers.isEmpty()) {
            this.setChoreographerCallback();
            this.maybeSetChoreographerIdleCallback();
        }
    }

    @Override
    public void onHeadlessJsTaskStart(int taskId) {
        if (!ReactInstanceManager.newUIFresh && !this.isRunningTasks.getAndSet(true)) {
            this.setChoreographerCallback();
            this.maybeSetChoreographerIdleCallback();
        }
    }

    @Override
    public void onHeadlessJsTaskFinish(int taskId) {
        HeadlessJsTaskContext headlessJsTaskContext = HeadlessJsTaskContext.getInstance(this.getReactApplicationContext());
        if (!headlessJsTaskContext.hasActiveTasks()) {
            this.isRunningTasks.set(false);
            this.clearFrameCallback();
            this.maybeIdleCallback();
        }
    }

    @Override
    public void onCatalystInstanceDestroy() {
        this.clearFrameCallback();
        this.clearChoreographerIdleCallback();
        HeadlessJsTaskContext headlessJsTaskContext = HeadlessJsTaskContext.getInstance(this.getReactApplicationContext());
        headlessJsTaskContext.removeTaskEventListener(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void maybeSetChoreographerIdleCallback() {
        Object object = this.mIdleCallbackGuard;
        synchronized (object) {
            if (this.mSendIdleEvents) {
                this.setChoreographerIdleCallback();
            }
        }
    }

    private void maybeIdleCallback() {
        if (this.isPaused.get() && !this.isRunningTasks.get()) {
            this.clearFrameCallback();
        }
    }

    private void setChoreographerCallback() {
        if (!this.mFrameCallbackPosted) {
            this.mReactChoreographer.postFrameCallback(ReactChoreographer.CallbackType.TIMERS_EVENTS, this.mTimerFrameCallback);
            this.mFrameCallbackPosted = true;
        }
    }

    private void clearFrameCallback() {
        HeadlessJsTaskContext headlessJsTaskContext = HeadlessJsTaskContext.getInstance(this.getReactApplicationContext());
        if (this.mFrameCallbackPosted && this.isPaused.get() && !headlessJsTaskContext.hasActiveTasks()) {
            this.mReactChoreographer.removeFrameCallback(ReactChoreographer.CallbackType.TIMERS_EVENTS, this.mTimerFrameCallback);
            this.mFrameCallbackPosted = false;
        }
    }

    private void setChoreographerIdleCallback() {
        if (!this.mFrameIdleCallbackPosted) {
            this.mReactChoreographer.postFrameCallback(ReactChoreographer.CallbackType.IDLE_EVENT, this.mIdleFrameCallback);
            this.mFrameIdleCallbackPosted = true;
        }
    }

    private void clearChoreographerIdleCallback() {
        if (this.mFrameIdleCallbackPosted) {
            this.mReactChoreographer.removeFrameCallback(ReactChoreographer.CallbackType.IDLE_EVENT, this.mIdleFrameCallback);
            this.mFrameIdleCallbackPosted = false;
        }
    }

    @Override
    public String getName() {
        return NAME;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ReactMethod
    public void createTimer(int callbackID, int duration, double jsSchedulingTime, boolean repeat) {
        long driftTime;
        long deviceTime = SystemClock.currentTimeMillis();
        long remoteTime = (long)jsSchedulingTime;
        if (this.mDevSupportManager.getDevSupportEnabled() && (driftTime = Math.abs(remoteTime - deviceTime)) > 60000L) {
            this.getReactApplicationContext().getJSModule(JSTimers.class).emitTimeDriftWarning("Debugger and device times have drifted by more than 60s. Please correct this by running adb shell \"date `date +%m%d%H%M%Y.%S`\" on your debugger machine.");
        }
        long adjustedDuration = Math.max(0L, remoteTime - deviceTime + (long)duration);
        if (duration == 0 && !repeat) {
            WritableArray timerToCall = Arguments.createArray();
            timerToCall.pushInt(callbackID);
            this.getReactApplicationContext().getJSModule(JSTimers.class).callTimers(timerToCall);
            return;
        }
        long initialTargetTime = SystemClock.nanoTime() / 1000000L + adjustedDuration;
        Timer timer = new Timer(callbackID, initialTargetTime, duration, repeat);
        Object object = this.mTimerGuard;
        synchronized (object) {
            this.mTimers.add(timer);
            this.mTimerIdsToTimers.put(callbackID, (Object)timer);
        }
        if (ReactInstanceManager.newUIFresh && !this.mTimers.isEmpty()) {
            this.mReactChoreographer.postFrameCallback(ReactChoreographer.CallbackType.TIMERS_EVENTS, this.mTimerFrameCallback);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ReactMethod
    public void deleteTimer(int timerId) {
        Object object = this.mTimerGuard;
        synchronized (object) {
            Timer timer = (Timer)this.mTimerIdsToTimers.get(timerId);
            if (timer == null) {
                return;
            }
            this.mTimerIdsToTimers.remove(timerId);
            this.mTimers.remove(timer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ReactMethod
    public void setSendIdleEvents(final boolean sendIdleEvents) {
        Object object = this.mIdleCallbackGuard;
        synchronized (object) {
            this.mSendIdleEvents = sendIdleEvents;
        }
        UiThreadUtil.runOnUiThread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Object object = Timing.this.mIdleCallbackGuard;
                synchronized (object) {
                    if (sendIdleEvents) {
                        Timing.this.setChoreographerIdleCallback();
                    } else {
                        Timing.this.clearChoreographerIdleCallback();
                    }
                }
            }
        });
    }

    private class IdleCallbackRunnable
    implements Runnable {
        private volatile boolean mCancelled = false;
        private final long mFrameStartTime;

        public IdleCallbackRunnable(long frameStartTime) {
            this.mFrameStartTime = frameStartTime;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            boolean sendIdleEvents;
            if (this.mCancelled) {
                return;
            }
            long frameTimeMillis = this.mFrameStartTime / 1000000L;
            long timeSinceBoot = SystemClock.uptimeMillis();
            long frameTimeElapsed = timeSinceBoot - frameTimeMillis;
            long time = SystemClock.currentTimeMillis();
            long absoluteFrameStartTime = time - frameTimeElapsed;
            if (16.666666f - (float)frameTimeElapsed < 1.0f) {
                return;
            }
            Object object = Timing.this.mIdleCallbackGuard;
            synchronized (object) {
                sendIdleEvents = Timing.this.mSendIdleEvents;
            }
            if (sendIdleEvents) {
                Timing.this.getReactApplicationContext().getJSModule(JSTimers.class).callIdleCallbacks(absoluteFrameStartTime);
            }
            Timing.this.mCurrentIdleCallbackRunnable = null;
        }

        public void cancel() {
            this.mCancelled = true;
        }
    }

    private class IdleFrameCallback
    extends ChoreographerCompat.FrameCallback {
        private IdleFrameCallback() {
        }

        @Override
        public void doFrame(long frameTimeNanos) {
            if (Timing.this.isPaused.get() && !Timing.this.isRunningTasks.get()) {
                return;
            }
            if (Timing.this.mCurrentIdleCallbackRunnable != null) {
                Timing.this.mCurrentIdleCallbackRunnable.cancel();
            }
            Timing.this.mCurrentIdleCallbackRunnable = new IdleCallbackRunnable(frameTimeNanos);
            Timing.this.getReactApplicationContext().runOnJSQueueThread(Timing.this.mCurrentIdleCallbackRunnable);
            if (!ReactInstanceManager.newUIFresh) {
                Timing.this.mReactChoreographer.postFrameCallback(ReactChoreographer.CallbackType.IDLE_EVENT, this);
            } else if (Timing.this.mSendIdleEvents) {
                Timing.this.mReactChoreographer.postFrameCallback(ReactChoreographer.CallbackType.IDLE_EVENT, this);
            }
        }
    }

    private class TimerFrameCallback
    extends ChoreographerCompat.FrameCallback {
        @Nullable
        private WritableArray mTimersToCall = null;

        private TimerFrameCallback() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void doFrame(long frameTimeNanos) {
            if (Timing.this.isPaused.get() && !Timing.this.isRunningTasks.get()) {
                return;
            }
            long frameTimeMillis = frameTimeNanos / 1000000L;
            Object object = Timing.this.mTimerGuard;
            synchronized (object) {
                while (!Timing.this.mTimers.isEmpty() && ((Timer)Timing.this.mTimers.peek()).mTargetTime < frameTimeMillis) {
                    Timer timer = (Timer)Timing.this.mTimers.poll();
                    if (this.mTimersToCall == null) {
                        this.mTimersToCall = Arguments.createArray();
                    }
                    this.mTimersToCall.pushInt(timer.mCallbackID);
                    if (timer.mRepeat) {
                        timer.mTargetTime = frameTimeMillis + (long)timer.mInterval;
                        Timing.this.mTimers.add(timer);
                        continue;
                    }
                    Timing.this.mTimerIdsToTimers.remove(timer.mCallbackID);
                }
            }
            if (this.mTimersToCall != null) {
                Timing.this.getReactApplicationContext().getJSModule(JSTimers.class).callTimers(this.mTimersToCall);
                this.mTimersToCall = null;
            }
            if (!ReactInstanceManager.newUIFresh) {
                Timing.this.mReactChoreographer.postFrameCallback(ReactChoreographer.CallbackType.TIMERS_EVENTS, this);
            } else if (!Timing.this.mTimers.isEmpty()) {
                Timing.this.mReactChoreographer.postFrameCallback(ReactChoreographer.CallbackType.TIMERS_EVENTS, this);
            }
        }
    }

    private static class Timer {
        private final int mCallbackID;
        private final boolean mRepeat;
        private final int mInterval;
        private long mTargetTime;

        private Timer(int callbackID, long initialTargetTime, int duration, boolean repeat) {
            this.mCallbackID = callbackID;
            this.mTargetTime = initialTargetTime;
            this.mInterval = duration;
            this.mRepeat = repeat;
        }
    }
}

