/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.fabric.mounting;

import android.content.Context;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewParent;
import androidx.annotation.AnyThread;
import androidx.annotation.Nullable;
import androidx.annotation.UiThread;
import com.facebook.infer.annotation.Assertions;
import com.facebook.react.bridge.ReactContext;
import com.facebook.react.bridge.ReadableArray;
import com.facebook.react.bridge.ReadableMap;
import com.facebook.react.bridge.ReadableNativeMap;
import com.facebook.react.bridge.SoftAssertions;
import com.facebook.react.bridge.UiThreadUtil;
import com.facebook.react.fabric.jsi.EventEmitterWrapper;
import com.facebook.react.fabric.mounting.ContextBasedViewPool;
import com.facebook.react.uimanager.IllegalViewOperationException;
import com.facebook.react.uimanager.ReactStylesDiffMap;
import com.facebook.react.uimanager.RootView;
import com.facebook.react.uimanager.RootViewManager;
import com.facebook.react.uimanager.ThemedReactContext;
import com.facebook.react.uimanager.ViewGroupManager;
import com.facebook.react.uimanager.ViewManager;
import com.facebook.react.uimanager.ViewManagerRegistry;
import com.facebook.react.uimanager.common.SizeMonitoringFrameLayout;
import com.facebook.yoga.YogaMeasureMode;
import java.util.concurrent.ConcurrentHashMap;

public class MountingManager {
    private final ConcurrentHashMap<Integer, ViewState> mTagToViewState;
    private final ViewManagerRegistry mViewManagerRegistry;
    private final RootViewManager mRootViewManager = new RootViewManager();
    private final ContextBasedViewPool mViewPool;

    public MountingManager(ViewManagerRegistry viewManagerRegistry) {
        this.mTagToViewState = new ConcurrentHashMap();
        this.mViewManagerRegistry = viewManagerRegistry;
        this.mViewPool = new ContextBasedViewPool(viewManagerRegistry);
    }

    @UiThread
    public void addRootView(int reactRootTag, SizeMonitoringFrameLayout rootView) {
        if (rootView.getId() != -1) {
            throw new IllegalViewOperationException("Trying to add a root view with an explicit id already set. React Native uses the id field to track react tags and will overwrite this field. If that is fine, explicitly overwrite the id field to View.NO_ID before calling addRootView.");
        }
        this.mTagToViewState.put(reactRootTag, new ViewState(reactRootTag, (View)rootView, this.mRootViewManager, true));
        rootView.setId(reactRootTag);
    }

    @UiThread
    private void dropView(View view) {
        UiThreadUtil.assertOnUiThread();
        int reactTag = view.getId();
        ViewState state = this.getViewState(reactTag);
        ViewManager viewManager = state.mViewManager;
        if (!state.mIsRoot && viewManager != null) {
            viewManager.onDropViewInstance(view);
        }
        if (view instanceof ViewGroup && viewManager instanceof ViewGroupManager) {
            ViewGroup viewGroup = (ViewGroup)view;
            ViewGroupManager<ViewGroup> viewGroupManager = MountingManager.getViewGroupManager(state);
            for (int i = viewGroupManager.getChildCount(viewGroup) - 1; i >= 0; --i) {
                View child = viewGroupManager.getChildAt(viewGroup, i);
                if (this.mTagToViewState.get(child.getId()) != null) {
                    this.dropView(child);
                }
                viewGroupManager.removeViewAt(viewGroup, i);
            }
        }
        this.mTagToViewState.remove(reactTag);
        Context context = view.getContext();
        this.mViewPool.returnToPool((ThemedReactContext)context, ((ViewManager)Assertions.assertNotNull((Object)viewManager)).getName(), view);
    }

    @UiThread
    public void removeRootView(int reactRootTag) {
        UiThreadUtil.assertOnUiThread();
        ViewState viewState = this.mTagToViewState.get(reactRootTag);
        if (viewState == null || !viewState.mIsRoot) {
            SoftAssertions.assertUnreachable("View with tag " + reactRootTag + " is not registered as a root view");
        }
        if (viewState.mView != null) {
            this.dropView(viewState.mView);
        }
    }

    @UiThread
    public void addViewAt(int parentTag, int tag, int index) {
        UiThreadUtil.assertOnUiThread();
        ViewState parentViewState = this.getViewState(parentTag);
        ViewGroup parentView = (ViewGroup)parentViewState.mView;
        View view = this.getViewState((int)tag).mView;
        if (view == null) {
            throw new IllegalStateException("Unable to find view for tag " + tag);
        }
        MountingManager.getViewGroupManager(parentViewState).addView(parentView, view, index);
    }

    private ViewState getViewState(int tag) {
        ViewState viewState = this.mTagToViewState.get(tag);
        if (viewState == null) {
            throw new IllegalStateException("Unable to find viewState for tag " + tag);
        }
        return viewState;
    }

    public void receiveCommand(int reactTag, int commandId, @Nullable ReadableArray commandArgs) {
        ViewState viewState = this.getViewState(reactTag);
        if (viewState.mViewManager == null) {
            throw new IllegalStateException("Unable to find viewState manager for tag " + reactTag);
        }
        if (viewState.mView == null) {
            throw new IllegalStateException("Unable to find viewState view for tag " + reactTag);
        }
        viewState.mViewManager.receiveCommand(viewState.mView, commandId, commandArgs);
    }

    private static ViewGroupManager<ViewGroup> getViewGroupManager(ViewState viewState) {
        if (viewState.mViewManager == null) {
            throw new IllegalStateException("Unable to find ViewManager");
        }
        return (ViewGroupManager)viewState.mViewManager;
    }

    @UiThread
    public void removeViewAt(int parentTag, int index) {
        UiThreadUtil.assertOnUiThread();
        ViewState viewState = this.getViewState(parentTag);
        ViewGroup parentView = (ViewGroup)viewState.mView;
        if (parentView == null) {
            throw new IllegalStateException("Unable to find view for tag " + parentTag);
        }
        MountingManager.getViewGroupManager(viewState).removeViewAt(parentView, index);
    }

    @UiThread
    public void createView(ThemedReactContext themedReactContext, String componentName, int reactTag, boolean isVirtual) {
        UiThreadUtil.assertOnUiThread();
        View view = null;
        ViewManager viewManager = null;
        if (!isVirtual) {
            viewManager = this.mViewManagerRegistry.get(componentName);
            view = this.mViewPool.getOrCreateView(componentName, themedReactContext);
            view.setId(reactTag);
        }
        if (viewManager != null) {
            this.mTagToViewState.put(reactTag, new ViewState(reactTag, view, viewManager));
        }
    }

    @UiThread
    public void updateProps(int reactTag, ReadableMap props) {
        if (props == null) {
            return;
        }
        UiThreadUtil.assertOnUiThread();
        ViewState viewState = this.getViewState(reactTag);
        viewState.mCurrentProps = new ReactStylesDiffMap(props);
        View view = viewState.mView;
        if (view == null) {
            throw new IllegalStateException("Unable to find view for tag " + reactTag);
        }
        ((ViewManager)Assertions.assertNotNull((Object)viewState.mViewManager)).updateProperties(view, viewState.mCurrentProps);
    }

    @UiThread
    public void updateLayout(int reactTag, int x, int y, int width, int height) {
        UiThreadUtil.assertOnUiThread();
        ViewState viewState = this.getViewState(reactTag);
        if (viewState.mIsRoot) {
            return;
        }
        View viewToUpdate = viewState.mView;
        if (viewToUpdate == null) {
            throw new IllegalStateException("Unable to find View for tag: " + reactTag);
        }
        viewToUpdate.measure(View.MeasureSpec.makeMeasureSpec((int)width, (int)0x40000000), View.MeasureSpec.makeMeasureSpec((int)height, (int)0x40000000));
        ViewParent parent = viewToUpdate.getParent();
        if (parent instanceof RootView) {
            parent.requestLayout();
        }
        viewToUpdate.layout(x, y, x + width, y + height);
    }

    @UiThread
    public void deleteView(int reactTag) {
        UiThreadUtil.assertOnUiThread();
        View view = this.getViewState((int)reactTag).mView;
        if (view != null) {
            this.dropView(view);
        } else {
            this.mTagToViewState.remove(reactTag);
        }
    }

    @UiThread
    public void updateLocalData(int reactTag, ReadableMap newLocalData) {
        UiThreadUtil.assertOnUiThread();
        ViewState viewState = this.getViewState(reactTag);
        if (viewState.mCurrentProps == null) {
            throw new IllegalStateException("Can not update local data to view without props: " + reactTag);
        }
        if (viewState.mCurrentLocalData != null && newLocalData.hasKey("hash") && viewState.mCurrentLocalData.getDouble("hash") == newLocalData.getDouble("hash") && viewState.mCurrentLocalData.toString().equals(newLocalData.toString())) {
            return;
        }
        viewState.mCurrentLocalData = newLocalData;
        ViewManager viewManager = viewState.mViewManager;
        if (viewManager == null) {
            throw new IllegalStateException("Unable to find ViewManager for tag: " + reactTag);
        }
        Object extraData = viewManager.updateLocalData(viewState.mView, viewState.mCurrentProps, new ReactStylesDiffMap(viewState.mCurrentLocalData));
        if (extraData != null) {
            viewManager.updateExtraData(viewState.mView, extraData);
        }
    }

    @UiThread
    public void preallocateView(ThemedReactContext reactContext, String componentName) {
        this.mViewPool.createView(reactContext, componentName);
    }

    @UiThread
    public void updateEventEmitter(int reactTag, EventEmitterWrapper eventEmitter) {
        UiThreadUtil.assertOnUiThread();
        ViewState viewState = this.getViewState(reactTag);
        viewState.mEventEmitter = eventEmitter;
    }

    @AnyThread
    public long measure(ReactContext context, String componentName, ReadableNativeMap localData, ReadableNativeMap props, float width, YogaMeasureMode widthMode, float height, YogaMeasureMode heightMode) {
        return this.mViewManagerRegistry.get(componentName).measure(context, localData, props, width, widthMode, height, heightMode);
    }

    @AnyThread
    @Nullable
    public EventEmitterWrapper getEventEmitter(int reactTag) {
        ViewState viewState = this.mTagToViewState.get(reactTag);
        return viewState == null ? null : viewState.mEventEmitter;
    }

    private static class ViewState {
        @Nullable
        final View mView;
        final int mReactTag;
        final boolean mIsRoot;
        @Nullable
        final ViewManager mViewManager;
        public ReactStylesDiffMap mCurrentProps;
        public ReadableMap mCurrentLocalData;
        public EventEmitterWrapper mEventEmitter;

        private ViewState(int reactTag, @Nullable View view, @Nullable ViewManager viewManager) {
            this(reactTag, view, viewManager, false);
        }

        private ViewState(int reactTag, @Nullable View view, ViewManager viewManager, boolean isRoot) {
            this.mReactTag = reactTag;
            this.mView = view;
            this.mIsRoot = isRoot;
            this.mViewManager = viewManager;
        }
    }
}

