/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.bridge;

import androidx.annotation.NonNull;
import com.facebook.infer.annotation.Assertions;
import com.facebook.jni.HybridData;
import com.facebook.proguard.annotations.DoNotStrip;
import com.facebook.react.bridge.ReactBridge;
import com.facebook.react.bridge.ReadableMap;
import com.facebook.react.bridge.ReadableNativeMap;
import com.facebook.react.bridge.WritableArray;
import com.facebook.react.bridge.WritableMap;
import com.facebook.react.bridge.WritableNativeArray;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@DoNotStrip
public class WritableNativeMap
extends ReadableNativeMap
implements WritableMap {
    @Override
    public native void putBoolean(@Nonnull String var1, boolean var2);

    @Override
    public native void putDouble(@Nonnull String var1, double var2);

    @Override
    public native void putInt(@Nonnull String var1, int var2);

    @Override
    public native void putString(@Nonnull String var1, @Nullable String var2);

    @Override
    public native void putNull(@NonNull String var1);

    @Override
    public void putMap(@Nonnull String key, @Nullable WritableMap value) {
        Assertions.assertCondition((value == null || value instanceof WritableNativeMap ? 1 : 0) != 0, (String)"Illegal type provided");
        this.putNativeMap(key, (WritableNativeMap)value);
    }

    @Override
    public void putArray(@Nonnull String key, @Nullable WritableArray value) {
        Assertions.assertCondition((value == null || value instanceof WritableNativeArray ? 1 : 0) != 0, (String)"Illegal type provided");
        this.putNativeArray(key, (WritableNativeArray)value);
    }

    @Override
    public void merge(@Nonnull ReadableMap source) {
        Assertions.assertCondition((boolean)(source instanceof ReadableNativeMap), (String)"Illegal type provided");
        this.mergeNativeMap((ReadableNativeMap)source);
    }

    public WritableNativeMap() {
        super(WritableNativeMap.initHybrid());
    }

    private static native HybridData initHybrid();

    private native void putNativeMap(String var1, WritableNativeMap var2);

    private native void putNativeArray(String var1, WritableNativeArray var2);

    private native void mergeNativeMap(ReadableNativeMap var1);

    static {
        ReactBridge.staticInit();
    }
}

