/*
 * Decompiled with CFR 0.152.
 */
package com.just.agentweb;

import android.os.Build;
import android.webkit.ValueCallback;
import android.webkit.WebView;
import com.just.agentweb.AgentWebUtils;
import com.just.agentweb.JsAccessEntrace;

public abstract class BaseJsAccessEntrace
implements JsAccessEntrace {
    private WebView mWebView;
    public static final String TAG = BaseJsAccessEntrace.class.getSimpleName();

    BaseJsAccessEntrace(WebView webView) {
        this.mWebView = webView;
    }

    @Override
    public void callJs(String js, ValueCallback<String> callback) {
        if (Build.VERSION.SDK_INT >= 19) {
            this.evaluateJs(js, callback);
        } else {
            this.loadJs(js);
        }
    }

    @Override
    public void callJs(String js) {
        this.callJs(js, null);
    }

    private void loadJs(String js) {
        this.mWebView.loadUrl(js);
    }

    private void evaluateJs(String js, final ValueCallback<String> callback) {
        this.mWebView.evaluateJavascript(js, (ValueCallback)new ValueCallback<String>(){

            public void onReceiveValue(String value) {
                if (callback != null) {
                    callback.onReceiveValue((Object)value);
                }
            }
        });
    }

    @Override
    public void quickCallJs(String method, ValueCallback<String> callback, String ... params) {
        StringBuilder sb = new StringBuilder();
        sb.append("javascript:" + method);
        if (params == null || params.length == 0) {
            sb.append("()");
        } else {
            sb.append("(").append(this.concat(params)).append(")");
        }
        this.callJs(sb.toString(), callback);
    }

    private String concat(String ... params) {
        StringBuilder mStringBuilder = new StringBuilder();
        for (int i = 0; i < params.length; ++i) {
            String param = params[i];
            if (!AgentWebUtils.isJson(param)) {
                mStringBuilder.append("\"").append(param).append("\"");
            } else {
                mStringBuilder.append(param);
            }
            if (i == params.length - 1) continue;
            mStringBuilder.append(" , ");
        }
        return mStringBuilder.toString();
    }

    @Override
    public void quickCallJs(String method, String ... params) {
        this.quickCallJs(method, (ValueCallback<String>)null, params);
    }

    @Override
    public void quickCallJs(String method) {
        this.quickCallJs(method, (String[])null);
    }
}

