/*
 * Decompiled with CFR 0.152.
 */
package com.browserup.harreader.model;

import com.browserup.harreader.model.HarContent;
import com.browserup.harreader.model.HarCookie;
import com.browserup.harreader.model.HarHeader;
import com.browserup.harreader.model.HttpStatus;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public class HarResponse {
    protected static final Long DEFAULT_SIZE = -1L;
    private HttpStatus status;
    private String statusText = "";
    private String httpVersion = "HTTP/1.1";
    private List<HarCookie> cookies;
    private List<HarHeader> headers;
    private HarContent content;
    private String redirectURL = "";
    private Long headersSize;
    private Long bodySize;
    private String comment;
    private Map<String, Object> additional = new HashMap<String, Object>();

    public int getStatus() {
        if (this.status == null) {
            this.status = HttpStatus.UNKNOWN_HTTP_STATUS;
        }
        return this.status.getCode();
    }

    public void setStatus(int status) {
        this.status = HttpStatus.byCode(status);
    }

    public String getStatusText() {
        return this.statusText;
    }

    public void setStatusText(String statusText) {
        this.statusText = statusText;
    }

    public String getHttpVersion() {
        return this.httpVersion;
    }

    public void setHttpVersion(String httpVersion) {
        this.httpVersion = httpVersion;
    }

    public List<HarCookie> getCookies() {
        if (this.cookies == null) {
            this.cookies = new ArrayList<HarCookie>();
        }
        return this.cookies;
    }

    public void setCookies(List<HarCookie> cookies) {
        this.cookies = cookies;
    }

    public List<HarHeader> getHeaders() {
        if (this.headers == null) {
            this.headers = new ArrayList<HarHeader>();
        }
        return this.headers;
    }

    public void setHeaders(List<HarHeader> headers) {
        this.headers = headers;
    }

    public HarContent getContent() {
        if (this.content == null) {
            this.content = new HarContent();
        }
        return this.content;
    }

    public void setContent(HarContent content) {
        this.content = content;
    }

    public String getRedirectURL() {
        return this.redirectURL;
    }

    public void setRedirectURL(String redirectURL) {
        this.redirectURL = redirectURL;
    }

    public Long getHeadersSize() {
        if (this.headersSize == null) {
            return DEFAULT_SIZE;
        }
        return this.headersSize;
    }

    public void setHeadersSize(Long headersSize) {
        this.headersSize = headersSize;
    }

    public Long getBodySize() {
        if (this.bodySize == null) {
            return DEFAULT_SIZE;
        }
        return this.bodySize;
    }

    public void setBodySize(Long bodySize) {
        this.bodySize = bodySize;
    }

    public String getComment() {
        return this.comment;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditional() {
        return this.additional;
    }

    @JsonAnySetter
    public void setAdditionalField(String name, Object value) {
        this.additional.put(name, value);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HarResponse that = (HarResponse)o;
        return this.status == that.status && Objects.equals(this.statusText, that.statusText) && Objects.equals(this.httpVersion, that.httpVersion) && Objects.equals(this.cookies, that.cookies) && Objects.equals(this.headers, that.headers) && Objects.equals(this.content, that.content) && Objects.equals(this.redirectURL, that.redirectURL) && Objects.equals(this.headersSize, that.headersSize) && Objects.equals(this.bodySize, that.bodySize) && Objects.equals(this.comment, that.comment) && Objects.equals(this.additional, that.additional);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.status, this.statusText, this.httpVersion, this.cookies, this.headers, this.content, this.redirectURL, this.headersSize, this.bodySize, this.comment, this.additional});
    }
}

