/*
 * Decompiled with CFR 0.152.
 */
package com.browserup.bup.util;

import com.browserup.bup.util.BrowserUpHttpUtil;
import io.netty.handler.codec.http.FullHttpMessage;
import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpMessage;
import java.nio.charset.Charset;
import java.nio.charset.UnsupportedCharsetException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpObjectUtil {
    private static final Logger log = LoggerFactory.getLogger(HttpObjectUtil.class);

    public static void replaceTextHttpEntityBody(FullHttpMessage message, String newContents) {
        Charset messageCharset;
        String contentTypeHeader = message.headers().get((CharSequence)HttpHeaderNames.CONTENT_TYPE);
        try {
            messageCharset = BrowserUpHttpUtil.readCharsetInContentTypeHeader(contentTypeHeader);
        }
        catch (com.browserup.bup.exception.UnsupportedCharsetException e) {
            UnsupportedCharsetException cause = e.getUnsupportedCharsetExceptionCause();
            log.error("Found unsupported character set in Content-Type header '{}' while attempting to replace contents of HTTP message.", (Object)contentTypeHeader, (Object)cause);
            throw cause;
        }
        if (messageCharset == null) {
            messageCharset = BrowserUpHttpUtil.DEFAULT_HTTP_CHARSET;
            log.warn("No character set declared in HTTP message. Replacing text using default charset {}.", (Object)messageCharset);
        }
        byte[] contentBytes = newContents.getBytes(messageCharset);
        HttpObjectUtil.replaceBinaryHttpEntityBody(message, contentBytes);
    }

    public static void replaceBinaryHttpEntityBody(FullHttpMessage message, byte[] newBinaryContents) {
        message.content().resetWriterIndex();
        message.content().ensureWritable(newBinaryContents.length, true);
        message.content().writeBytes(newBinaryContents);
        message.headers().set((CharSequence)HttpHeaderNames.CONTENT_LENGTH, (Object)newBinaryContents.length);
    }

    public static String extractHttpEntityBody(HttpContent httpContent, Charset charset) {
        if (charset == null) {
            throw new IllegalArgumentException("No charset specified when extracting the contents of an HTTP message");
        }
        byte[] contentBytes = BrowserUpHttpUtil.extractReadableBytes(httpContent.content());
        return new String(contentBytes, charset);
    }

    public static String extractHttpEntityBody(FullHttpMessage httpMessage) {
        Charset charset;
        try {
            charset = HttpObjectUtil.getCharsetFromMessage((HttpMessage)httpMessage);
        }
        catch (com.browserup.bup.exception.UnsupportedCharsetException e) {
            UnsupportedCharsetException cause = e.getUnsupportedCharsetExceptionCause();
            String contentTypeHeader = HttpHeaders.getHeader((HttpMessage)httpMessage, (CharSequence)HttpHeaderNames.CONTENT_TYPE);
            log.error("Cannot retrieve text contents of message because HTTP message declares a character set that is not supported on this platform. Content type header: {}.", (Object)contentTypeHeader, (Object)cause);
            throw cause;
        }
        return HttpObjectUtil.extractHttpEntityBody((HttpContent)httpMessage, charset);
    }

    public static Charset getCharsetFromMessage(HttpMessage httpMessage) throws com.browserup.bup.exception.UnsupportedCharsetException {
        String contentTypeHeader = HttpHeaders.getHeader((HttpMessage)httpMessage, (CharSequence)HttpHeaderNames.CONTENT_TYPE);
        Charset charset = BrowserUpHttpUtil.readCharsetInContentTypeHeader(contentTypeHeader);
        if (charset == null) {
            return BrowserUpHttpUtil.DEFAULT_HTTP_CHARSET;
        }
        return charset;
    }

    public static byte[] extractBinaryHttpEntityBody(HttpContent httpContent) {
        return BrowserUpHttpUtil.extractReadableBytes(httpContent.content());
    }
}

