/*
 * Decompiled with CFR 0.152.
 */
package com.browserup.bup.proxy;

import com.google.common.collect.ImmutableList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Whitelist {
    private final List<Pattern> patterns;
    private final int statusCode;
    private final boolean enabled;
    public static final Whitelist WHITELIST_DISABLED = new Whitelist();

    public Whitelist() {
        this.patterns = Collections.emptyList();
        this.statusCode = -1;
        this.enabled = false;
    }

    public Whitelist(int statusCode) {
        this.patterns = Collections.emptyList();
        this.statusCode = statusCode;
        this.enabled = true;
    }

    @Deprecated
    public Whitelist(String[] patterns, int statusCode) {
        this(patterns == null ? null : Arrays.asList(patterns), statusCode);
    }

    public Whitelist(Collection<String> patterns, int statusCode) {
        if (patterns == null || patterns.isEmpty()) {
            this.patterns = Collections.emptyList();
        } else {
            ImmutableList.Builder builder = ImmutableList.builder();
            patterns.stream().map(Pattern::compile).forEach(arg_0 -> ((ImmutableList.Builder)builder).add(arg_0));
            this.patterns = builder.build();
        }
        this.statusCode = statusCode;
        this.enabled = true;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public Collection<Pattern> getPatterns() {
        return this.patterns;
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    @Deprecated
    public int getResponseCode() {
        return this.getStatusCode();
    }

    public boolean matches(String url) {
        if (!this.enabled) {
            return false;
        }
        return this.getPatterns().stream().map(pattern -> pattern.matcher(url)).anyMatch(Matcher::matches);
    }
}

