/*
 * Decompiled with CFR 0.152.
 */
package com.booking.rtlviewpager;

import android.content.Context;
import android.database.DataSetObserver;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.text.TextUtilsCompat;
import android.support.v4.util.ArrayMap;
import android.support.v4.view.PagerAdapter;
import android.support.v4.view.ViewPager;
import android.util.AttributeSet;
import android.view.ViewGroup;
import com.booking.rtlviewpager.PagerAdapterWrapper;
import java.util.Locale;
import java.util.Map;

public class RtlViewPager
extends ViewPager {
    @NonNull
    private final Map<ViewPager.OnPageChangeListener, ReverseOnPageChangeListener> reverseOnPageChangeListeners = new ArrayMap(1);
    @Nullable
    private DataSetObserver dataSetObserver;
    private boolean suppressOnPageChangeListeners;

    public RtlViewPager(Context context) {
        super(context);
    }

    public RtlViewPager(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        this.registerRtlDataSetObserver(super.getAdapter());
    }

    protected void onDetachedFromWindow() {
        this.unregisterRtlDataSetObserver();
        super.onDetachedFromWindow();
    }

    private void registerRtlDataSetObserver(PagerAdapter adapter) {
        if (adapter instanceof ReverseAdapter && this.dataSetObserver == null) {
            this.dataSetObserver = new RevalidateIndicesOnContentChange((ReverseAdapter)adapter);
            adapter.registerDataSetObserver(this.dataSetObserver);
            ((ReverseAdapter)adapter).revalidateIndices();
        }
    }

    private void unregisterRtlDataSetObserver() {
        PagerAdapter adapter = super.getAdapter();
        if (adapter instanceof ReverseAdapter && this.dataSetObserver != null) {
            adapter.unregisterDataSetObserver(this.dataSetObserver);
            this.dataSetObserver = null;
        }
    }

    public void setCurrentItem(int item, boolean smoothScroll) {
        super.setCurrentItem(this.convert(item), smoothScroll);
    }

    public void setCurrentItem(int item) {
        super.setCurrentItem(this.convert(item));
    }

    public int getCurrentItem() {
        return this.convert(super.getCurrentItem());
    }

    private int convert(int position) {
        if (position >= 0 && this.isRtl()) {
            return this.getAdapter() == null ? 0 : this.getAdapter().getCount() - position - 1;
        }
        return position;
    }

    @Nullable
    public PagerAdapter getAdapter() {
        PagerAdapter adapter = super.getAdapter();
        return adapter instanceof ReverseAdapter ? ((ReverseAdapter)adapter).getInnerAdapter() : adapter;
    }

    public void fakeDragBy(float xOffset) {
        super.fakeDragBy(this.isRtl() ? xOffset : -xOffset);
    }

    public void setAdapter(@Nullable PagerAdapter adapter) {
        boolean rtlReady;
        this.unregisterRtlDataSetObserver();
        boolean bl = rtlReady = adapter != null && this.isRtl();
        if (rtlReady) {
            adapter = new ReverseAdapter(adapter);
            this.registerRtlDataSetObserver(adapter);
        }
        super.setAdapter(adapter);
        if (rtlReady) {
            this.setCurrentItemWithoutNotification(0);
        }
    }

    private void setCurrentItemWithoutNotification(int index) {
        this.suppressOnPageChangeListeners = true;
        this.setCurrentItem(index, false);
        this.suppressOnPageChangeListeners = false;
    }

    protected boolean isRtl() {
        return TextUtilsCompat.getLayoutDirectionFromLocale((Locale)this.getContext().getResources().getConfiguration().locale) == 1;
    }

    public void addOnPageChangeListener(@NonNull ViewPager.OnPageChangeListener listener) {
        if (this.isRtl()) {
            ReverseOnPageChangeListener reverseListener = new ReverseOnPageChangeListener(listener);
            this.reverseOnPageChangeListeners.put(listener, reverseListener);
            listener = reverseListener;
        }
        super.addOnPageChangeListener(listener);
    }

    public void removeOnPageChangeListener(@NonNull ViewPager.OnPageChangeListener listener) {
        if (this.isRtl()) {
            listener = this.reverseOnPageChangeListeners.remove(listener);
        }
        super.removeOnPageChangeListener(listener);
    }

    private class ReverseOnPageChangeListener
    implements ViewPager.OnPageChangeListener {
        @NonNull
        private final ViewPager.OnPageChangeListener original;
        private int pagerPosition;

        private ReverseOnPageChangeListener(ViewPager.OnPageChangeListener original) {
            this.original = original;
            this.pagerPosition = -1;
        }

        public void onPageScrolled(int position, float positionOffset, int positionOffsetPixels) {
            if (!RtlViewPager.this.suppressOnPageChangeListeners) {
                this.pagerPosition = positionOffset == 0.0f && positionOffsetPixels == 0 ? this.reverse(position) : this.reverse(position + 1);
                this.original.onPageScrolled(this.pagerPosition, positionOffset > 0.0f ? 1.0f - positionOffset : positionOffset, positionOffsetPixels);
            }
        }

        public void onPageSelected(int position) {
            if (!RtlViewPager.this.suppressOnPageChangeListeners) {
                this.original.onPageSelected(this.reverse(position));
            }
        }

        public void onPageScrollStateChanged(int state) {
            if (!RtlViewPager.this.suppressOnPageChangeListeners) {
                this.original.onPageScrollStateChanged(state);
            }
        }

        private int reverse(int position) {
            PagerAdapter adapter = RtlViewPager.this.getAdapter();
            return adapter == null ? position : adapter.getCount() - position - 1;
        }
    }

    private static class RevalidateIndicesOnContentChange
    extends DataSetObserver {
        @NonNull
        private final ReverseAdapter adapter;

        private RevalidateIndicesOnContentChange(@NonNull ReverseAdapter adapter) {
            this.adapter = adapter;
        }

        public void onChanged() {
            super.onChanged();
            this.adapter.revalidateIndices();
        }
    }

    private class ReverseAdapter
    extends PagerAdapterWrapper {
        private int lastCount;

        public ReverseAdapter(PagerAdapter adapter) {
            super(adapter);
            this.lastCount = adapter.getCount();
        }

        @Override
        public CharSequence getPageTitle(int position) {
            return super.getPageTitle(this.reverse(position));
        }

        @Override
        public float getPageWidth(int position) {
            return super.getPageWidth(this.reverse(position));
        }

        @Override
        public int getItemPosition(Object object) {
            int itemPosition = super.getItemPosition(object);
            return itemPosition < 0 ? itemPosition : this.reverse(itemPosition);
        }

        @Override
        public Object instantiateItem(ViewGroup container, int position) {
            return super.instantiateItem(container, this.reverse(position));
        }

        @Override
        public void destroyItem(ViewGroup container, int position, Object object) {
            super.destroyItem(container, this.reverse(position), object);
        }

        @Override
        public void setPrimaryItem(ViewGroup container, int position, Object object) {
            super.setPrimaryItem(container, this.lastCount - position - 1, object);
        }

        private int reverse(int position) {
            return this.getCount() - position - 1;
        }

        private void revalidateIndices() {
            int newCount = this.getCount();
            if (newCount != this.lastCount) {
                RtlViewPager.this.setCurrentItemWithoutNotification(Math.max(0, this.lastCount - 1));
                this.lastCount = newCount;
            }
        }
    }
}

