/*
 * Decompiled with CFR 0.152.
 */
package com.bol.openapi;

import com.bol.api.openapi_4_0.SearchResults;
import com.bol.openapi.OpenApiClient;
import com.bol.openapi.QueryCategoryId;
import com.bol.openapi.QueryDataType;
import com.bol.openapi.QueryIncludeAttribute;
import com.bol.openapi.QueryLimit;
import com.bol.openapi.QueryOfferType;
import com.bol.openapi.QueryOffset;
import com.bol.openapi.QueryProductId;
import com.bol.openapi.QuerySearch;
import com.bol.openapi.QuerySearchField;
import com.bol.openapi.QuerySortingMethod;

public class SearchBuilder {
    private static final int OFFSET_DEFAULT = 0;
    private static final int LIMIT_DEFAULT = 10;
    private final OpenApiClient client;
    private QuerySearch.Builder query = QuerySearch.builder();
    private QueryProductId.Builder productIds = QueryProductId.builder();
    private QueryCategoryId.Builder categoryIds = QueryCategoryId.builder();
    private QueryDataType.Builder dataTypes = QueryDataType.builder();
    private QueryOfferType.Builder offerTypes = QueryOfferType.builder();
    private QuerySortingMethod sortingMethod = QuerySortingMethod.builder().by(QuerySortingMethod.SortingBy.PRICE).order(QuerySortingMethod.SortingOrder.ASCENDING);
    private QueryOffset offset = QueryOffset.builder().offset(0);
    private QueryLimit limit = QueryLimit.builder().limit(10);
    private QueryIncludeAttribute includeAttributes = QueryIncludeAttribute.builder().exclude();
    private QuerySearchField searchField = QuerySearchField.builder().none();

    public SearchBuilder(OpenApiClient client) {
        this.client = client;
    }

    public SearchBuilder(SearchBuilder builder) {
        this.client = builder.client;
        this.query = builder.query;
        this.productIds = builder.productIds;
        this.categoryIds = builder.categoryIds;
        this.dataTypes = builder.dataTypes;
        this.offerTypes = builder.offerTypes;
        this.sortingMethod = builder.sortingMethod;
        this.offset = builder.offset;
        this.limit = builder.limit;
        this.includeAttributes = builder.includeAttributes;
        this.searchField = builder.searchField;
    }

    public SearchBuilder term(String term) {
        this.query.add(term);
        return new SearchBuilder(this);
    }

    public SearchBuilder product(String id) {
        this.productIds.add(id);
        return new SearchBuilder(this);
    }

    public SearchBuilder category(String id) {
        this.categoryIds.add(id);
        return new SearchBuilder(this);
    }

    public SearchBuilder allOffers() {
        this.offerTypes.add(QueryOfferType.OfferType.ALL);
        return new SearchBuilder(this);
    }

    public SearchBuilder cheapestOffer() {
        this.offerTypes.add(QueryOfferType.OfferType.CHEAPEST);
        return new SearchBuilder(this);
    }

    public SearchBuilder bolOffer() {
        this.offerTypes.add(QueryOfferType.OfferType.BOLCOM);
        return new SearchBuilder(this);
    }

    public SearchBuilder newOffer() {
        this.offerTypes.add(QueryOfferType.OfferType.NEW);
        return new SearchBuilder(this);
    }

    public SearchBuilder secondHandOffer() {
        this.offerTypes.add(QueryOfferType.OfferType.SECONDHAND);
        return new SearchBuilder(this);
    }

    public SearchBuilder sort(QuerySortingMethod.SortingBy by) {
        this.sortingMethod = QuerySortingMethod.builder().by(by).order(QuerySortingMethod.SortingOrder.ASCENDING);
        return new SearchBuilder(this);
    }

    public SearchBuilder sortDescending(QuerySortingMethod.SortingBy by) {
        this.sortingMethod = QuerySortingMethod.builder().by(by).order(QuerySortingMethod.SortingOrder.DESCENDING);
        return new SearchBuilder(this);
    }

    public SearchBuilder offset(int amount) {
        this.offset = QueryOffset.builder().offset(amount);
        return new SearchBuilder(this);
    }

    public SearchBuilder limit(int amount) {
        this.limit = QueryLimit.builder().limit(amount);
        return new SearchBuilder(this);
    }

    public SearchBuilder includeAttributes() {
        this.includeAttributes = QueryIncludeAttribute.builder().include();
        return new SearchBuilder(this);
    }

    public SearchBuilder field(QuerySearchField.SearchField field) {
        this.searchField = QuerySearchField.builder().field(field);
        return new SearchBuilder(this);
    }

    public SearchResults search() {
        return this.client.getApi().search(this.query.create(), this.productIds.create(), this.categoryIds.create(), this.dataTypes.create(), this.offerTypes.create(), this.sortingMethod, this.offset, this.limit, this.includeAttributes, this.searchField);
    }
}

