/*
 * Decompiled with CFR 0.152.
 */
package com.bol.openapi;

import com.bol.api.openapi_4_0.Pong;
import com.bol.openapi.HealthStatus;
import com.bol.openapi.ListBuilder;
import com.bol.openapi.OpenApi;
import com.bol.openapi.OpenApiHttpClient;
import com.bol.openapi.SearchBuilder;

public class OpenApiClient {
    private final OpenApi api;

    public OpenApiClient(OpenApi api) {
        this.api = api;
    }

    public static OpenApiClient withDefaultClient(String key) {
        return new OpenApiClient(OpenApiHttpClient.create((String)key));
    }

    OpenApi getApi() {
        return this.api;
    }

    public HealthStatus getHealthStatus() {
        try {
            Pong pong = this.api.ping();
            return HealthStatus.builder().isHealthy();
        }
        catch (RuntimeException ex) {
            return HealthStatus.builder().isUnhealthy(ex.getMessage());
        }
    }

    public SearchBuilder searchBuilder() {
        return new SearchBuilder(this);
    }

    public ListBuilder listBuilder() {
        return new ListBuilder(this);
    }
}

