/*
 * Decompiled with CFR 0.152.
 */
package com.bol.openapi;

import com.bol.api.openapi_4_0.ListResults;
import com.bol.openapi.OpenApiClient;
import com.bol.openapi.QueryCategoryId;
import com.bol.openapi.QueryDataType;
import com.bol.openapi.QueryIncludeAttribute;
import com.bol.openapi.QueryLimit;
import com.bol.openapi.QueryOfferType;
import com.bol.openapi.QueryOffset;
import com.bol.openapi.QueryProductListType;
import com.bol.openapi.QuerySortingMethod;

public class ListBuilder {
    private static final int OFFSET_DEFAULT = 0;
    private static final int LIMIT_DEFAULT = 10;
    private final OpenApiClient client;
    private QueryProductListType productListType = QueryProductListType.builder().list(QueryProductListType.ProductListType.DEFAULT);
    private QueryCategoryId.Builder categoryIds = QueryCategoryId.builder();
    private QueryDataType.Builder dataTypes = QueryDataType.builder();
    private QueryOfferType.Builder offerTypes = QueryOfferType.builder();
    private QuerySortingMethod sortingMethod = QuerySortingMethod.builder().by(QuerySortingMethod.SortingBy.PRICE).order(QuerySortingMethod.SortingOrder.ASCENDING);
    private QueryOffset offset = QueryOffset.builder().offset(0);
    private QueryLimit limit = QueryLimit.builder().limit(10);
    private QueryIncludeAttribute includeAttributes = QueryIncludeAttribute.builder().exclude();

    public ListBuilder(OpenApiClient client) {
        this.client = client;
    }

    public ListBuilder(ListBuilder builder) {
        this.client = builder.client;
        this.productListType = builder.productListType;
        this.categoryIds = builder.categoryIds;
        this.dataTypes = builder.dataTypes;
        this.offerTypes = builder.offerTypes;
        this.sortingMethod = builder.sortingMethod;
        this.offset = builder.offset;
        this.limit = builder.limit;
        this.includeAttributes = builder.includeAttributes;
    }

    public ListBuilder defaultTopSelling() {
        this.productListType = QueryProductListType.builder().list(QueryProductListType.ProductListType.DEFAULT);
        return new ListBuilder(this);
    }

    public ListBuilder lastWeeksTopSelling() {
        this.productListType = QueryProductListType.builder().list(QueryProductListType.ProductListType.LAST_WEEK);
        return new ListBuilder(this);
    }

    public ListBuilder lastTwoMonthsTopSelling() {
        this.productListType = QueryProductListType.builder().list(QueryProductListType.ProductListType.LAST_TWO_MONTHS);
        return new ListBuilder(this);
    }

    public ListBuilder newTopSelling() {
        this.productListType = QueryProductListType.builder().list(QueryProductListType.ProductListType.NEW);
        return new ListBuilder(this);
    }

    public ListBuilder preOrderTopSelling() {
        this.productListType = QueryProductListType.builder().list(QueryProductListType.ProductListType.PRE_ORDER);
        return new ListBuilder(this);
    }

    public ListBuilder category(String id) {
        this.categoryIds.add(id);
        return new ListBuilder(this);
    }

    public ListBuilder allOffers() {
        this.offerTypes.add(QueryOfferType.OfferType.ALL);
        return new ListBuilder(this);
    }

    public ListBuilder cheapestOffer() {
        this.offerTypes.add(QueryOfferType.OfferType.CHEAPEST);
        return new ListBuilder(this);
    }

    public ListBuilder bolOffer() {
        this.offerTypes.add(QueryOfferType.OfferType.BOLCOM);
        return new ListBuilder(this);
    }

    public ListBuilder newOffer() {
        this.offerTypes.add(QueryOfferType.OfferType.NEW);
        return new ListBuilder(this);
    }

    public ListBuilder secondHandOffer() {
        this.offerTypes.add(QueryOfferType.OfferType.SECONDHAND);
        return new ListBuilder(this);
    }

    public ListBuilder sort(QuerySortingMethod.SortingBy by) {
        this.sortingMethod = QuerySortingMethod.builder().by(by).order(QuerySortingMethod.SortingOrder.ASCENDING);
        return new ListBuilder(this);
    }

    public ListBuilder sortDescending(QuerySortingMethod.SortingBy by) {
        this.sortingMethod = QuerySortingMethod.builder().by(by).order(QuerySortingMethod.SortingOrder.DESCENDING);
        return new ListBuilder(this);
    }

    public ListBuilder offset(int amount) {
        this.offset = QueryOffset.builder().offset(amount);
        return new ListBuilder(this);
    }

    public ListBuilder limit(int amount) {
        this.limit = QueryLimit.builder().limit(amount);
        return new ListBuilder(this);
    }

    public ListBuilder includeAttributes() {
        this.includeAttributes = QueryIncludeAttribute.builder().include();
        return new ListBuilder(this);
    }

    public ListResults list() {
        return this.client.getApi().list(this.productListType, this.categoryIds.create(), this.dataTypes.create(), this.offerTypes.create(), this.sortingMethod, this.offset, this.limit, this.includeAttributes);
    }
}

