/*
 * Decompiled with CFR 0.152.
 */
package com.bol.openapi;

import com.bol.openapi.OpenApi;
import com.bol.openapi.internal.interceptor.JsonFormatRequestInterceptor;
import com.bol.openapi.internal.interceptor.OpenApiV4AuthenticationRequestInterceptor;
import feign.Contract;
import feign.Feign;
import feign.RequestInterceptor;
import feign.codec.Decoder;
import feign.codec.Encoder;
import feign.jackson.JacksonDecoder;
import feign.jackson.JacksonEncoder;
import feign.jaxrs.JAXRSModule;
import java.util.Arrays;
import java.util.Objects;

public class OpenApiHttpClient {
    public static final String API_URL = "https://api.bol.com";
    private final String url;
    private final String apiKey;

    public static OpenApi create(String apiKey) {
        return new OpenApiHttpClient(API_URL, apiKey).createClient();
    }

    public static OpenApi create(String apiKey, String url) {
        return new OpenApiHttpClient(url, apiKey).createClient();
    }

    private OpenApiHttpClient(String url, String apiKey) {
        Objects.requireNonNull(url, "url must be provided");
        Objects.requireNonNull(apiKey, "apiKey must be provided");
        this.url = url;
        this.apiKey = apiKey;
    }

    private OpenApi createClient() {
        return (OpenApi)Feign.builder().contract((Contract)new JAXRSModule.JAXRSContract()).decoder((Decoder)new JacksonDecoder()).encoder((Encoder)new JacksonEncoder()).requestInterceptors(this.getRequestInterceptors()).target(OpenApi.class, this.url);
    }

    private Iterable<RequestInterceptor> getRequestInterceptors() {
        return Arrays.asList(new OpenApiV4AuthenticationRequestInterceptor(this.apiKey), new JsonFormatRequestInterceptor());
    }
}

