/*
 * Decompiled with CFR 0.152.
 */
package com.github.dockerjava.httpclient5;

import com.bmuschko.gradle.docker.shaded.org.apache.hc.core5.http.ClassicHttpRequest;
import com.bmuschko.gradle.docker.shaded.org.apache.hc.core5.http.ClassicHttpResponse;
import com.bmuschko.gradle.docker.shaded.org.apache.hc.core5.http.ConnectionReuseStrategy;
import com.bmuschko.gradle.docker.shaded.org.apache.hc.core5.http.HttpException;
import com.bmuschko.gradle.docker.shaded.org.apache.hc.core5.http.ProtocolException;
import com.bmuschko.gradle.docker.shaded.org.apache.hc.core5.http.ProtocolVersion;
import com.bmuschko.gradle.docker.shaded.org.apache.hc.core5.http.impl.io.HttpRequestExecutor;
import com.bmuschko.gradle.docker.shaded.org.apache.hc.core5.http.io.HttpClientConnection;
import com.bmuschko.gradle.docker.shaded.org.apache.hc.core5.http.io.HttpResponseInformationCallback;
import com.bmuschko.gradle.docker.shaded.org.apache.hc.core5.http.io.entity.AbstractHttpEntity;
import com.bmuschko.gradle.docker.shaded.org.apache.hc.core5.http.message.BasicClassicHttpRequest;
import com.bmuschko.gradle.docker.shaded.org.apache.hc.core5.http.message.StatusLine;
import com.bmuschko.gradle.docker.shaded.org.apache.hc.core5.http.protocol.HttpContext;
import com.bmuschko.gradle.docker.shaded.org.apache.hc.core5.io.Closer;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Objects;

class HijackingHttpRequestExecutor
extends HttpRequestExecutor {
    static final String HIJACKED_INPUT_ATTRIBUTE = "com.github.docker-java.hijackedInput";

    HijackingHttpRequestExecutor(ConnectionReuseStrategy connectionReuseStrategy) {
        super(connectionReuseStrategy);
    }

    @Override
    public ClassicHttpResponse execute(ClassicHttpRequest request, HttpClientConnection conn, HttpResponseInformationCallback informationCallback, HttpContext context) throws IOException, HttpException {
        Objects.requireNonNull(request, "HTTP request");
        Objects.requireNonNull(conn, "Client connection");
        Objects.requireNonNull(context, "HTTP context");
        InputStream hijackedInput = (InputStream)context.getAttribute(HIJACKED_INPUT_ATTRIBUTE);
        if (hijackedInput != null) {
            return this.executeHijacked(request, conn, context, hijackedInput);
        }
        return super.execute(request, conn, informationCallback, context);
    }

    private ClassicHttpResponse executeHijacked(ClassicHttpRequest request, HttpClientConnection conn, HttpContext context, InputStream hijackedInput) throws HttpException, IOException {
        try {
            context.setAttribute("http.ssl-session", conn.getSSLSession());
            context.setAttribute("http.connection-endpoint", conn.getEndpointDetails());
            ProtocolVersion transportVersion = request.getVersion();
            if (transportVersion != null) {
                context.setProtocolVersion(transportVersion);
            }
            conn.sendRequestHeader(request);
            conn.sendRequestEntity(request);
            conn.flush();
            ClassicHttpResponse response = conn.receiveResponseHeader();
            if (response.getCode() != 101) {
                conn.terminateRequest(request);
                throw new ProtocolException("Expected 101 Switching Protocols, got: " + new StatusLine(response));
            }
            Thread thread = new Thread(() -> {
                try {
                    BasicClassicHttpRequest fakeRequest = new BasicClassicHttpRequest("POST", "/");
                    fakeRequest.setHeader("Content-Length", Long.MAX_VALUE);
                    fakeRequest.setEntity(new HijackedEntity(hijackedInput));
                    conn.sendRequestEntity(fakeRequest);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            });
            thread.setName("docker-java-httpclient5-hijacking-stream-" + System.identityHashCode(request));
            thread.setDaemon(true);
            thread.start();
            response.setCode(200);
            conn.receiveResponseEntity(response);
            return response;
        }
        catch (HttpException | IOException | RuntimeException ex) {
            Closer.closeQuietly(conn);
            throw ex;
        }
    }

    private static class HijackedEntity
    extends AbstractHttpEntity {
        private final InputStream inStream;

        HijackedEntity(InputStream inStream) {
            super((String)null, null, false);
            this.inStream = inStream;
        }

        @Override
        public void writeTo(OutputStream outStream) throws IOException {
            int read;
            byte[] buffer = new byte[1024];
            while ((read = this.inStream.read(buffer)) != -1) {
                outStream.write(buffer, 0, read);
                outStream.flush();
            }
        }

        @Override
        public InputStream getContent() {
            return this.inStream;
        }

        @Override
        public boolean isStreaming() {
            return true;
        }

        @Override
        public boolean isRepeatable() {
            return false;
        }

        @Override
        public void close() throws IOException {
            this.inStream.close();
        }

        @Override
        public long getContentLength() {
            return -1L;
        }
    }
}

