/*
 * Decompiled with CFR 0.152.
 */
package com.github.dockerjava.core.exec;

import com.bmuschko.gradle.docker.shaded.com.fasterxml.jackson.databind.ObjectMapper;
import com.bmuschko.gradle.docker.shaded.com.fasterxml.jackson.databind.node.ObjectNode;
import com.bmuschko.gradle.docker.shaded.com.google.common.base.Preconditions;
import com.bmuschko.gradle.docker.shaded.com.google.common.io.BaseEncoding;
import com.bmuschko.gradle.docker.shaded.javax.annotation.CheckForNull;
import com.bmuschko.gradle.docker.shaded.javax.annotation.Nonnull;
import com.github.dockerjava.api.model.AuthConfig;
import com.github.dockerjava.api.model.AuthConfigurations;
import com.github.dockerjava.core.DockerClientConfig;
import com.github.dockerjava.core.InvocationBuilder;
import com.github.dockerjava.core.RemoteApiVersion;
import com.github.dockerjava.core.WebTarget;
import java.io.IOException;

public abstract class AbstrDockerCmdExec {
    private final transient DockerClientConfig dockerClientConfig;
    private final transient WebTarget baseResource;

    public AbstrDockerCmdExec(WebTarget baseResource, DockerClientConfig dockerClientConfig) {
        Preconditions.checkNotNull(baseResource, "baseResource was not specified");
        Preconditions.checkNotNull(dockerClientConfig, "dockerClientConfig was not specified");
        this.baseResource = baseResource;
        this.dockerClientConfig = dockerClientConfig;
    }

    protected WebTarget getBaseResource() {
        return this.baseResource;
    }

    @CheckForNull
    protected AuthConfigurations getBuildAuthConfigs() {
        return this.dockerClientConfig.getAuthConfigurations();
    }

    protected String registryAuth(@Nonnull AuthConfig authConfig) {
        try {
            return BaseEncoding.base64Url().encode(this.dockerClientConfig.getObjectMapper().writeValueAsString(authConfig).getBytes());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Nonnull
    protected String registryConfigs(@Nonnull AuthConfigurations authConfigs) {
        try {
            String json;
            RemoteApiVersion apiVersion = this.dockerClientConfig.getApiVersion();
            ObjectMapper objectMapper = this.dockerClientConfig.getObjectMapper();
            if (apiVersion.equals(RemoteApiVersion.UNKNOWN_VERSION)) {
                ObjectNode rootNode = (ObjectNode)objectMapper.valueToTree(authConfigs.getConfigs());
                ObjectNode authNodes = (ObjectNode)objectMapper.valueToTree(authConfigs);
                rootNode.setAll(authNodes);
                json = rootNode.toString();
            } else {
                json = apiVersion.isGreaterOrEqual(RemoteApiVersion.VERSION_1_19) ? objectMapper.writeValueAsString(authConfigs.getConfigs()) : objectMapper.writeValueAsString(authConfigs);
            }
            return BaseEncoding.base64Url().encode(json.getBytes());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Nonnull
    protected InvocationBuilder resourceWithAuthConfig(@Nonnull AuthConfig authConfig, @Nonnull InvocationBuilder request) {
        return request.header("X-Registry-Auth", this.registryAuth(authConfig));
    }

    @Nonnull
    protected InvocationBuilder resourceWithOptionalAuthConfig(@CheckForNull AuthConfig authConfig, @Nonnull InvocationBuilder request) {
        if (authConfig != null) {
            request = this.resourceWithAuthConfig(authConfig, request);
        }
        return request;
    }

    protected boolean bool(Boolean bool) {
        return bool != null && bool != false;
    }

    protected WebTarget booleanQueryParam(WebTarget webTarget, String name, Boolean value) {
        if (this.bool(value)) {
            webTarget = webTarget.queryParam(name, this.bool(value) + "");
        }
        return webTarget;
    }
}

