/*
 * Decompiled with CFR 0.152.
 */
package com.bmuschko.gradle.docker.shaded.org.bouncycastle.jcajce.provider.digest;

import com.bmuschko.gradle.docker.shaded.org.bouncycastle.asn1.teletrust.TeleTrusTObjectIdentifiers;
import com.bmuschko.gradle.docker.shaded.org.bouncycastle.crypto.CipherKeyGenerator;
import com.bmuschko.gradle.docker.shaded.org.bouncycastle.crypto.digests.RIPEMD256Digest;
import com.bmuschko.gradle.docker.shaded.org.bouncycastle.crypto.macs.HMac;
import com.bmuschko.gradle.docker.shaded.org.bouncycastle.jcajce.provider.config.ConfigurableProvider;
import com.bmuschko.gradle.docker.shaded.org.bouncycastle.jcajce.provider.digest.BCMessageDigest;
import com.bmuschko.gradle.docker.shaded.org.bouncycastle.jcajce.provider.digest.DigestAlgorithmProvider;
import com.bmuschko.gradle.docker.shaded.org.bouncycastle.jcajce.provider.symmetric.util.BaseKeyGenerator;
import com.bmuschko.gradle.docker.shaded.org.bouncycastle.jcajce.provider.symmetric.util.BaseMac;

public class RIPEMD256 {
    private RIPEMD256() {
    }

    public static class Digest
    extends BCMessageDigest
    implements Cloneable {
        public Digest() {
            super(new RIPEMD256Digest());
        }

        public Object clone() throws CloneNotSupportedException {
            Digest digest = (Digest)super.clone();
            digest.digest = new RIPEMD256Digest((RIPEMD256Digest)this.digest);
            return digest;
        }
    }

    public static class HashMac
    extends BaseMac {
        public HashMac() {
            super(new HMac(new RIPEMD256Digest()));
        }
    }

    public static class KeyGenerator
    extends BaseKeyGenerator {
        public KeyGenerator() {
            super("HMACRIPEMD256", 256, new CipherKeyGenerator());
        }
    }

    public static class Mappings
    extends DigestAlgorithmProvider {
        private static final String PREFIX = RIPEMD256.class.getName();

        public void configure(ConfigurableProvider configurableProvider) {
            configurableProvider.addAlgorithm("MessageDigest.RIPEMD256", PREFIX + "$Digest");
            configurableProvider.addAlgorithm("Alg.Alias.MessageDigest." + TeleTrusTObjectIdentifiers.ripemd256, "RIPEMD256");
            this.addHMACAlgorithm(configurableProvider, "RIPEMD256", PREFIX + "$HashMac", PREFIX + "$KeyGenerator");
        }
    }
}

