/*
 * Decompiled with CFR 0.152.
 */
package com.bmuschko.gradle.docker.internal;

import com.bmuschko.gradle.docker.internal.DockerConfigResolver;
import com.bmuschko.gradle.docker.internal.OsUtils;
import com.bmuschko.gradle.docker.shaded.javax.annotation.Nullable;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.transform.Generated;
import groovy.transform.Internal;
import java.beans.Transient;
import java.io.File;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.runtime.typehandling.ShortTypeHandling;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;

public class DefaultDockerConfigResolver
implements DockerConfigResolver,
GroovyObject {
    private static final Logger logger;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;
    private static /* synthetic */ ClassInfo $staticClassInfo$;

    @Generated
    public DefaultDockerConfigResolver() {
        MetaClass metaClass;
        this.metaClass = metaClass = this.$getStaticMetaClass();
    }

    @Override
    public String getDefaultDockerUrl() {
        String dockerUrl = this.getEnv("DOCKER_HOST");
        if (!DefaultTypeTransformation.booleanUnbox((Object)dockerUrl)) {
            Boolean bl = OsUtils.isWindows();
            if (bl == null ? false : bl) {
                if (this.isFileExists("\\\\.\\pipe\\docker_engine")) {
                    String string;
                    dockerUrl = string = "npipe:////./pipe/docker_engine";
                }
            } else if (this.isFileExists("/var/run/docker.sock")) {
                String string;
                dockerUrl = string = "unix:///var/run/docker.sock";
            } else if (this.isFileExists(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{System.getProperty("user.home")}, new String[]{"", "/.docker/run/docker.sock"})))) {
                GStringImpl gStringImpl = new GStringImpl(new Object[]{System.getProperty("user.home")}, new String[]{"unix://", "/.docker/run/docker.sock"});
                dockerUrl = ShortTypeHandling.castToString((Object)gStringImpl);
            }
            if (!DefaultTypeTransformation.booleanUnbox((Object)dockerUrl)) {
                String string;
                dockerUrl = string = "tcp://127.0.0.1:2375";
            }
        }
        logger.info(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{dockerUrl}, new String[]{"Default docker.url set to ", ""})));
        return dockerUrl;
    }

    @Override
    @Nullable
    public File getDefaultDockerCert() {
        String dockerCertPath = this.getEnv("DOCKER_CERT_PATH");
        if (DefaultTypeTransformation.booleanUnbox((Object)dockerCertPath)) {
            File certFile = new File(dockerCertPath);
            if (certFile.exists()) {
                return certFile;
            }
        }
        return (File)ScriptBytecodeAdapter.castToType(null, File.class);
    }

    @Nullable
    String getEnv(String name) {
        return System.getenv(name);
    }

    boolean isFileExists(String path) {
        return new File(path).exists();
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != DefaultDockerConfigResolver.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    @Generated
    @Internal
    @Transient
    public MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    @Generated
    @Internal
    public void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    static {
        Logger logger;
        DefaultDockerConfigResolver.logger = logger = Logging.getLogger(DefaultDockerConfigResolver.class);
    }
}

