/*
 * Decompiled with CFR 0.152.
 */
package com.github.dockerjava.api.command;

import com.bmuschko.gradle.docker.shaded.javax.annotation.CheckForNull;
import com.bmuschko.gradle.docker.shaded.javax.annotation.Nonnull;
import com.bmuschko.gradle.docker.shaded.javax.annotation.Nullable;
import com.github.dockerjava.api.async.ResultCallback;
import com.github.dockerjava.api.command.AsyncDockerCmd;
import com.github.dockerjava.api.command.DockerCmdAsyncExec;
import com.github.dockerjava.api.exception.DockerClientException;
import com.github.dockerjava.api.model.AuthConfig;
import com.github.dockerjava.api.model.PushResponseItem;

public interface PushImageCmd
extends AsyncDockerCmd<PushImageCmd, PushResponseItem> {
    @CheckForNull
    public AuthConfig getAuthConfig();

    @CheckForNull
    public String getName();

    @CheckForNull
    public String getTag();

    public PushImageCmd withName(@Nonnull String var1);

    public PushImageCmd withTag(String var1);

    public PushImageCmd withAuthConfig(AuthConfig var1);

    @Override
    public <T extends ResultCallback<PushResponseItem>> T exec(T var1);

    default public ResultCallback.Adapter<PushResponseItem> start() {
        return this.exec(new ResultCallback.Adapter<PushResponseItem>(){
            @Nullable
            private PushResponseItem latestItem = null;

            @Override
            public void onNext(PushResponseItem item) {
                this.latestItem = item;
            }

            @Override
            protected void throwFirstError() {
                super.throwFirstError();
                if (this.latestItem == null) {
                    throw new DockerClientException("Could not push image");
                }
                if (this.latestItem.isErrorIndicated()) {
                    throw new DockerClientException("Could not push image: " + this.latestItem.getError());
                }
            }
        });
    }

    public static interface Exec
    extends DockerCmdAsyncExec<PushImageCmd, PushResponseItem> {
    }
}

