/*
 * Decompiled with CFR 0.152.
 */
package com.bmuschko.gradle.docker.tasks.container;

import com.bmuschko.gradle.docker.tasks.container.DockerExistingContainer;
import com.github.dockerjava.api.command.WaitContainerCmd;
import com.github.dockerjava.api.command.WaitContainerResultCallback;
import com.github.dockerjava.api.model.WaitResponse;
import java.util.concurrent.TimeUnit;
import org.gradle.api.Action;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.Optional;

public class DockerWaitContainer
extends DockerExistingContainer {
    private int exitCode;
    private final Property<Integer> awaitStatusTimeout = this.getProject().getObjects().property(Integer.class);

    @Input
    @Optional
    public final Property<Integer> getAwaitStatusTimeout() {
        return this.awaitStatusTimeout;
    }

    @Override
    public void runRemoteCommand() {
        String possibleTimeout = this.awaitStatusTimeout.getOrNull() != null ? " for " + String.valueOf(this.getAwaitStatusTimeout().get()) + " seconds" : "";
        this.getLogger().quiet("Waiting for container with ID '" + (String)this.getContainerId().get() + "'" + possibleTimeout + ".");
        WaitContainerCmd containerCommand = this.getDockerClient().waitContainerCmd((String)this.getContainerId().get());
        WaitContainerResultCallback callback = containerCommand.exec(this.createCallback(this.getNextHandler()));
        this.exitCode = this.awaitStatusTimeout.getOrNull() != null ? callback.awaitStatusCode(((Integer)this.awaitStatusTimeout.get()).intValue(), TimeUnit.SECONDS) : callback.awaitStatusCode();
        this.getLogger().quiet("Container exited with code " + this.getExitCode());
    }

    @Internal
    public int getExitCode() {
        return this.exitCode;
    }

    private WaitContainerResultCallback createCallback(final Action nextHandler) {
        return new WaitContainerResultCallback(){

            @Override
            public void onNext(WaitResponse waitResponse) {
                if (nextHandler != null) {
                    try {
                        nextHandler.execute((Object)waitResponse);
                    }
                    catch (Exception e) {
                        DockerWaitContainer.this.getLogger().error("Failed to handle wait response", (Throwable)e);
                        return;
                    }
                }
                super.onNext(waitResponse);
            }
        };
    }
}

