/*
 * Decompiled with CFR 0.152.
 */
package com.bmuschko.gradle.docker.tasks.container;

import com.bmuschko.gradle.docker.internal.RegularFileToStringTransformer;
import com.bmuschko.gradle.docker.tasks.image.DockerExistingImage;
import com.github.dockerjava.api.command.CreateContainerCmd;
import com.github.dockerjava.api.command.CreateContainerResponse;
import com.github.dockerjava.api.exception.DockerException;
import com.github.dockerjava.api.model.Bind;
import com.github.dockerjava.api.model.Capability;
import com.github.dockerjava.api.model.Device;
import com.github.dockerjava.api.model.HealthCheck;
import com.github.dockerjava.api.model.InternetProtocol;
import com.github.dockerjava.api.model.Link;
import com.github.dockerjava.api.model.LogConfig;
import com.github.dockerjava.api.model.PortBinding;
import com.github.dockerjava.api.model.Ports;
import com.github.dockerjava.api.model.RestartPolicy;
import com.github.dockerjava.api.model.Volume;
import com.github.dockerjava.api.model.VolumesFrom;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.gradle.api.Task;
import org.gradle.api.Transformer;
import org.gradle.api.file.RegularFile;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.ListProperty;
import org.gradle.api.provider.MapProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.specs.Spec;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.Nested;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.OutputFile;

public class DockerCreateContainer
extends DockerExistingImage {
    private final Property<String> containerName = this.getProject().getObjects().property(String.class);
    private final Property<String> hostName = this.getProject().getObjects().property(String.class);
    private final Property<String> ipv4Address = this.getProject().getObjects().property(String.class);
    private final ListProperty<String> portSpecs = this.getProject().getObjects().listProperty(String.class);
    private final Property<String> user = this.getProject().getObjects().property(String.class);
    private final Property<Boolean> stdinOpen = this.getProject().getObjects().property(Boolean.class);
    private final Property<Boolean> stdinOnce = this.getProject().getObjects().property(Boolean.class);
    private final Property<Boolean> attachStdin = this.getProject().getObjects().property(Boolean.class);
    private final Property<Boolean> attachStdout = this.getProject().getObjects().property(Boolean.class);
    private final Property<Boolean> attachStderr = this.getProject().getObjects().property(Boolean.class);
    private final MapProperty<String, String> envVars = this.getProject().getObjects().mapProperty(String.class, String.class);
    private final ListProperty<String> cmd = this.getProject().getObjects().listProperty(String.class);
    private final ListProperty<String> entrypoint = this.getProject().getObjects().listProperty(String.class);
    private final ListProperty<String> networkAliases = this.getProject().getObjects().listProperty(String.class);
    private final Property<String> image = this.getProject().getObjects().property(String.class);
    private final ListProperty<String> volumes = this.getProject().getObjects().listProperty(String.class);
    private final Property<String> workingDir = this.getProject().getObjects().property(String.class);
    private final ListProperty<ExposedPort> exposedPorts = this.getProject().getObjects().listProperty(ExposedPort.class);
    private final Property<Boolean> tty = this.getProject().getObjects().property(Boolean.class);
    private final Property<String> pid = this.getProject().getObjects().property(String.class);
    private final MapProperty<String, String> labels = this.getProject().getObjects().mapProperty(String.class, String.class);
    private final RegularFileProperty containerIdFile = this.getProject().getObjects().fileProperty();
    private final Property<String> containerId = this.getProject().getObjects().property(String.class);
    private final Property<String> macAddress = this.getProject().getObjects().property(String.class);
    private final Property<String> platform = this.getProject().getObjects().property(String.class);
    private final HostConfig hostConfig;
    private final HealthCheckConfig healthCheck;
    private Spec<Task> upToDateWhenSpec = new Spec<Task>(){

        public boolean isSatisfiedBy(Task element) {
            File file = ((RegularFile)DockerCreateContainer.this.getContainerIdFile().get()).getAsFile();
            if (file.exists()) {
                try {
                    String fileContainerId;
                    try {
                        fileContainerId = Files.readString(file.toPath());
                    }
                    catch (IOException e) {
                        throw new UncheckedIOException(e);
                    }
                    DockerCreateContainer.this.getDockerClient().inspectContainerCmd(fileContainerId).exec();
                    return true;
                }
                catch (DockerException dockerException) {
                    // empty catch block
                }
            }
            return false;
        }
    };

    @Input
    @Optional
    public final Property<String> getContainerName() {
        return this.containerName;
    }

    @Input
    @Optional
    public final Property<String> getHostName() {
        return this.hostName;
    }

    @Input
    @Optional
    public final Property<String> getIpv4Address() {
        return this.ipv4Address;
    }

    @Input
    @Optional
    public final ListProperty<String> getPortSpecs() {
        return this.portSpecs;
    }

    @Input
    @Optional
    public final Property<String> getUser() {
        return this.user;
    }

    @Input
    @Optional
    public final Property<Boolean> getStdinOpen() {
        return this.stdinOpen;
    }

    @Input
    @Optional
    public final Property<Boolean> getStdinOnce() {
        return this.stdinOnce;
    }

    @Input
    @Optional
    public final Property<Boolean> getAttachStdin() {
        return this.attachStdin;
    }

    @Input
    @Optional
    public final Property<Boolean> getAttachStdout() {
        return this.attachStdout;
    }

    @Input
    @Optional
    public final Property<Boolean> getAttachStderr() {
        return this.attachStderr;
    }

    @Input
    @Optional
    public final MapProperty<String, String> getEnvVars() {
        return this.envVars;
    }

    @Input
    @Optional
    public final ListProperty<String> getCmd() {
        return this.cmd;
    }

    @Input
    @Optional
    public final ListProperty<String> getEntrypoint() {
        return this.entrypoint;
    }

    @Input
    @Optional
    public final ListProperty<String> getNetworkAliases() {
        return this.networkAliases;
    }

    @Input
    @Optional
    public final Property<String> getImage() {
        return this.image;
    }

    @Input
    @Optional
    public final ListProperty<String> getVolumes() {
        return this.volumes;
    }

    @Input
    @Optional
    public final Property<String> getWorkingDir() {
        return this.workingDir;
    }

    @Input
    public final ListProperty<ExposedPort> getExposedPorts() {
        return this.exposedPorts;
    }

    @Input
    @Optional
    public final Property<Boolean> getTty() {
        return this.tty;
    }

    @Input
    @Optional
    public final Property<String> getPid() {
        return this.pid;
    }

    @Input
    @Optional
    public final MapProperty<String, String> getLabels() {
        return this.labels;
    }

    @OutputFile
    public final RegularFileProperty getContainerIdFile() {
        return this.containerIdFile;
    }

    @Internal
    public final Property<String> getContainerId() {
        return this.containerId;
    }

    @Input
    @Optional
    public final Property<String> getMacAddress() {
        return this.macAddress;
    }

    @Input
    @Optional
    public final Property<String> getPlatform() {
        return this.platform;
    }

    @Nested
    public final HostConfig getHostConfig() {
        return this.hostConfig;
    }

    @Nested
    public final HealthCheckConfig getHealthCheck() {
        return this.healthCheck;
    }

    @Inject
    public DockerCreateContainer(ObjectFactory objectFactory) {
        this.hostConfig = (HostConfig)objectFactory.newInstance(HostConfig.class, new Object[0]);
        this.healthCheck = (HealthCheckConfig)objectFactory.newInstance(HealthCheckConfig.class, new Object[0]);
        this.stdinOpen.convention((Object)false);
        this.stdinOnce.convention((Object)false);
        this.attachStdin.convention((Object)false);
        this.attachStdout.convention((Object)false);
        this.attachStderr.convention((Object)false);
        this.tty.convention((Object)false);
        this.containerId.convention(this.containerIdFile.map((Transformer)new RegularFileToStringTransformer()));
        String safeTaskPath = this.getPath().replaceFirst("^:", "").replaceAll(":", "_");
        this.containerIdFile.convention(this.getProject().getLayout().getBuildDirectory().file(".docker/" + safeTaskPath + "-containerId.txt"));
        this.getOutputs().upToDateWhen(this.upToDateWhenSpec);
    }

    @Override
    public void runRemoteCommand() throws IOException {
        CreateContainerCmd containerCommand = this.getDockerClient().createContainerCmd((String)this.getImageId().get());
        this.setContainerCommandConfig(containerCommand);
        CreateContainerResponse container = containerCommand.exec();
        String orNull = (String)this.containerName.getOrNull();
        String localContainerName = orNull != null ? orNull : container.getId();
        this.getLogger().quiet("Created container with ID '" + localContainerName + "'.");
        Files.writeString(((RegularFile)this.containerIdFile.get()).getAsFile().toPath(), (CharSequence)container.getId(), new OpenOption[0]);
        if (this.getNextHandler() != null) {
            this.getNextHandler().execute((Object)container);
        }
    }

    public void exposePorts(String internetProtocol, List<Integer> ports) {
        this.exposedPorts.add((Object)new ExposedPort(internetProtocol, ports));
    }

    public void withEnvVar(String key, String value) {
        this.envVars.put((Object)key, (Object)value);
    }

    private static HealthCheck getOrCreateHealthCheck(CreateContainerCmd containerCommand) {
        if (containerCommand.getHealthcheck() == null) {
            containerCommand.withHealthcheck(new HealthCheck());
        }
        return containerCommand.getHealthcheck();
    }

    private void setContainerCommandConfig(CreateContainerCmd containerCommand) {
        Capability[] capabilities;
        List<Volume> createdVolumes;
        if (this.containerName.getOrNull() != null) {
            containerCommand.withName((String)this.containerName.get());
        }
        if (this.hostName.getOrNull() != null) {
            containerCommand.withHostName((String)this.hostName.get());
        }
        if (this.ipv4Address.getOrNull() != null) {
            containerCommand.withIpv4Address((String)this.ipv4Address.get());
        }
        if (this.portSpecs.getOrNull() != null && !((List)this.portSpecs.get()).isEmpty()) {
            containerCommand.withPortSpecs((List)this.portSpecs.get());
        }
        if (this.user.getOrNull() != null) {
            containerCommand.withUser((String)this.user.get());
        }
        if (this.hostConfig.getGroups().getOrNull() != null && !((List)this.hostConfig.getGroups().get()).isEmpty()) {
            containerCommand.getHostConfig().withGroupAdd((List)this.hostConfig.getGroups().get());
        }
        if (Boolean.TRUE.equals(this.stdinOpen.getOrNull())) {
            containerCommand.withStdinOpen((Boolean)this.stdinOpen.get());
        }
        if (Boolean.TRUE.equals(this.stdinOnce.getOrNull())) {
            containerCommand.withStdInOnce((Boolean)this.stdinOnce.get());
        }
        if (this.hostConfig.getMemory().getOrNull() != null) {
            containerCommand.getHostConfig().withMemory((Long)this.hostConfig.getMemory().get());
        }
        if (this.hostConfig.getMemorySwap().getOrNull() != null) {
            containerCommand.getHostConfig().withMemorySwap((Long)this.hostConfig.getMemorySwap().get());
        }
        if (this.hostConfig.getCpuset().getOrNull() != null) {
            containerCommand.getHostConfig().withCpusetCpus((String)this.hostConfig.getCpuset().get());
        }
        if (Boolean.TRUE.equals(this.attachStdin.getOrNull())) {
            containerCommand.withAttachStdin((Boolean)this.attachStdin.get());
        }
        if (Boolean.TRUE.equals(this.attachStdout.getOrNull())) {
            containerCommand.withAttachStdout((Boolean)this.attachStdout.get());
        }
        if (Boolean.TRUE.equals(this.attachStderr.getOrNull())) {
            containerCommand.withAttachStderr((Boolean)this.attachStderr.get());
        }
        if (this.envVars.getOrNull() != null && !((Map)this.envVars.get()).isEmpty()) {
            containerCommand.withEnv(((Map)this.envVars.get()).entrySet().stream().map(entry -> (String)entry.getKey() + "=" + (String)entry.getValue()).collect(Collectors.toList()));
        }
        if (this.cmd.getOrNull() != null && !((List)this.cmd.get()).isEmpty()) {
            containerCommand.withCmd((List)this.cmd.get());
        }
        if (this.entrypoint.getOrNull() != null && !((List)this.entrypoint.get()).isEmpty()) {
            containerCommand.withEntrypoint((List)this.entrypoint.get());
        }
        if (this.hostConfig.getDns().getOrNull() != null && !((List)this.hostConfig.getDns().get()).isEmpty()) {
            containerCommand.getHostConfig().withDns((List)this.hostConfig.getDns().get());
        }
        if (this.hostConfig.getNetwork().getOrNull() != null) {
            containerCommand.getHostConfig().withNetworkMode((String)this.hostConfig.getNetwork().get());
        }
        if (this.networkAliases.getOrNull() != null && !((List)this.networkAliases.get()).isEmpty()) {
            containerCommand.withAliases((List)this.networkAliases.get());
        }
        if (this.image.getOrNull() != null) {
            containerCommand.withImage((String)this.image.get());
        }
        if (this.volumes.getOrNull() != null && !((List)this.volumes.get()).isEmpty()) {
            createdVolumes = ((List)this.volumes.get()).stream().map(Volume::parse).collect(Collectors.toList());
            containerCommand.withVolumes(createdVolumes);
        }
        if (this.hostConfig.getLinks().getOrNull() != null && !((List)this.hostConfig.getLinks().get()).isEmpty()) {
            List createdLinks = ((List)this.hostConfig.links.get()).stream().map(Link::parse).collect(Collectors.toList());
            containerCommand.getHostConfig().withLinks((Link[])createdLinks.toArray(Link[]::new));
        }
        if (this.hostConfig.getVolumesFrom().getOrNull() != null && !((List)this.hostConfig.getVolumesFrom().get()).isEmpty()) {
            createdVolumes = ((List)this.hostConfig.volumesFrom.get()).stream().map(VolumesFrom::new).collect(Collectors.toList());
            containerCommand.getHostConfig().withVolumesFrom(createdVolumes);
        }
        if (this.workingDir.getOrNull() != null) {
            containerCommand.withWorkingDir((String)this.workingDir.get());
        }
        if (this.exposedPorts.getOrNull() != null && !((List)this.exposedPorts.get()).isEmpty()) {
            List<com.github.dockerjava.api.model.ExposedPort> allPorts = ((List)this.exposedPorts.get()).stream().flatMap(exposedPort -> exposedPort.getPorts().stream().map(port -> new com.github.dockerjava.api.model.ExposedPort((int)port, InternetProtocol.parse(exposedPort.getInternetProtocol().toLowerCase())))).collect(Collectors.toList());
            containerCommand.withExposedPorts(allPorts);
        }
        if (this.hostConfig.getPortBindings().getOrNull() != null && !((List)this.hostConfig.getPortBindings().get()).isEmpty()) {
            List createdPortBindings = ((List)this.hostConfig.portBindings.get()).stream().map(PortBinding::parse).collect(Collectors.toList());
            containerCommand.getHostConfig().withPortBindings(new Ports((PortBinding[])createdPortBindings.toArray(PortBinding[]::new)));
        }
        if (Boolean.TRUE.equals(this.hostConfig.getPublishAll().getOrNull())) {
            containerCommand.getHostConfig().withPublishAllPorts((Boolean)this.hostConfig.getPublishAll().get());
        }
        if (this.hostConfig.getBinds().getOrNull() != null && !((Map)this.hostConfig.getBinds().get()).isEmpty()) {
            List<Bind> createdBinds = ((Map)this.hostConfig.binds.get()).entrySet().stream().map(it -> Bind.parse((String)it.getKey() + ":" + (String)it.getValue())).collect(Collectors.toList());
            containerCommand.getHostConfig().withBinds(createdBinds);
        }
        if (this.hostConfig.getTmpFs().getOrNull() != null && !((Map)this.hostConfig.getTmpFs().get()).isEmpty()) {
            containerCommand.getHostConfig().withTmpFs((Map)this.hostConfig.getTmpFs().get());
        }
        if (this.hostConfig.getExtraHosts().getOrNull() != null && !((List)this.hostConfig.getExtraHosts().get()).isEmpty()) {
            containerCommand.getHostConfig().withExtraHosts((String[])((List)this.hostConfig.getExtraHosts().get()).toArray(String[]::new));
        }
        if (this.hostConfig.getLogConfig().getOrNull() != null) {
            LogConfig.LoggingType type = LogConfig.LoggingType.fromValue(((HostConfig.LogConfig)this.hostConfig.getLogConfig().get()).getType());
            LogConfig config = new LogConfig(type, ((HostConfig.LogConfig)this.hostConfig.getLogConfig().get()).getConfig());
            containerCommand.getHostConfig().withLogConfig(config);
        }
        if (Boolean.TRUE.equals(this.hostConfig.getPrivileged().getOrNull())) {
            containerCommand.getHostConfig().withPrivileged((Boolean)this.hostConfig.getPrivileged().get());
        }
        if (this.hostConfig.getRestartPolicy().getOrNull() != null) {
            containerCommand.getHostConfig().withRestartPolicy(RestartPolicy.parse((String)this.hostConfig.getRestartPolicy().get()));
        }
        if (this.hostConfig.getCapAdd().getOrNull() != null && !((List)this.hostConfig.getCapAdd().get()).isEmpty()) {
            capabilities = (Capability[])((List)this.hostConfig.getCapAdd().get()).stream().map(Capability::valueOf).toArray(Capability[]::new);
            containerCommand.getHostConfig().withCapAdd(capabilities);
        }
        if (this.hostConfig.getCapDrop().getOrNull() != null && !((List)this.hostConfig.getCapDrop().get()).isEmpty()) {
            capabilities = (Capability[])((List)this.hostConfig.getCapDrop().get()).stream().map(Capability::valueOf).toArray(Capability[]::new);
            containerCommand.getHostConfig().withCapDrop(capabilities);
        }
        if (this.pid.getOrNull() != null) {
            containerCommand.getHostConfig().withPidMode((String)this.pid.get());
        }
        if (this.hostConfig.getDevices().getOrNull() != null && !((List)this.hostConfig.getDevices().get()).isEmpty()) {
            List<Device> createdDevices = ((List)this.hostConfig.getDevices().get()).stream().map(Device::parse).collect(Collectors.toList());
            containerCommand.getHostConfig().withDevices(createdDevices);
        }
        if (Boolean.TRUE.equals(this.tty.getOrNull())) {
            containerCommand.withTty((Boolean)this.tty.get());
        }
        if (this.hostConfig.getShmSize().getOrNull() != null) {
            containerCommand.getHostConfig().withShmSize((Long)this.hostConfig.getShmSize().get());
        }
        if (this.hostConfig.getAutoRemove().getOrNull() != null) {
            containerCommand.getHostConfig().withAutoRemove((Boolean)this.hostConfig.getAutoRemove().get());
        }
        if (this.labels.getOrNull() != null && !((Map)this.labels.get()).isEmpty()) {
            containerCommand.withLabels((Map)this.labels.get());
        }
        if (this.macAddress.getOrNull() != null) {
            containerCommand.withMacAddress((String)this.macAddress.get());
        }
        if (this.platform.getOrNull() != null && !((String)this.platform.get()).isEmpty()) {
            containerCommand.withPlatform((String)this.platform.get());
        }
        if (this.hostConfig.getIpcMode().getOrNull() != null) {
            containerCommand.getHostConfig().withIpcMode((String)this.hostConfig.getIpcMode().get());
        }
        if (this.hostConfig.getSysctls().getOrNull() != null && !((Map)this.hostConfig.getSysctls().get()).isEmpty()) {
            containerCommand.getHostConfig().withSysctls((Map)this.hostConfig.getSysctls().get());
        }
        if (this.healthCheck.getInterval().getOrNull() != null) {
            DockerCreateContainer.getOrCreateHealthCheck(containerCommand).withInterval((Long)this.healthCheck.getInterval().get());
        }
        if (this.healthCheck.getTimeout().getOrNull() != null) {
            DockerCreateContainer.getOrCreateHealthCheck(containerCommand).withTimeout((Long)this.healthCheck.getTimeout().get());
        }
        if (this.healthCheck.getCmd().getOrNull() != null && !((List)this.healthCheck.getCmd().get()).isEmpty()) {
            String command = ((List)this.healthCheck.getCmd().get()).size() == 1 ? "CMD-SHELL" : "CMD";
            ArrayList<String> test = new ArrayList<String>(List.of(command));
            test.addAll((Collection)this.healthCheck.getCmd().get());
            DockerCreateContainer.getOrCreateHealthCheck(containerCommand).withTest(test);
        }
        if (this.healthCheck.getRetries().getOrNull() != null) {
            DockerCreateContainer.getOrCreateHealthCheck(containerCommand).withRetries((Integer)this.healthCheck.getRetries().get());
        }
        if (this.healthCheck.getStartPeriod().getOrNull() != null) {
            DockerCreateContainer.getOrCreateHealthCheck(containerCommand).withStartPeriod((Long)this.healthCheck.getStartPeriod().get());
        }
    }

    public static class HostConfig {
        private final ListProperty<String> groups;
        private final Property<Long> memory;
        private final Property<Long> memorySwap;
        private final Property<String> cpuset;
        private final ListProperty<String> dns;
        private final Property<String> network;
        private final ListProperty<String> links;
        private final ListProperty<String> volumesFrom;
        private final ListProperty<String> portBindings;
        private final Property<Boolean> publishAll;
        private final MapProperty<String, String> binds;
        private final MapProperty<String, String> tmpFs;
        private final ListProperty<String> extraHosts;
        private final Property<LogConfig> logConfig;
        private final Property<Boolean> privileged;
        private final Property<String> restartPolicy;
        private final ListProperty<String> devices;
        private final ListProperty<String> capAdd;
        private final ListProperty<String> capDrop;
        private final Property<Long> shmSize;
        private final Property<Boolean> autoRemove;
        private final Property<String> ipcMode;
        private final MapProperty<String, String> sysctls;

        @Input
        @Optional
        public final ListProperty<String> getGroups() {
            return this.groups;
        }

        @Input
        @Optional
        public final Property<Long> getMemory() {
            return this.memory;
        }

        @Input
        @Optional
        public final Property<Long> getMemorySwap() {
            return this.memorySwap;
        }

        @Input
        @Optional
        public final Property<String> getCpuset() {
            return this.cpuset;
        }

        @Input
        @Optional
        public final ListProperty<String> getDns() {
            return this.dns;
        }

        @Input
        @Optional
        public final Property<String> getNetwork() {
            return this.network;
        }

        @Input
        @Optional
        public final ListProperty<String> getLinks() {
            return this.links;
        }

        @Input
        @Optional
        public final ListProperty<String> getVolumesFrom() {
            return this.volumesFrom;
        }

        @Input
        @Optional
        public final ListProperty<String> getPortBindings() {
            return this.portBindings;
        }

        @Input
        @Optional
        public final Property<Boolean> getPublishAll() {
            return this.publishAll;
        }

        @Input
        @Optional
        public final MapProperty<String, String> getBinds() {
            return this.binds;
        }

        @Input
        @Optional
        public final MapProperty<String, String> getTmpFs() {
            return this.tmpFs;
        }

        @Input
        @Optional
        public final ListProperty<String> getExtraHosts() {
            return this.extraHosts;
        }

        @Input
        @Optional
        public final Property<LogConfig> getLogConfig() {
            return this.logConfig;
        }

        @Input
        @Optional
        public final Property<Boolean> getPrivileged() {
            return this.privileged;
        }

        @Input
        @Optional
        public final Property<String> getRestartPolicy() {
            return this.restartPolicy;
        }

        @Input
        @Optional
        public final ListProperty<String> getDevices() {
            return this.devices;
        }

        @Input
        @Optional
        public final ListProperty<String> getCapAdd() {
            return this.capAdd;
        }

        @Input
        @Optional
        public final ListProperty<String> getCapDrop() {
            return this.capDrop;
        }

        @Input
        @Optional
        public final Property<Long> getShmSize() {
            return this.shmSize;
        }

        @Input
        @Optional
        public final Property<Boolean> getAutoRemove() {
            return this.autoRemove;
        }

        @Input
        @Optional
        public final Property<String> getIpcMode() {
            return this.ipcMode;
        }

        @Input
        @Optional
        public final MapProperty<String, String> getSysctls() {
            return this.sysctls;
        }

        @Inject
        public HostConfig(ObjectFactory objectFactory) {
            this.groups = objectFactory.listProperty(String.class);
            this.memory = objectFactory.property(Long.class);
            this.memorySwap = objectFactory.property(Long.class);
            this.cpuset = objectFactory.property(String.class);
            this.dns = objectFactory.listProperty(String.class);
            this.network = objectFactory.property(String.class);
            this.links = objectFactory.listProperty(String.class);
            this.volumesFrom = objectFactory.listProperty(String.class);
            this.portBindings = objectFactory.listProperty(String.class);
            this.publishAll = objectFactory.property(Boolean.class);
            this.publishAll.convention((Object)false);
            this.binds = objectFactory.mapProperty(String.class, String.class);
            this.tmpFs = objectFactory.mapProperty(String.class, String.class);
            this.extraHosts = objectFactory.listProperty(String.class);
            this.logConfig = objectFactory.property(LogConfig.class);
            this.privileged = objectFactory.property(Boolean.class);
            this.privileged.convention((Object)false);
            this.restartPolicy = objectFactory.property(String.class);
            this.capAdd = objectFactory.listProperty(String.class);
            this.capDrop = objectFactory.listProperty(String.class);
            this.devices = objectFactory.listProperty(String.class);
            this.shmSize = objectFactory.property(Long.class);
            this.autoRemove = objectFactory.property(Boolean.class);
            this.ipcMode = objectFactory.property(String.class);
            this.sysctls = objectFactory.mapProperty(String.class, String.class);
        }

        public void logConfig(String type, Map<String, String> config) {
            LogConfig logConfig = new LogConfig();
            logConfig.setType(type);
            logConfig.setConfig(config);
            this.logConfig.set((Object)logConfig);
        }

        public void restartPolicy(String name, int maximumRetryCount) {
            this.restartPolicy.set((Object)(name + ":" + maximumRetryCount));
        }

        public static class LogConfig
        implements Serializable {
            private String type;
            private Map<String, String> config = new HashMap<String, String>();

            public String getType() {
                return this.type;
            }

            public void setType(String type) {
                this.type = type;
            }

            public Map<String, String> getConfig() {
                return this.config;
            }

            public void setConfig(Map<String, String> config) {
                this.config = config;
            }
        }
    }

    public static class HealthCheckConfig {
        private final Property<Long> interval;
        private final Property<Long> timeout;
        private final ListProperty<String> cmd;
        private final Property<Integer> retries;
        private final Property<Long> startPeriod;

        @Input
        @Optional
        public final Property<Long> getInterval() {
            return this.interval;
        }

        @Input
        @Optional
        public final Property<Long> getTimeout() {
            return this.timeout;
        }

        @Input
        @Optional
        public final ListProperty<String> getCmd() {
            return this.cmd;
        }

        @Input
        @Optional
        public final Property<Integer> getRetries() {
            return this.retries;
        }

        @Input
        @Optional
        public final Property<Long> getStartPeriod() {
            return this.startPeriod;
        }

        @Inject
        public HealthCheckConfig(ObjectFactory objectFactory) {
            this.interval = objectFactory.property(Long.class);
            this.timeout = objectFactory.property(Long.class);
            this.cmd = objectFactory.listProperty(String.class);
            this.retries = objectFactory.property(Integer.class);
            this.startPeriod = objectFactory.property(Long.class);
        }

        public void cmd(String shellCommand) {
            this.cmd.set(List.of(shellCommand));
        }
    }

    public static class ExposedPort
    implements Serializable {
        private final String internetProtocol;
        private final List<Integer> ports;

        public ExposedPort(String internetProtocol, List<Integer> ports) {
            this.internetProtocol = internetProtocol;
            this.ports = ports;
        }

        public final String getInternetProtocol() {
            return this.internetProtocol;
        }

        public final List<Integer> getPorts() {
            return this.ports;
        }
    }
}

