/*
 * Decompiled with CFR 0.152.
 */
package com.bmuschko.gradle.docker.shaded.org.apache.hc.client5.http.impl;

import com.bmuschko.gradle.docker.shaded.org.apache.hc.client5.http.impl.DefaultRedirectStrategy;
import com.bmuschko.gradle.docker.shaded.org.apache.hc.core5.annotation.Contract;
import com.bmuschko.gradle.docker.shaded.org.apache.hc.core5.annotation.ThreadingBehavior;
import com.bmuschko.gradle.docker.shaded.org.apache.hc.core5.http.Header;
import com.bmuschko.gradle.docker.shaded.org.apache.hc.core5.http.HttpRequest;
import com.bmuschko.gradle.docker.shaded.org.apache.hc.core5.http.HttpResponse;
import com.bmuschko.gradle.docker.shaded.org.apache.hc.core5.http.protocol.HttpContext;

@Contract(threading=ThreadingBehavior.STATELESS)
public class LaxRedirectStrategy
extends DefaultRedirectStrategy {
    public static final LaxRedirectStrategy INSTANCE = new LaxRedirectStrategy();
    private static final String[] REDIRECT_METHODS = new String[]{"GET", "POST", "HEAD", "DELETE"};

    @Override
    public boolean isRedirected(HttpRequest request, HttpResponse response, HttpContext context) {
        if (!response.containsHeader("Location")) {
            return false;
        }
        int statusCode = response.getCode();
        String method = request.getMethod();
        Header locationHeader = response.getFirstHeader("location");
        switch (statusCode) {
            case 302: {
                return this.isRedirectable(method) && locationHeader != null;
            }
            case 301: 
            case 307: {
                return this.isRedirectable(method);
            }
            case 303: {
                return true;
            }
        }
        return false;
    }

    protected boolean isRedirectable(String method) {
        for (String m : REDIRECT_METHODS) {
            if (!m.equalsIgnoreCase(method)) continue;
            return true;
        }
        return false;
    }
}

