/*
 * Decompiled with CFR 0.152.
 */
package com.bmuschko.gradle.docker.tasks.image;

import com.bmuschko.gradle.docker.DockerRegistryCredentials;
import com.bmuschko.gradle.docker.shaded.javax.annotation.Nullable;
import com.bmuschko.gradle.docker.tasks.AbstractDockerRemoteApiTask;
import com.bmuschko.gradle.docker.tasks.RegistryCredentialsAware;
import com.github.dockerjava.api.async.ResultCallback;
import com.github.dockerjava.api.command.PushImageCmd;
import com.github.dockerjava.api.exception.DockerClientException;
import com.github.dockerjava.api.model.AuthConfig;
import com.github.dockerjava.api.model.PushResponseItem;
import java.util.Set;
import org.gradle.api.Action;
import org.gradle.api.GradleException;
import org.gradle.api.provider.SetProperty;
import org.gradle.api.tasks.Input;

public class DockerPushImage
extends AbstractDockerRemoteApiTask
implements RegistryCredentialsAware {
    private final SetProperty<String> images = this.getProject().getObjects().setProperty(String.class);
    private final DockerRegistryCredentials registryCredentials = (DockerRegistryCredentials)this.getProject().getObjects().newInstance(DockerRegistryCredentials.class, new Object[]{this.getProject().getObjects()});

    @Input
    public final SetProperty<String> getImages() {
        return this.images;
    }

    @Override
    public final DockerRegistryCredentials getRegistryCredentials() {
        return this.registryCredentials;
    }

    @Override
    public void runRemoteCommand() throws Exception {
        if (((Set)this.images.get()).isEmpty()) {
            throw new GradleException("No images configured for push operation.");
        }
        for (String image : (Set)this.images.get()) {
            AuthConfig authConfig = this.getRegistryAuthLocator().lookupAuthConfig(image, this.registryCredentials);
            this.getLogger().quiet("Pushing image '" + image + "' to " + this.getRegistryAuthLocator().getRegistry(image) + ".");
            PushImageCmd pushImageCmd = this.getDockerClient().pushImageCmd(image);
            pushImageCmd.withAuthConfig(authConfig);
            ResultCallback.Adapter<PushResponseItem> callback = this.createCallback(this.getNextHandler());
            pushImageCmd.exec(callback).awaitCompletion();
        }
    }

    @Override
    public void registryCredentials(Action<? super DockerRegistryCredentials> action) {
        action.execute((Object)this.registryCredentials);
    }

    private ResultCallback.Adapter<PushResponseItem> createCallback(final Action nextHandler) {
        return new ResultCallback.Adapter<PushResponseItem>(){
            @Nullable
            private PushResponseItem latestItem = null;

            @Override
            public void onNext(PushResponseItem item) {
                this.latestItem = item;
                if (nextHandler != null) {
                    nextHandler.execute((Object)item);
                }
            }

            @Override
            protected void throwFirstError() {
                super.throwFirstError();
                if (this.latestItem == null) {
                    throw new DockerClientException("Could not push image");
                }
                if (this.latestItem.isErrorIndicated()) {
                    throw new DockerClientException("Could not push image: " + this.latestItem.getError());
                }
            }
        };
    }
}

