/*
 * Decompiled with CFR 0.152.
 */
package com.bmuschko.gradle.docker.tasks.container;

import com.bmuschko.gradle.docker.domain.ExecProbe;
import com.bmuschko.gradle.docker.internal.IOUtils;
import com.bmuschko.gradle.docker.tasks.container.DockerExistingContainer;
import com.github.dockerjava.api.DockerClient;
import com.github.dockerjava.api.async.ResultCallback;
import com.github.dockerjava.api.command.ExecCreateCmd;
import com.github.dockerjava.api.command.ExecCreateCmdResponse;
import com.github.dockerjava.api.command.InspectExecResponse;
import com.github.dockerjava.api.model.Frame;
import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import org.gradle.api.Action;
import org.gradle.api.GradleException;
import org.gradle.api.file.RegularFile;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.ListProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.Nested;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.OutputFile;
import org.gradle.internal.logging.progress.ProgressLogger;

public class DockerExecContainer
extends DockerExistingContainer {
    private final ListProperty<String[]> commands = this.getProject().getObjects().listProperty(String[].class);
    private final Property<Boolean> attachStdout = this.getProject().getObjects().property(Boolean.class);
    private final Property<Boolean> attachStderr = this.getProject().getObjects().property(Boolean.class);
    private final Property<String> user = this.getProject().getObjects().property(String.class);
    private final Property<String> workingDir = this.getProject().getObjects().property(String.class);
    private final ListProperty<Integer> successOnExitCodes = this.getProject().getObjects().listProperty(Integer.class);
    private ExecProbe execProbe;
    private final List<String> execIds = new ArrayList<String>();
    private final RegularFileProperty execIdsFile;
    private final Provider<List<String>> execIdsProvider;

    @Input
    @Optional
    public final ListProperty<String[]> getCommands() {
        return this.commands;
    }

    @Input
    @Optional
    public final Property<Boolean> getAttachStdout() {
        return this.attachStdout;
    }

    @Input
    @Optional
    public final Property<Boolean> getAttachStderr() {
        return this.attachStderr;
    }

    @Input
    @Optional
    public final Property<String> getUser() {
        return this.user;
    }

    @Input
    @Optional
    public final Property<String> getWorkingDir() {
        return this.workingDir;
    }

    @Input
    @Optional
    public final ListProperty<Integer> getSuccessOnExitCodes() {
        return this.successOnExitCodes;
    }

    @Nested
    @Optional
    public ExecProbe getExecProbe() {
        return this.execProbe;
    }

    public void setExecProbe(ExecProbe execProbe) {
        this.execProbe = execProbe;
    }

    @OutputFile
    public final RegularFileProperty getExecIdsFile() {
        return this.execIdsFile;
    }

    @Internal
    public final Provider<List<String>> getExecIdsProvider() {
        return this.execIdsProvider;
    }

    @Internal
    public final List<String> getExecIds() {
        return this.execIds;
    }

    @Inject
    public DockerExecContainer(ObjectFactory objects) {
        this.attachStdout.convention((Object)true);
        this.attachStderr.convention((Object)true);
        this.execIdsFile = objects.fileProperty();
        String safeTaskPath = this.getPath().replaceFirst("^:", "").replaceAll(":", "_");
        this.execIdsFile.convention(this.getProject().getLayout().getBuildDirectory().file(".docker/" + safeTaskPath + "-execIds.txt"));
        this.execIdsProvider = this.execIdsFile.map(file -> {
            try {
                if (!file.getAsFile().exists()) {
                    return new ArrayList();
                }
                return Files.readAllLines(file.getAsFile().toPath());
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        });
    }

    @Override
    public void runRemoteCommand() throws InterruptedException {
        this.getLogger().quiet("Executing on container with ID '" + (String)this.getContainerId().get() + "'.");
        this.doRunRemoteCommand(this.getDockerClient());
    }

    protected void doRunRemoteCommand(DockerClient dockerClient) throws InterruptedException {
        ResultCallback.Adapter<Frame> execCallback = this.createCallback(this.getNextHandler());
        this.execIds.clear();
        List localCommands = (List)this.commands.get();
        for (int i = 0; i < ((List)this.commands.get()).size(); ++i) {
            Object[] singleCommand = (String[])localCommands.get(i);
            ExecCreateCmd execCmd = dockerClient.execCreateCmd((String)this.getContainerId().get());
            this.setContainerCommandConfig(execCmd, (String[])singleCommand);
            String localExecId = ((ExecCreateCmdResponse)execCmd.exec()).getId();
            dockerClient.execStartCmd(localExecId).withDetach(false).exec(execCallback).awaitCompletion();
            ProgressLogger progressLogger = IOUtils.getProgressLogger(this.getServices(), DockerExecContainer.class);
            progressLogger.started();
            ExecProbe localProbe = this.execProbe != null ? this.execProbe : new ExecProbe(60000L, 2000L);
            int pollTimes = 0;
            boolean isRunning = true;
            InspectExecResponse lastExecResponse = null;
            for (long localPollTime = localProbe.getPollTime(); isRunning && localPollTime > 0L; localPollTime -= localProbe.getPollInterval()) {
                ++pollTimes;
                lastExecResponse = dockerClient.inspectExecCmd(localExecId).exec();
                isRunning = lastExecResponse.isRunning();
                if (!isRunning) break;
                long totalMillis = (long)pollTimes * localProbe.getPollInterval();
                long totalMinutes = TimeUnit.MILLISECONDS.toMinutes(totalMillis);
                progressLogger.progress("Executing for " + totalMinutes + "m...");
                Thread.sleep(localProbe.getPollInterval());
                continue;
            }
            progressLogger.completed();
            if (isRunning) {
                throw new GradleException("Exec '" + Arrays.toString(singleCommand) + "' did not finish in a timely fashion: " + String.valueOf(localProbe));
            }
            if (this.successOnExitCodes.getOrNull() != null && !((List)this.successOnExitCodes.get()).isEmpty()) {
                int exitCode;
                int n = exitCode = lastExecResponse.getExitCode() != null ? lastExecResponse.getExitCode() : 0;
                if (!((List)this.successOnExitCodes.get()).contains(exitCode)) {
                    throw new GradleException(exitCode + " is not a successful exit code. Valid values are " + String.valueOf(this.getSuccessOnExitCodes().get()) + ", response=" + String.valueOf(lastExecResponse));
                }
            }
            this.execIds.add(localExecId);
        }
        File execIdsFile = ((RegularFile)this.getExecIdsFile().get()).getAsFile();
        execIdsFile.getParentFile().mkdirs();
        try {
            Files.write(execIdsFile.toPath(), this.execIds, new OpenOption[0]);
        }
        catch (IOException e) {
            throw new UncheckedIOException("Failed to write exec IDs to file", e);
        }
    }

    private void setContainerCommandConfig(ExecCreateCmd containerCommand, String[] commandToExecute) {
        if (commandToExecute != null) {
            containerCommand.withCmd(commandToExecute);
        }
        if (Boolean.TRUE.equals(this.attachStderr.getOrNull())) {
            containerCommand.withAttachStderr((Boolean)this.attachStderr.get());
        }
        if (Boolean.TRUE.equals(this.attachStdout.getOrNull())) {
            containerCommand.withAttachStdout((Boolean)this.attachStdout.get());
        }
        if (this.user.getOrNull() != null) {
            containerCommand.withUser((String)this.user.get());
        }
        if (this.workingDir.getOrNull() != null) {
            containerCommand.withWorkingDir((String)this.workingDir.get());
        }
    }

    public ExecProbe execProbe(long pollTime, long pollInterval) {
        this.execProbe = new ExecProbe(pollTime, pollInterval);
        return this.execProbe;
    }

    private ResultCallback.Adapter<Frame> createCallback(final Action nextHandler) {
        if (nextHandler != null) {
            return new ResultCallback.Adapter<Frame>(){

                @Override
                public void onNext(Frame frame) {
                    try {
                        nextHandler.execute((Object)frame);
                    }
                    catch (Exception e) {
                        DockerExecContainer.this.getLogger().error("Failed to handle frame", (Throwable)e);
                        return;
                    }
                    super.onNext(frame);
                }
            };
        }
        return new ResultCallback.Adapter<Frame>(){

            @Override
            public void onNext(Frame frame) {
                if (frame != null) {
                    switch (frame.getStreamType()) {
                        case STDOUT: 
                        case RAW: {
                            try {
                                System.out.write(frame.getPayload());
                            }
                            catch (IOException e) {
                                throw new UncheckedIOException(e);
                            }
                            System.out.flush();
                            break;
                        }
                        case STDERR: {
                            try {
                                System.err.write(frame.getPayload());
                            }
                            catch (IOException e) {
                                throw new UncheckedIOException(e);
                            }
                            System.err.flush();
                            break;
                        }
                        default: {
                            DockerExecContainer.this.getLogger().error("unknown stream type:" + String.valueOf((Object)frame.getStreamType()));
                        }
                    }
                }
            }
        };
    }
}

