/*
 * Decompiled with CFR 0.152.
 */
package com.bmuschko.gradle.docker.tasks.container;

import com.bmuschko.gradle.docker.domain.CopyFileToContainer;
import com.bmuschko.gradle.docker.tasks.container.DockerExistingContainer;
import com.github.dockerjava.api.command.CopyArchiveToContainerCmd;
import groovy.lang.Closure;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.Objects;
import org.gradle.api.GradleException;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.internal.file.FileOperations;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.Optional;

public class DockerCopyFileToContainer
extends DockerExistingContainer {
    private final Property<String> remotePath = this.getProject().getObjects().property(String.class);
    private final Property<String> hostPath = this.getProject().getObjects().property(String.class);
    private final RegularFileProperty tarFile = this.getProject().getObjects().fileProperty();
    private final ArrayList<CopyFileToContainer> copyFiles = new ArrayList();
    private final FileOperations fileOperations = ((ProjectInternal)this.getProject()).getFileOperations();

    @Input
    @Optional
    public final Property<String> getRemotePath() {
        return this.remotePath;
    }

    @Input
    @Optional
    public final Property<String> getHostPath() {
        return this.hostPath;
    }

    @InputFile
    @Optional
    public final RegularFileProperty getTarFile() {
        return this.tarFile;
    }

    @Input
    @Optional
    public final ArrayList<CopyFileToContainer> getCopyFiles() {
        return this.copyFiles;
    }

    @Override
    public void runRemoteCommand() throws IOException {
        if (this.remotePath.getOrNull() != null) {
            if (this.hostPath.getOrNull() != null && this.tarFile.getOrNull() != null) {
                throw new GradleException("Can specify either hostPath or tarFile not both");
            }
            if (this.hostPath.getOrNull() != null) {
                this.withFile(this.hostPath.get(), this.remotePath.get());
            } else if (this.tarFile.getOrNull() != null) {
                this.withTarFile(this.tarFile.get(), this.remotePath.get());
            }
        }
        for (int i = 0; i < this.copyFiles.size(); ++i) {
            CopyFileToContainer fileToCopy = this.copyFiles.get(i);
            this.getLogger().quiet("Copying file to container with ID '" + (String)this.getContainerId().get() + "' at '" + String.valueOf(fileToCopy.getRemotePath()) + "'.");
            CopyArchiveToContainerCmd containerCommand = this.getDockerClient().copyArchiveToContainerCmd((String)this.getContainerId().get());
            this.setContainerCommandConfig(containerCommand, fileToCopy);
            containerCommand.exec();
        }
    }

    private void setContainerCommandConfig(CopyArchiveToContainerCmd containerCommand, CopyFileToContainer copyFileToContainer) throws IOException {
        File localHostPath = copyFileToContainer.getHostPath() instanceof Closure ? this.fileOperations.file(((Closure)copyFileToContainer.getHostPath()).call()) : this.fileOperations.file(copyFileToContainer.getHostPath());
        if (copyFileToContainer.getRemotePath() instanceof Closure) {
            containerCommand.withRemotePath((String)((Closure)copyFileToContainer.getRemotePath()).call());
        } else {
            containerCommand.withRemotePath((String)copyFileToContainer.getRemotePath());
        }
        if (copyFileToContainer.getIsTar()) {
            containerCommand.withTarInputStream(Files.newInputStream(localHostPath.toPath(), new OpenOption[0]));
        } else {
            containerCommand.withHostResource(localHostPath.getPath());
        }
    }

    public void withFile(Object hostPath, Object remotePath) {
        CopyFileToContainer container = new CopyFileToContainer();
        container.setHostPath(Objects.requireNonNull(hostPath));
        container.setRemotePath(Objects.requireNonNull(remotePath));
        this.copyFiles.add(container);
    }

    public void withTarFile(Object hostPath, Object remotePath) {
        CopyFileToContainer container = new CopyFileToContainer();
        container.setHostPath(Objects.requireNonNull(hostPath));
        container.setRemotePath(Objects.requireNonNull(remotePath));
        container.setIsTar(true);
        this.copyFiles.add(container);
    }
}

