/*
 * Decompiled with CFR 0.152.
 */
package com.bmuschko.gradle.docker.shaded.org.apache.hc.core5.http2.protocol;

import com.bmuschko.gradle.docker.shaded.org.apache.hc.core5.annotation.Contract;
import com.bmuschko.gradle.docker.shaded.org.apache.hc.core5.annotation.Internal;
import com.bmuschko.gradle.docker.shaded.org.apache.hc.core5.annotation.ThreadingBehavior;
import com.bmuschko.gradle.docker.shaded.org.apache.hc.core5.http.EntityDetails;
import com.bmuschko.gradle.docker.shaded.org.apache.hc.core5.http.Header;
import com.bmuschko.gradle.docker.shaded.org.apache.hc.core5.http.HttpException;
import com.bmuschko.gradle.docker.shaded.org.apache.hc.core5.http.HttpResponse;
import com.bmuschko.gradle.docker.shaded.org.apache.hc.core5.http.HttpResponseInterceptor;
import com.bmuschko.gradle.docker.shaded.org.apache.hc.core5.http.ProtocolException;
import com.bmuschko.gradle.docker.shaded.org.apache.hc.core5.http.protocol.HttpContext;
import com.bmuschko.gradle.docker.shaded.org.apache.hc.core5.util.Args;
import java.io.IOException;

@Internal
@Contract(threading=ThreadingBehavior.IMMUTABLE)
public class H2ResponseConformance
implements HttpResponseInterceptor {
    public static final H2ResponseConformance INSTANCE = new H2ResponseConformance();
    private final String[] illegalHeaderNames;

    @Internal
    public H2ResponseConformance(String ... illegalHeaderNames) {
        this.illegalHeaderNames = illegalHeaderNames;
    }

    public H2ResponseConformance() {
        this("Connection", "Keep-Alive", "Transfer-Encoding", "Upgrade");
    }

    @Override
    public void process(HttpResponse response, EntityDetails entity, HttpContext context) throws HttpException, IOException {
        Args.notNull(response, "HTTP response");
        for (int i = 0; i < this.illegalHeaderNames.length; ++i) {
            String headerName = this.illegalHeaderNames[i];
            Header header = response.getFirstHeader(headerName);
            if (header == null) continue;
            throw new ProtocolException("Header '%s' is illegal for HTTP/2 messages", headerName);
        }
    }
}

