/*
 * Decompiled with CFR 0.152.
 */
package com.blankj.utilcode.util;

import android.annotation.SuppressLint;
import androidx.annotation.NonNull;
import com.blankj.utilcode.util.Utils;
import com.blankj.utilcode.util.UtilsBridge;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;

public final class CrashUtils {
    private static final String FILE_SEP = System.getProperty("file.separator");
    private static final Thread.UncaughtExceptionHandler DEFAULT_UNCAUGHT_EXCEPTION_HANDLER = Thread.getDefaultUncaughtExceptionHandler();

    private CrashUtils() {
        throw new UnsupportedOperationException("u can't instantiate me...");
    }

    @SuppressLint(value={"MissingPermission"})
    public static void init() {
        CrashUtils.init("");
    }

    public static void init(@NonNull File crashDir) {
        if (crashDir == null) {
            throw new NullPointerException("Argument 'crashDir' of type File (#0 out of 1, zero-based) is marked by @androidx.annotation.NonNull but got null for it");
        }
        CrashUtils.init(crashDir.getAbsolutePath(), null);
    }

    public static void init(String crashDirPath) {
        CrashUtils.init(crashDirPath, null);
    }

    public static void init(OnCrashListener onCrashListener) {
        CrashUtils.init("", onCrashListener);
    }

    public static void init(@NonNull File crashDir, OnCrashListener onCrashListener) {
        if (crashDir == null) {
            throw new NullPointerException("Argument 'crashDir' of type File (#0 out of 2, zero-based) is marked by @androidx.annotation.NonNull but got null for it");
        }
        CrashUtils.init(crashDir.getAbsolutePath(), onCrashListener);
    }

    public static void init(String crashDirPath, OnCrashListener onCrashListener) {
        String dirPath = UtilsBridge.isSpace(crashDirPath) ? (UtilsBridge.isSDCardEnableByEnvironment() && Utils.getApp().getExternalFilesDir(null) != null ? Utils.getApp().getExternalFilesDir(null) + FILE_SEP + "crash" + FILE_SEP : Utils.getApp().getFilesDir() + FILE_SEP + "crash" + FILE_SEP) : (crashDirPath.endsWith(FILE_SEP) ? crashDirPath : crashDirPath + FILE_SEP);
        Thread.setDefaultUncaughtExceptionHandler(CrashUtils.getUncaughtExceptionHandler(dirPath, onCrashListener));
    }

    private static Thread.UncaughtExceptionHandler getUncaughtExceptionHandler(final String dirPath, final OnCrashListener onCrashListener) {
        return new Thread.UncaughtExceptionHandler(){

            @Override
            public void uncaughtException(@NonNull Thread t, @NonNull Throwable e) {
                if (t == null) {
                    throw new NullPointerException("Argument 't' of type Thread (#0 out of 2, zero-based) is marked by @androidx.annotation.NonNull but got null for it");
                }
                if (e == null) {
                    throw new NullPointerException("Argument 'e' of type Throwable (#1 out of 2, zero-based) is marked by @androidx.annotation.NonNull but got null for it");
                }
                String time = new SimpleDateFormat("yyyy_MM_dd-HH_mm_ss").format(new Date());
                CrashInfo info = new CrashInfo(time, e);
                if (onCrashListener != null) {
                    onCrashListener.onCrash(info);
                }
                String crashFile = dirPath + time + ".txt";
                UtilsBridge.writeFileFromString(crashFile, info.toString(), true);
                if (DEFAULT_UNCAUGHT_EXCEPTION_HANDLER != null) {
                    DEFAULT_UNCAUGHT_EXCEPTION_HANDLER.uncaughtException(t, e);
                }
            }
        };
    }

    public static final class CrashInfo {
        private UtilsBridge.FileHead mFileHeadProvider;
        private Throwable mThrowable;

        private CrashInfo(String time, Throwable throwable) {
            this.mThrowable = throwable;
            this.mFileHeadProvider = new UtilsBridge.FileHead("Crash");
            this.mFileHeadProvider.addFirst("Time Of Crash", time);
        }

        public final void addExtraHead(Map<String, String> extraHead) {
            this.mFileHeadProvider.append(extraHead);
        }

        public final void addExtraHead(String key, String value) {
            this.mFileHeadProvider.append(key, value);
        }

        public final Throwable getThrowable() {
            return this.mThrowable;
        }

        public String toString() {
            return this.mFileHeadProvider.toString() + UtilsBridge.getFullStackTrace(this.mThrowable);
        }
    }

    public static interface OnCrashListener {
        public void onCrash(CrashInfo var1);
    }
}

