/*
 * Decompiled with CFR 0.152.
 */
package com.blankj.utilcode.util;

import android.app.Activity;
import android.app.ActivityManager;
import android.content.Intent;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.pm.Signature;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.os.Build;
import android.os.Process;
import android.util.Log;
import androidx.annotation.NonNull;
import com.blankj.utilcode.util.ShellUtils;
import com.blankj.utilcode.util.Utils;
import com.blankj.utilcode.util.UtilsBridge;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

public final class AppUtils {
    private AppUtils() {
        throw new UnsupportedOperationException("u can't instantiate me...");
    }

    public static void registerAppStatusChangedListener(@NonNull Utils.OnAppStatusChangedListener listener) {
        if (listener == null) {
            throw new NullPointerException("Argument 'listener' of type Utils.OnAppStatusChangedListener (#0 out of 1, zero-based) is marked by @androidx.annotation.NonNull but got null for it");
        }
        UtilsBridge.addOnAppStatusChangedListener(listener);
    }

    public static void unregisterAppStatusChangedListener(@NonNull Utils.OnAppStatusChangedListener listener) {
        if (listener == null) {
            throw new NullPointerException("Argument 'listener' of type Utils.OnAppStatusChangedListener (#0 out of 1, zero-based) is marked by @androidx.annotation.NonNull but got null for it");
        }
        UtilsBridge.removeOnAppStatusChangedListener(listener);
    }

    public static void installApp(String filePath) {
        AppUtils.installApp(UtilsBridge.getFileByPath(filePath));
    }

    public static void installApp(File file) {
        Intent installAppIntent = UtilsBridge.getInstallAppIntent(file);
        if (installAppIntent == null) {
            return;
        }
        Utils.getApp().startActivity(installAppIntent);
    }

    public static void installApp(Uri uri) {
        Intent installAppIntent = UtilsBridge.getInstallAppIntent(uri);
        if (installAppIntent == null) {
            return;
        }
        Utils.getApp().startActivity(installAppIntent);
    }

    public static void uninstallApp(String packageName) {
        if (UtilsBridge.isSpace(packageName)) {
            return;
        }
        Utils.getApp().startActivity(UtilsBridge.getUninstallAppIntent(packageName));
    }

    public static boolean isAppInstalled(String pkgName) {
        if (UtilsBridge.isSpace(pkgName)) {
            return false;
        }
        PackageManager pm = Utils.getApp().getPackageManager();
        try {
            return pm.getApplicationInfo((String)pkgName, (int)0).enabled;
        }
        catch (PackageManager.NameNotFoundException e) {
            return false;
        }
    }

    public static boolean isAppRoot() {
        ShellUtils.CommandResult result = UtilsBridge.execCmd("echo root", true);
        return result.result == 0;
    }

    public static boolean isAppDebug() {
        return AppUtils.isAppDebug(Utils.getApp().getPackageName());
    }

    public static boolean isAppDebug(String packageName) {
        if (UtilsBridge.isSpace(packageName)) {
            return false;
        }
        ApplicationInfo ai = Utils.getApp().getApplicationInfo();
        return ai != null && (ai.flags & 2) != 0;
    }

    public static boolean isAppSystem() {
        return AppUtils.isAppSystem(Utils.getApp().getPackageName());
    }

    public static boolean isAppSystem(String packageName) {
        if (UtilsBridge.isSpace(packageName)) {
            return false;
        }
        try {
            PackageManager pm = Utils.getApp().getPackageManager();
            ApplicationInfo ai = pm.getApplicationInfo(packageName, 0);
            return ai != null && (ai.flags & 1) != 0;
        }
        catch (PackageManager.NameNotFoundException e) {
            e.printStackTrace();
            return false;
        }
    }

    public static boolean isAppForeground() {
        return UtilsBridge.isAppForeground();
    }

    public static boolean isAppForeground(@NonNull String pkgName) {
        if (pkgName == null) {
            throw new NullPointerException("Argument 'pkgName' of type String (#0 out of 1, zero-based) is marked by @androidx.annotation.NonNull but got null for it");
        }
        return !UtilsBridge.isSpace(pkgName) && pkgName.equals(UtilsBridge.getForegroundProcessName());
    }

    public static boolean isAppRunning(String pkgName) {
        if (UtilsBridge.isSpace(pkgName)) {
            return false;
        }
        ApplicationInfo ai = Utils.getApp().getApplicationInfo();
        int uid = ai.uid;
        ActivityManager am = (ActivityManager)Utils.getApp().getSystemService("activity");
        if (am != null) {
            List serviceInfo;
            List taskInfo = am.getRunningTasks(Integer.MAX_VALUE);
            if (taskInfo != null && taskInfo.size() > 0) {
                for (ActivityManager.RunningTaskInfo aInfo : taskInfo) {
                    if (aInfo.baseActivity == null || !pkgName.equals(aInfo.baseActivity.getPackageName())) continue;
                    return true;
                }
            }
            if ((serviceInfo = am.getRunningServices(Integer.MAX_VALUE)) != null && serviceInfo.size() > 0) {
                for (ActivityManager.RunningServiceInfo aInfo : serviceInfo) {
                    if (uid != aInfo.uid) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public static void launchApp(String packageName) {
        if (UtilsBridge.isSpace(packageName)) {
            return;
        }
        Intent launchAppIntent = UtilsBridge.getLaunchAppIntent(packageName);
        if (launchAppIntent == null) {
            Log.e((String)"AppUtils", (String)"Didn't exist launcher activity.");
            return;
        }
        Utils.getApp().startActivity(launchAppIntent);
    }

    public static void relaunchApp() {
        AppUtils.relaunchApp(false);
    }

    public static void relaunchApp(boolean isKillProcess) {
        Intent intent = UtilsBridge.getLaunchAppIntent(Utils.getApp().getPackageName());
        if (intent == null) {
            Log.e((String)"AppUtils", (String)"Didn't exist launcher activity.");
            return;
        }
        intent.addFlags(335577088);
        Utils.getApp().startActivity(intent);
        if (!isKillProcess) {
            return;
        }
        Process.killProcess((int)Process.myPid());
        System.exit(0);
    }

    public static void launchAppDetailsSettings() {
        AppUtils.launchAppDetailsSettings(Utils.getApp().getPackageName());
    }

    public static void launchAppDetailsSettings(String pkgName) {
        if (UtilsBridge.isSpace(pkgName)) {
            return;
        }
        Intent intent = UtilsBridge.getLaunchAppDetailsSettingsIntent(pkgName, true);
        if (!UtilsBridge.isIntentAvailable(intent)) {
            return;
        }
        Utils.getApp().startActivity(intent);
    }

    public static void launchAppDetailsSettings(Activity activity, int requestCode) {
        AppUtils.launchAppDetailsSettings(activity, requestCode, Utils.getApp().getPackageName());
    }

    public static void launchAppDetailsSettings(Activity activity, int requestCode, String pkgName) {
        if (activity == null || UtilsBridge.isSpace(pkgName)) {
            return;
        }
        Intent intent = UtilsBridge.getLaunchAppDetailsSettingsIntent(pkgName, false);
        if (!UtilsBridge.isIntentAvailable(intent)) {
            return;
        }
        activity.startActivityForResult(intent, requestCode);
    }

    public static void exitApp() {
        UtilsBridge.finishAllActivities();
        System.exit(0);
    }

    public static Drawable getAppIcon() {
        return AppUtils.getAppIcon(Utils.getApp().getPackageName());
    }

    public static Drawable getAppIcon(String packageName) {
        if (UtilsBridge.isSpace(packageName)) {
            return null;
        }
        try {
            PackageManager pm = Utils.getApp().getPackageManager();
            PackageInfo pi = pm.getPackageInfo(packageName, 0);
            return pi == null ? null : pi.applicationInfo.loadIcon(pm);
        }
        catch (PackageManager.NameNotFoundException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static int getAppIconId() {
        return AppUtils.getAppIconId(Utils.getApp().getPackageName());
    }

    public static int getAppIconId(String packageName) {
        if (UtilsBridge.isSpace(packageName)) {
            return 0;
        }
        try {
            PackageManager pm = Utils.getApp().getPackageManager();
            PackageInfo pi = pm.getPackageInfo(packageName, 0);
            return pi == null ? 0 : pi.applicationInfo.icon;
        }
        catch (PackageManager.NameNotFoundException e) {
            e.printStackTrace();
            return 0;
        }
    }

    public static String getAppPackageName() {
        return Utils.getApp().getPackageName();
    }

    public static String getAppName() {
        return AppUtils.getAppName(Utils.getApp().getPackageName());
    }

    public static String getAppName(String packageName) {
        if (UtilsBridge.isSpace(packageName)) {
            return "";
        }
        try {
            PackageManager pm = Utils.getApp().getPackageManager();
            PackageInfo pi = pm.getPackageInfo(packageName, 0);
            return pi == null ? null : pi.applicationInfo.loadLabel(pm).toString();
        }
        catch (PackageManager.NameNotFoundException e) {
            e.printStackTrace();
            return "";
        }
    }

    public static String getAppPath() {
        return AppUtils.getAppPath(Utils.getApp().getPackageName());
    }

    public static String getAppPath(String packageName) {
        if (UtilsBridge.isSpace(packageName)) {
            return "";
        }
        try {
            PackageManager pm = Utils.getApp().getPackageManager();
            PackageInfo pi = pm.getPackageInfo(packageName, 0);
            return pi == null ? null : pi.applicationInfo.sourceDir;
        }
        catch (PackageManager.NameNotFoundException e) {
            e.printStackTrace();
            return "";
        }
    }

    public static String getAppVersionName() {
        return AppUtils.getAppVersionName(Utils.getApp().getPackageName());
    }

    public static String getAppVersionName(String packageName) {
        if (UtilsBridge.isSpace(packageName)) {
            return "";
        }
        try {
            PackageManager pm = Utils.getApp().getPackageManager();
            PackageInfo pi = pm.getPackageInfo(packageName, 0);
            return pi == null ? null : pi.versionName;
        }
        catch (PackageManager.NameNotFoundException e) {
            e.printStackTrace();
            return "";
        }
    }

    public static int getAppVersionCode() {
        return AppUtils.getAppVersionCode(Utils.getApp().getPackageName());
    }

    public static int getAppVersionCode(String packageName) {
        if (UtilsBridge.isSpace(packageName)) {
            return -1;
        }
        try {
            PackageManager pm = Utils.getApp().getPackageManager();
            PackageInfo pi = pm.getPackageInfo(packageName, 0);
            return pi == null ? -1 : pi.versionCode;
        }
        catch (PackageManager.NameNotFoundException e) {
            e.printStackTrace();
            return -1;
        }
    }

    public static Signature[] getAppSignature() {
        return AppUtils.getAppSignature(Utils.getApp().getPackageName());
    }

    public static Signature[] getAppSignature(String packageName) {
        if (UtilsBridge.isSpace(packageName)) {
            return null;
        }
        try {
            PackageManager pm = Utils.getApp().getPackageManager();
            PackageInfo pi = Build.VERSION.SDK_INT >= 28 ? pm.getPackageInfo(packageName, 0x8000000) : pm.getPackageInfo(packageName, 64);
            return pi == null ? null : pi.signatures;
        }
        catch (PackageManager.NameNotFoundException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Signature[] getAppSignature(File file) {
        if (file == null) {
            return null;
        }
        PackageManager pm = Utils.getApp().getPackageManager();
        PackageInfo pi = Build.VERSION.SDK_INT >= 28 ? pm.getPackageArchiveInfo(file.getAbsolutePath(), 0x8000000) : pm.getPackageArchiveInfo(file.getAbsolutePath(), 64);
        return pi == null ? null : pi.signatures;
    }

    public static String getAppSignatureSHA1() {
        return AppUtils.getAppSignatureSHA1(Utils.getApp().getPackageName());
    }

    public static String getAppSignatureSHA1(String packageName) {
        return AppUtils.getAppSignatureHash(packageName, "SHA1");
    }

    public static String getAppSignatureSHA256() {
        return AppUtils.getAppSignatureSHA256(Utils.getApp().getPackageName());
    }

    public static String getAppSignatureSHA256(String packageName) {
        return AppUtils.getAppSignatureHash(packageName, "SHA256");
    }

    public static String getAppSignatureMD5() {
        return AppUtils.getAppSignatureMD5(Utils.getApp().getPackageName());
    }

    public static String getAppSignatureMD5(String packageName) {
        return AppUtils.getAppSignatureHash(packageName, "MD5");
    }

    public static int getAppUid() {
        return AppUtils.getAppUid(Utils.getApp().getPackageName());
    }

    public static int getAppUid(String pkgName) {
        try {
            return Utils.getApp().getPackageManager().getApplicationInfo((String)pkgName, (int)0).uid;
        }
        catch (Exception e) {
            e.printStackTrace();
            return -1;
        }
    }

    private static String getAppSignatureHash(String packageName, String algorithm) {
        if (UtilsBridge.isSpace(packageName)) {
            return "";
        }
        Signature[] signature = AppUtils.getAppSignature(packageName);
        if (signature == null || signature.length <= 0) {
            return "";
        }
        return UtilsBridge.bytes2HexString(UtilsBridge.hashTemplate(signature[0].toByteArray(), algorithm)).replaceAll("(?<=[0-9A-F]{2})[0-9A-F]{2}", ":$0");
    }

    public static AppInfo getAppInfo() {
        return AppUtils.getAppInfo(Utils.getApp().getPackageName());
    }

    public static AppInfo getAppInfo(String packageName) {
        try {
            PackageManager pm = Utils.getApp().getPackageManager();
            if (pm == null) {
                return null;
            }
            return AppUtils.getBean(pm, pm.getPackageInfo(packageName, 0));
        }
        catch (PackageManager.NameNotFoundException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static List<AppInfo> getAppsInfo() {
        ArrayList<AppInfo> list = new ArrayList<AppInfo>();
        PackageManager pm = Utils.getApp().getPackageManager();
        if (pm == null) {
            return list;
        }
        List installedPackages = pm.getInstalledPackages(0);
        for (PackageInfo pi : installedPackages) {
            AppInfo ai = AppUtils.getBean(pm, pi);
            if (ai == null) continue;
            list.add(ai);
        }
        return list;
    }

    public static AppInfo getApkInfo(File apkFile) {
        if (apkFile == null || !apkFile.isFile() || !apkFile.exists()) {
            return null;
        }
        return AppUtils.getApkInfo(apkFile.getAbsolutePath());
    }

    public static AppInfo getApkInfo(String apkFilePath) {
        if (UtilsBridge.isSpace(apkFilePath)) {
            return null;
        }
        PackageManager pm = Utils.getApp().getPackageManager();
        if (pm == null) {
            return null;
        }
        PackageInfo pi = pm.getPackageArchiveInfo(apkFilePath, 0);
        if (pi == null) {
            return null;
        }
        ApplicationInfo appInfo = pi.applicationInfo;
        appInfo.sourceDir = apkFilePath;
        appInfo.publicSourceDir = apkFilePath;
        return AppUtils.getBean(pm, pi);
    }

    private static AppInfo getBean(PackageManager pm, PackageInfo pi) {
        if (pi == null) {
            return null;
        }
        ApplicationInfo ai = pi.applicationInfo;
        String packageName = pi.packageName;
        String name = ai.loadLabel(pm).toString();
        Drawable icon = ai.loadIcon(pm);
        String packagePath = ai.sourceDir;
        String versionName = pi.versionName;
        int versionCode = pi.versionCode;
        boolean isSystem = (1 & ai.flags) != 0;
        return new AppInfo(packageName, name, icon, packagePath, versionName, versionCode, isSystem);
    }

    public static class AppInfo {
        private String packageName;
        private String name;
        private Drawable icon;
        private String packagePath;
        private String versionName;
        private int versionCode;
        private boolean isSystem;

        public Drawable getIcon() {
            return this.icon;
        }

        public void setIcon(Drawable icon) {
            this.icon = icon;
        }

        public boolean isSystem() {
            return this.isSystem;
        }

        public void setSystem(boolean isSystem) {
            this.isSystem = isSystem;
        }

        public String getPackageName() {
            return this.packageName;
        }

        public void setPackageName(String packageName) {
            this.packageName = packageName;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getPackagePath() {
            return this.packagePath;
        }

        public void setPackagePath(String packagePath) {
            this.packagePath = packagePath;
        }

        public int getVersionCode() {
            return this.versionCode;
        }

        public void setVersionCode(int versionCode) {
            this.versionCode = versionCode;
        }

        public String getVersionName() {
            return this.versionName;
        }

        public void setVersionName(String versionName) {
            this.versionName = versionName;
        }

        public AppInfo(String packageName, String name, Drawable icon, String packagePath, String versionName, int versionCode, boolean isSystem) {
            this.setName(name);
            this.setIcon(icon);
            this.setPackageName(packageName);
            this.setPackagePath(packagePath);
            this.setVersionName(versionName);
            this.setVersionCode(versionCode);
            this.setSystem(isSystem);
        }

        public String toString() {
            return "{\n    pkg name: " + this.getPackageName() + "\n    app icon: " + this.getIcon() + "\n    app name: " + this.getName() + "\n    app path: " + this.getPackagePath() + "\n    app v name: " + this.getVersionName() + "\n    app v code: " + this.getVersionCode() + "\n    is system: " + this.isSystem() + "\n}";
        }
    }
}

