/*
 * Decompiled with CFR 0.152.
 */
package com.blankj.utilcode.util;

import androidx.collection.SimpleArrayMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class RegexUtils {
    private static final SimpleArrayMap<String, String> CITY_MAP = new SimpleArrayMap();

    private RegexUtils() {
        throw new UnsupportedOperationException("u can't instantiate me...");
    }

    public static boolean isMobileSimple(CharSequence input) {
        return RegexUtils.isMatch("^[1]\\d{10}$", input);
    }

    public static boolean isMobileExact(CharSequence input) {
        return RegexUtils.isMobileExact(input, null);
    }

    public static boolean isMobileExact(CharSequence input, List<String> newSegments) {
        boolean match = RegexUtils.isMatch("^((13[0-9])|(14[57])|(15[0-35-9])|(16[6])|(17[0135-8])|(18[0-9])|(19[189]))\\d{8}$", input);
        if (match) {
            return true;
        }
        if (newSegments == null) {
            return false;
        }
        if (input == null || input.length() != 11) {
            return false;
        }
        String content = input.toString();
        for (char c : content.toCharArray()) {
            if (Character.isDigit(c)) continue;
            return false;
        }
        Object object = newSegments.iterator();
        while (object.hasNext()) {
            String newSegment = (String)object.next();
            if (!content.startsWith(newSegment)) continue;
            return true;
        }
        return false;
    }

    public static boolean isTel(CharSequence input) {
        return RegexUtils.isMatch("^0\\d{2,3}[- ]?\\d{7,8}$", input);
    }

    public static boolean isIDCard15(CharSequence input) {
        return RegexUtils.isMatch("^[1-9]\\d{7}((0\\d)|(1[0-2]))(([0|1|2]\\d)|3[0-1])\\d{3}$", input);
    }

    public static boolean isIDCard18(CharSequence input) {
        return RegexUtils.isMatch("^[1-9]\\d{5}[1-9]\\d{3}((0\\d)|(1[0-2]))(([0|1|2]\\d)|3[0-1])\\d{3}([0-9Xx])$", input);
    }

    public static boolean isIDCard18Exact(CharSequence input) {
        if (RegexUtils.isIDCard18(input)) {
            int[] factor = new int[]{7, 9, 10, 5, 8, 4, 2, 1, 6, 3, 7, 9, 10, 5, 8, 4, 2};
            char[] suffix = new char[]{'1', '0', 'X', '9', '8', '7', '6', '5', '4', '3', '2'};
            if (CITY_MAP.isEmpty()) {
                CITY_MAP.put((Object)"11", (Object)"\u5317\u4eac");
                CITY_MAP.put((Object)"12", (Object)"\u5929\u6d25");
                CITY_MAP.put((Object)"13", (Object)"\u6cb3\u5317");
                CITY_MAP.put((Object)"14", (Object)"\u5c71\u897f");
                CITY_MAP.put((Object)"15", (Object)"\u5185\u8499\u53e4");
                CITY_MAP.put((Object)"21", (Object)"\u8fbd\u5b81");
                CITY_MAP.put((Object)"22", (Object)"\u5409\u6797");
                CITY_MAP.put((Object)"23", (Object)"\u9ed1\u9f99\u6c5f");
                CITY_MAP.put((Object)"31", (Object)"\u4e0a\u6d77");
                CITY_MAP.put((Object)"32", (Object)"\u6c5f\u82cf");
                CITY_MAP.put((Object)"33", (Object)"\u6d59\u6c5f");
                CITY_MAP.put((Object)"34", (Object)"\u5b89\u5fbd");
                CITY_MAP.put((Object)"35", (Object)"\u798f\u5efa");
                CITY_MAP.put((Object)"36", (Object)"\u6c5f\u897f");
                CITY_MAP.put((Object)"37", (Object)"\u5c71\u4e1c");
                CITY_MAP.put((Object)"41", (Object)"\u6cb3\u5357");
                CITY_MAP.put((Object)"42", (Object)"\u6e56\u5317");
                CITY_MAP.put((Object)"43", (Object)"\u6e56\u5357");
                CITY_MAP.put((Object)"44", (Object)"\u5e7f\u4e1c");
                CITY_MAP.put((Object)"45", (Object)"\u5e7f\u897f");
                CITY_MAP.put((Object)"46", (Object)"\u6d77\u5357");
                CITY_MAP.put((Object)"50", (Object)"\u91cd\u5e86");
                CITY_MAP.put((Object)"51", (Object)"\u56db\u5ddd");
                CITY_MAP.put((Object)"52", (Object)"\u8d35\u5dde");
                CITY_MAP.put((Object)"53", (Object)"\u4e91\u5357");
                CITY_MAP.put((Object)"54", (Object)"\u897f\u85cf");
                CITY_MAP.put((Object)"61", (Object)"\u9655\u897f");
                CITY_MAP.put((Object)"62", (Object)"\u7518\u8083");
                CITY_MAP.put((Object)"63", (Object)"\u9752\u6d77");
                CITY_MAP.put((Object)"64", (Object)"\u5b81\u590f");
                CITY_MAP.put((Object)"65", (Object)"\u65b0\u7586");
                CITY_MAP.put((Object)"71", (Object)"\u53f0\u6e7e");
                CITY_MAP.put((Object)"81", (Object)"\u9999\u6e2f");
                CITY_MAP.put((Object)"82", (Object)"\u6fb3\u95e8");
                CITY_MAP.put((Object)"91", (Object)"\u56fd\u5916");
            }
            if (CITY_MAP.get((Object)input.subSequence(0, 2).toString()) != null) {
                int weightSum = 0;
                for (int i = 0; i < 17; ++i) {
                    weightSum += (input.charAt(i) - 48) * factor[i];
                }
                int idCardMod = weightSum % 11;
                char idCardLast = input.charAt(17);
                return idCardLast == suffix[idCardMod];
            }
        }
        return false;
    }

    public static boolean isEmail(CharSequence input) {
        return RegexUtils.isMatch("^\\w+([-+.]\\w+)*@\\w+([-.]\\w+)*\\.\\w+([-.]\\w+)*$", input);
    }

    public static boolean isURL(CharSequence input) {
        return RegexUtils.isMatch("[a-zA-z]+://[^\\s]*", input);
    }

    public static boolean isZh(CharSequence input) {
        return RegexUtils.isMatch("^[\\u4e00-\\u9fa5]+$", input);
    }

    public static boolean isUsername(CharSequence input) {
        return RegexUtils.isMatch("^[\\w\\u4e00-\\u9fa5]{6,20}(?<!_)$", input);
    }

    public static boolean isDate(CharSequence input) {
        return RegexUtils.isMatch("^(?:(?!0000)[0-9]{4}-(?:(?:0[1-9]|1[0-2])-(?:0[1-9]|1[0-9]|2[0-8])|(?:0[13-9]|1[0-2])-(?:29|30)|(?:0[13578]|1[02])-31)|(?:[0-9]{2}(?:0[48]|[2468][048]|[13579][26])|(?:0[48]|[2468][048]|[13579][26])00)-02-29)$", input);
    }

    public static boolean isIP(CharSequence input) {
        return RegexUtils.isMatch("((2[0-4]\\d|25[0-5]|[01]?\\d\\d?)\\.){3}(2[0-4]\\d|25[0-5]|[01]?\\d\\d?)", input);
    }

    public static boolean isMatch(String regex, CharSequence input) {
        return input != null && input.length() > 0 && Pattern.matches(regex, input);
    }

    public static List<String> getMatches(String regex, CharSequence input) {
        if (input == null) {
            return Collections.emptyList();
        }
        ArrayList<String> matches = new ArrayList<String>();
        Pattern pattern = Pattern.compile(regex);
        Matcher matcher = pattern.matcher(input);
        while (matcher.find()) {
            matches.add(matcher.group());
        }
        return matches;
    }

    public static String[] getSplits(String input, String regex) {
        if (input == null) {
            return new String[0];
        }
        return input.split(regex);
    }

    public static String getReplaceFirst(String input, String regex, String replacement) {
        if (input == null) {
            return "";
        }
        return Pattern.compile(regex).matcher(input).replaceFirst(replacement);
    }

    public static String getReplaceAll(String input, String regex, String replacement) {
        if (input == null) {
            return "";
        }
        return Pattern.compile(regex).matcher(input).replaceAll(replacement);
    }
}

