/*
 * Decompiled with CFR 0.152.
 */
package com.blankj.utilcode.util;

import android.os.Build;
import android.os.Environment;
import android.text.TextUtils;
import com.blankj.utilcode.util.Utils;
import com.blankj.utilcode.util.UtilsBridge;
import java.io.File;

public final class PathUtils {
    private static final char SEP = File.separatorChar;

    private PathUtils() {
        throw new UnsupportedOperationException("u can't instantiate me...");
    }

    public static String join(String parent, String child) {
        if (TextUtils.isEmpty((CharSequence)child)) {
            return parent;
        }
        if (parent == null) {
            parent = "";
        }
        int len = parent.length();
        String legalSegment = PathUtils.getLegalSegment(child);
        String newPath = len == 0 ? SEP + legalSegment : (parent.charAt(len - 1) == SEP ? parent + legalSegment : parent + SEP + legalSegment);
        return newPath;
    }

    private static String getLegalSegment(String segment) {
        int st = -1;
        int end = -1;
        char[] charArray = segment.toCharArray();
        for (int i = 0; i < charArray.length; ++i) {
            char c = charArray[i];
            if (c == SEP) continue;
            if (st == -1) {
                st = i;
            }
            end = i;
        }
        if (st >= 0 && end >= st) {
            return segment.substring(st, end + 1);
        }
        throw new IllegalArgumentException("segment of <" + segment + "> is illegal");
    }

    public static String getRootPath() {
        return PathUtils.getAbsolutePath(Environment.getRootDirectory());
    }

    public static String getDataPath() {
        return PathUtils.getAbsolutePath(Environment.getDataDirectory());
    }

    public static String getDownloadCachePath() {
        return PathUtils.getAbsolutePath(Environment.getDownloadCacheDirectory());
    }

    public static String getInternalAppDataPath() {
        if (Build.VERSION.SDK_INT < 24) {
            return Utils.getApp().getApplicationInfo().dataDir;
        }
        return PathUtils.getAbsolutePath(Utils.getApp().getDataDir());
    }

    public static String getInternalAppCodeCacheDir() {
        if (Build.VERSION.SDK_INT < 21) {
            return Utils.getApp().getApplicationInfo().dataDir + "/code_cache";
        }
        return PathUtils.getAbsolutePath(Utils.getApp().getCodeCacheDir());
    }

    public static String getInternalAppCachePath() {
        return PathUtils.getAbsolutePath(Utils.getApp().getCacheDir());
    }

    public static String getInternalAppDbsPath() {
        return Utils.getApp().getApplicationInfo().dataDir + "/databases";
    }

    public static String getInternalAppDbPath(String name) {
        return PathUtils.getAbsolutePath(Utils.getApp().getDatabasePath(name));
    }

    public static String getInternalAppFilesPath() {
        return PathUtils.getAbsolutePath(Utils.getApp().getFilesDir());
    }

    public static String getInternalAppSpPath() {
        return Utils.getApp().getApplicationInfo().dataDir + "/shared_prefs";
    }

    public static String getInternalAppNoBackupFilesPath() {
        if (Build.VERSION.SDK_INT < 21) {
            return Utils.getApp().getApplicationInfo().dataDir + "/no_backup";
        }
        return PathUtils.getAbsolutePath(Utils.getApp().getNoBackupFilesDir());
    }

    public static String getExternalStoragePath() {
        if (!UtilsBridge.isSDCardEnableByEnvironment()) {
            return "";
        }
        return PathUtils.getAbsolutePath(Environment.getExternalStorageDirectory());
    }

    public static String getExternalMusicPath() {
        if (!UtilsBridge.isSDCardEnableByEnvironment()) {
            return "";
        }
        return PathUtils.getAbsolutePath(Environment.getExternalStoragePublicDirectory((String)Environment.DIRECTORY_MUSIC));
    }

    public static String getExternalPodcastsPath() {
        if (!UtilsBridge.isSDCardEnableByEnvironment()) {
            return "";
        }
        return PathUtils.getAbsolutePath(Environment.getExternalStoragePublicDirectory((String)Environment.DIRECTORY_PODCASTS));
    }

    public static String getExternalRingtonesPath() {
        if (!UtilsBridge.isSDCardEnableByEnvironment()) {
            return "";
        }
        return PathUtils.getAbsolutePath(Environment.getExternalStoragePublicDirectory((String)Environment.DIRECTORY_RINGTONES));
    }

    public static String getExternalAlarmsPath() {
        if (!UtilsBridge.isSDCardEnableByEnvironment()) {
            return "";
        }
        return PathUtils.getAbsolutePath(Environment.getExternalStoragePublicDirectory((String)Environment.DIRECTORY_ALARMS));
    }

    public static String getExternalNotificationsPath() {
        if (!UtilsBridge.isSDCardEnableByEnvironment()) {
            return "";
        }
        return PathUtils.getAbsolutePath(Environment.getExternalStoragePublicDirectory((String)Environment.DIRECTORY_NOTIFICATIONS));
    }

    public static String getExternalPicturesPath() {
        if (!UtilsBridge.isSDCardEnableByEnvironment()) {
            return "";
        }
        return PathUtils.getAbsolutePath(Environment.getExternalStoragePublicDirectory((String)Environment.DIRECTORY_PICTURES));
    }

    public static String getExternalMoviesPath() {
        if (!UtilsBridge.isSDCardEnableByEnvironment()) {
            return "";
        }
        return PathUtils.getAbsolutePath(Environment.getExternalStoragePublicDirectory((String)Environment.DIRECTORY_MOVIES));
    }

    public static String getExternalDownloadsPath() {
        if (!UtilsBridge.isSDCardEnableByEnvironment()) {
            return "";
        }
        return PathUtils.getAbsolutePath(Environment.getExternalStoragePublicDirectory((String)Environment.DIRECTORY_DOWNLOADS));
    }

    public static String getExternalDcimPath() {
        if (!UtilsBridge.isSDCardEnableByEnvironment()) {
            return "";
        }
        return PathUtils.getAbsolutePath(Environment.getExternalStoragePublicDirectory((String)Environment.DIRECTORY_DCIM));
    }

    public static String getExternalDocumentsPath() {
        if (!UtilsBridge.isSDCardEnableByEnvironment()) {
            return "";
        }
        if (Build.VERSION.SDK_INT < 19) {
            return PathUtils.getAbsolutePath(Environment.getExternalStorageDirectory()) + "/Documents";
        }
        return PathUtils.getAbsolutePath(Environment.getExternalStoragePublicDirectory((String)Environment.DIRECTORY_DOCUMENTS));
    }

    public static String getExternalAppDataPath() {
        if (!UtilsBridge.isSDCardEnableByEnvironment()) {
            return "";
        }
        File externalCacheDir = Utils.getApp().getExternalCacheDir();
        if (externalCacheDir == null) {
            return "";
        }
        return PathUtils.getAbsolutePath(externalCacheDir.getParentFile());
    }

    public static String getExternalAppCachePath() {
        if (!UtilsBridge.isSDCardEnableByEnvironment()) {
            return "";
        }
        return PathUtils.getAbsolutePath(Utils.getApp().getExternalCacheDir());
    }

    public static String getExternalAppFilesPath() {
        if (!UtilsBridge.isSDCardEnableByEnvironment()) {
            return "";
        }
        return PathUtils.getAbsolutePath(Utils.getApp().getExternalFilesDir(null));
    }

    public static String getExternalAppMusicPath() {
        if (!UtilsBridge.isSDCardEnableByEnvironment()) {
            return "";
        }
        return PathUtils.getAbsolutePath(Utils.getApp().getExternalFilesDir(Environment.DIRECTORY_MUSIC));
    }

    public static String getExternalAppPodcastsPath() {
        if (!UtilsBridge.isSDCardEnableByEnvironment()) {
            return "";
        }
        return PathUtils.getAbsolutePath(Utils.getApp().getExternalFilesDir(Environment.DIRECTORY_PODCASTS));
    }

    public static String getExternalAppRingtonesPath() {
        if (!UtilsBridge.isSDCardEnableByEnvironment()) {
            return "";
        }
        return PathUtils.getAbsolutePath(Utils.getApp().getExternalFilesDir(Environment.DIRECTORY_RINGTONES));
    }

    public static String getExternalAppAlarmsPath() {
        if (!UtilsBridge.isSDCardEnableByEnvironment()) {
            return "";
        }
        return PathUtils.getAbsolutePath(Utils.getApp().getExternalFilesDir(Environment.DIRECTORY_ALARMS));
    }

    public static String getExternalAppNotificationsPath() {
        if (!UtilsBridge.isSDCardEnableByEnvironment()) {
            return "";
        }
        return PathUtils.getAbsolutePath(Utils.getApp().getExternalFilesDir(Environment.DIRECTORY_NOTIFICATIONS));
    }

    public static String getExternalAppPicturesPath() {
        if (!UtilsBridge.isSDCardEnableByEnvironment()) {
            return "";
        }
        return PathUtils.getAbsolutePath(Utils.getApp().getExternalFilesDir(Environment.DIRECTORY_PICTURES));
    }

    public static String getExternalAppMoviesPath() {
        if (!UtilsBridge.isSDCardEnableByEnvironment()) {
            return "";
        }
        return PathUtils.getAbsolutePath(Utils.getApp().getExternalFilesDir(Environment.DIRECTORY_MOVIES));
    }

    public static String getExternalAppDownloadPath() {
        if (!UtilsBridge.isSDCardEnableByEnvironment()) {
            return "";
        }
        return PathUtils.getAbsolutePath(Utils.getApp().getExternalFilesDir(Environment.DIRECTORY_DOWNLOADS));
    }

    public static String getExternalAppDcimPath() {
        if (!UtilsBridge.isSDCardEnableByEnvironment()) {
            return "";
        }
        return PathUtils.getAbsolutePath(Utils.getApp().getExternalFilesDir(Environment.DIRECTORY_DCIM));
    }

    public static String getExternalAppDocumentsPath() {
        if (!UtilsBridge.isSDCardEnableByEnvironment()) {
            return "";
        }
        if (Build.VERSION.SDK_INT < 19) {
            return PathUtils.getAbsolutePath(Utils.getApp().getExternalFilesDir(null)) + "/Documents";
        }
        return PathUtils.getAbsolutePath(Utils.getApp().getExternalFilesDir(Environment.DIRECTORY_DOCUMENTS));
    }

    public static String getExternalAppObbPath() {
        if (!UtilsBridge.isSDCardEnableByEnvironment()) {
            return "";
        }
        return PathUtils.getAbsolutePath(Utils.getApp().getObbDir());
    }

    public static String getRootPathExternalFirst() {
        String rootPath = PathUtils.getExternalStoragePath();
        if (TextUtils.isEmpty((CharSequence)rootPath)) {
            rootPath = PathUtils.getRootPath();
        }
        return rootPath;
    }

    public static String getAppDataPathExternalFirst() {
        String appDataPath = PathUtils.getExternalAppDataPath();
        if (TextUtils.isEmpty((CharSequence)appDataPath)) {
            appDataPath = PathUtils.getInternalAppDataPath();
        }
        return appDataPath;
    }

    public static String getFilesPathExternalFirst() {
        String filePath = PathUtils.getExternalAppFilesPath();
        if (TextUtils.isEmpty((CharSequence)filePath)) {
            filePath = PathUtils.getInternalAppFilesPath();
        }
        return filePath;
    }

    public static String getCachePathExternalFirst() {
        String appPath = PathUtils.getExternalAppCachePath();
        if (TextUtils.isEmpty((CharSequence)appPath)) {
            appPath = PathUtils.getInternalAppCachePath();
        }
        return appPath;
    }

    private static String getAbsolutePath(File file) {
        if (file == null) {
            return "";
        }
        return file.getAbsolutePath();
    }
}

