/*
 * Decompiled with CFR 0.152.
 */
package com.blankj.utilcode.util;

import android.graphics.drawable.Drawable;
import android.os.Build;
import android.os.Bundle;
import android.util.Log;
import android.view.View;
import androidx.annotation.AnimRes;
import androidx.annotation.AnimatorRes;
import androidx.annotation.ColorInt;
import androidx.annotation.DrawableRes;
import androidx.annotation.IdRes;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.fragment.app.Fragment;
import androidx.fragment.app.FragmentManager;
import androidx.fragment.app.FragmentTransaction;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public final class FragmentUtils {
    private static final int TYPE_ADD_FRAGMENT = 1;
    private static final int TYPE_SHOW_FRAGMENT = 2;
    private static final int TYPE_HIDE_FRAGMENT = 4;
    private static final int TYPE_SHOW_HIDE_FRAGMENT = 8;
    private static final int TYPE_REPLACE_FRAGMENT = 16;
    private static final int TYPE_REMOVE_FRAGMENT = 32;
    private static final int TYPE_REMOVE_TO_FRAGMENT = 64;
    private static final String ARGS_ID = "args_id";
    private static final String ARGS_IS_HIDE = "args_is_hide";
    private static final String ARGS_IS_ADD_STACK = "args_is_add_stack";
    private static final String ARGS_TAG = "args_tag";

    private FragmentUtils() {
        throw new UnsupportedOperationException("u can't instantiate me...");
    }

    public static void add(@NonNull FragmentManager fm, @NonNull Fragment add, @IdRes int containerId) {
        if (fm == null) {
            throw new NullPointerException("Argument 'fm' of type FragmentManager (#0 out of 3, zero-based) is marked by @androidx.annotation.NonNull but got null for it");
        }
        if (add == null) {
            throw new NullPointerException("Argument 'add' of type Fragment (#1 out of 3, zero-based) is marked by @androidx.annotation.NonNull but got null for it");
        }
        FragmentUtils.add(fm, add, containerId, null, false, false);
    }

    public static void add(@NonNull FragmentManager fm, @NonNull Fragment add, @IdRes int containerId, boolean isHide) {
        if (fm == null) {
            throw new NullPointerException("Argument 'fm' of type FragmentManager (#0 out of 4, zero-based) is marked by @androidx.annotation.NonNull but got null for it");
        }
        if (add == null) {
            throw new NullPointerException("Argument 'add' of type Fragment (#1 out of 4, zero-based) is marked by @androidx.annotation.NonNull but got null for it");
        }
        FragmentUtils.add(fm, add, containerId, null, isHide, false);
    }

    public static void add(@NonNull FragmentManager fm, @NonNull Fragment add, @IdRes int containerId, boolean isHide, boolean isAddStack) {
        if (fm == null) {
            throw new NullPointerException("Argument 'fm' of type FragmentManager (#0 out of 5, zero-based) is marked by @androidx.annotation.NonNull but got null for it");
        }
        if (add == null) {
            throw new NullPointerException("Argument 'add' of type Fragment (#1 out of 5, zero-based) is marked by @androidx.annotation.NonNull but got null for it");
        }
        FragmentUtils.add(fm, add, containerId, null, isHide, isAddStack);
    }

    public static void add(@NonNull FragmentManager fm, @NonNull Fragment add, @IdRes int containerId, @AnimatorRes @AnimRes int enterAnim, @AnimatorRes @AnimRes int exitAnim) {
        if (fm == null) {
            throw new NullPointerException("Argument 'fm' of type FragmentManager (#0 out of 5, zero-based) is marked by @androidx.annotation.NonNull but got null for it");
        }
        if (add == null) {
            throw new NullPointerException("Argument 'add' of type Fragment (#1 out of 5, zero-based) is marked by @androidx.annotation.NonNull but got null for it");
        }
        FragmentUtils.add(fm, add, containerId, null, false, enterAnim, exitAnim, 0, 0);
    }

    public static void add(@NonNull FragmentManager fm, @NonNull Fragment add, @IdRes int containerId, boolean isAddStack, @AnimatorRes @AnimRes int enterAnim, @AnimatorRes @AnimRes int exitAnim) {
        if (fm == null) {
            throw new NullPointerException("Argument 'fm' of type FragmentManager (#0 out of 6, zero-based) is marked by @androidx.annotation.NonNull but got null for it");
        }
        if (add == null) {
            throw new NullPointerException("Argument 'add' of type Fragment (#1 out of 6, zero-based) is marked by @androidx.annotation.NonNull but got null for it");
        }
        FragmentUtils.add(fm, add, containerId, null, isAddStack, enterAnim, exitAnim, 0, 0);
    }

    public static void add(@NonNull FragmentManager fm, @NonNull Fragment add, @IdRes int containerId, @AnimatorRes @AnimRes int enterAnim, @AnimatorRes @AnimRes int exitAnim, @AnimatorRes @AnimRes int popEnterAnim, @AnimatorRes @AnimRes int popExitAnim) {
        if (fm == null) {
            throw new NullPointerException("Argument 'fm' of type FragmentManager (#0 out of 7, zero-based) is marked by @androidx.annotation.NonNull but got null for it");
        }
        if (add == null) {
            throw new NullPointerException("Argument 'add' of type Fragment (#1 out of 7, zero-based) is marked by @androidx.annotation.NonNull but got null for it");
        }
        FragmentUtils.add(fm, add, containerId, null, false, enterAnim, exitAnim, popEnterAnim, popExitAnim);
    }

    public static void add(@NonNull FragmentManager fm, @NonNull Fragment add, @IdRes int containerId, boolean isAddStack, @AnimatorRes @AnimRes int enterAnim, @AnimatorRes @AnimRes int exitAnim, @AnimatorRes @AnimRes int popEnterAnim, @AnimatorRes @AnimRes int popExitAnim) {
        if (fm == null) {
            throw new NullPointerException("Argument 'fm' of type FragmentManager (#0 out of 8, zero-based) is marked by @androidx.annotation.NonNull but got null for it");
        }
        if (add == null) {
            throw new NullPointerException("Argument 'add' of type Fragment (#1 out of 8, zero-based) is marked by @androidx.annotation.NonNull but got null for it");
        }
        FragmentUtils.add(fm, add, containerId, null, isAddStack, enterAnim, exitAnim, popEnterAnim, popExitAnim);
    }

    public static void add(@NonNull FragmentManager fm, @NonNull Fragment add, @IdRes int containerId, View ... sharedElements) {
        if (fm == null) {
            throw new NullPointerException("Argument 'fm' of type FragmentManager (#0 out of 4, zero-based) is marked by @androidx.annotation.NonNull but got null for it");
        }
        if (add == null) {
            throw new NullPointerException("Argument 'add' of type Fragment (#1 out of 4, zero-based) is marked by @androidx.annotation.NonNull but got null for it");
        }
        if (sharedElements == null) {
            throw new NullPointerException("Argument 'sharedElements' of type View[] (#3 out of 4, zero-based) is marked by @androidx.annotation.NonNull but got null for it");
        }
        FragmentUtils.add(fm, add, containerId, null, false, sharedElements);
    }

    public static void add(@NonNull FragmentManager fm, @NonNull Fragment add, @IdRes int containerId, boolean isAddStack, View ... sharedElements) {
        if (fm == null) {
            throw new NullPointerException("Argument 'fm' of type FragmentManager (#0 out of 5, zero-based) is marked by @androidx.annotation.NonNull but got null for it");
        }
        if (add == null) {
            throw new NullPointerException("Argument 'add' of type Fragment (#1 out of 5, zero-based) is marked by @androidx.annotation.NonNull but got null for it");
        }
        if (sharedElements == null) {
            throw new NullPointerException("Argument 'sharedElements' of type View[] (#4 out of 5, zero-based) is marked by @androidx.annotation.NonNull but got null for it");
        }
        FragmentUtils.add(fm, add, containerId, null, isAddStack, sharedElements);
    }

    public static void add(@NonNull FragmentManager fm, @NonNull List<Fragment> adds, @IdRes int containerId, int showIndex) {
        if (fm == null) {
            throw new NullPointerException("Argument 'fm' of type FragmentManager (#0 out of 4, zero-based) is marked by @androidx.annotation.NonNull but got null for it");
        }
        if (adds == null) {
            throw new NullPointerException("Argument 'adds' of type List<Fragment> (#1 out of 4, zero-based) is marked by @androidx.annotation.NonNull but got null for it");
        }
        FragmentUtils.add(fm, adds.toArray(new Fragment[0]), containerId, null, showIndex);
    }

    public static void add(@NonNull FragmentManager fm, @NonNull Fragment[] adds, @IdRes int containerId, int showIndex) {
        if (fm == null) {
            throw new NullPointerException("Argument 'fm' of type FragmentManager (#0 out of 4, zero-based) is marked by @androidx.annotation.NonNull but got null for it");
        }
        if (adds == null) {
            throw new NullPointerException("Argument 'adds' of type Fragment[] (#1 out of 4, zero-based) is marked by @androidx.annotation.NonNull but got null for it");
        }
        FragmentUtils.add(fm, adds, containerId, null, showIndex);
    }

    public static void add(@NonNull FragmentManager fm, @NonNull Fragment add, @IdRes int containerId, String tag) {
        if (fm == null) {
            throw new NullPointerException("Argument 'fm' of type FragmentManager (#0 out of 4, zero-based) is marked by @androidx.annotation.NonNull but got null for it");
        }
        if (add == null) {
            throw new NullPointerException("Argument 'add' of type Fragment (#1 out of 4, zero-based) is marked by @androidx.annotation.NonNull but got null for it");
        }
        FragmentUtils.add(fm, add, containerId, tag, false, false);
    }

    public static void add(@NonNull FragmentManager fm, @NonNull Fragment add, @IdRes int containerId, String tag, boolean isHide) {
        if (fm == null) {
            throw new NullPointerException("Argument 'fm' of type FragmentManager (#0 out of 5, zero-based) is marked by @androidx.annotation.NonNull but got null for it");
        }
        if (add == null) {
            throw new NullPointerException("Argument 'add' of type Fragment (#1 out of 5, zero-based) is marked by @androidx.annotation.NonNull but got null for it");
        }
        FragmentUtils.add(fm, add, containerId, tag, isHide, false);
    }

    public static void add(@NonNull FragmentManager fm, @NonNull Fragment add, @IdRes int containerId, String tag, boolean isHide, boolean isAddStack) {
        if (fm == null) {
            throw new NullPointerException("Argument 'fm' of type FragmentManager (#0 out of 6, zero-based) is marked by @androidx.annotation.NonNull but got null for it");
        }
        if (add == null) {
            throw new NullPointerException("Argument 'add' of type Fragment (#1 out of 6, zero-based) is marked by @androidx.annotation.NonNull but got null for it");
        }
        FragmentUtils.putArgs(add, new Args(containerId, tag, isHide, isAddStack));
        FragmentUtils.operateNoAnim(fm, 1, null, add);
    }

    public static void add(@NonNull FragmentManager fm, @NonNull Fragment add, @IdRes int containerId, String tag, @AnimatorRes @AnimRes int enterAnim, @AnimatorRes @AnimRes int exitAnim) {
        if (fm == null) {
            throw new NullPointerException("Argument 'fm' of type FragmentManager (#0 out of 6, zero-based) is marked by @androidx.annotation.NonNull but got null for it");
        }
        if (add == null) {
            throw new NullPointerException("Argument 'add' of type Fragment (#1 out of 6, zero-based) is marked by @androidx.annotation.NonNull but got null for it");
        }
        FragmentUtils.add(fm, add, containerId, tag, false, enterAnim, exitAnim, 0, 0);
    }

    public static void add(@NonNull FragmentManager fm, @NonNull Fragment add, @IdRes int containerId, String tag, boolean isAddStack, @AnimatorRes @AnimRes int enterAnim, @AnimatorRes @AnimRes int exitAnim) {
        if (fm == null) {
            throw new NullPointerException("Argument 'fm' of type FragmentManager (#0 out of 7, zero-based) is marked by @androidx.annotation.NonNull but got null for it");
        }
        if (add == null) {
            throw new NullPointerException("Argument 'add' of type Fragment (#1 out of 7, zero-based) is marked by @androidx.annotation.NonNull but got null for it");
        }
        FragmentUtils.add(fm, add, containerId, tag, isAddStack, enterAnim, exitAnim, 0, 0);
    }

    public static void add(@NonNull FragmentManager fm, @NonNull Fragment add, @IdRes int containerId, String tag, @AnimatorRes @AnimRes int enterAnim, @AnimatorRes @AnimRes int exitAnim, @AnimatorRes @AnimRes int popEnterAnim, @AnimatorRes @AnimRes int popExitAnim) {
        if (fm == null) {
            throw new NullPointerException("Argument 'fm' of type FragmentManager (#0 out of 8, zero-based) is marked by @androidx.annotation.NonNull but got null for it");
        }
        if (add == null) {
            throw new NullPointerException("Argument 'add' of type Fragment (#1 out of 8, zero-based) is marked by @androidx.annotation.NonNull but got null for it");
        }
        FragmentUtils.add(fm, add, containerId, tag, false, enterAnim, exitAnim, popEnterAnim, popExitAnim);
    }

    public static void add(@NonNull FragmentManager fm, @NonNull Fragment add, @IdRes int containerId, String tag, boolean isAddStack, @AnimatorRes @AnimRes int enterAnim, @AnimatorRes @AnimRes int exitAnim, @AnimatorRes @AnimRes int popEnterAnim, @AnimatorRes @AnimRes int popExitAnim) {
        if (fm == null) {
            throw new NullPointerException("Argument 'fm' of type FragmentManager (#0 out of 9, zero-based) is marked by @androidx.annotation.NonNull but got null for it");
        }
        if (add == null) {
            throw new NullPointerException("Argument 'add' of type Fragment (#1 out of 9, zero-based) is marked by @androidx.annotation.NonNull but got null for it");
        }
        FragmentTransaction ft = fm.beginTransaction();
        FragmentUtils.putArgs(add, new Args(containerId, tag, false, isAddStack));
        FragmentUtils.addAnim(ft, enterAnim, exitAnim, popEnterAnim, popExitAnim);
        FragmentUtils.operate(1, fm, ft, null, add);
    }

    public static void add(@NonNull FragmentManager fm, @NonNull Fragment add, @IdRes int containerId, String tag, View ... sharedElements) {
        if (fm == null) {
            throw new NullPointerException("Argument 'fm' of type FragmentManager (#0 out of 5, zero-based) is marked by @androidx.annotation.NonNull but got null for it");
        }
        if (add == null) {
            throw new NullPointerException("Argument 'add' of type Fragment (#1 out of 5, zero-based) is marked by @androidx.annotation.NonNull but got null for it");
        }
        if (sharedElements == null) {
            throw new NullPointerException("Argument 'sharedElements' of type View[] (#4 out of 5, zero-based) is marked by @androidx.annotation.NonNull but got null for it");
        }
        FragmentUtils.add(fm, add, containerId, tag, false, sharedElements);
    }

    public static void add(@NonNull FragmentManager fm, @NonNull Fragment add, @IdRes int containerId, String tag, boolean isAddStack, View ... sharedElements) {
        if (fm == null) {
            throw new NullPointerException("Argument 'fm' of type FragmentManager (#0 out of 6, zero-based) is marked by @androidx.annotation.NonNull but got null for it");
        }
        if (add == null) {
            throw new NullPointerException("Argument 'add' of type Fragment (#1 out of 6, zero-based) is marked by @androidx.annotation.NonNull but got null for it");
        }
        if (sharedElements == null) {
            throw new NullPointerException("Argument 'sharedElements' of type View[] (#5 out of 6, zero-based) is marked by @androidx.annotation.NonNull but got null for it");
        }
        FragmentTransaction ft = fm.beginTransaction();
        FragmentUtils.putArgs(add, new Args(containerId, tag, false, isAddStack));
        FragmentUtils.addSharedElement(ft, sharedElements);
        FragmentUtils.operate(1, fm, ft, null, add);
    }

    public static void add(@NonNull FragmentManager fm, @NonNull List<Fragment> adds, @IdRes int containerId, String[] tags, int showIndex) {
        if (fm == null) {
            throw new NullPointerException("Argument 'fm' of type FragmentManager (#0 out of 5, zero-based) is marked by @androidx.annotation.NonNull but got null for it");
        }
        if (adds == null) {
            throw new NullPointerException("Argument 'adds' of type List<Fragment> (#1 out of 5, zero-based) is marked by @androidx.annotation.NonNull but got null for it");
        }
        FragmentUtils.add(fm, adds.toArray(new Fragment[0]), containerId, tags, showIndex);
    }

    public static void add(@NonNull FragmentManager fm, @NonNull Fragment[] adds, @IdRes int containerId, String[] tags, int showIndex) {
        if (fm == null) {
            throw new NullPointerException("Argument 'fm' of type FragmentManager (#0 out of 5, zero-based) is marked by @androidx.annotation.NonNull but got null for it");
        }
        if (adds == null) {
            throw new NullPointerException("Argument 'adds' of type Fragment[] (#1 out of 5, zero-based) is marked by @androidx.annotation.NonNull but got null for it");
        }
        if (tags == null) {
            int len = adds.length;
            for (int i = 0; i < len; ++i) {
                FragmentUtils.putArgs(adds[i], new Args(containerId, null, showIndex != i, false));
            }
        } else {
            int len = adds.length;
            for (int i = 0; i < len; ++i) {
                FragmentUtils.putArgs(adds[i], new Args(containerId, tags[i], showIndex != i, false));
            }
        }
        FragmentUtils.operateNoAnim(fm, 1, null, adds);
    }

    public static void show(@NonNull Fragment show) {
        if (show == null) {
            throw new NullPointerException("Argument 'show' of type Fragment (#0 out of 1, zero-based) is marked by @androidx.annotation.NonNull but got null for it");
        }
        FragmentUtils.putArgs(show, false);
        FragmentUtils.operateNoAnim(show.getFragmentManager(), 2, null, show);
    }

    public static void show(@NonNull FragmentManager fm) {
        if (fm == null) {
            throw new NullPointerException("Argument 'fm' of type FragmentManager (#0 out of 1, zero-based) is marked by @androidx.annotation.NonNull but got null for it");
        }
        List<Fragment> fragments = FragmentUtils.getFragments(fm);
        for (Fragment show : fragments) {
            FragmentUtils.putArgs(show, false);
        }
        FragmentUtils.operateNoAnim(fm, 2, null, fragments.toArray(new Fragment[0]));
    }

    public static void hide(@NonNull Fragment hide) {
        if (hide == null) {
            throw new NullPointerException("Argument 'hide' of type Fragment (#0 out of 1, zero-based) is marked by @androidx.annotation.NonNull but got null for it");
        }
        FragmentUtils.putArgs(hide, true);
        FragmentUtils.operateNoAnim(hide.getFragmentManager(), 4, null, hide);
    }

    public static void hide(@NonNull FragmentManager fm) {
        if (fm == null) {
            throw new NullPointerException("Argument 'fm' of type FragmentManager (#0 out of 1, zero-based) is marked by @androidx.annotation.NonNull but got null for it");
        }
        List<Fragment> fragments = FragmentUtils.getFragments(fm);
        for (Fragment hide : fragments) {
            FragmentUtils.putArgs(hide, true);
        }
        FragmentUtils.operateNoAnim(fm, 4, null, fragments.toArray(new Fragment[0]));
    }

    public static void showHide(int showIndex, @NonNull List<Fragment> fragments) {
        if (fragments == null) {
            throw new NullPointerException("Argument 'fragments' of type List<Fragment> (#1 out of 2, zero-based) is marked by @androidx.annotation.NonNull but got null for it");
        }
        FragmentUtils.showHide(fragments.get(showIndex), fragments);
    }

    public static void showHide(@NonNull Fragment show, @NonNull List<Fragment> hide) {
        if (show == null) {
            throw new NullPointerException("Argument 'show' of type Fragment (#0 out of 2, zero-based) is marked by @androidx.annotation.NonNull but got null for it");
        }
        if (hide == null) {
            throw new NullPointerException("Argument 'hide' of type List<Fragment> (#1 out of 2, zero-based) is marked by @androidx.annotation.NonNull but got null for it");
        }
        for (Fragment fragment : hide) {
            FragmentUtils.putArgs(fragment, fragment != show);
        }
        FragmentUtils.operateNoAnim(show.getFragmentManager(), 8, show, hide.toArray(new Fragment[0]));
    }

    public static void showHide(int showIndex, Fragment ... fragments) {
        if (fragments == null) {
            throw new NullPointerException("Argument 'fragments' of type Fragment[] (#1 out of 2, zero-based) is marked by @androidx.annotation.NonNull but got null for it");
        }
        FragmentUtils.showHide(fragments[showIndex], fragments);
    }

    public static void showHide(@NonNull Fragment show, Fragment ... hide) {
        if (show == null) {
            throw new NullPointerException("Argument 'show' of type Fragment (#0 out of 2, zero-based) is marked by @androidx.annotation.NonNull but got null for it");
        }
        if (hide == null) {
            throw new NullPointerException("Argument 'hide' of type Fragment[] (#1 out of 2, zero-based) is marked by @androidx.annotation.NonNull but got null for it");
        }
        for (Fragment fragment : hide) {
            FragmentUtils.putArgs(fragment, fragment != show);
        }
        FragmentUtils.operateNoAnim(show.getFragmentManager(), 8, show, hide);
    }

    public static void showHide(@NonNull Fragment show, @NonNull Fragment hide) {
        if (show == null) {
            throw new NullPointerException("Argument 'show' of type Fragment (#0 out of 2, zero-based) is marked by @androidx.annotation.NonNull but got null for it");
        }
        if (hide == null) {
            throw new NullPointerException("Argument 'hide' of type Fragment (#1 out of 2, zero-based) is marked by @androidx.annotation.NonNull but got null for it");
        }
        FragmentUtils.putArgs(show, false);
        FragmentUtils.putArgs(hide, true);
        FragmentUtils.operateNoAnim(show.getFragmentManager(), 8, show, hide);
    }

    public static void replace(@NonNull Fragment srcFragment, @NonNull Fragment destFragment) {
        if (srcFragment == null) {
            throw new NullPointerException("Argument 'srcFragment' of type Fragment (#0 out of 2, zero-based) is marked by @androidx.annotation.NonNull but got null for it");
        }
        if (destFragment == null) {
            throw new NullPointerException("Argument 'destFragment' of type Fragment (#1 out of 2, zero-based) is marked by @androidx.annotation.NonNull but got null for it");
        }
        FragmentUtils.replace(srcFragment, destFragment, null, false);
    }

    public static void replace(@NonNull Fragment srcFragment, @NonNull Fragment destFragment, boolean isAddStack) {
        if (srcFragment == null) {
            throw new NullPointerException("Argument 'srcFragment' of type Fragment (#0 out of 3, zero-based) is marked by @androidx.annotation.NonNull but got null for it");
        }
        if (destFragment == null) {
            throw new NullPointerException("Argument 'destFragment' of type Fragment (#1 out of 3, zero-based) is marked by @androidx.annotation.NonNull but got null for it");
        }
        FragmentUtils.replace(srcFragment, destFragment, null, isAddStack);
    }

    public static void replace(@NonNull Fragment srcFragment, @NonNull Fragment destFragment, @AnimatorRes @AnimRes int enterAnim, @AnimatorRes @AnimRes int exitAnim) {
        if (srcFragment == null) {
            throw new NullPointerException("Argument 'srcFragment' of type Fragment (#0 out of 4, zero-based) is marked by @androidx.annotation.NonNull but got null for it");
        }
        if (destFragment == null) {
            throw new NullPointerException("Argument 'destFragment' of type Fragment (#1 out of 4, zero-based) is marked by @androidx.annotation.NonNull but got null for it");
        }
        FragmentUtils.replace(srcFragment, destFragment, null, false, enterAnim, exitAnim, 0, 0);
    }

    public static void replace(@NonNull Fragment srcFragment, @NonNull Fragment destFragment, boolean isAddStack, @AnimatorRes @AnimRes int enterAnim, @AnimatorRes @AnimRes int exitAnim) {
        if (srcFragment == null) {
            throw new NullPointerException("Argument 'srcFragment' of type Fragment (#0 out of 5, zero-based) is marked by @androidx.annotation.NonNull but got null for it");
        }
        if (destFragment == null) {
            throw new NullPointerException("Argument 'destFragment' of type Fragment (#1 out of 5, zero-based) is marked by @androidx.annotation.NonNull but got null for it");
        }
        FragmentUtils.replace(srcFragment, destFragment, null, isAddStack, enterAnim, exitAnim, 0, 0);
    }

    public static void replace(@NonNull Fragment srcFragment, @NonNull Fragment destFragment, @AnimatorRes @AnimRes int enterAnim, @AnimatorRes @AnimRes int exitAnim, @AnimatorRes @AnimRes int popEnterAnim, @AnimatorRes @AnimRes int popExitAnim) {
        if (srcFragment == null) {
            throw new NullPointerException("Argument 'srcFragment' of type Fragment (#0 out of 6, zero-based) is marked by @androidx.annotation.NonNull but got null for it");
        }
        if (destFragment == null) {
            throw new NullPointerException("Argument 'destFragment' of type Fragment (#1 out of 6, zero-based) is marked by @androidx.annotation.NonNull but got null for it");
        }
        FragmentUtils.replace(srcFragment, destFragment, null, false, enterAnim, exitAnim, popEnterAnim, popExitAnim);
    }

    public static void replace(@NonNull Fragment srcFragment, @NonNull Fragment destFragment, boolean isAddStack, @AnimatorRes @AnimRes int enterAnim, @AnimatorRes @AnimRes int exitAnim, @AnimatorRes @AnimRes int popEnterAnim, @AnimatorRes @AnimRes int popExitAnim) {
        if (srcFragment == null) {
            throw new NullPointerException("Argument 'srcFragment' of type Fragment (#0 out of 7, zero-based) is marked by @androidx.annotation.NonNull but got null for it");
        }
        if (destFragment == null) {
            throw new NullPointerException("Argument 'destFragment' of type Fragment (#1 out of 7, zero-based) is marked by @androidx.annotation.NonNull but got null for it");
        }
        FragmentUtils.replace(srcFragment, destFragment, null, isAddStack, enterAnim, exitAnim, popEnterAnim, popExitAnim);
    }

    public static void replace(@NonNull Fragment srcFragment, @NonNull Fragment destFragment, View ... sharedElements) {
        if (srcFragment == null) {
            throw new NullPointerException("Argument 'srcFragment' of type Fragment (#0 out of 3, zero-based) is marked by @androidx.annotation.NonNull but got null for it");
        }
        if (destFragment == null) {
            throw new NullPointerException("Argument 'destFragment' of type Fragment (#1 out of 3, zero-based) is marked by @androidx.annotation.NonNull but got null for it");
        }
        FragmentUtils.replace(srcFragment, destFragment, null, false, sharedElements);
    }

    public static void replace(@NonNull Fragment srcFragment, @NonNull Fragment destFragment, boolean isAddStack, View ... sharedElements) {
        if (srcFragment == null) {
            throw new NullPointerException("Argument 'srcFragment' of type Fragment (#0 out of 4, zero-based) is marked by @androidx.annotation.NonNull but got null for it");
        }
        if (destFragment == null) {
            throw new NullPointerException("Argument 'destFragment' of type Fragment (#1 out of 4, zero-based) is marked by @androidx.annotation.NonNull but got null for it");
        }
        FragmentUtils.replace(srcFragment, destFragment, null, isAddStack, sharedElements);
    }

    public static void replace(@NonNull FragmentManager fm, @NonNull Fragment fragment, @IdRes int containerId) {
        if (fm == null) {
            throw new NullPointerException("Argument 'fm' of type FragmentManager (#0 out of 3, zero-based) is marked by @androidx.annotation.NonNull but got null for it");
        }
        if (fragment == null) {
            throw new NullPointerException("Argument 'fragment' of type Fragment (#1 out of 3, zero-based) is marked by @androidx.annotation.NonNull but got null for it");
        }
        FragmentUtils.replace(fm, fragment, containerId, null, false);
    }

    public static void replace(@NonNull FragmentManager fm, @NonNull Fragment fragment, @IdRes int containerId, boolean isAddStack) {
        if (fm == null) {
            throw new NullPointerException("Argument 'fm' of type FragmentManager (#0 out of 4, zero-based) is marked by @androidx.annotation.NonNull but got null for it");
        }
        if (fragment == null) {
            throw new NullPointerException("Argument 'fragment' of type Fragment (#1 out of 4, zero-based) is marked by @androidx.annotation.NonNull but got null for it");
        }
        FragmentUtils.replace(fm, fragment, containerId, null, isAddStack);
    }

    public static void replace(@NonNull FragmentManager fm, @NonNull Fragment fragment, @IdRes int containerId, @AnimatorRes @AnimRes int enterAnim, @AnimatorRes @AnimRes int exitAnim) {
        if (fm == null) {
            throw new NullPointerException("Argument 'fm' of type FragmentManager (#0 out of 5, zero-based) is marked by @androidx.annotation.NonNull but got null for it");
        }
        if (fragment == null) {
            throw new NullPointerException("Argument 'fragment' of type Fragment (#1 out of 5, zero-based) is marked by @androidx.annotation.NonNull but got null for it");
        }
        FragmentUtils.replace(fm, fragment, containerId, null, false, enterAnim, exitAnim, 0, 0);
    }

    public static void replace(@NonNull FragmentManager fm, @NonNull Fragment fragment, @IdRes int containerId, boolean isAddStack, @AnimatorRes @AnimRes int enterAnim, @AnimatorRes @AnimRes int exitAnim) {
        if (fm == null) {
            throw new NullPointerException("Argument 'fm' of type FragmentManager (#0 out of 6, zero-based) is marked by @androidx.annotation.NonNull but got null for it");
        }
        if (fragment == null) {
            throw new NullPointerException("Argument 'fragment' of type Fragment (#1 out of 6, zero-based) is marked by @androidx.annotation.NonNull but got null for it");
        }
        FragmentUtils.replace(fm, fragment, containerId, null, isAddStack, enterAnim, exitAnim, 0, 0);
    }

    public static void replace(@NonNull FragmentManager fm, @NonNull Fragment fragment, @IdRes int containerId, @AnimatorRes @AnimRes int enterAnim, @AnimatorRes @AnimRes int exitAnim, @AnimatorRes @AnimRes int popEnterAnim, @AnimatorRes @AnimRes int popExitAnim) {
        if (fm == null) {
            throw new NullPointerException("Argument 'fm' of type FragmentManager (#0 out of 7, zero-based) is marked by @androidx.annotation.NonNull but got null for it");
        }
        if (fragment == null) {
            throw new NullPointerException("Argument 'fragment' of type Fragment (#1 out of 7, zero-based) is marked by @androidx.annotation.NonNull but got null for it");
        }
        FragmentUtils.replace(fm, fragment, containerId, null, false, enterAnim, exitAnim, popEnterAnim, popExitAnim);
    }

    public static void replace(@NonNull FragmentManager fm, @NonNull Fragment fragment, @IdRes int containerId, boolean isAddStack, @AnimatorRes @AnimRes int enterAnim, @AnimatorRes @AnimRes int exitAnim, @AnimatorRes @AnimRes int popEnterAnim, @AnimatorRes @AnimRes int popExitAnim) {
        if (fm == null) {
            throw new NullPointerException("Argument 'fm' of type FragmentManager (#0 out of 8, zero-based) is marked by @androidx.annotation.NonNull but got null for it");
        }
        if (fragment == null) {
            throw new NullPointerException("Argument 'fragment' of type Fragment (#1 out of 8, zero-based) is marked by @androidx.annotation.NonNull but got null for it");
        }
        FragmentUtils.replace(fm, fragment, containerId, null, isAddStack, enterAnim, exitAnim, popEnterAnim, popExitAnim);
    }

    public static void replace(@NonNull FragmentManager fm, @NonNull Fragment fragment, @IdRes int containerId, View ... sharedElements) {
        if (fm == null) {
            throw new NullPointerException("Argument 'fm' of type FragmentManager (#0 out of 4, zero-based) is marked by @androidx.annotation.NonNull but got null for it");
        }
        if (fragment == null) {
            throw new NullPointerException("Argument 'fragment' of type Fragment (#1 out of 4, zero-based) is marked by @androidx.annotation.NonNull but got null for it");
        }
        FragmentUtils.replace(fm, fragment, containerId, null, false, sharedElements);
    }

    public static void replace(@NonNull FragmentManager fm, @NonNull Fragment fragment, @IdRes int containerId, boolean isAddStack, View ... sharedElements) {
        if (fm == null) {
            throw new NullPointerException("Argument 'fm' of type FragmentManager (#0 out of 5, zero-based) is marked by @androidx.annotation.NonNull but got null for it");
        }
        if (fragment == null) {
            throw new NullPointerException("Argument 'fragment' of type Fragment (#1 out of 5, zero-based) is marked by @androidx.annotation.NonNull but got null for it");
        }
        FragmentUtils.replace(fm, fragment, containerId, null, isAddStack, sharedElements);
    }

    public static void replace(@NonNull Fragment srcFragment, @NonNull Fragment destFragment, String destTag) {
        if (srcFragment == null) {
            throw new NullPointerException("Argument 'srcFragment' of type Fragment (#0 out of 3, zero-based) is marked by @androidx.annotation.NonNull but got null for it");
        }
        if (destFragment == null) {
            throw new NullPointerException("Argument 'destFragment' of type Fragment (#1 out of 3, zero-based) is marked by @androidx.annotation.NonNull but got null for it");
        }
        FragmentUtils.replace(srcFragment, destFragment, destTag, false);
    }

    public static void replace(@NonNull Fragment srcFragment, @NonNull Fragment destFragment, String destTag, boolean isAddStack) {
        if (srcFragment == null) {
            throw new NullPointerException("Argument 'srcFragment' of type Fragment (#0 out of 4, zero-based) is marked by @androidx.annotation.NonNull but got null for it");
        }
        if (destFragment == null) {
            throw new NullPointerException("Argument 'destFragment' of type Fragment (#1 out of 4, zero-based) is marked by @androidx.annotation.NonNull but got null for it");
        }
        FragmentManager fm = srcFragment.getFragmentManager();
        if (fm == null) {
            return;
        }
        Args args = FragmentUtils.getArgs(srcFragment);
        FragmentUtils.replace(fm, destFragment, args.id, destTag, isAddStack);
    }

    public static void replace(@NonNull Fragment srcFragment, @NonNull Fragment destFragment, String destTag, @AnimatorRes @AnimRes int enterAnim, @AnimatorRes @AnimRes int exitAnim) {
        if (srcFragment == null) {
            throw new NullPointerException("Argument 'srcFragment' of type Fragment (#0 out of 5, zero-based) is marked by @androidx.annotation.NonNull but got null for it");
        }
        if (destFragment == null) {
            throw new NullPointerException("Argument 'destFragment' of type Fragment (#1 out of 5, zero-based) is marked by @androidx.annotation.NonNull but got null for it");
        }
        FragmentUtils.replace(srcFragment, destFragment, destTag, false, enterAnim, exitAnim, 0, 0);
    }

    public static void replace(@NonNull Fragment srcFragment, @NonNull Fragment destFragment, String destTag, boolean isAddStack, @AnimatorRes @AnimRes int enterAnim, @AnimatorRes @AnimRes int exitAnim) {
        if (srcFragment == null) {
            throw new NullPointerException("Argument 'srcFragment' of type Fragment (#0 out of 6, zero-based) is marked by @androidx.annotation.NonNull but got null for it");
        }
        if (destFragment == null) {
            throw new NullPointerException("Argument 'destFragment' of type Fragment (#1 out of 6, zero-based) is marked by @androidx.annotation.NonNull but got null for it");
        }
        FragmentUtils.replace(srcFragment, destFragment, destTag, isAddStack, enterAnim, exitAnim, 0, 0);
    }

    public static void replace(@NonNull Fragment srcFragment, @NonNull Fragment destFragment, String destTag, @AnimatorRes @AnimRes int enterAnim, @AnimatorRes @AnimRes int exitAnim, @AnimatorRes @AnimRes int popEnterAnim, @AnimatorRes @AnimRes int popExitAnim) {
        if (srcFragment == null) {
            throw new NullPointerException("Argument 'srcFragment' of type Fragment (#0 out of 7, zero-based) is marked by @androidx.annotation.NonNull but got null for it");
        }
        if (destFragment == null) {
            throw new NullPointerException("Argument 'destFragment' of type Fragment (#1 out of 7, zero-based) is marked by @androidx.annotation.NonNull but got null for it");
        }
        FragmentUtils.replace(srcFragment, destFragment, destTag, false, enterAnim, exitAnim, popEnterAnim, popExitAnim);
    }

    public static void replace(@NonNull Fragment srcFragment, @NonNull Fragment destFragment, String destTag, boolean isAddStack, @AnimatorRes @AnimRes int enterAnim, @AnimatorRes @AnimRes int exitAnim, @AnimatorRes @AnimRes int popEnterAnim, @AnimatorRes @AnimRes int popExitAnim) {
        if (srcFragment == null) {
            throw new NullPointerException("Argument 'srcFragment' of type Fragment (#0 out of 8, zero-based) is marked by @androidx.annotation.NonNull but got null for it");
        }
        if (destFragment == null) {
            throw new NullPointerException("Argument 'destFragment' of type Fragment (#1 out of 8, zero-based) is marked by @androidx.annotation.NonNull but got null for it");
        }
        FragmentManager fm = srcFragment.getFragmentManager();
        if (fm == null) {
            return;
        }
        Args args = FragmentUtils.getArgs(srcFragment);
        FragmentUtils.replace(fm, destFragment, args.id, destTag, isAddStack, enterAnim, exitAnim, popEnterAnim, popExitAnim);
    }

    public static void replace(@NonNull Fragment srcFragment, @NonNull Fragment destFragment, String destTag, View ... sharedElements) {
        if (srcFragment == null) {
            throw new NullPointerException("Argument 'srcFragment' of type Fragment (#0 out of 4, zero-based) is marked by @androidx.annotation.NonNull but got null for it");
        }
        if (destFragment == null) {
            throw new NullPointerException("Argument 'destFragment' of type Fragment (#1 out of 4, zero-based) is marked by @androidx.annotation.NonNull but got null for it");
        }
        FragmentUtils.replace(srcFragment, destFragment, destTag, false, sharedElements);
    }

    public static void replace(@NonNull Fragment srcFragment, @NonNull Fragment destFragment, String destTag, boolean isAddStack, View ... sharedElements) {
        if (srcFragment == null) {
            throw new NullPointerException("Argument 'srcFragment' of type Fragment (#0 out of 5, zero-based) is marked by @androidx.annotation.NonNull but got null for it");
        }
        if (destFragment == null) {
            throw new NullPointerException("Argument 'destFragment' of type Fragment (#1 out of 5, zero-based) is marked by @androidx.annotation.NonNull but got null for it");
        }
        FragmentManager fm = srcFragment.getFragmentManager();
        if (fm == null) {
            return;
        }
        Args args = FragmentUtils.getArgs(srcFragment);
        FragmentUtils.replace(fm, destFragment, args.id, destTag, isAddStack, sharedElements);
    }

    public static void replace(@NonNull FragmentManager fm, @NonNull Fragment fragment, @IdRes int containerId, String destTag) {
        if (fm == null) {
            throw new NullPointerException("Argument 'fm' of type FragmentManager (#0 out of 4, zero-based) is marked by @androidx.annotation.NonNull but got null for it");
        }
        if (fragment == null) {
            throw new NullPointerException("Argument 'fragment' of type Fragment (#1 out of 4, zero-based) is marked by @androidx.annotation.NonNull but got null for it");
        }
        FragmentUtils.replace(fm, fragment, containerId, destTag, false);
    }

    public static void replace(@NonNull FragmentManager fm, @NonNull Fragment fragment, @IdRes int containerId, String destTag, boolean isAddStack) {
        if (fm == null) {
            throw new NullPointerException("Argument 'fm' of type FragmentManager (#0 out of 5, zero-based) is marked by @androidx.annotation.NonNull but got null for it");
        }
        if (fragment == null) {
            throw new NullPointerException("Argument 'fragment' of type Fragment (#1 out of 5, zero-based) is marked by @androidx.annotation.NonNull but got null for it");
        }
        FragmentTransaction ft = fm.beginTransaction();
        FragmentUtils.putArgs(fragment, new Args(containerId, destTag, false, isAddStack));
        FragmentUtils.operate(16, fm, ft, null, fragment);
    }

    public static void replace(@NonNull FragmentManager fm, @NonNull Fragment fragment, @IdRes int containerId, String destTag, @AnimatorRes @AnimRes int enterAnim, @AnimatorRes @AnimRes int exitAnim) {
        if (fm == null) {
            throw new NullPointerException("Argument 'fm' of type FragmentManager (#0 out of 6, zero-based) is marked by @androidx.annotation.NonNull but got null for it");
        }
        if (fragment == null) {
            throw new NullPointerException("Argument 'fragment' of type Fragment (#1 out of 6, zero-based) is marked by @androidx.annotation.NonNull but got null for it");
        }
        FragmentUtils.replace(fm, fragment, containerId, destTag, false, enterAnim, exitAnim, 0, 0);
    }

    public static void replace(@NonNull FragmentManager fm, @NonNull Fragment fragment, @IdRes int containerId, String destTag, boolean isAddStack, @AnimatorRes @AnimRes int enterAnim, @AnimatorRes @AnimRes int exitAnim) {
        if (fm == null) {
            throw new NullPointerException("Argument 'fm' of type FragmentManager (#0 out of 7, zero-based) is marked by @androidx.annotation.NonNull but got null for it");
        }
        if (fragment == null) {
            throw new NullPointerException("Argument 'fragment' of type Fragment (#1 out of 7, zero-based) is marked by @androidx.annotation.NonNull but got null for it");
        }
        FragmentUtils.replace(fm, fragment, containerId, destTag, isAddStack, enterAnim, exitAnim, 0, 0);
    }

    public static void replace(@NonNull FragmentManager fm, @NonNull Fragment fragment, @IdRes int containerId, String destTag, @AnimatorRes @AnimRes int enterAnim, @AnimatorRes @AnimRes int exitAnim, @AnimatorRes @AnimRes int popEnterAnim, @AnimatorRes @AnimRes int popExitAnim) {
        if (fm == null) {
            throw new NullPointerException("Argument 'fm' of type FragmentManager (#0 out of 8, zero-based) is marked by @androidx.annotation.NonNull but got null for it");
        }
        if (fragment == null) {
            throw new NullPointerException("Argument 'fragment' of type Fragment (#1 out of 8, zero-based) is marked by @androidx.annotation.NonNull but got null for it");
        }
        FragmentUtils.replace(fm, fragment, containerId, destTag, false, enterAnim, exitAnim, popEnterAnim, popExitAnim);
    }

    public static void replace(@NonNull FragmentManager fm, @NonNull Fragment fragment, @IdRes int containerId, String destTag, boolean isAddStack, @AnimatorRes @AnimRes int enterAnim, @AnimatorRes @AnimRes int exitAnim, @AnimatorRes @AnimRes int popEnterAnim, @AnimatorRes @AnimRes int popExitAnim) {
        if (fm == null) {
            throw new NullPointerException("Argument 'fm' of type FragmentManager (#0 out of 9, zero-based) is marked by @androidx.annotation.NonNull but got null for it");
        }
        if (fragment == null) {
            throw new NullPointerException("Argument 'fragment' of type Fragment (#1 out of 9, zero-based) is marked by @androidx.annotation.NonNull but got null for it");
        }
        FragmentTransaction ft = fm.beginTransaction();
        FragmentUtils.putArgs(fragment, new Args(containerId, destTag, false, isAddStack));
        FragmentUtils.addAnim(ft, enterAnim, exitAnim, popEnterAnim, popExitAnim);
        FragmentUtils.operate(16, fm, ft, null, fragment);
    }

    public static void replace(@NonNull FragmentManager fm, @NonNull Fragment fragment, @IdRes int containerId, String destTag, View ... sharedElements) {
        if (fm == null) {
            throw new NullPointerException("Argument 'fm' of type FragmentManager (#0 out of 5, zero-based) is marked by @androidx.annotation.NonNull but got null for it");
        }
        if (fragment == null) {
            throw new NullPointerException("Argument 'fragment' of type Fragment (#1 out of 5, zero-based) is marked by @androidx.annotation.NonNull but got null for it");
        }
        FragmentUtils.replace(fm, fragment, containerId, destTag, false, sharedElements);
    }

    public static void replace(@NonNull FragmentManager fm, @NonNull Fragment fragment, @IdRes int containerId, String destTag, boolean isAddStack, View ... sharedElements) {
        if (fm == null) {
            throw new NullPointerException("Argument 'fm' of type FragmentManager (#0 out of 6, zero-based) is marked by @androidx.annotation.NonNull but got null for it");
        }
        if (fragment == null) {
            throw new NullPointerException("Argument 'fragment' of type Fragment (#1 out of 6, zero-based) is marked by @androidx.annotation.NonNull but got null for it");
        }
        FragmentTransaction ft = fm.beginTransaction();
        FragmentUtils.putArgs(fragment, new Args(containerId, destTag, false, isAddStack));
        FragmentUtils.addSharedElement(ft, sharedElements);
        FragmentUtils.operate(16, fm, ft, null, fragment);
    }

    public static void pop(@NonNull FragmentManager fm) {
        if (fm == null) {
            throw new NullPointerException("Argument 'fm' of type FragmentManager (#0 out of 1, zero-based) is marked by @androidx.annotation.NonNull but got null for it");
        }
        FragmentUtils.pop(fm, true);
    }

    public static void pop(@NonNull FragmentManager fm, boolean isImmediate) {
        if (fm == null) {
            throw new NullPointerException("Argument 'fm' of type FragmentManager (#0 out of 2, zero-based) is marked by @androidx.annotation.NonNull but got null for it");
        }
        if (isImmediate) {
            fm.popBackStackImmediate();
        } else {
            fm.popBackStack();
        }
    }

    public static void popTo(@NonNull FragmentManager fm, Class<? extends Fragment> popClz, boolean isIncludeSelf) {
        if (fm == null) {
            throw new NullPointerException("Argument 'fm' of type FragmentManager (#0 out of 3, zero-based) is marked by @androidx.annotation.NonNull but got null for it");
        }
        FragmentUtils.popTo(fm, popClz, isIncludeSelf, true);
    }

    public static void popTo(@NonNull FragmentManager fm, Class<? extends Fragment> popClz, boolean isIncludeSelf, boolean isImmediate) {
        if (fm == null) {
            throw new NullPointerException("Argument 'fm' of type FragmentManager (#0 out of 4, zero-based) is marked by @androidx.annotation.NonNull but got null for it");
        }
        if (isImmediate) {
            fm.popBackStackImmediate(popClz.getName(), isIncludeSelf ? 1 : 0);
        } else {
            fm.popBackStack(popClz.getName(), isIncludeSelf ? 1 : 0);
        }
    }

    public static void popAll(@NonNull FragmentManager fm) {
        if (fm == null) {
            throw new NullPointerException("Argument 'fm' of type FragmentManager (#0 out of 1, zero-based) is marked by @androidx.annotation.NonNull but got null for it");
        }
        FragmentUtils.popAll(fm, true);
    }

    public static void popAll(@NonNull FragmentManager fm, boolean isImmediate) {
        if (fm == null) {
            throw new NullPointerException("Argument 'fm' of type FragmentManager (#0 out of 2, zero-based) is marked by @androidx.annotation.NonNull but got null for it");
        }
        if (fm.getBackStackEntryCount() > 0) {
            FragmentManager.BackStackEntry entry = fm.getBackStackEntryAt(0);
            if (isImmediate) {
                fm.popBackStackImmediate(entry.getId(), 1);
            } else {
                fm.popBackStack(entry.getId(), 1);
            }
        }
    }

    public static void remove(@NonNull Fragment remove) {
        if (remove == null) {
            throw new NullPointerException("Argument 'remove' of type Fragment (#0 out of 1, zero-based) is marked by @androidx.annotation.NonNull but got null for it");
        }
        FragmentUtils.operateNoAnim(remove.getFragmentManager(), 32, null, remove);
    }

    public static void removeTo(@NonNull Fragment removeTo, boolean isIncludeSelf) {
        if (removeTo == null) {
            throw new NullPointerException("Argument 'removeTo' of type Fragment (#0 out of 2, zero-based) is marked by @androidx.annotation.NonNull but got null for it");
        }
        FragmentUtils.operateNoAnim(removeTo.getFragmentManager(), 64, (Fragment)(isIncludeSelf ? removeTo : null), removeTo);
    }

    public static void removeAll(@NonNull FragmentManager fm) {
        if (fm == null) {
            throw new NullPointerException("Argument 'fm' of type FragmentManager (#0 out of 1, zero-based) is marked by @androidx.annotation.NonNull but got null for it");
        }
        List<Fragment> fragments = FragmentUtils.getFragments(fm);
        FragmentUtils.operateNoAnim(fm, 32, null, fragments.toArray(new Fragment[0]));
    }

    private static void putArgs(Fragment fragment, Args args) {
        Bundle bundle = fragment.getArguments();
        if (bundle == null) {
            bundle = new Bundle();
            fragment.setArguments(bundle);
        }
        bundle.putInt(ARGS_ID, args.id);
        bundle.putBoolean(ARGS_IS_HIDE, args.isHide);
        bundle.putBoolean(ARGS_IS_ADD_STACK, args.isAddStack);
        bundle.putString(ARGS_TAG, args.tag);
    }

    private static void putArgs(Fragment fragment, boolean isHide) {
        Bundle bundle = fragment.getArguments();
        if (bundle == null) {
            bundle = new Bundle();
            fragment.setArguments(bundle);
        }
        bundle.putBoolean(ARGS_IS_HIDE, isHide);
    }

    private static Args getArgs(Fragment fragment) {
        Bundle bundle = fragment.getArguments();
        if (bundle == null) {
            bundle = Bundle.EMPTY;
        }
        return new Args(bundle.getInt(ARGS_ID, fragment.getId()), bundle.getBoolean(ARGS_IS_HIDE), bundle.getBoolean(ARGS_IS_ADD_STACK));
    }

    private static void operateNoAnim(@Nullable FragmentManager fm, int type, Fragment src, Fragment ... dest) {
        if (fm == null) {
            return;
        }
        FragmentTransaction ft = fm.beginTransaction();
        FragmentUtils.operate(type, fm, ft, src, dest);
    }

    private static void operate(int type, @NonNull FragmentManager fm, FragmentTransaction ft, Fragment src, Fragment ... dest) {
        if (fm == null) {
            throw new NullPointerException("Argument 'fm' of type FragmentManager (#1 out of 5, zero-based) is marked by @androidx.annotation.NonNull but got null for it");
        }
        if (src != null && src.isRemoving()) {
            Log.e((String)"FragmentUtils", (String)(src.getClass().getName() + " is isRemoving"));
            return;
        }
        block0 : switch (type) {
            case 1: {
                for (Fragment fragment : dest) {
                    Bundle args = fragment.getArguments();
                    if (args == null) {
                        return;
                    }
                    String name = args.getString(ARGS_TAG, fragment.getClass().getName());
                    Fragment fragmentByTag = fm.findFragmentByTag(name);
                    if (fragmentByTag != null && fragmentByTag.isAdded()) {
                        ft.remove(fragmentByTag);
                    }
                    ft.add(args.getInt(ARGS_ID), fragment, name);
                    if (args.getBoolean(ARGS_IS_HIDE)) {
                        ft.hide(fragment);
                    }
                    if (!args.getBoolean(ARGS_IS_ADD_STACK)) continue;
                    ft.addToBackStack(name);
                }
                break;
            }
            case 4: {
                for (Fragment fragment : dest) {
                    ft.hide(fragment);
                }
                break;
            }
            case 2: {
                for (Fragment fragment : dest) {
                    ft.show(fragment);
                }
                break;
            }
            case 8: {
                ft.show(src);
                for (Fragment fragment : dest) {
                    if (fragment == src) continue;
                    ft.hide(fragment);
                }
                break;
            }
            case 16: {
                Bundle args = dest[0].getArguments();
                if (args == null) {
                    return;
                }
                String name = args.getString(ARGS_TAG, dest[0].getClass().getName());
                ft.replace(args.getInt(ARGS_ID), dest[0], name);
                if (!args.getBoolean(ARGS_IS_ADD_STACK)) break;
                ft.addToBackStack(name);
                break;
            }
            case 32: {
                for (Fragment fragment : dest) {
                    if (fragment == src) continue;
                    ft.remove(fragment);
                }
                break;
            }
            case 64: {
                for (int i = dest.length - 1; i >= 0; --i) {
                    Fragment fragment = dest[i];
                    if (fragment == dest[0]) {
                        if (src == null) break block0;
                        ft.remove(fragment);
                        break block0;
                    }
                    ft.remove(fragment);
                }
                break;
            }
        }
        ft.commitAllowingStateLoss();
    }

    private static void addAnim(FragmentTransaction ft, int enter, int exit, int popEnter, int popExit) {
        ft.setCustomAnimations(enter, exit, popEnter, popExit);
    }

    private static void addSharedElement(FragmentTransaction ft, View ... views) {
        if (Build.VERSION.SDK_INT >= 21) {
            for (View view : views) {
                ft.addSharedElement(view, view.getTransitionName());
            }
        }
    }

    public static Fragment getTop(@NonNull FragmentManager fm) {
        if (fm == null) {
            throw new NullPointerException("Argument 'fm' of type FragmentManager (#0 out of 1, zero-based) is marked by @androidx.annotation.NonNull but got null for it");
        }
        return FragmentUtils.getTopIsInStack(fm, null, false);
    }

    public static Fragment getTopInStack(@NonNull FragmentManager fm) {
        if (fm == null) {
            throw new NullPointerException("Argument 'fm' of type FragmentManager (#0 out of 1, zero-based) is marked by @androidx.annotation.NonNull but got null for it");
        }
        return FragmentUtils.getTopIsInStack(fm, null, true);
    }

    private static Fragment getTopIsInStack(@NonNull FragmentManager fm, Fragment parentFragment, boolean isInStack) {
        if (fm == null) {
            throw new NullPointerException("Argument 'fm' of type FragmentManager (#0 out of 3, zero-based) is marked by @androidx.annotation.NonNull but got null for it");
        }
        List<Fragment> fragments = FragmentUtils.getFragments(fm);
        for (int i = fragments.size() - 1; i >= 0; --i) {
            Fragment fragment = fragments.get(i);
            if (fragment == null) continue;
            if (isInStack) {
                Bundle args = fragment.getArguments();
                if (args == null || !args.getBoolean(ARGS_IS_ADD_STACK)) continue;
                return FragmentUtils.getTopIsInStack(fragment.getChildFragmentManager(), fragment, true);
            }
            return FragmentUtils.getTopIsInStack(fragment.getChildFragmentManager(), fragment, false);
        }
        return parentFragment;
    }

    public static Fragment getTopShow(@NonNull FragmentManager fm) {
        if (fm == null) {
            throw new NullPointerException("Argument 'fm' of type FragmentManager (#0 out of 1, zero-based) is marked by @androidx.annotation.NonNull but got null for it");
        }
        return FragmentUtils.getTopShowIsInStack(fm, null, false);
    }

    public static Fragment getTopShowInStack(@NonNull FragmentManager fm) {
        if (fm == null) {
            throw new NullPointerException("Argument 'fm' of type FragmentManager (#0 out of 1, zero-based) is marked by @androidx.annotation.NonNull but got null for it");
        }
        return FragmentUtils.getTopShowIsInStack(fm, null, true);
    }

    private static Fragment getTopShowIsInStack(@NonNull FragmentManager fm, Fragment parentFragment, boolean isInStack) {
        if (fm == null) {
            throw new NullPointerException("Argument 'fm' of type FragmentManager (#0 out of 3, zero-based) is marked by @androidx.annotation.NonNull but got null for it");
        }
        List<Fragment> fragments = FragmentUtils.getFragments(fm);
        for (int i = fragments.size() - 1; i >= 0; --i) {
            Fragment fragment = fragments.get(i);
            if (fragment == null || !fragment.isResumed() || !fragment.isVisible() || !fragment.getUserVisibleHint()) continue;
            if (isInStack) {
                Bundle args = fragment.getArguments();
                if (args == null || !args.getBoolean(ARGS_IS_ADD_STACK)) continue;
                return FragmentUtils.getTopShowIsInStack(fragment.getChildFragmentManager(), fragment, true);
            }
            return FragmentUtils.getTopShowIsInStack(fragment.getChildFragmentManager(), fragment, false);
        }
        return parentFragment;
    }

    public static List<Fragment> getFragments(@NonNull FragmentManager fm) {
        if (fm == null) {
            throw new NullPointerException("Argument 'fm' of type FragmentManager (#0 out of 1, zero-based) is marked by @androidx.annotation.NonNull but got null for it");
        }
        List fragments = fm.getFragments();
        if (fragments == null || fragments.isEmpty()) {
            return Collections.emptyList();
        }
        return fragments;
    }

    public static List<Fragment> getFragmentsInStack(@NonNull FragmentManager fm) {
        if (fm == null) {
            throw new NullPointerException("Argument 'fm' of type FragmentManager (#0 out of 1, zero-based) is marked by @androidx.annotation.NonNull but got null for it");
        }
        List<Fragment> fragments = FragmentUtils.getFragments(fm);
        ArrayList<Fragment> result = new ArrayList<Fragment>();
        for (Fragment fragment : fragments) {
            Bundle args;
            if (fragment == null || (args = fragment.getArguments()) == null || !args.getBoolean(ARGS_IS_ADD_STACK)) continue;
            result.add(fragment);
        }
        return result;
    }

    public static List<FragmentNode> getAllFragments(@NonNull FragmentManager fm) {
        if (fm == null) {
            throw new NullPointerException("Argument 'fm' of type FragmentManager (#0 out of 1, zero-based) is marked by @androidx.annotation.NonNull but got null for it");
        }
        return FragmentUtils.getAllFragments(fm, new ArrayList<FragmentNode>());
    }

    private static List<FragmentNode> getAllFragments(@NonNull FragmentManager fm, List<FragmentNode> result) {
        if (fm == null) {
            throw new NullPointerException("Argument 'fm' of type FragmentManager (#0 out of 2, zero-based) is marked by @androidx.annotation.NonNull but got null for it");
        }
        List<Fragment> fragments = FragmentUtils.getFragments(fm);
        for (int i = fragments.size() - 1; i >= 0; --i) {
            Fragment fragment = fragments.get(i);
            if (fragment == null) continue;
            result.add(new FragmentNode(fragment, FragmentUtils.getAllFragments(fragment.getChildFragmentManager(), new ArrayList<FragmentNode>())));
        }
        return result;
    }

    public static List<FragmentNode> getAllFragmentsInStack(@NonNull FragmentManager fm) {
        if (fm == null) {
            throw new NullPointerException("Argument 'fm' of type FragmentManager (#0 out of 1, zero-based) is marked by @androidx.annotation.NonNull but got null for it");
        }
        return FragmentUtils.getAllFragmentsInStack(fm, new ArrayList<FragmentNode>());
    }

    private static List<FragmentNode> getAllFragmentsInStack(@NonNull FragmentManager fm, List<FragmentNode> result) {
        if (fm == null) {
            throw new NullPointerException("Argument 'fm' of type FragmentManager (#0 out of 2, zero-based) is marked by @androidx.annotation.NonNull but got null for it");
        }
        List<Fragment> fragments = FragmentUtils.getFragments(fm);
        for (int i = fragments.size() - 1; i >= 0; --i) {
            Bundle args;
            Fragment fragment = fragments.get(i);
            if (fragment == null || (args = fragment.getArguments()) == null || !args.getBoolean(ARGS_IS_ADD_STACK)) continue;
            result.add(new FragmentNode(fragment, FragmentUtils.getAllFragmentsInStack(fragment.getChildFragmentManager(), new ArrayList<FragmentNode>())));
        }
        return result;
    }

    public static Fragment findFragment(@NonNull FragmentManager fm, Class<? extends Fragment> findClz) {
        if (fm == null) {
            throw new NullPointerException("Argument 'fm' of type FragmentManager (#0 out of 2, zero-based) is marked by @androidx.annotation.NonNull but got null for it");
        }
        return fm.findFragmentByTag(findClz.getName());
    }

    public static Fragment findFragment(@NonNull FragmentManager fm, @NonNull String tag) {
        if (fm == null) {
            throw new NullPointerException("Argument 'fm' of type FragmentManager (#0 out of 2, zero-based) is marked by @androidx.annotation.NonNull but got null for it");
        }
        if (tag == null) {
            throw new NullPointerException("Argument 'tag' of type String (#1 out of 2, zero-based) is marked by @androidx.annotation.NonNull but got null for it");
        }
        return fm.findFragmentByTag(tag);
    }

    public static boolean dispatchBackPress(@NonNull Fragment fragment) {
        if (fragment == null) {
            throw new NullPointerException("Argument 'fragment' of type Fragment (#0 out of 1, zero-based) is marked by @androidx.annotation.NonNull but got null for it");
        }
        return fragment.isResumed() && fragment.isVisible() && fragment.getUserVisibleHint() && fragment instanceof OnBackClickListener && ((OnBackClickListener)fragment).onBackClick();
    }

    public static boolean dispatchBackPress(@NonNull FragmentManager fm) {
        if (fm == null) {
            throw new NullPointerException("Argument 'fm' of type FragmentManager (#0 out of 1, zero-based) is marked by @androidx.annotation.NonNull but got null for it");
        }
        List<Fragment> fragments = FragmentUtils.getFragments(fm);
        if (fragments == null || fragments.isEmpty()) {
            return false;
        }
        for (int i = fragments.size() - 1; i >= 0; --i) {
            Fragment fragment = fragments.get(i);
            if (fragment == null || !fragment.isResumed() || !fragment.isVisible() || !fragment.getUserVisibleHint() || !(fragment instanceof OnBackClickListener) || !((OnBackClickListener)fragment).onBackClick()) continue;
            return true;
        }
        return false;
    }

    public static void setBackgroundColor(@NonNull Fragment fragment, @ColorInt int color) {
        if (fragment == null) {
            throw new NullPointerException("Argument 'fragment' of type Fragment (#0 out of 2, zero-based) is marked by @androidx.annotation.NonNull but got null for it");
        }
        View view = fragment.getView();
        if (view != null) {
            view.setBackgroundColor(color);
        }
    }

    public static void setBackgroundResource(@NonNull Fragment fragment, @DrawableRes int resId) {
        if (fragment == null) {
            throw new NullPointerException("Argument 'fragment' of type Fragment (#0 out of 2, zero-based) is marked by @androidx.annotation.NonNull but got null for it");
        }
        View view = fragment.getView();
        if (view != null) {
            view.setBackgroundResource(resId);
        }
    }

    public static void setBackground(@NonNull Fragment fragment, Drawable background) {
        if (fragment == null) {
            throw new NullPointerException("Argument 'fragment' of type Fragment (#0 out of 2, zero-based) is marked by @androidx.annotation.NonNull but got null for it");
        }
        View view = fragment.getView();
        if (view == null) {
            return;
        }
        if (Build.VERSION.SDK_INT >= 16) {
            view.setBackground(background);
        } else {
            view.setBackgroundDrawable(background);
        }
    }

    public static String getSimpleName(Fragment fragment) {
        return fragment == null ? "null" : fragment.getClass().getSimpleName();
    }

    public static interface OnBackClickListener {
        public boolean onBackClick();
    }

    public static class FragmentNode {
        final Fragment fragment;
        final List<FragmentNode> next;

        public FragmentNode(Fragment fragment, List<FragmentNode> next) {
            this.fragment = fragment;
            this.next = next;
        }

        public Fragment getFragment() {
            return this.fragment;
        }

        public List<FragmentNode> getNext() {
            return this.next;
        }

        public String toString() {
            return this.fragment.getClass().getSimpleName() + "->" + (this.next == null || this.next.isEmpty() ? "no child" : this.next.toString());
        }
    }

    private static class Args {
        final int id;
        final boolean isHide;
        final boolean isAddStack;
        final String tag;

        Args(int id2, boolean isHide, boolean isAddStack) {
            this(id2, null, isHide, isAddStack);
        }

        Args(int id2, String tag, boolean isHide, boolean isAddStack) {
            this.id = id2;
            this.tag = tag;
            this.isHide = isHide;
            this.isAddStack = isAddStack;
        }
    }
}

