/*
 * Decompiled with CFR 0.152.
 */
package com.blankj.utilcode.util;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;

public class ArrayUtils {
    public static final int INDEX_NOT_FOUND = -1;

    private ArrayUtils() {
        throw new UnsupportedOperationException("u can't instantiate me...");
    }

    @SafeVarargs
    public static <T> T[] newArray(T ... array) {
        return array;
    }

    public static long[] newLongArray(long ... array) {
        return array;
    }

    public static int[] newIntArray(int ... array) {
        return array;
    }

    public static short[] newShortArray(short ... array) {
        return array;
    }

    public static char[] newCharArray(char ... array) {
        return array;
    }

    public static byte[] newByteArray(byte ... array) {
        return array;
    }

    public static double[] newDoubleArray(double ... array) {
        return array;
    }

    public static float[] newFloatArray(float ... array) {
        return array;
    }

    public static boolean[] newBooleanArray(boolean ... array) {
        return array;
    }

    public static boolean isEmpty(Object array) {
        return ArrayUtils.getLength(array) == 0;
    }

    public static int getLength(Object array) {
        if (array == null) {
            return 0;
        }
        return Array.getLength(array);
    }

    public static boolean isSameLength(Object array1, Object array2) {
        return ArrayUtils.getLength(array1) == ArrayUtils.getLength(array2);
    }

    public static Object get(Object array, int index) {
        return ArrayUtils.get(array, index, null);
    }

    public static Object get(Object array, int index, Object defaultValue) {
        if (array == null) {
            return defaultValue;
        }
        try {
            return Array.get(array, index);
        }
        catch (Exception ignore) {
            return defaultValue;
        }
    }

    public static void set(Object array, int index, Object value) {
        if (array == null) {
            return;
        }
        Array.set(array, index, value);
    }

    public static boolean equals(Object[] a, Object[] a2) {
        return Arrays.deepEquals(a, a2);
    }

    public static boolean equals(boolean[] a, boolean[] a2) {
        return Arrays.equals(a, a2);
    }

    public static boolean equals(byte[] a, byte[] a2) {
        return Arrays.equals(a, a2);
    }

    public static boolean equals(char[] a, char[] a2) {
        return Arrays.equals(a, a2);
    }

    public static boolean equals(double[] a, double[] a2) {
        return Arrays.equals(a, a2);
    }

    public static boolean equals(float[] a, float[] a2) {
        return Arrays.equals(a, a2);
    }

    public static boolean equals(int[] a, int[] a2) {
        return Arrays.equals(a, a2);
    }

    public static boolean equals(short[] a, short[] a2) {
        return Arrays.equals(a, a2);
    }

    public static <T> void reverse(T[] array) {
        if (array == null) {
            return;
        }
        int i = 0;
        for (int j = array.length - 1; j > i; --j, ++i) {
            T tmp = array[j];
            array[j] = array[i];
            array[i] = tmp;
        }
    }

    public static void reverse(long[] array) {
        if (array == null) {
            return;
        }
        int i = 0;
        for (int j = array.length - 1; j > i; --j, ++i) {
            long tmp = array[j];
            array[j] = array[i];
            array[i] = tmp;
        }
    }

    public static void reverse(int[] array) {
        if (array == null) {
            return;
        }
        int i = 0;
        for (int j = array.length - 1; j > i; --j, ++i) {
            int tmp = array[j];
            array[j] = array[i];
            array[i] = tmp;
        }
    }

    public static void reverse(short[] array) {
        if (array == null) {
            return;
        }
        int i = 0;
        for (int j = array.length - 1; j > i; --j, ++i) {
            short tmp = array[j];
            array[j] = array[i];
            array[i] = tmp;
        }
    }

    public static void reverse(char[] array) {
        if (array == null) {
            return;
        }
        int i = 0;
        for (int j = array.length - 1; j > i; --j, ++i) {
            char tmp = array[j];
            array[j] = array[i];
            array[i] = tmp;
        }
    }

    public static void reverse(byte[] array) {
        if (array == null) {
            return;
        }
        int i = 0;
        for (int j = array.length - 1; j > i; --j, ++i) {
            byte tmp = array[j];
            array[j] = array[i];
            array[i] = tmp;
        }
    }

    public static void reverse(double[] array) {
        if (array == null) {
            return;
        }
        int i = 0;
        for (int j = array.length - 1; j > i; --j, ++i) {
            double tmp = array[j];
            array[j] = array[i];
            array[i] = tmp;
        }
    }

    public static void reverse(float[] array) {
        if (array == null) {
            return;
        }
        int i = 0;
        for (int j = array.length - 1; j > i; --j, ++i) {
            float tmp = array[j];
            array[j] = array[i];
            array[i] = tmp;
        }
    }

    public static void reverse(boolean[] array) {
        if (array == null) {
            return;
        }
        int i = 0;
        for (int j = array.length - 1; j > i; --j, ++i) {
            boolean tmp = array[j];
            array[j] = array[i];
            array[i] = tmp;
        }
    }

    public static <T> T[] copy(T[] array) {
        if (array == null) {
            return null;
        }
        return ArrayUtils.subArray(array, 0, array.length);
    }

    public static long[] copy(long[] array) {
        if (array == null) {
            return null;
        }
        return ArrayUtils.subArray(array, 0, array.length);
    }

    public static int[] copy(int[] array) {
        if (array == null) {
            return null;
        }
        return ArrayUtils.subArray(array, 0, array.length);
    }

    public static short[] copy(short[] array) {
        if (array == null) {
            return null;
        }
        return ArrayUtils.subArray(array, 0, array.length);
    }

    public static char[] copy(char[] array) {
        if (array == null) {
            return null;
        }
        return ArrayUtils.subArray(array, 0, array.length);
    }

    public static byte[] copy(byte[] array) {
        if (array == null) {
            return null;
        }
        return ArrayUtils.subArray(array, 0, array.length);
    }

    public static double[] copy(double[] array) {
        if (array == null) {
            return null;
        }
        return ArrayUtils.subArray(array, 0, array.length);
    }

    public static float[] copy(float[] array) {
        if (array == null) {
            return null;
        }
        return ArrayUtils.subArray(array, 0, array.length);
    }

    public static boolean[] copy(boolean[] array) {
        if (array == null) {
            return null;
        }
        return ArrayUtils.subArray(array, 0, array.length);
    }

    private static Object realCopy(Object array) {
        if (array == null) {
            return null;
        }
        return ArrayUtils.realSubArray(array, 0, ArrayUtils.getLength(array));
    }

    public static <T> T[] subArray(T[] array, int startIndexInclusive, int endIndexExclusive) {
        return (Object[])ArrayUtils.realSubArray(array, startIndexInclusive, endIndexExclusive);
    }

    public static long[] subArray(long[] array, int startIndexInclusive, int endIndexExclusive) {
        return (long[])ArrayUtils.realSubArray(array, startIndexInclusive, endIndexExclusive);
    }

    public static int[] subArray(int[] array, int startIndexInclusive, int endIndexExclusive) {
        return (int[])ArrayUtils.realSubArray(array, startIndexInclusive, endIndexExclusive);
    }

    public static short[] subArray(short[] array, int startIndexInclusive, int endIndexExclusive) {
        return (short[])ArrayUtils.realSubArray(array, startIndexInclusive, endIndexExclusive);
    }

    public static char[] subArray(char[] array, int startIndexInclusive, int endIndexExclusive) {
        return (char[])ArrayUtils.realSubArray(array, startIndexInclusive, endIndexExclusive);
    }

    public static byte[] subArray(byte[] array, int startIndexInclusive, int endIndexExclusive) {
        return (byte[])ArrayUtils.realSubArray(array, startIndexInclusive, endIndexExclusive);
    }

    public static double[] subArray(double[] array, int startIndexInclusive, int endIndexExclusive) {
        return (double[])ArrayUtils.realSubArray(array, startIndexInclusive, endIndexExclusive);
    }

    public static float[] subArray(float[] array, int startIndexInclusive, int endIndexExclusive) {
        return (float[])ArrayUtils.realSubArray(array, startIndexInclusive, endIndexExclusive);
    }

    public static boolean[] subArray(boolean[] array, int startIndexInclusive, int endIndexExclusive) {
        return (boolean[])ArrayUtils.realSubArray(array, startIndexInclusive, endIndexExclusive);
    }

    private static Object realSubArray(Object array, int startIndexInclusive, int endIndexExclusive) {
        int length;
        if (array == null) {
            return null;
        }
        if (startIndexInclusive < 0) {
            startIndexInclusive = 0;
        }
        if (endIndexExclusive > (length = ArrayUtils.getLength(array))) {
            endIndexExclusive = length;
        }
        int newSize = endIndexExclusive - startIndexInclusive;
        Class<?> type = array.getClass().getComponentType();
        if (newSize <= 0) {
            return Array.newInstance(type, 0);
        }
        Object subArray = Array.newInstance(type, newSize);
        System.arraycopy(array, startIndexInclusive, subArray, 0, newSize);
        return subArray;
    }

    public static <T> T[] add(T[] array, T element) {
        Class<Object> type = array != null ? array.getClass() : (element != null ? element.getClass() : Object.class);
        return (Object[])ArrayUtils.realAddOne(array, element, type);
    }

    public static boolean[] add(boolean[] array, boolean element) {
        return (boolean[])ArrayUtils.realAddOne(array, element, Boolean.TYPE);
    }

    public static byte[] add(byte[] array, byte element) {
        return (byte[])ArrayUtils.realAddOne(array, element, Byte.TYPE);
    }

    public static char[] add(char[] array, char element) {
        return (char[])ArrayUtils.realAddOne(array, Character.valueOf(element), Character.TYPE);
    }

    public static double[] add(double[] array, double element) {
        return (double[])ArrayUtils.realAddOne(array, element, Double.TYPE);
    }

    public static float[] add(float[] array, float element) {
        return (float[])ArrayUtils.realAddOne(array, Float.valueOf(element), Float.TYPE);
    }

    public static int[] add(int[] array, int element) {
        return (int[])ArrayUtils.realAddOne(array, element, Integer.TYPE);
    }

    public static long[] add(long[] array, long element) {
        return (long[])ArrayUtils.realAddOne(array, element, Long.TYPE);
    }

    public static short[] add(short[] array, short element) {
        return (short[])ArrayUtils.realAddOne(array, element, Short.TYPE);
    }

    private static Object realAddOne(Object array, Object element, Class newArrayComponentType) {
        Object newArray;
        int arrayLength = 0;
        if (array != null) {
            arrayLength = ArrayUtils.getLength(array);
            newArray = Array.newInstance(array.getClass().getComponentType(), arrayLength + 1);
            System.arraycopy(array, 0, newArray, 0, arrayLength);
        } else {
            newArray = Array.newInstance(newArrayComponentType, 1);
        }
        Array.set(newArray, arrayLength, element);
        return newArray;
    }

    public static <T> T[] add(T[] array1, T[] array2) {
        return (Object[])ArrayUtils.realAddArr(array1, array2);
    }

    public static boolean[] add(boolean[] array1, boolean[] array2) {
        return (boolean[])ArrayUtils.realAddArr(array1, array2);
    }

    public static char[] add(char[] array1, char[] array2) {
        return (char[])ArrayUtils.realAddArr(array1, array2);
    }

    public static byte[] add(byte[] array1, byte[] array2) {
        return (byte[])ArrayUtils.realAddArr(array1, array2);
    }

    public static short[] add(short[] array1, short[] array2) {
        return (short[])ArrayUtils.realAddArr(array1, array2);
    }

    public static int[] add(int[] array1, int[] array2) {
        return (int[])ArrayUtils.realAddArr(array1, array2);
    }

    public static long[] add(long[] array1, long[] array2) {
        return (long[])ArrayUtils.realAddArr(array1, array2);
    }

    public static float[] add(float[] array1, float[] array2) {
        return (float[])ArrayUtils.realAddArr(array1, array2);
    }

    public static double[] add(double[] array1, double[] array2) {
        return (double[])ArrayUtils.realAddArr(array1, array2);
    }

    private static Object realAddArr(Object array1, Object array2) {
        if (array1 == null && array2 == null) {
            return null;
        }
        if (array1 == null) {
            return ArrayUtils.realCopy(array2);
        }
        if (array2 == null) {
            return ArrayUtils.realCopy(array1);
        }
        int len1 = ArrayUtils.getLength(array1);
        int len2 = ArrayUtils.getLength(array2);
        Object joinedArray = Array.newInstance(array1.getClass().getComponentType(), len1 + len2);
        System.arraycopy(array1, 0, joinedArray, 0, len1);
        System.arraycopy(array2, 0, joinedArray, len1, len2);
        return joinedArray;
    }

    public static <T> T[] add(T[] array1, int index, T[] array2) {
        Class<?> clss;
        if (array1 != null) {
            clss = array1.getClass().getComponentType();
        } else if (array2 != null) {
            clss = array2.getClass().getComponentType();
        } else {
            return new Object[]{null};
        }
        return (Object[])ArrayUtils.realAddArr(array1, index, array2, clss);
    }

    public static boolean[] add(boolean[] array1, int index, boolean[] array2) {
        return (boolean[])ArrayUtils.realAddArr(array1, index, array2, Boolean.TYPE);
    }

    public static char[] add(char[] array1, int index, char[] array2) {
        return (char[])ArrayUtils.realAddArr(array1, index, array2, Character.TYPE);
    }

    public static byte[] add(byte[] array1, int index, byte[] array2) {
        return (byte[])ArrayUtils.realAddArr(array1, index, array2, Byte.TYPE);
    }

    public static short[] add(short[] array1, int index, short[] array2) {
        return (short[])ArrayUtils.realAddArr(array1, index, array2, Short.TYPE);
    }

    public static int[] add(int[] array1, int index, int[] array2) {
        return (int[])ArrayUtils.realAddArr(array1, index, array2, Integer.TYPE);
    }

    public static long[] add(long[] array1, int index, long[] array2) {
        return (long[])ArrayUtils.realAddArr(array1, index, array2, Long.TYPE);
    }

    public static float[] add(float[] array1, int index, float[] array2) {
        return (float[])ArrayUtils.realAddArr(array1, index, array2, Float.TYPE);
    }

    public static double[] add(double[] array1, int index, double[] array2) {
        return (double[])ArrayUtils.realAddArr(array1, index, array2, Double.TYPE);
    }

    private static Object realAddArr(Object array1, int index, Object array2, Class clss) {
        if (array1 == null && array2 == null) {
            return null;
        }
        int len1 = ArrayUtils.getLength(array1);
        int len2 = ArrayUtils.getLength(array2);
        if (len1 == 0) {
            if (index != 0) {
                throw new IndexOutOfBoundsException("Index: " + index + ", array1 Length: 0");
            }
            return ArrayUtils.realCopy(array2);
        }
        if (len2 == 0) {
            return ArrayUtils.realCopy(array1);
        }
        if (index > len1 || index < 0) {
            throw new IndexOutOfBoundsException("Index: " + index + ", array1 Length: " + len1);
        }
        Object joinedArray = Array.newInstance(array1.getClass().getComponentType(), len1 + len2);
        if (index == len1) {
            System.arraycopy(array1, 0, joinedArray, 0, len1);
            System.arraycopy(array2, 0, joinedArray, len1, len2);
        } else if (index == 0) {
            System.arraycopy(array2, 0, joinedArray, 0, len2);
            System.arraycopy(array1, 0, joinedArray, len2, len1);
        } else {
            System.arraycopy(array1, 0, joinedArray, 0, index);
            System.arraycopy(array2, 0, joinedArray, index, len2);
            System.arraycopy(array1, index, joinedArray, index + len2, len1 - index);
        }
        return joinedArray;
    }

    public static <T> T[] add(T[] array, int index, T element) {
        Class<?> clss;
        if (array != null) {
            clss = array.getClass().getComponentType();
        } else if (element != null) {
            clss = element.getClass();
        } else {
            return new Object[]{null};
        }
        return (Object[])ArrayUtils.realAdd(array, index, element, clss);
    }

    public static boolean[] add(boolean[] array, int index, boolean element) {
        return (boolean[])ArrayUtils.realAdd(array, index, element, Boolean.TYPE);
    }

    public static char[] add(char[] array, int index, char element) {
        return (char[])ArrayUtils.realAdd(array, index, Character.valueOf(element), Character.TYPE);
    }

    public static byte[] add(byte[] array, int index, byte element) {
        return (byte[])ArrayUtils.realAdd(array, index, element, Byte.TYPE);
    }

    public static short[] add(short[] array, int index, short element) {
        return (short[])ArrayUtils.realAdd(array, index, element, Short.TYPE);
    }

    public static int[] add(int[] array, int index, int element) {
        return (int[])ArrayUtils.realAdd(array, index, element, Integer.TYPE);
    }

    public static long[] add(long[] array, int index, long element) {
        return (long[])ArrayUtils.realAdd(array, index, element, Long.TYPE);
    }

    public static float[] add(float[] array, int index, float element) {
        return (float[])ArrayUtils.realAdd(array, index, Float.valueOf(element), Float.TYPE);
    }

    public static double[] add(double[] array, int index, double element) {
        return (double[])ArrayUtils.realAdd(array, index, element, Double.TYPE);
    }

    private static Object realAdd(Object array, int index, Object element, Class clss) {
        if (array == null) {
            if (index != 0) {
                throw new IndexOutOfBoundsException("Index: " + index + ", Length: 0");
            }
            Object joinedArray = Array.newInstance(clss, 1);
            Array.set(joinedArray, 0, element);
            return joinedArray;
        }
        int length = Array.getLength(array);
        if (index > length || index < 0) {
            throw new IndexOutOfBoundsException("Index: " + index + ", Length: " + length);
        }
        Object result = Array.newInstance(clss, length + 1);
        System.arraycopy(array, 0, result, 0, index);
        Array.set(result, index, element);
        if (index < length) {
            System.arraycopy(array, index, result, index + 1, length - index);
        }
        return result;
    }

    public static Object[] remove(Object[] array, int index) {
        return (Object[])ArrayUtils.remove((Object)array, index);
    }

    public static Object[] removeElement(Object[] array, Object element) {
        int index = ArrayUtils.indexOf(array, element);
        if (index == -1) {
            return ArrayUtils.copy(array);
        }
        return ArrayUtils.remove(array, index);
    }

    public static boolean[] remove(boolean[] array, int index) {
        return (boolean[])ArrayUtils.remove((Object)array, index);
    }

    public static boolean[] removeElement(boolean[] array, boolean element) {
        int index = ArrayUtils.indexOf(array, element);
        if (index == -1) {
            return ArrayUtils.copy(array);
        }
        return ArrayUtils.remove(array, index);
    }

    public static byte[] remove(byte[] array, int index) {
        return (byte[])ArrayUtils.remove((Object)array, index);
    }

    public static byte[] removeElement(byte[] array, byte element) {
        int index = ArrayUtils.indexOf(array, element);
        if (index == -1) {
            return ArrayUtils.copy(array);
        }
        return ArrayUtils.remove(array, index);
    }

    public static char[] remove(char[] array, int index) {
        return (char[])ArrayUtils.remove((Object)array, index);
    }

    public static char[] removeElement(char[] array, char element) {
        int index = ArrayUtils.indexOf(array, element);
        if (index == -1) {
            return ArrayUtils.copy(array);
        }
        return ArrayUtils.remove(array, index);
    }

    public static double[] remove(double[] array, int index) {
        return (double[])ArrayUtils.remove((Object)array, index);
    }

    public static double[] removeElement(double[] array, double element) {
        int index = ArrayUtils.indexOf(array, element);
        if (index == -1) {
            return ArrayUtils.copy(array);
        }
        return ArrayUtils.remove(array, index);
    }

    public static float[] remove(float[] array, int index) {
        return (float[])ArrayUtils.remove((Object)array, index);
    }

    public static float[] removeElement(float[] array, float element) {
        int index = ArrayUtils.indexOf(array, element);
        if (index == -1) {
            return ArrayUtils.copy(array);
        }
        return ArrayUtils.remove(array, index);
    }

    public static int[] remove(int[] array, int index) {
        return (int[])ArrayUtils.remove((Object)array, index);
    }

    public static int[] removeElement(int[] array, int element) {
        int index = ArrayUtils.indexOf(array, element);
        if (index == -1) {
            return ArrayUtils.copy(array);
        }
        return ArrayUtils.remove(array, index);
    }

    public static long[] remove(long[] array, int index) {
        return (long[])ArrayUtils.remove((Object)array, index);
    }

    public static long[] removeElement(long[] array, long element) {
        int index = ArrayUtils.indexOf(array, element);
        if (index == -1) {
            return ArrayUtils.copy(array);
        }
        return ArrayUtils.remove(array, index);
    }

    public static short[] remove(short[] array, int index) {
        return (short[])ArrayUtils.remove((Object)array, index);
    }

    public static short[] removeElement(short[] array, short element) {
        int index = ArrayUtils.indexOf(array, element);
        if (index == -1) {
            return ArrayUtils.copy(array);
        }
        return ArrayUtils.remove(array, index);
    }

    private static Object remove(Object array, int index) {
        int length = ArrayUtils.getLength(array);
        if (index < 0 || index >= length) {
            throw new IndexOutOfBoundsException("Index: " + index + ", Length: " + length);
        }
        Object result = Array.newInstance(array.getClass().getComponentType(), length - 1);
        System.arraycopy(array, 0, result, 0, index);
        if (index < length - 1) {
            System.arraycopy(array, index + 1, result, index, length - index - 1);
        }
        return result;
    }

    public static int indexOf(Object[] array, Object objectToFind) {
        return ArrayUtils.indexOf(array, objectToFind, 0);
    }

    public static int indexOf(Object[] array, Object objectToFind, int startIndex) {
        if (array == null) {
            return -1;
        }
        if (startIndex < 0) {
            startIndex = 0;
        }
        if (objectToFind == null) {
            for (int i = startIndex; i < array.length; ++i) {
                if (array[i] != null) continue;
                return i;
            }
        } else {
            for (int i = startIndex; i < array.length; ++i) {
                if (!objectToFind.equals(array[i])) continue;
                return i;
            }
        }
        return -1;
    }

    public static int lastIndexOf(Object[] array, Object objectToFind) {
        return ArrayUtils.lastIndexOf(array, objectToFind, Integer.MAX_VALUE);
    }

    public static int lastIndexOf(Object[] array, Object objectToFind, int startIndex) {
        if (array == null) {
            return -1;
        }
        if (startIndex < 0) {
            return -1;
        }
        if (startIndex >= array.length) {
            startIndex = array.length - 1;
        }
        if (objectToFind == null) {
            for (int i = startIndex; i >= 0; --i) {
                if (array[i] != null) continue;
                return i;
            }
        } else {
            for (int i = startIndex; i >= 0; --i) {
                if (!objectToFind.equals(array[i])) continue;
                return i;
            }
        }
        return -1;
    }

    public static boolean contains(Object[] array, Object objectToFind) {
        return ArrayUtils.indexOf(array, objectToFind) != -1;
    }

    public static int indexOf(long[] array, long valueToFind) {
        return ArrayUtils.indexOf(array, valueToFind, 0);
    }

    public static int indexOf(long[] array, long valueToFind, int startIndex) {
        if (array == null) {
            return -1;
        }
        if (startIndex < 0) {
            startIndex = 0;
        }
        for (int i = startIndex; i < array.length; ++i) {
            if (valueToFind != array[i]) continue;
            return i;
        }
        return -1;
    }

    public static int lastIndexOf(long[] array, long valueToFind) {
        return ArrayUtils.lastIndexOf(array, valueToFind, Integer.MAX_VALUE);
    }

    public static int lastIndexOf(long[] array, long valueToFind, int startIndex) {
        if (array == null) {
            return -1;
        }
        if (startIndex < 0) {
            return -1;
        }
        if (startIndex >= array.length) {
            startIndex = array.length - 1;
        }
        for (int i = startIndex; i >= 0; --i) {
            if (valueToFind != array[i]) continue;
            return i;
        }
        return -1;
    }

    public static boolean contains(long[] array, long valueToFind) {
        return ArrayUtils.indexOf(array, valueToFind) != -1;
    }

    public static int indexOf(int[] array, int valueToFind) {
        return ArrayUtils.indexOf(array, valueToFind, 0);
    }

    public static int indexOf(int[] array, int valueToFind, int startIndex) {
        if (array == null) {
            return -1;
        }
        if (startIndex < 0) {
            startIndex = 0;
        }
        for (int i = startIndex; i < array.length; ++i) {
            if (valueToFind != array[i]) continue;
            return i;
        }
        return -1;
    }

    public static int lastIndexOf(int[] array, int valueToFind) {
        return ArrayUtils.lastIndexOf(array, valueToFind, Integer.MAX_VALUE);
    }

    public static int lastIndexOf(int[] array, int valueToFind, int startIndex) {
        if (array == null) {
            return -1;
        }
        if (startIndex < 0) {
            return -1;
        }
        if (startIndex >= array.length) {
            startIndex = array.length - 1;
        }
        for (int i = startIndex; i >= 0; --i) {
            if (valueToFind != array[i]) continue;
            return i;
        }
        return -1;
    }

    public static boolean contains(int[] array, int valueToFind) {
        return ArrayUtils.indexOf(array, valueToFind) != -1;
    }

    public static int indexOf(short[] array, short valueToFind) {
        return ArrayUtils.indexOf(array, valueToFind, 0);
    }

    public static int indexOf(short[] array, short valueToFind, int startIndex) {
        if (array == null) {
            return -1;
        }
        if (startIndex < 0) {
            startIndex = 0;
        }
        for (int i = startIndex; i < array.length; ++i) {
            if (valueToFind != array[i]) continue;
            return i;
        }
        return -1;
    }

    public static int lastIndexOf(short[] array, short valueToFind) {
        return ArrayUtils.lastIndexOf(array, valueToFind, Integer.MAX_VALUE);
    }

    public static int lastIndexOf(short[] array, short valueToFind, int startIndex) {
        if (array == null) {
            return -1;
        }
        if (startIndex < 0) {
            return -1;
        }
        if (startIndex >= array.length) {
            startIndex = array.length - 1;
        }
        for (int i = startIndex; i >= 0; --i) {
            if (valueToFind != array[i]) continue;
            return i;
        }
        return -1;
    }

    public static boolean contains(short[] array, short valueToFind) {
        return ArrayUtils.indexOf(array, valueToFind) != -1;
    }

    public static int indexOf(char[] array, char valueToFind) {
        return ArrayUtils.indexOf(array, valueToFind, 0);
    }

    public static int indexOf(char[] array, char valueToFind, int startIndex) {
        if (array == null) {
            return -1;
        }
        if (startIndex < 0) {
            startIndex = 0;
        }
        for (int i = startIndex; i < array.length; ++i) {
            if (valueToFind != array[i]) continue;
            return i;
        }
        return -1;
    }

    public static int lastIndexOf(char[] array, char valueToFind) {
        return ArrayUtils.lastIndexOf(array, valueToFind, Integer.MAX_VALUE);
    }

    public static int lastIndexOf(char[] array, char valueToFind, int startIndex) {
        if (array == null) {
            return -1;
        }
        if (startIndex < 0) {
            return -1;
        }
        if (startIndex >= array.length) {
            startIndex = array.length - 1;
        }
        for (int i = startIndex; i >= 0; --i) {
            if (valueToFind != array[i]) continue;
            return i;
        }
        return -1;
    }

    public static boolean contains(char[] array, char valueToFind) {
        return ArrayUtils.indexOf(array, valueToFind) != -1;
    }

    public static int indexOf(byte[] array, byte valueToFind) {
        return ArrayUtils.indexOf(array, valueToFind, 0);
    }

    public static int indexOf(byte[] array, byte valueToFind, int startIndex) {
        if (array == null) {
            return -1;
        }
        if (startIndex < 0) {
            startIndex = 0;
        }
        for (int i = startIndex; i < array.length; ++i) {
            if (valueToFind != array[i]) continue;
            return i;
        }
        return -1;
    }

    public static int lastIndexOf(byte[] array, byte valueToFind) {
        return ArrayUtils.lastIndexOf(array, valueToFind, Integer.MAX_VALUE);
    }

    public static int lastIndexOf(byte[] array, byte valueToFind, int startIndex) {
        if (array == null) {
            return -1;
        }
        if (startIndex < 0) {
            return -1;
        }
        if (startIndex >= array.length) {
            startIndex = array.length - 1;
        }
        for (int i = startIndex; i >= 0; --i) {
            if (valueToFind != array[i]) continue;
            return i;
        }
        return -1;
    }

    public static boolean contains(byte[] array, byte valueToFind) {
        return ArrayUtils.indexOf(array, valueToFind) != -1;
    }

    public static int indexOf(double[] array, double valueToFind) {
        return ArrayUtils.indexOf(array, valueToFind, 0);
    }

    public static int indexOf(double[] array, double valueToFind, double tolerance) {
        return ArrayUtils.indexOf(array, valueToFind, 0, tolerance);
    }

    public static int indexOf(double[] array, double valueToFind, int startIndex) {
        if (ArrayUtils.isEmpty(array)) {
            return -1;
        }
        if (startIndex < 0) {
            startIndex = 0;
        }
        for (int i = startIndex; i < array.length; ++i) {
            if (valueToFind != array[i]) continue;
            return i;
        }
        return -1;
    }

    public static int indexOf(double[] array, double valueToFind, int startIndex, double tolerance) {
        if (ArrayUtils.isEmpty(array)) {
            return -1;
        }
        if (startIndex < 0) {
            startIndex = 0;
        }
        double min = valueToFind - tolerance;
        double max = valueToFind + tolerance;
        for (int i = startIndex; i < array.length; ++i) {
            if (!(array[i] >= min) || !(array[i] <= max)) continue;
            return i;
        }
        return -1;
    }

    public static int lastIndexOf(double[] array, double valueToFind) {
        return ArrayUtils.lastIndexOf(array, valueToFind, Integer.MAX_VALUE);
    }

    public static int lastIndexOf(double[] array, double valueToFind, double tolerance) {
        return ArrayUtils.lastIndexOf(array, valueToFind, Integer.MAX_VALUE, tolerance);
    }

    public static int lastIndexOf(double[] array, double valueToFind, int startIndex) {
        if (ArrayUtils.isEmpty(array)) {
            return -1;
        }
        if (startIndex < 0) {
            return -1;
        }
        if (startIndex >= array.length) {
            startIndex = array.length - 1;
        }
        for (int i = startIndex; i >= 0; --i) {
            if (valueToFind != array[i]) continue;
            return i;
        }
        return -1;
    }

    public static int lastIndexOf(double[] array, double valueToFind, int startIndex, double tolerance) {
        if (ArrayUtils.isEmpty(array)) {
            return -1;
        }
        if (startIndex < 0) {
            return -1;
        }
        if (startIndex >= array.length) {
            startIndex = array.length - 1;
        }
        double min = valueToFind - tolerance;
        double max = valueToFind + tolerance;
        for (int i = startIndex; i >= 0; --i) {
            if (!(array[i] >= min) || !(array[i] <= max)) continue;
            return i;
        }
        return -1;
    }

    public static boolean contains(double[] array, double valueToFind) {
        return ArrayUtils.indexOf(array, valueToFind) != -1;
    }

    public static boolean contains(double[] array, double valueToFind, double tolerance) {
        return ArrayUtils.indexOf(array, valueToFind, 0, tolerance) != -1;
    }

    public static int indexOf(float[] array, float valueToFind) {
        return ArrayUtils.indexOf(array, valueToFind, 0);
    }

    public static int indexOf(float[] array, float valueToFind, int startIndex) {
        if (ArrayUtils.isEmpty(array)) {
            return -1;
        }
        if (startIndex < 0) {
            startIndex = 0;
        }
        for (int i = startIndex; i < array.length; ++i) {
            if (valueToFind != array[i]) continue;
            return i;
        }
        return -1;
    }

    public static int lastIndexOf(float[] array, float valueToFind) {
        return ArrayUtils.lastIndexOf(array, valueToFind, Integer.MAX_VALUE);
    }

    public static int lastIndexOf(float[] array, float valueToFind, int startIndex) {
        if (ArrayUtils.isEmpty(array)) {
            return -1;
        }
        if (startIndex < 0) {
            return -1;
        }
        if (startIndex >= array.length) {
            startIndex = array.length - 1;
        }
        for (int i = startIndex; i >= 0; --i) {
            if (valueToFind != array[i]) continue;
            return i;
        }
        return -1;
    }

    public static boolean contains(float[] array, float valueToFind) {
        return ArrayUtils.indexOf(array, valueToFind) != -1;
    }

    public static int indexOf(boolean[] array, boolean valueToFind) {
        return ArrayUtils.indexOf(array, valueToFind, 0);
    }

    public static int indexOf(boolean[] array, boolean valueToFind, int startIndex) {
        if (ArrayUtils.isEmpty(array)) {
            return -1;
        }
        if (startIndex < 0) {
            startIndex = 0;
        }
        for (int i = startIndex; i < array.length; ++i) {
            if (valueToFind != array[i]) continue;
            return i;
        }
        return -1;
    }

    public static int lastIndexOf(boolean[] array, boolean valueToFind) {
        return ArrayUtils.lastIndexOf(array, valueToFind, Integer.MAX_VALUE);
    }

    public static int lastIndexOf(boolean[] array, boolean valueToFind, int startIndex) {
        if (ArrayUtils.isEmpty(array)) {
            return -1;
        }
        if (startIndex < 0) {
            return -1;
        }
        if (startIndex >= array.length) {
            startIndex = array.length - 1;
        }
        for (int i = startIndex; i >= 0; --i) {
            if (valueToFind != array[i]) continue;
            return i;
        }
        return -1;
    }

    public static boolean contains(boolean[] array, boolean valueToFind) {
        return ArrayUtils.indexOf(array, valueToFind) != -1;
    }

    public static char[] toPrimitive(Character[] array) {
        if (array == null) {
            return null;
        }
        if (array.length == 0) {
            return new char[0];
        }
        char[] result = new char[array.length];
        for (int i = 0; i < array.length; ++i) {
            result[i] = array[i].charValue();
        }
        return result;
    }

    public static char[] toPrimitive(Character[] array, char valueForNull) {
        if (array == null) {
            return null;
        }
        if (array.length == 0) {
            return new char[0];
        }
        char[] result = new char[array.length];
        for (int i = 0; i < array.length; ++i) {
            Character b = array[i];
            result[i] = b == null ? valueForNull : b.charValue();
        }
        return result;
    }

    public static Character[] toObject(char[] array) {
        if (array == null) {
            return null;
        }
        if (array.length == 0) {
            return new Character[0];
        }
        Character[] result = new Character[array.length];
        for (int i = 0; i < array.length; ++i) {
            result[i] = new Character(array[i]);
        }
        return result;
    }

    public static long[] toPrimitive(Long[] array) {
        if (array == null) {
            return null;
        }
        if (array.length == 0) {
            return new long[0];
        }
        long[] result = new long[array.length];
        for (int i = 0; i < array.length; ++i) {
            result[i] = array[i];
        }
        return result;
    }

    public static long[] toPrimitive(Long[] array, long valueForNull) {
        if (array == null) {
            return null;
        }
        if (array.length == 0) {
            return new long[0];
        }
        long[] result = new long[array.length];
        for (int i = 0; i < array.length; ++i) {
            Long b = array[i];
            result[i] = b == null ? valueForNull : b;
        }
        return result;
    }

    public static Long[] toObject(long[] array) {
        if (array == null) {
            return null;
        }
        if (array.length == 0) {
            return new Long[0];
        }
        Long[] result = new Long[array.length];
        for (int i = 0; i < array.length; ++i) {
            result[i] = new Long(array[i]);
        }
        return result;
    }

    public static int[] toPrimitive(Integer[] array) {
        if (array == null) {
            return null;
        }
        if (array.length == 0) {
            return new int[0];
        }
        int[] result = new int[array.length];
        for (int i = 0; i < array.length; ++i) {
            result[i] = array[i];
        }
        return result;
    }

    public static int[] toPrimitive(Integer[] array, int valueForNull) {
        if (array == null) {
            return null;
        }
        if (array.length == 0) {
            return new int[0];
        }
        int[] result = new int[array.length];
        for (int i = 0; i < array.length; ++i) {
            Integer b = array[i];
            result[i] = b == null ? valueForNull : b;
        }
        return result;
    }

    public static Integer[] toObject(int[] array) {
        if (array == null) {
            return null;
        }
        if (array.length == 0) {
            return new Integer[0];
        }
        Integer[] result = new Integer[array.length];
        for (int i = 0; i < array.length; ++i) {
            result[i] = new Integer(array[i]);
        }
        return result;
    }

    public static short[] toPrimitive(Short[] array) {
        if (array == null) {
            return null;
        }
        if (array.length == 0) {
            return new short[0];
        }
        short[] result = new short[array.length];
        for (int i = 0; i < array.length; ++i) {
            result[i] = array[i];
        }
        return result;
    }

    public static short[] toPrimitive(Short[] array, short valueForNull) {
        if (array == null) {
            return null;
        }
        if (array.length == 0) {
            return new short[0];
        }
        short[] result = new short[array.length];
        for (int i = 0; i < array.length; ++i) {
            Short b = array[i];
            result[i] = b == null ? valueForNull : b;
        }
        return result;
    }

    public static Short[] toObject(short[] array) {
        if (array == null) {
            return null;
        }
        if (array.length == 0) {
            return new Short[0];
        }
        Short[] result = new Short[array.length];
        for (int i = 0; i < array.length; ++i) {
            result[i] = new Short(array[i]);
        }
        return result;
    }

    public static byte[] toPrimitive(Byte[] array) {
        if (array == null) {
            return null;
        }
        if (array.length == 0) {
            return new byte[0];
        }
        byte[] result = new byte[array.length];
        for (int i = 0; i < array.length; ++i) {
            result[i] = array[i];
        }
        return result;
    }

    public static byte[] toPrimitive(Byte[] array, byte valueForNull) {
        if (array == null) {
            return null;
        }
        if (array.length == 0) {
            return new byte[0];
        }
        byte[] result = new byte[array.length];
        for (int i = 0; i < array.length; ++i) {
            Byte b = array[i];
            result[i] = b == null ? valueForNull : b;
        }
        return result;
    }

    public static Byte[] toObject(byte[] array) {
        if (array == null) {
            return null;
        }
        if (array.length == 0) {
            return new Byte[0];
        }
        Byte[] result = new Byte[array.length];
        for (int i = 0; i < array.length; ++i) {
            result[i] = new Byte(array[i]);
        }
        return result;
    }

    public static double[] toPrimitive(Double[] array) {
        if (array == null) {
            return null;
        }
        if (array.length == 0) {
            return new double[0];
        }
        double[] result = new double[array.length];
        for (int i = 0; i < array.length; ++i) {
            result[i] = array[i];
        }
        return result;
    }

    public static double[] toPrimitive(Double[] array, double valueForNull) {
        if (array == null) {
            return null;
        }
        if (array.length == 0) {
            return new double[0];
        }
        double[] result = new double[array.length];
        for (int i = 0; i < array.length; ++i) {
            Double b = array[i];
            result[i] = b == null ? valueForNull : b;
        }
        return result;
    }

    public static Double[] toObject(double[] array) {
        if (array == null) {
            return null;
        }
        if (array.length == 0) {
            return new Double[0];
        }
        Double[] result = new Double[array.length];
        for (int i = 0; i < array.length; ++i) {
            result[i] = new Double(array[i]);
        }
        return result;
    }

    public static float[] toPrimitive(Float[] array) {
        if (array == null) {
            return null;
        }
        if (array.length == 0) {
            return new float[0];
        }
        float[] result = new float[array.length];
        for (int i = 0; i < array.length; ++i) {
            result[i] = array[i].floatValue();
        }
        return result;
    }

    public static float[] toPrimitive(Float[] array, float valueForNull) {
        if (array == null) {
            return null;
        }
        if (array.length == 0) {
            return new float[0];
        }
        float[] result = new float[array.length];
        for (int i = 0; i < array.length; ++i) {
            Float b = array[i];
            result[i] = b == null ? valueForNull : b.floatValue();
        }
        return result;
    }

    public static Float[] toObject(float[] array) {
        if (array == null) {
            return null;
        }
        if (array.length == 0) {
            return new Float[0];
        }
        Float[] result = new Float[array.length];
        for (int i = 0; i < array.length; ++i) {
            result[i] = new Float(array[i]);
        }
        return result;
    }

    public static boolean[] toPrimitive(Boolean[] array) {
        if (array == null) {
            return null;
        }
        if (array.length == 0) {
            return new boolean[0];
        }
        boolean[] result = new boolean[array.length];
        for (int i = 0; i < array.length; ++i) {
            result[i] = array[i];
        }
        return result;
    }

    public static boolean[] toPrimitive(Boolean[] array, boolean valueForNull) {
        if (array == null) {
            return null;
        }
        if (array.length == 0) {
            return new boolean[0];
        }
        boolean[] result = new boolean[array.length];
        for (int i = 0; i < array.length; ++i) {
            Boolean b = array[i];
            result[i] = b == null ? valueForNull : b;
        }
        return result;
    }

    public static Boolean[] toObject(boolean[] array) {
        if (array == null) {
            return null;
        }
        if (array.length == 0) {
            return new Boolean[0];
        }
        Boolean[] result = new Boolean[array.length];
        for (int i = 0; i < array.length; ++i) {
            result[i] = array[i] ? Boolean.TRUE : Boolean.FALSE;
        }
        return result;
    }

    public static <T> List<T> asList(T ... array) {
        if (array == null || array.length == 0) {
            return Collections.emptyList();
        }
        return Arrays.asList(array);
    }

    public static <T> List<T> asUnmodifiableList(T ... array) {
        return Collections.unmodifiableList(ArrayUtils.asList(array));
    }

    public static <T> List<T> asArrayList(T ... array) {
        ArrayList<T> list = new ArrayList<T>();
        if (array == null || array.length == 0) {
            return list;
        }
        list.addAll(Arrays.asList(array));
        return list;
    }

    public static <T> List<T> asLinkedList(T ... array) {
        LinkedList<T> list = new LinkedList<T>();
        if (array == null || array.length == 0) {
            return list;
        }
        list.addAll(Arrays.asList(array));
        return list;
    }

    public static <T> void sort(T[] array, Comparator<? super T> c) {
        if (array == null || array.length < 2) {
            return;
        }
        Arrays.sort(array, c);
    }

    public static void sort(byte[] array) {
        if (array == null || array.length < 2) {
            return;
        }
        Arrays.sort(array);
    }

    public static void sort(char[] array) {
        if (array == null || array.length < 2) {
            return;
        }
        Arrays.sort(array);
    }

    public static void sort(double[] array) {
        if (array == null || array.length < 2) {
            return;
        }
        Arrays.sort(array);
    }

    public static void sort(float[] array) {
        if (array == null || array.length < 2) {
            return;
        }
        Arrays.sort(array);
    }

    public static void sort(int[] array) {
        if (array == null || array.length < 2) {
            return;
        }
        Arrays.sort(array);
    }

    public static void sort(long[] array) {
        if (array == null || array.length < 2) {
            return;
        }
        Arrays.sort(array);
    }

    public static void sort(short[] array) {
        if (array == null || array.length < 2) {
            return;
        }
        Arrays.sort(array);
    }

    public static <E> void forAllDo(Object array, Closure<E> closure) {
        if (array == null || closure == null) {
            return;
        }
        if (array instanceof Object[]) {
            Object[] objects = (Object[])array;
            int length = objects.length;
            for (int i = 0; i < length; ++i) {
                Object ele = objects[i];
                closure.execute(i, ele);
            }
        } else if (array instanceof boolean[]) {
            boolean[] booleans = (boolean[])array;
            int length = booleans.length;
            for (int i = 0; i < length; ++i) {
                boolean ele = booleans[i];
                closure.execute(i, ele ? Boolean.TRUE : Boolean.FALSE);
            }
        } else if (array instanceof byte[]) {
            byte[] bytes = (byte[])array;
            int length = bytes.length;
            for (int i = 0; i < length; ++i) {
                byte ele = bytes[i];
                closure.execute(i, ele);
            }
        } else if (array instanceof char[]) {
            char[] chars = (char[])array;
            int length = chars.length;
            for (int i = 0; i < length; ++i) {
                char ele = chars[i];
                closure.execute(i, Character.valueOf(ele));
            }
        } else if (array instanceof short[]) {
            short[] shorts = (short[])array;
            int length = shorts.length;
            for (int i = 0; i < length; ++i) {
                short ele = shorts[i];
                closure.execute(i, ele);
            }
        } else if (array instanceof int[]) {
            int[] ints = (int[])array;
            int length = ints.length;
            for (int i = 0; i < length; ++i) {
                int ele = ints[i];
                closure.execute(i, ele);
            }
        } else if (array instanceof long[]) {
            long[] longs = (long[])array;
            int length = longs.length;
            for (int i = 0; i < length; ++i) {
                long ele = longs[i];
                closure.execute(i, ele);
            }
        } else if (array instanceof float[]) {
            float[] floats = (float[])array;
            int length = floats.length;
            for (int i = 0; i < length; ++i) {
                float ele = floats[i];
                closure.execute(i, Float.valueOf(ele));
            }
        } else if (array instanceof double[]) {
            double[] doubles = (double[])array;
            int length = doubles.length;
            for (int i = 0; i < length; ++i) {
                double ele = doubles[i];
                closure.execute(i, ele);
            }
        } else {
            throw new IllegalArgumentException("Not an array: " + array.getClass());
        }
    }

    public static String toString(Object array) {
        if (array == null) {
            return "null";
        }
        if (array instanceof Object[]) {
            return Arrays.deepToString((Object[])array);
        }
        if (array instanceof boolean[]) {
            return Arrays.toString((boolean[])array);
        }
        if (array instanceof byte[]) {
            return Arrays.toString((byte[])array);
        }
        if (array instanceof char[]) {
            return Arrays.toString((char[])array);
        }
        if (array instanceof double[]) {
            return Arrays.toString((double[])array);
        }
        if (array instanceof float[]) {
            return Arrays.toString((float[])array);
        }
        if (array instanceof int[]) {
            return Arrays.toString((int[])array);
        }
        if (array instanceof long[]) {
            return Arrays.toString((long[])array);
        }
        if (array instanceof short[]) {
            return Arrays.toString((short[])array);
        }
        throw new IllegalArgumentException("Array has incompatible type: " + array.getClass());
    }

    public static interface Closure<E> {
        public void execute(int var1, E var2);
    }
}

