/*
 * Decompiled with CFR 0.152.
 */
package com.blankj.utilcode.util;

import android.animation.ValueAnimator;
import android.annotation.SuppressLint;
import android.app.Activity;
import android.app.ActivityManager;
import android.app.Application;
import android.content.Context;
import android.content.Intent;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.os.Process;
import android.text.TextUtils;
import android.util.Log;
import android.view.MotionEvent;
import android.view.View;
import android.view.Window;
import android.view.WindowManager;
import android.view.inputmethod.InputMethodManager;
import androidx.annotation.Nullable;
import androidx.core.content.FileProvider;
import androidx.fragment.app.FragmentActivity;
import com.blankj.utilcode.util.AdaptScreenUtils;
import com.blankj.utilcode.util.LanguageUtils;
import com.blankj.utilcode.util.SPUtils;
import com.blankj.utilcode.util.ThreadUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutorService;

public final class Utils {
    private static final ActivityLifecycleImpl ACTIVITY_LIFECYCLE = new ActivityLifecycleImpl();
    private static final ExecutorService UTIL_POOL = ThreadUtils.getCachedPool();
    private static final Handler UTIL_HANDLER = new Handler(Looper.getMainLooper());
    @SuppressLint(value={"StaticFieldLeak"})
    private static Application sApplication;

    private Utils() {
        throw new UnsupportedOperationException("u can't instantiate me...");
    }

    public static void init(Context context) {
        if (context == null) {
            Utils.init(Utils.getApplicationByReflect());
            return;
        }
        Utils.init((Application)context.getApplicationContext());
    }

    public static void init(Application app) {
        if (sApplication == null) {
            sApplication = app == null ? Utils.getApplicationByReflect() : app;
            sApplication.registerActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)ACTIVITY_LIFECYCLE);
            UTIL_POOL.execute(new Runnable(){

                @Override
                public void run() {
                    AdaptScreenUtils.preLoad();
                }
            });
        } else if (app != null && app.getClass() != sApplication.getClass()) {
            sApplication.unregisterActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)ACTIVITY_LIFECYCLE);
            Utils.ACTIVITY_LIFECYCLE.mActivityList.clear();
            sApplication = app;
            sApplication.registerActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)ACTIVITY_LIFECYCLE);
        }
    }

    public static Application getApp() {
        if (sApplication != null) {
            return sApplication;
        }
        Application app = Utils.getApplicationByReflect();
        Utils.init(app);
        return app;
    }

    static ActivityLifecycleImpl getActivityLifecycle() {
        return ACTIVITY_LIFECYCLE;
    }

    static LinkedList<Activity> getActivityList() {
        return Utils.ACTIVITY_LIFECYCLE.mActivityList;
    }

    static Context getTopActivityOrApp() {
        if (Utils.isAppForeground()) {
            Activity topActivity = ACTIVITY_LIFECYCLE.getTopActivity();
            return topActivity == null ? Utils.getApp() : topActivity;
        }
        return Utils.getApp();
    }

    static boolean isAppForeground() {
        ActivityManager am = (ActivityManager)Utils.getApp().getSystemService("activity");
        if (am == null) {
            return false;
        }
        List info = am.getRunningAppProcesses();
        if (info == null || info.size() == 0) {
            return false;
        }
        for (ActivityManager.RunningAppProcessInfo aInfo : info) {
            if (aInfo.importance != 100 || !aInfo.processName.equals(Utils.getApp().getPackageName())) continue;
            return true;
        }
        return false;
    }

    static <T> Task<T> doAsync(Task<T> task) {
        UTIL_POOL.execute(task);
        return task;
    }

    public static void runOnUiThread(Runnable runnable) {
        if (Looper.myLooper() == Looper.getMainLooper()) {
            runnable.run();
        } else {
            UTIL_HANDLER.post(runnable);
        }
    }

    public static void runOnUiThreadDelayed(Runnable runnable, long delayMillis) {
        UTIL_HANDLER.postDelayed(runnable, delayMillis);
    }

    static String getCurrentProcessName() {
        String name = Utils.getCurrentProcessNameByFile();
        if (!TextUtils.isEmpty((CharSequence)name)) {
            return name;
        }
        name = Utils.getCurrentProcessNameByAms();
        if (!TextUtils.isEmpty((CharSequence)name)) {
            return name;
        }
        name = Utils.getCurrentProcessNameByReflect();
        return name;
    }

    static void fixSoftInputLeaks(Window window) {
        String[] leakViews;
        InputMethodManager imm = (InputMethodManager)Utils.getApp().getSystemService("input_method");
        if (imm == null) {
            return;
        }
        for (String leakView : leakViews = new String[]{"mLastSrvView", "mCurRootView", "mServedView", "mNextServedView"}) {
            try {
                View view;
                Object obj;
                Field leakViewField = InputMethodManager.class.getDeclaredField(leakView);
                if (!leakViewField.isAccessible()) {
                    leakViewField.setAccessible(true);
                }
                if (!((obj = leakViewField.get(imm)) instanceof View) || (view = (View)obj).getRootView() != window.getDecorView().getRootView()) continue;
                leakViewField.set(imm, null);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    static SPUtils getSpUtils4Utils() {
        return SPUtils.getInstance("Utils");
    }

    private static String getCurrentProcessNameByFile() {
        try {
            File file = new File("/proc/" + Process.myPid() + "/cmdline");
            BufferedReader mBufferedReader = new BufferedReader(new FileReader(file));
            String processName = mBufferedReader.readLine().trim();
            mBufferedReader.close();
            return processName;
        }
        catch (Exception e) {
            e.printStackTrace();
            return "";
        }
    }

    private static String getCurrentProcessNameByAms() {
        ActivityManager am = (ActivityManager)Utils.getApp().getSystemService("activity");
        if (am == null) {
            return "";
        }
        List info = am.getRunningAppProcesses();
        if (info == null || info.size() == 0) {
            return "";
        }
        int pid = Process.myPid();
        for (ActivityManager.RunningAppProcessInfo aInfo : info) {
            if (aInfo.pid != pid || aInfo.processName == null) continue;
            return aInfo.processName;
        }
        return "";
    }

    private static String getCurrentProcessNameByReflect() {
        String processName = "";
        try {
            Application app = Utils.getApp();
            Field loadedApkField = app.getClass().getField("mLoadedApk");
            loadedApkField.setAccessible(true);
            Object loadedApk = loadedApkField.get(app);
            Field activityThreadField = loadedApk.getClass().getDeclaredField("mActivityThread");
            activityThreadField.setAccessible(true);
            Object activityThread = activityThreadField.get(loadedApk);
            Method getProcessName = activityThread.getClass().getDeclaredMethod("getProcessName", new Class[0]);
            processName = (String)getProcessName.invoke(activityThread, new Object[0]);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return processName;
    }

    private static Application getApplicationByReflect() {
        try {
            Class<?> activityThread = Class.forName("android.app.ActivityThread");
            Object thread = activityThread.getMethod("currentActivityThread", new Class[0]).invoke(null, new Object[0]);
            Object app = activityThread.getMethod("getApplication", new Class[0]).invoke(thread, new Object[0]);
            if (app == null) {
                throw new NullPointerException("u should init first");
            }
            return (Application)app;
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        throw new NullPointerException("u should init first");
    }

    private static void setAnimatorsEnabled() {
        if (Build.VERSION.SDK_INT >= 26 && ValueAnimator.areAnimatorsEnabled()) {
            return;
        }
        try {
            Field sDurationScaleField = ValueAnimator.class.getDeclaredField("sDurationScale");
            sDurationScaleField.setAccessible(true);
            float sDurationScale = ((Float)sDurationScaleField.get(null)).floatValue();
            if (sDurationScale == 0.0f) {
                sDurationScaleField.set(null, Float.valueOf(1.0f));
                Log.i((String)"Utils", (String)"setAnimatorsEnabled: Animators are enabled now!");
            }
        }
        catch (NoSuchFieldException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
    }

    public static interface Func1<Ret, Par> {
        public Ret call(Par var1);
    }

    public static interface OnActivityDestroyedListener {
        public void onActivityDestroyed(Activity var1);
    }

    public static interface OnAppStatusChangedListener {
        public void onForeground(Activity var1);

        public void onBackground(Activity var1);
    }

    public static interface Callback<T> {
        public void onCall(T var1);
    }

    public static abstract class Task<Result>
    implements Runnable {
        private static final int NEW = 0;
        private static final int COMPLETING = 1;
        private static final int CANCELLED = 2;
        private static final int EXCEPTIONAL = 3;
        private volatile int state = 0;
        private Callback<Result> mCallback;

        abstract Result doInBackground();

        public Task(Callback<Result> callback) {
            this.mCallback = callback;
        }

        @Override
        public void run() {
            try {
                final Result t = this.doInBackground();
                if (this.state != 0) {
                    return;
                }
                this.state = 1;
                UTIL_HANDLER.post(new Runnable(){

                    @Override
                    public void run() {
                        Task.this.mCallback.onCall(t);
                    }
                });
            }
            catch (Throwable th) {
                if (this.state != 0) {
                    return;
                }
                this.state = 3;
            }
        }

        public void cancel() {
            this.state = 2;
        }

        public boolean isDone() {
            return this.state != 0;
        }

        public boolean isCanceled() {
            return this.state == 2;
        }
    }

    public static final class FileProvider4UtilCode
    extends FileProvider {
        public boolean onCreate() {
            Utils.init(this.getContext());
            try {
                Class.forName("com.blankj.utildebug.DebugUtils");
            }
            catch (Exception exception) {
                // empty catch block
            }
            return true;
        }
    }

    static class ActivityLifecycleImpl
    implements Application.ActivityLifecycleCallbacks {
        final LinkedList<Activity> mActivityList = new LinkedList();
        final List<OnAppStatusChangedListener> mStatusListeners = new ArrayList<OnAppStatusChangedListener>();
        final Map<Activity, List<OnActivityDestroyedListener>> mDestroyedListenerMap = new HashMap<Activity, List<OnActivityDestroyedListener>>();
        private int mForegroundCount = 0;
        private int mConfigCount = 0;
        private boolean mIsBackground = false;

        ActivityLifecycleImpl() {
        }

        public void onActivityCreated(Activity activity, Bundle savedInstanceState) {
            LanguageUtils.applyLanguage(activity);
            Utils.setAnimatorsEnabled();
            this.setTopActivity(activity);
        }

        public void onActivityStarted(Activity activity) {
            if (!this.mIsBackground) {
                this.setTopActivity(activity);
            }
            if (this.mConfigCount < 0) {
                ++this.mConfigCount;
            } else {
                ++this.mForegroundCount;
            }
        }

        public void onActivityResumed(Activity activity) {
            this.setTopActivity(activity);
            if (this.mIsBackground) {
                this.mIsBackground = false;
                this.postStatus(activity, true);
            }
            this.processHideSoftInputOnActivityDestroy(activity, false);
        }

        public void onActivityPaused(Activity activity) {
        }

        public void onActivityStopped(Activity activity) {
            if (activity.isChangingConfigurations()) {
                --this.mConfigCount;
            } else {
                --this.mForegroundCount;
                if (this.mForegroundCount <= 0) {
                    this.mIsBackground = true;
                    this.postStatus(activity, false);
                }
            }
            this.processHideSoftInputOnActivityDestroy(activity, true);
        }

        public void onActivitySaveInstanceState(Activity activity, Bundle outState) {
        }

        public void onActivityDestroyed(Activity activity) {
            this.mActivityList.remove(activity);
            this.consumeOnActivityDestroyedListener(activity);
            Utils.fixSoftInputLeaks(activity.getWindow());
        }

        Activity getTopActivity() {
            Activity topActivityByReflect;
            if (!this.mActivityList.isEmpty()) {
                for (int i = this.mActivityList.size() - 1; i >= 0; --i) {
                    Activity activity = this.mActivityList.get(i);
                    if (activity == null || activity.isFinishing() || Build.VERSION.SDK_INT >= 17 && activity.isDestroyed()) continue;
                    return activity;
                }
            }
            if ((topActivityByReflect = this.getTopActivityByReflect()) != null) {
                this.setTopActivity(topActivityByReflect);
            }
            return topActivityByReflect;
        }

        void addOnAppStatusChangedListener(OnAppStatusChangedListener listener) {
            this.mStatusListeners.add(listener);
        }

        void removeOnAppStatusChangedListener(OnAppStatusChangedListener listener) {
            this.mStatusListeners.remove(listener);
        }

        void removeOnActivityDestroyedListener(Activity activity) {
            if (activity == null) {
                return;
            }
            this.mDestroyedListenerMap.remove(activity);
        }

        void addOnActivityDestroyedListener(Activity activity, OnActivityDestroyedListener listener) {
            if (activity == null || listener == null) {
                return;
            }
            List<OnActivityDestroyedListener> listeners = this.mDestroyedListenerMap.get(activity);
            if (listeners == null) {
                listeners = new CopyOnWriteArrayList<OnActivityDestroyedListener>();
                this.mDestroyedListenerMap.put(activity, listeners);
            } else if (listeners.contains(listener)) {
                return;
            }
            listeners.add(listener);
        }

        private void processHideSoftInputOnActivityDestroy(final Activity activity, boolean isSave) {
            if (isSave) {
                WindowManager.LayoutParams attrs = activity.getWindow().getAttributes();
                int softInputMode = attrs.softInputMode;
                activity.getWindow().getDecorView().setTag(-123, (Object)softInputMode);
                activity.getWindow().setSoftInputMode(3);
            } else {
                final Object tag = activity.getWindow().getDecorView().getTag(-123);
                if (!(tag instanceof Integer)) {
                    return;
                }
                Utils.runOnUiThreadDelayed(new Runnable(){

                    @Override
                    public void run() {
                        Window window = activity.getWindow();
                        if (window != null) {
                            window.setSoftInputMode(((Integer)tag).intValue());
                        }
                    }
                }, 100L);
            }
        }

        private void postStatus(Activity activity, boolean isForeground) {
            if (this.mStatusListeners.isEmpty()) {
                return;
            }
            for (OnAppStatusChangedListener statusListener : this.mStatusListeners) {
                if (isForeground) {
                    statusListener.onForeground(activity);
                    continue;
                }
                statusListener.onBackground(activity);
            }
        }

        private void setTopActivity(Activity activity) {
            if (this.mActivityList.contains(activity)) {
                if (!this.mActivityList.getLast().equals(activity)) {
                    this.mActivityList.remove(activity);
                    this.mActivityList.addLast(activity);
                }
            } else {
                this.mActivityList.addLast(activity);
            }
        }

        private void consumeOnActivityDestroyedListener(Activity activity) {
            Iterator<Map.Entry<Activity, List<OnActivityDestroyedListener>>> iterator = this.mDestroyedListenerMap.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<Activity, List<OnActivityDestroyedListener>> entry = iterator.next();
                if (entry.getKey() != activity) continue;
                List<OnActivityDestroyedListener> value = entry.getValue();
                for (OnActivityDestroyedListener listener : value) {
                    listener.onActivityDestroyed(activity);
                }
                iterator.remove();
            }
        }

        private Activity getTopActivityByReflect() {
            try {
                Class<?> activityThreadClass = Class.forName("android.app.ActivityThread");
                Object currentActivityThreadMethod = activityThreadClass.getMethod("currentActivityThread", new Class[0]).invoke(null, new Object[0]);
                Field mActivityListField = activityThreadClass.getDeclaredField("mActivityList");
                mActivityListField.setAccessible(true);
                Map activities = (Map)mActivityListField.get(currentActivityThreadMethod);
                if (activities == null) {
                    return null;
                }
                for (Object activityRecord : activities.values()) {
                    Class<?> activityRecordClass = activityRecord.getClass();
                    Field pausedField = activityRecordClass.getDeclaredField("paused");
                    pausedField.setAccessible(true);
                    if (pausedField.getBoolean(activityRecord)) continue;
                    Field activityField = activityRecordClass.getDeclaredField("activity");
                    activityField.setAccessible(true);
                    return (Activity)activityField.get(activityRecord);
                }
            }
            catch (Exception e) {
                Log.e((String)"Utils", (String)e.getMessage());
            }
            return null;
        }
    }

    public static final class TransActivity
    extends FragmentActivity {
        private static final Map<TransActivity, TransActivityDelegate> CALLBACK_MAP = new HashMap<TransActivity, TransActivityDelegate>();
        private static TransActivityDelegate sDelegate;

        public static void start(Func1<Void, Intent> consumer, TransActivityDelegate delegate) {
            if (delegate == null) {
                return;
            }
            Intent starter = new Intent((Context)Utils.getApp(), TransActivity.class);
            starter.addFlags(0x10000000);
            if (consumer != null) {
                consumer.call(starter);
            }
            Utils.getApp().startActivity(starter);
            sDelegate = delegate;
        }

        protected void onCreate(@Nullable Bundle savedInstanceState) {
            this.overridePendingTransition(0, 0);
            if (sDelegate == null) {
                super.onCreate(savedInstanceState);
                this.finish();
                return;
            }
            CALLBACK_MAP.put(this, sDelegate);
            sDelegate.onCreateBefore((Activity)this, savedInstanceState);
            super.onCreate(savedInstanceState);
            sDelegate.onCreated((Activity)this, savedInstanceState);
            sDelegate = null;
        }

        protected void onStart() {
            super.onStart();
            TransActivityDelegate callback = CALLBACK_MAP.get((Object)this);
            if (callback == null) {
                return;
            }
            callback.onStarted((Activity)this);
        }

        protected void onResume() {
            super.onResume();
            TransActivityDelegate callback = CALLBACK_MAP.get((Object)this);
            if (callback == null) {
                return;
            }
            callback.onResumed((Activity)this);
        }

        protected void onPause() {
            this.overridePendingTransition(0, 0);
            super.onPause();
            TransActivityDelegate callback = CALLBACK_MAP.get((Object)this);
            if (callback == null) {
                return;
            }
            callback.onPaused((Activity)this);
        }

        protected void onStop() {
            super.onStop();
            TransActivityDelegate callback = CALLBACK_MAP.get((Object)this);
            if (callback == null) {
                return;
            }
            callback.onStopped((Activity)this);
        }

        protected void onSaveInstanceState(Bundle outState) {
            super.onSaveInstanceState(outState);
            TransActivityDelegate callback = CALLBACK_MAP.get((Object)this);
            if (callback == null) {
                return;
            }
            callback.onSaveInstanceState((Activity)this, outState);
        }

        protected void onDestroy() {
            super.onDestroy();
            TransActivityDelegate callback = CALLBACK_MAP.get((Object)this);
            if (callback == null) {
                return;
            }
            callback.onDestroy((Activity)this);
            CALLBACK_MAP.remove((Object)this);
        }

        public void onRequestPermissionsResult(int requestCode, String[] permissions, int[] grantResults) {
            super.onRequestPermissionsResult(requestCode, permissions, grantResults);
            TransActivityDelegate callback = CALLBACK_MAP.get((Object)this);
            if (callback == null) {
                return;
            }
            callback.onRequestPermissionsResult((Activity)this, requestCode, permissions, grantResults);
        }

        protected void onActivityResult(int requestCode, int resultCode, Intent data) {
            super.onActivityResult(requestCode, resultCode, data);
            TransActivityDelegate callback = CALLBACK_MAP.get((Object)this);
            if (callback == null) {
                return;
            }
            callback.onActivityResult((Activity)this, requestCode, resultCode, data);
        }

        public boolean dispatchTouchEvent(MotionEvent ev) {
            TransActivityDelegate callback = CALLBACK_MAP.get((Object)this);
            if (callback == null) {
                return super.dispatchTouchEvent(ev);
            }
            if (callback.dispatchTouchEvent((Activity)this, ev)) {
                return true;
            }
            return super.dispatchTouchEvent(ev);
        }

        public static abstract class TransActivityDelegate {
            public void onCreateBefore(Activity activity, @Nullable Bundle savedInstanceState) {
            }

            public void onCreated(Activity activity, @Nullable Bundle savedInstanceState) {
            }

            public void onStarted(Activity activity) {
            }

            public void onDestroy(Activity activity) {
            }

            public void onResumed(Activity activity) {
            }

            public void onPaused(Activity activity) {
            }

            public void onStopped(Activity activity) {
            }

            public void onSaveInstanceState(Activity activity, Bundle outState) {
            }

            public void onRequestPermissionsResult(Activity activity, int requestCode, String[] permissions, int[] grantResults) {
            }

            public void onActivityResult(Activity activity, int requestCode, int resultCode, Intent data) {
            }

            public boolean dispatchTouchEvent(Activity activity, MotionEvent ev) {
                return false;
            }
        }
    }
}

