/*
 * Decompiled with CFR 0.152.
 */
package com.blankj.utilcode.util;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.content.Context;
import android.graphics.ColorFilter;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffColorFilter;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.os.Handler;
import android.os.Message;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowManager;
import android.widget.TextView;
import android.widget.Toast;
import androidx.annotation.ColorInt;
import androidx.annotation.DrawableRes;
import androidx.annotation.LayoutRes;
import androidx.annotation.StringRes;
import androidx.core.app.NotificationManagerCompat;
import com.blankj.utilcode.util.Utils;
import java.lang.reflect.Field;

public final class ToastUtils {
    private static final int COLOR_DEFAULT = -16777217;
    private static final String NULL = "null";
    private static IToast iToast;
    private static int sGravity;
    private static int sXOffset;
    private static int sYOffset;
    private static int sBgColor;
    private static int sBgResource;
    private static int sMsgColor;
    private static int sMsgTextSize;

    private ToastUtils() {
        throw new UnsupportedOperationException("u can't instantiate me...");
    }

    public static void setGravity(int gravity, int xOffset, int yOffset) {
        sGravity = gravity;
        sXOffset = xOffset;
        sYOffset = yOffset;
    }

    public static void setBgColor(@ColorInt int backgroundColor) {
        sBgColor = backgroundColor;
    }

    public static void setBgResource(@DrawableRes int bgResource) {
        sBgResource = bgResource;
    }

    public static void setMsgColor(@ColorInt int msgColor) {
        sMsgColor = msgColor;
    }

    public static void setMsgTextSize(int textSize) {
        sMsgTextSize = textSize;
    }

    public static void showShort(CharSequence text) {
        ToastUtils.show(text == null ? NULL : text, 0);
    }

    public static void showShort(@StringRes int resId) {
        ToastUtils.show(resId, 0);
    }

    public static void showShort(@StringRes int resId, Object ... args) {
        ToastUtils.show(resId, 0, args);
    }

    public static void showShort(String format, Object ... args) {
        ToastUtils.show(format, 0, args);
    }

    public static void showLong(CharSequence text) {
        ToastUtils.show(text == null ? NULL : text, 1);
    }

    public static void showLong(@StringRes int resId) {
        ToastUtils.show(resId, 1);
    }

    public static void showLong(@StringRes int resId, Object ... args) {
        ToastUtils.show(resId, 1, args);
    }

    public static void showLong(String format, Object ... args) {
        ToastUtils.show(format, 1, args);
    }

    public static View showCustomShort(@LayoutRes int layoutId) {
        return ToastUtils.showCustomShort(ToastUtils.getView(layoutId));
    }

    public static View showCustomShort(View view) {
        ToastUtils.show(view, 0);
        return view;
    }

    public static View showCustomLong(@LayoutRes int layoutId) {
        return ToastUtils.showCustomLong(ToastUtils.getView(layoutId));
    }

    public static View showCustomLong(View view) {
        ToastUtils.show(view, 1);
        return view;
    }

    public static void cancel() {
        if (iToast != null) {
            iToast.cancel();
        }
    }

    private static void show(int resId, int duration) {
        ToastUtils.show(resId, duration, new Object[]{null});
    }

    private static void show(int resId, int duration, Object ... args) {
        try {
            CharSequence text = Utils.getApp().getResources().getText(resId);
            if (args != null) {
                text = String.format(text.toString(), args);
            }
            ToastUtils.show(text, duration);
        }
        catch (Exception ignore) {
            ToastUtils.show(String.valueOf(resId), duration);
        }
    }

    private static void show(String format, int duration, Object ... args) {
        String text = format;
        if (text == null) {
            text = NULL;
        } else if (args != null) {
            text = String.format(format, args);
        }
        ToastUtils.show(text, duration);
    }

    private static void show(final CharSequence text, final int duration) {
        Utils.runOnUiThread(new Runnable(){

            @Override
            @SuppressLint(value={"ShowToast"})
            public void run() {
                ToastUtils.cancel();
                iToast = ToastFactory.makeToast((Context)Utils.getApp(), text, duration);
                View toastView = iToast.getView();
                if (toastView == null) {
                    return;
                }
                TextView tvMessage = (TextView)toastView.findViewById(16908299);
                if (sMsgColor != -16777217) {
                    tvMessage.setTextColor(sMsgColor);
                }
                if (sMsgTextSize != -1) {
                    tvMessage.setTextSize((float)sMsgTextSize);
                }
                if (sGravity != -1 || sXOffset != -1 || sYOffset != -1) {
                    iToast.setGravity(sGravity, sXOffset, sYOffset);
                }
                ToastUtils.setBg(tvMessage);
                iToast.show();
            }
        });
    }

    private static void show(final View view, final int duration) {
        Utils.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                ToastUtils.cancel();
                iToast = ToastFactory.newToast((Context)Utils.getApp());
                iToast.setView(view);
                iToast.setDuration(duration);
                if (sGravity != -1 || sXOffset != -1 || sYOffset != -1) {
                    iToast.setGravity(sGravity, sXOffset, sYOffset);
                }
                ToastUtils.setBg();
                iToast.show();
            }
        });
    }

    private static void setBg() {
        if (sBgResource != -1) {
            View toastView = iToast.getView();
            toastView.setBackgroundResource(sBgResource);
        } else if (sBgColor != -16777217) {
            View toastView = iToast.getView();
            Drawable background = toastView.getBackground();
            if (background != null) {
                background.setColorFilter((ColorFilter)new PorterDuffColorFilter(sBgColor, PorterDuff.Mode.SRC_IN));
            } else if (Build.VERSION.SDK_INT >= 16) {
                toastView.setBackground((Drawable)new ColorDrawable(sBgColor));
            } else {
                toastView.setBackgroundDrawable((Drawable)new ColorDrawable(sBgColor));
            }
        }
    }

    private static void setBg(TextView tvMsg) {
        if (sBgResource != -1) {
            View toastView = iToast.getView();
            toastView.setBackgroundResource(sBgResource);
            tvMsg.setBackgroundColor(0);
        } else if (sBgColor != -16777217) {
            View toastView = iToast.getView();
            Drawable tvBg = toastView.getBackground();
            Drawable msgBg = tvMsg.getBackground();
            if (tvBg != null && msgBg != null) {
                tvBg.setColorFilter((ColorFilter)new PorterDuffColorFilter(sBgColor, PorterDuff.Mode.SRC_IN));
                tvMsg.setBackgroundColor(0);
            } else if (tvBg != null) {
                tvBg.setColorFilter((ColorFilter)new PorterDuffColorFilter(sBgColor, PorterDuff.Mode.SRC_IN));
            } else if (msgBg != null) {
                msgBg.setColorFilter((ColorFilter)new PorterDuffColorFilter(sBgColor, PorterDuff.Mode.SRC_IN));
            } else {
                toastView.setBackgroundColor(sBgColor);
            }
        }
    }

    private static View getView(@LayoutRes int layoutId) {
        LayoutInflater inflate = (LayoutInflater)Utils.getApp().getSystemService("layout_inflater");
        return inflate.inflate(layoutId, null);
    }

    static {
        sGravity = -1;
        sXOffset = -1;
        sYOffset = -1;
        sBgColor = -16777217;
        sBgResource = -1;
        sMsgColor = -16777217;
        sMsgTextSize = -1;
    }

    static interface IToast {
        public void show();

        public void cancel();

        public void setView(View var1);

        public View getView();

        public void setDuration(int var1);

        public void setGravity(int var1, int var2, int var3);

        public void setText(@StringRes int var1);

        public void setText(CharSequence var1);
    }

    static abstract class AbsToast
    implements IToast {
        Toast mToast;

        AbsToast(Toast toast) {
            this.mToast = toast;
        }

        @Override
        public void setView(View view) {
            this.mToast.setView(view);
        }

        @Override
        public View getView() {
            return this.mToast.getView();
        }

        @Override
        public void setDuration(int duration) {
            this.mToast.setDuration(duration);
        }

        @Override
        public void setGravity(int gravity, int xOffset, int yOffset) {
            this.mToast.setGravity(gravity, xOffset, yOffset);
        }

        @Override
        public void setText(int resId) {
            this.mToast.setText(resId);
        }

        @Override
        public void setText(CharSequence s) {
            this.mToast.setText(s);
        }
    }

    static class ToastWithoutNotification
    extends AbsToast {
        private View mView;
        private WindowManager mWM;
        private WindowManager.LayoutParams mParams = new WindowManager.LayoutParams();
        private static final Utils.OnActivityDestroyedListener LISTENER = new Utils.OnActivityDestroyedListener(){

            @Override
            public void onActivityDestroyed(Activity activity) {
                if (iToast == null) {
                    return;
                }
                activity.getWindow().getDecorView().setVisibility(8);
                iToast.cancel();
            }
        };

        ToastWithoutNotification(Toast toast) {
            super(toast);
        }

        @Override
        public void show() {
            Utils.runOnUiThreadDelayed(new Runnable(){

                @Override
                public void run() {
                    ToastWithoutNotification.this.realShow();
                }
            }, 300L);
        }

        private void realShow() {
            if (this.mToast == null) {
                return;
            }
            this.mView = this.mToast.getView();
            if (this.mView == null) {
                return;
            }
            Context context = this.mToast.getView().getContext();
            if (Build.VERSION.SDK_INT < 25) {
                this.mWM = (WindowManager)context.getSystemService("window");
                this.mParams.type = 2005;
            } else {
                Context topActivityOrApp = Utils.getTopActivityOrApp();
                if (!(topActivityOrApp instanceof Activity)) {
                    Log.e((String)"ToastUtils", (String)"Couldn't get top Activity.");
                    return;
                }
                Activity topActivity = (Activity)topActivityOrApp;
                if (topActivity.isFinishing() || topActivity.isDestroyed()) {
                    Log.e((String)"ToastUtils", (String)(topActivity + " is useless"));
                    return;
                }
                this.mWM = topActivity.getWindowManager();
                this.mParams.type = 99;
                Utils.getActivityLifecycle().addOnActivityDestroyedListener(topActivity, LISTENER);
            }
            this.mParams.height = -2;
            this.mParams.width = -2;
            this.mParams.format = -3;
            this.mParams.windowAnimations = 16973828;
            this.mParams.setTitle((CharSequence)"ToastWithoutNotification");
            this.mParams.flags = 152;
            this.mParams.packageName = Utils.getApp().getPackageName();
            this.mParams.gravity = this.mToast.getGravity();
            if ((this.mParams.gravity & 7) == 7) {
                this.mParams.horizontalWeight = 1.0f;
            }
            if ((this.mParams.gravity & 0x70) == 112) {
                this.mParams.verticalWeight = 1.0f;
            }
            this.mParams.x = this.mToast.getXOffset();
            this.mParams.y = this.mToast.getYOffset();
            this.mParams.horizontalMargin = this.mToast.getHorizontalMargin();
            this.mParams.verticalMargin = this.mToast.getVerticalMargin();
            try {
                if (this.mWM != null) {
                    this.mWM.addView(this.mView, (ViewGroup.LayoutParams)this.mParams);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            Utils.runOnUiThreadDelayed(new Runnable(){

                @Override
                public void run() {
                    ToastWithoutNotification.this.cancel();
                }
            }, this.mToast.getDuration() == 0 ? 2000L : 3500L);
        }

        @Override
        public void cancel() {
            try {
                if (this.mWM != null) {
                    this.mWM.removeViewImmediate(this.mView);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.mView = null;
            this.mWM = null;
            this.mToast = null;
        }
    }

    static class SystemToast
    extends AbsToast {
        SystemToast(Toast toast) {
            super(toast);
            if (Build.VERSION.SDK_INT == 25) {
                try {
                    Field mTNField = Toast.class.getDeclaredField("mTN");
                    mTNField.setAccessible(true);
                    Object mTN = mTNField.get(toast);
                    Field mTNmHandlerField = mTNField.getType().getDeclaredField("mHandler");
                    mTNmHandlerField.setAccessible(true);
                    Handler tnHandler = (Handler)mTNmHandlerField.get(mTN);
                    mTNmHandlerField.set(mTN, (Object)new SafeHandler(tnHandler));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }

        @Override
        public void show() {
            this.mToast.show();
        }

        @Override
        public void cancel() {
            this.mToast.cancel();
        }

        static class SafeHandler
        extends Handler {
            private Handler impl;

            SafeHandler(Handler impl) {
                this.impl = impl;
            }

            public void handleMessage(Message msg) {
                this.impl.handleMessage(msg);
            }

            public void dispatchMessage(Message msg) {
                try {
                    this.impl.dispatchMessage(msg);
                }
                catch (Exception e) {
                    Log.e((String)"ToastUtils", (String)e.toString());
                }
            }
        }
    }

    static class ToastFactory {
        ToastFactory() {
        }

        static IToast makeToast(Context context, CharSequence text, int duration) {
            if (NotificationManagerCompat.from((Context)context).areNotificationsEnabled()) {
                return new SystemToast(ToastFactory.makeNormalToast(context, text, duration));
            }
            return new ToastWithoutNotification(ToastFactory.makeNormalToast(context, text, duration));
        }

        static IToast newToast(Context context) {
            if (NotificationManagerCompat.from((Context)context).areNotificationsEnabled()) {
                return new SystemToast(new Toast(context));
            }
            return new ToastWithoutNotification(new Toast(context));
        }

        private static Toast makeNormalToast(Context context, CharSequence text, int duration) {
            Toast toast = Toast.makeText((Context)context, (CharSequence)"", (int)duration);
            toast.setText(text);
            return toast;
        }
    }
}

