/*
 * Decompiled with CFR 0.152.
 */
package com.blankj.utilcode.util;

import android.app.Activity;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.content.res.Configuration;
import android.content.res.Resources;
import android.os.Build;
import android.text.TextUtils;
import android.util.DisplayMetrics;
import android.util.Log;
import androidx.annotation.NonNull;
import com.blankj.utilcode.util.Utils;
import java.util.List;
import java.util.Locale;

public class LanguageUtils {
    private static final String KEY_LOCALE = "KEY_LOCALE";
    private static final String VALUE_FOLLOW_SYSTEM = "VALUE_FOLLOW_SYSTEM";

    private LanguageUtils() {
        throw new UnsupportedOperationException("u can't instantiate me...");
    }

    public static void applySystemLanguageInAppOnCreate() {
        if (LanguageUtils.isAppliedSystemLanguage()) {
            return;
        }
        LanguageUtils.applyLanguage(Resources.getSystem().getConfiguration().locale, "", true, false);
    }

    public static void applyLanguageInAppOnCreate(@NonNull Locale locale) {
        if (locale == null) {
            throw new NullPointerException("Argument 'locale' of type Locale (#0 out of 1, zero-based) is marked by @androidx.annotation.NonNull but got null for it");
        }
        if (LanguageUtils.isAppliedLanguage()) {
            return;
        }
        LanguageUtils.applyLanguage(locale, "", false, false);
    }

    public static void applySystemLanguage(Class<? extends Activity> activityClz) {
        LanguageUtils.applyLanguage(Resources.getSystem().getConfiguration().locale, activityClz, true, true);
    }

    public static void applySystemLanguage(String activityClassName) {
        LanguageUtils.applyLanguage(Resources.getSystem().getConfiguration().locale, activityClassName, true, true);
    }

    public static void applyLanguage(@NonNull Locale locale, Class<? extends Activity> activityClz) {
        if (locale == null) {
            throw new NullPointerException("Argument 'locale' of type Locale (#0 out of 2, zero-based) is marked by @androidx.annotation.NonNull but got null for it");
        }
        LanguageUtils.applyLanguage(locale, activityClz, false, true);
    }

    public static void applyLanguage(@NonNull Locale locale, String activityClassName) {
        if (locale == null) {
            throw new NullPointerException("Argument 'locale' of type Locale (#0 out of 2, zero-based) is marked by @androidx.annotation.NonNull but got null for it");
        }
        LanguageUtils.applyLanguage(locale, activityClassName, false, true);
    }

    private static void applyLanguage(@NonNull Locale locale, Class<? extends Activity> activityClz, boolean isFollowSystem, boolean isNeedStartActivity) {
        if (locale == null) {
            throw new NullPointerException("Argument 'locale' of type Locale (#0 out of 4, zero-based) is marked by @androidx.annotation.NonNull but got null for it");
        }
        if (activityClz == null) {
            LanguageUtils.applyLanguage(locale, "", isFollowSystem, isNeedStartActivity);
            return;
        }
        LanguageUtils.applyLanguage(locale, activityClz.getName(), isFollowSystem, isNeedStartActivity);
    }

    private static void applyLanguage(@NonNull Locale locale, String activityClassName, boolean isFollowSystem, boolean isNeedStartActivity) {
        if (locale == null) {
            throw new NullPointerException("Argument 'locale' of type Locale (#0 out of 4, zero-based) is marked by @androidx.annotation.NonNull but got null for it");
        }
        if (isFollowSystem) {
            Utils.getSpUtils4Utils().put(KEY_LOCALE, VALUE_FOLLOW_SYSTEM);
        } else {
            String localLanguage = locale.getLanguage();
            String localCountry = locale.getCountry();
            Utils.getSpUtils4Utils().put(KEY_LOCALE, localLanguage + "$" + localCountry);
        }
        LanguageUtils.updateLanguage((Context)Utils.getApp(), locale);
        if (isNeedStartActivity) {
            Intent intent = new Intent();
            String realActivityClassName = TextUtils.isEmpty((CharSequence)activityClassName) ? LanguageUtils.getLauncherActivity() : activityClassName;
            intent.setComponent(new ComponentName((Context)Utils.getApp(), realActivityClassName));
            intent.addFlags(335577088);
            Utils.getApp().startActivity(intent);
        }
    }

    public static boolean isAppliedSystemLanguage() {
        return VALUE_FOLLOW_SYSTEM.equals(Utils.getSpUtils4Utils().getString(KEY_LOCALE));
    }

    public static boolean isAppliedLanguage() {
        return !TextUtils.isEmpty((CharSequence)Utils.getSpUtils4Utils().getString(KEY_LOCALE));
    }

    public static Locale getCurrentLocale() {
        return Utils.getApp().getResources().getConfiguration().locale;
    }

    static void applyLanguage(@NonNull Activity activity) {
        if (activity == null) {
            throw new NullPointerException("Argument 'activity' of type Activity (#0 out of 1, zero-based) is marked by @androidx.annotation.NonNull but got null for it");
        }
        String spLocale = Utils.getSpUtils4Utils().getString(KEY_LOCALE);
        if (TextUtils.isEmpty((CharSequence)spLocale)) {
            return;
        }
        if (VALUE_FOLLOW_SYSTEM.equals(spLocale)) {
            Locale sysLocale = Resources.getSystem().getConfiguration().locale;
            LanguageUtils.updateLanguage((Context)Utils.getApp(), sysLocale);
            LanguageUtils.updateLanguage((Context)activity, sysLocale);
            return;
        }
        String[] language_country = spLocale.split("\\$");
        if (language_country.length != 2) {
            Log.e((String)"LanguageUtils", (String)("The string of " + spLocale + " is not in the correct format."));
            return;
        }
        Locale settingLocale = new Locale(language_country[0], language_country[1]);
        LanguageUtils.updateLanguage((Context)Utils.getApp(), settingLocale);
        LanguageUtils.updateLanguage((Context)activity, settingLocale);
    }

    private static void updateLanguage(Context context, Locale locale) {
        Resources resources = context.getResources();
        Configuration config = resources.getConfiguration();
        Locale contextLocale = config.locale;
        if (LanguageUtils.equals(contextLocale.getLanguage(), locale.getLanguage()) && LanguageUtils.equals(contextLocale.getCountry(), locale.getCountry())) {
            return;
        }
        DisplayMetrics dm = resources.getDisplayMetrics();
        if (Build.VERSION.SDK_INT >= 17) {
            config.setLocale(locale);
            context.createConfigurationContext(config);
        } else {
            config.locale = locale;
        }
        resources.updateConfiguration(config, dm);
    }

    private static boolean equals(CharSequence s1, CharSequence s2) {
        int length;
        if (s1 == s2) {
            return true;
        }
        if (s1 != null && s2 != null && (length = s1.length()) == s2.length()) {
            if (s1 instanceof String && s2 instanceof String) {
                return s1.equals(s2);
            }
            for (int i = 0; i < length; ++i) {
                if (s1.charAt(i) == s2.charAt(i)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private static String getLauncherActivity() {
        Intent intent = new Intent("android.intent.action.MAIN", null);
        intent.addCategory("android.intent.category.LAUNCHER");
        intent.setPackage(Utils.getApp().getPackageName());
        PackageManager pm = Utils.getApp().getPackageManager();
        List info = pm.queryIntentActivities(intent, 0);
        ResolveInfo next = (ResolveInfo)info.iterator().next();
        if (next != null) {
            return next.activityInfo.name;
        }
        return "no launcher activity";
    }
}

