/*
 * Decompiled with CFR 0.152.
 */
package com.blankj.utilcode.util;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.os.Parcelable;
import androidx.annotation.RequiresPermission;
import androidx.core.content.FileProvider;
import com.blankj.utilcode.util.Utils;
import java.io.File;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;

public final class IntentUtils {
    private IntentUtils() {
        throw new UnsupportedOperationException("u can't instantiate me...");
    }

    public static boolean isIntentAvailable(Intent intent) {
        return Utils.getApp().getPackageManager().queryIntentActivities(intent, 65536).size() > 0;
    }

    public static Intent getInstallAppIntent(String filePath) {
        return IntentUtils.getInstallAppIntent(IntentUtils.getFileByPath(filePath), false);
    }

    public static Intent getInstallAppIntent(File file) {
        return IntentUtils.getInstallAppIntent(file, false);
    }

    public static Intent getInstallAppIntent(String filePath, boolean isNewTask) {
        return IntentUtils.getInstallAppIntent(IntentUtils.getFileByPath(filePath), isNewTask);
    }

    public static Intent getInstallAppIntent(File file, boolean isNewTask) {
        Uri data;
        if (file == null) {
            return null;
        }
        Intent intent = new Intent("android.intent.action.VIEW");
        String type = "application/vnd.android.package-archive";
        if (Build.VERSION.SDK_INT < 24) {
            data = Uri.fromFile((File)file);
        } else {
            intent.setFlags(1);
            String authority = Utils.getApp().getPackageName() + ".utilcode.provider";
            data = FileProvider.getUriForFile((Context)Utils.getApp(), (String)authority, (File)file);
        }
        intent.setDataAndType(data, type);
        return IntentUtils.getIntent(intent, isNewTask);
    }

    public static Intent getUninstallAppIntent(String packageName) {
        return IntentUtils.getUninstallAppIntent(packageName, false);
    }

    public static Intent getUninstallAppIntent(String packageName, boolean isNewTask) {
        Intent intent = new Intent("android.intent.action.DELETE");
        intent.setData(Uri.parse((String)("package:" + packageName)));
        return IntentUtils.getIntent(intent, isNewTask);
    }

    public static Intent getLaunchAppIntent(String packageName) {
        return IntentUtils.getLaunchAppIntent(packageName, false);
    }

    public static Intent getLaunchAppIntent(String packageName, boolean isNewTask) {
        Intent intent = Utils.getApp().getPackageManager().getLaunchIntentForPackage(packageName);
        if (intent == null) {
            return null;
        }
        return IntentUtils.getIntent(intent, isNewTask);
    }

    public static Intent getLaunchAppDetailsSettingsIntent(String packageName) {
        return IntentUtils.getLaunchAppDetailsSettingsIntent(packageName, false);
    }

    public static Intent getLaunchAppDetailsSettingsIntent(String packageName, boolean isNewTask) {
        Intent intent = new Intent("android.settings.APPLICATION_DETAILS_SETTINGS");
        intent.setData(Uri.parse((String)("package:" + packageName)));
        return IntentUtils.getIntent(intent, isNewTask);
    }

    public static Intent getShareTextIntent(String content) {
        return IntentUtils.getShareTextIntent(content, false);
    }

    public static Intent getShareTextIntent(String content, boolean isNewTask) {
        Intent intent = new Intent("android.intent.action.SEND");
        intent.setType("text/plain");
        intent.putExtra("android.intent.extra.TEXT", content);
        return IntentUtils.getIntent(intent, isNewTask);
    }

    public static Intent getShareImageIntent(String content, String imagePath) {
        return IntentUtils.getShareImageIntent(content, imagePath, false);
    }

    public static Intent getShareImageIntent(String content, String imagePath, boolean isNewTask) {
        if (imagePath == null || imagePath.length() == 0) {
            return null;
        }
        return IntentUtils.getShareImageIntent(content, new File(imagePath), isNewTask);
    }

    public static Intent getShareImageIntent(String content, File image) {
        return IntentUtils.getShareImageIntent(content, image, false);
    }

    public static Intent getShareImageIntent(String content, File image, boolean isNewTask) {
        if (image == null || !image.isFile()) {
            return null;
        }
        return IntentUtils.getShareImageIntent(content, IntentUtils.file2Uri(image), isNewTask);
    }

    public static Intent getShareImageIntent(String content, Uri uri) {
        return IntentUtils.getShareImageIntent(content, uri, false);
    }

    public static Intent getShareImageIntent(String content, Uri uri, boolean isNewTask) {
        Intent intent = new Intent("android.intent.action.SEND");
        intent.putExtra("android.intent.extra.TEXT", content);
        intent.putExtra("android.intent.extra.STREAM", (Parcelable)uri);
        intent.setType("image/*");
        return IntentUtils.getIntent(intent, isNewTask);
    }

    public static Intent getShareImageIntent(String content, LinkedList<String> imagePaths) {
        return IntentUtils.getShareImageIntent(content, imagePaths, false);
    }

    public static Intent getShareImageIntent(String content, LinkedList<String> imagePaths, boolean isNewTask) {
        if (imagePaths == null || imagePaths.isEmpty()) {
            return null;
        }
        ArrayList<File> files = new ArrayList<File>();
        for (String imagePath : imagePaths) {
            files.add(new File(imagePath));
        }
        return IntentUtils.getShareImageIntent(content, files, isNewTask);
    }

    public static Intent getShareImageIntent(String content, List<File> images) {
        return IntentUtils.getShareImageIntent(content, images, false);
    }

    public static Intent getShareImageIntent(String content, List<File> images, boolean isNewTask) {
        if (images == null || images.isEmpty()) {
            return null;
        }
        ArrayList<Uri> uris = new ArrayList<Uri>();
        for (File image : images) {
            if (!image.isFile()) continue;
            uris.add(IntentUtils.file2Uri(image));
        }
        return IntentUtils.getShareImageIntent(content, uris, isNewTask);
    }

    public static Intent getShareImageIntent(String content, ArrayList<Uri> uris) {
        return IntentUtils.getShareImageIntent(content, uris, false);
    }

    public static Intent getShareImageIntent(String content, ArrayList<Uri> uris, boolean isNewTask) {
        Intent intent = new Intent("android.intent.action.SEND_MULTIPLE");
        intent.putExtra("android.intent.extra.TEXT", content);
        intent.putParcelableArrayListExtra("android.intent.extra.STREAM", uris);
        intent.setType("image/*");
        return IntentUtils.getIntent(intent, isNewTask);
    }

    public static Intent getComponentIntent(String packageName, String className) {
        return IntentUtils.getComponentIntent(packageName, className, null, false);
    }

    public static Intent getComponentIntent(String packageName, String className, boolean isNewTask) {
        return IntentUtils.getComponentIntent(packageName, className, null, isNewTask);
    }

    public static Intent getComponentIntent(String packageName, String className, Bundle bundle) {
        return IntentUtils.getComponentIntent(packageName, className, bundle, false);
    }

    public static Intent getComponentIntent(String packageName, String className, Bundle bundle, boolean isNewTask) {
        Intent intent = new Intent("android.intent.action.VIEW");
        if (bundle != null) {
            intent.putExtras(bundle);
        }
        ComponentName cn = new ComponentName(packageName, className);
        intent.setComponent(cn);
        return IntentUtils.getIntent(intent, isNewTask);
    }

    public static Intent getShutdownIntent() {
        return IntentUtils.getShutdownIntent(false);
    }

    public static Intent getShutdownIntent(boolean isNewTask) {
        Intent intent = new Intent("android.intent.action.ACTION_REQUEST_SHUTDOWN");
        intent.putExtra("android.intent.extra.KEY_CONFIRM", false);
        return IntentUtils.getIntent(intent, isNewTask);
    }

    public static Intent getDialIntent(String phoneNumber) {
        return IntentUtils.getDialIntent(phoneNumber, false);
    }

    public static Intent getDialIntent(String phoneNumber, boolean isNewTask) {
        Intent intent = new Intent("android.intent.action.DIAL", Uri.parse((String)("tel:" + phoneNumber)));
        return IntentUtils.getIntent(intent, isNewTask);
    }

    @RequiresPermission(value="android.permission.CALL_PHONE")
    public static Intent getCallIntent(String phoneNumber) {
        return IntentUtils.getCallIntent(phoneNumber, false);
    }

    @RequiresPermission(value="android.permission.CALL_PHONE")
    public static Intent getCallIntent(String phoneNumber, boolean isNewTask) {
        Intent intent = new Intent("android.intent.action.CALL", Uri.parse((String)("tel:" + phoneNumber)));
        return IntentUtils.getIntent(intent, isNewTask);
    }

    public static Intent getSendSmsIntent(String phoneNumber, String content) {
        return IntentUtils.getSendSmsIntent(phoneNumber, content, false);
    }

    public static Intent getSendSmsIntent(String phoneNumber, String content, boolean isNewTask) {
        Uri uri = Uri.parse((String)("smsto:" + phoneNumber));
        Intent intent = new Intent("android.intent.action.SENDTO", uri);
        intent.putExtra("sms_body", content);
        return IntentUtils.getIntent(intent, isNewTask);
    }

    public static Intent getCaptureIntent(Uri outUri) {
        return IntentUtils.getCaptureIntent(outUri, false);
    }

    public static Intent getCaptureIntent(Uri outUri, boolean isNewTask) {
        Intent intent = new Intent("android.media.action.IMAGE_CAPTURE");
        intent.putExtra("output", (Parcelable)outUri);
        intent.addFlags(1);
        return IntentUtils.getIntent(intent, isNewTask);
    }

    private static Intent getIntent(Intent intent, boolean isNewTask) {
        return isNewTask ? intent.addFlags(0x10000000) : intent;
    }

    private static File getFileByPath(String filePath) {
        return IntentUtils.isSpace(filePath) ? null : new File(filePath);
    }

    private static boolean isSpace(String s) {
        if (s == null) {
            return true;
        }
        int len = s.length();
        for (int i = 0; i < len; ++i) {
            if (Character.isWhitespace(s.charAt(i))) continue;
            return false;
        }
        return true;
    }

    private static Uri file2Uri(File file) {
        if (file == null) {
            return null;
        }
        if (Build.VERSION.SDK_INT >= 24) {
            String authority = Utils.getApp().getPackageName() + ".utilcode.provider";
            return FileProvider.getUriForFile((Context)Utils.getApp(), (String)authority, (File)file);
        }
        return Uri.fromFile((File)file);
    }
}

