/*
 * Decompiled with CFR 0.152.
 */
package com.blankj.utilcode.util;

import android.content.ContentUris;
import android.content.Context;
import android.database.Cursor;
import android.net.Uri;
import android.os.Build;
import android.os.Environment;
import android.provider.DocumentsContract;
import android.provider.MediaStore;
import android.text.TextUtils;
import android.util.Log;
import androidx.annotation.NonNull;
import androidx.core.content.FileProvider;
import com.blankj.utilcode.util.Utils;
import java.io.File;

public final class UriUtils {
    private UriUtils() {
        throw new UnsupportedOperationException("u can't instantiate me...");
    }

    public static Uri file2Uri(@NonNull File file) {
        if (Build.VERSION.SDK_INT >= 24) {
            String authority = Utils.getApp().getPackageName() + ".utilcode.provider";
            return FileProvider.getUriForFile((Context)Utils.getApp(), (String)authority, (File)file);
        }
        return Uri.fromFile((File)file);
    }

    public static File uri2File(@NonNull Uri uri) {
        Log.d((String)"UriUtils", (String)uri.toString());
        String authority = uri.getAuthority();
        String scheme = uri.getScheme();
        if ("file".equals(scheme)) {
            String path = uri.getPath();
            if (path != null) {
                return new File(path);
            }
            Log.d((String)"UriUtils", (String)(uri.toString() + " parse failed. -> 0"));
            return null;
        }
        if (Build.VERSION.SDK_INT >= 19 && DocumentsContract.isDocumentUri((Context)Utils.getApp(), (Uri)uri)) {
            if ("com.android.externalstorage.documents".equals(authority)) {
                String docId = DocumentsContract.getDocumentId((Uri)uri);
                String[] split = docId.split(":");
                String type = split[0];
                if ("primary".equalsIgnoreCase(type)) {
                    return new File(Environment.getExternalStorageDirectory() + "/" + split[1]);
                }
                Log.d((String)"UriUtils", (String)(uri.toString() + " parse failed. -> 1"));
                return null;
            }
            if ("com.android.providers.downloads.documents".equals(authority)) {
                String id2 = DocumentsContract.getDocumentId((Uri)uri);
                if (!TextUtils.isEmpty((CharSequence)id2)) {
                    if (id2.startsWith("raw:")) {
                        return new File(id2.substring(4));
                    }
                    Uri contentUri = ContentUris.withAppendedId((Uri)Uri.parse((String)Environment.DIRECTORY_DOWNLOADS), (long)Long.valueOf(id2));
                    return UriUtils.getFileFromUri(contentUri, 2);
                }
                Log.d((String)"UriUtils", (String)(uri.toString() + " parse failed. -> 3"));
                return null;
            }
            if ("com.android.providers.media.documents".equals(authority)) {
                Uri contentUri;
                String docId = DocumentsContract.getDocumentId((Uri)uri);
                String[] split = docId.split(":");
                String type = split[0];
                if ("image".equals(type)) {
                    contentUri = MediaStore.Images.Media.EXTERNAL_CONTENT_URI;
                } else if ("video".equals(type)) {
                    contentUri = MediaStore.Video.Media.EXTERNAL_CONTENT_URI;
                } else if ("audio".equals(type)) {
                    contentUri = MediaStore.Audio.Media.EXTERNAL_CONTENT_URI;
                } else {
                    Log.d((String)"UriUtils", (String)(uri.toString() + " parse failed. -> 3"));
                    return null;
                }
                String selection = "_id=?";
                String[] selectionArgs = new String[]{split[1]};
                return UriUtils.getFileFromUri(contentUri, "_id=?", selectionArgs, 4);
            }
            if ("content".equals(scheme)) {
                return UriUtils.getFileFromUri(uri, 5);
            }
            Log.d((String)"UriUtils", (String)(uri.toString() + " parse failed. -> 6"));
            return null;
        }
        if ("content".equals(scheme)) {
            return UriUtils.getFileFromUri(uri, 7);
        }
        Log.d((String)"UriUtils", (String)(uri.toString() + " parse failed. -> 8"));
        return null;
    }

    private static File getFileFromUri(Uri uri, int code) {
        return UriUtils.getFileFromUri(uri, null, null, code);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static File getFileFromUri(Uri uri, String selection, String[] selectionArgs, int code) {
        Cursor cursor = Utils.getApp().getContentResolver().query(uri, new String[]{"_data"}, selection, selectionArgs, null);
        if (cursor == null) {
            Log.d((String)"UriUtils", (String)(uri.toString() + " parse failed(cursor is null). -> " + code));
            return null;
        }
        try {
            if (cursor.moveToFirst()) {
                int columnIndex = cursor.getColumnIndex("_data");
                if (columnIndex > -1) {
                    File file = new File(cursor.getString(columnIndex));
                    return file;
                }
                Log.d((String)"UriUtils", (String)(uri.toString() + " parse failed(columnIndex: " + columnIndex + " is wrong). -> " + code));
                File file = null;
                return file;
            }
            Log.d((String)"UriUtils", (String)(uri.toString() + " parse failed(moveToFirst return false). -> " + code));
            File columnIndex = null;
            return columnIndex;
        }
        catch (Exception e) {
            Log.d((String)"UriUtils", (String)(uri.toString() + " parse failed. -> " + code));
            File file = null;
            return file;
        }
        finally {
            cursor.close();
        }
    }
}

