/*
 * Decompiled with CFR 0.152.
 */
package com.blankj.utilcode.util;

import android.annotation.TargetApi;
import android.app.Activity;
import android.app.AppOpsManager;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.os.Process;
import android.provider.Settings;
import android.util.Log;
import android.view.MotionEvent;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import androidx.core.content.ContextCompat;
import com.blankj.utilcode.constant.PermissionConstants;
import com.blankj.utilcode.util.Utils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;

public final class PermissionUtils {
    private static final List<String> PERMISSIONS = PermissionUtils.getPermissions();
    private static PermissionUtils sInstance;
    private OnRationaleListener mOnRationaleListener;
    private SimpleCallback mSimpleCallback;
    private FullCallback mFullCallback;
    private ThemeCallback mThemeCallback;
    private Set<String> mPermissions = new LinkedHashSet<String>();
    private List<String> mPermissionsRequest;
    private List<String> mPermissionsGranted;
    private List<String> mPermissionsDenied;
    private List<String> mPermissionsDeniedForever;
    private static SimpleCallback sSimpleCallback4WriteSettings;
    private static SimpleCallback sSimpleCallback4DrawOverlays;

    public static List<String> getPermissions() {
        return PermissionUtils.getPermissions(Utils.getApp().getPackageName());
    }

    public static List<String> getPermissions(String packageName) {
        PackageManager pm = Utils.getApp().getPackageManager();
        try {
            return Arrays.asList(pm.getPackageInfo((String)packageName, (int)4096).requestedPermissions);
        }
        catch (PackageManager.NameNotFoundException e) {
            e.printStackTrace();
            return Collections.emptyList();
        }
    }

    public static boolean isGranted(String ... permissions) {
        for (String permission2 : permissions) {
            if (PermissionUtils.isGranted(permission2)) continue;
            return false;
        }
        return true;
    }

    private static boolean isGranted(String permission2) {
        return Build.VERSION.SDK_INT < 23 || 0 == ContextCompat.checkSelfPermission((Context)Utils.getApp(), (String)permission2);
    }

    @RequiresApi(api=23)
    public static boolean isGrantedWriteSettings() {
        return Settings.System.canWrite((Context)Utils.getApp());
    }

    @RequiresApi(api=23)
    public static void requestWriteSettings(SimpleCallback callback) {
        if (PermissionUtils.isGrantedWriteSettings()) {
            if (callback != null) {
                callback.onGranted();
            }
            return;
        }
        sSimpleCallback4WriteSettings = callback;
        PermissionActivity.start((Context)Utils.getApp(), 2);
    }

    @TargetApi(value=23)
    private static void startWriteSettingsActivity(Activity activity, int requestCode) {
        Intent intent = new Intent("android.settings.action.MANAGE_WRITE_SETTINGS");
        intent.setData(Uri.parse((String)("package:" + Utils.getApp().getPackageName())));
        if (!PermissionUtils.isIntentAvailable(intent)) {
            PermissionUtils.launchAppDetailsSettings();
            return;
        }
        activity.startActivityForResult(intent, requestCode);
    }

    @RequiresApi(api=23)
    public static boolean isGrantedDrawOverlays() {
        if (Build.VERSION.SDK_INT >= 26) {
            AppOpsManager aom = (AppOpsManager)Utils.getApp().getSystemService("appops");
            if (aom == null) {
                return false;
            }
            int mode = aom.checkOpNoThrow("android:system_alert_window", Process.myUid(), Utils.getApp().getPackageName());
            return mode == 0 || mode == 1;
        }
        return Settings.canDrawOverlays((Context)Utils.getApp());
    }

    @RequiresApi(api=23)
    public static void requestDrawOverlays(SimpleCallback callback) {
        if (PermissionUtils.isGrantedDrawOverlays()) {
            if (callback != null) {
                callback.onGranted();
            }
            return;
        }
        sSimpleCallback4DrawOverlays = callback;
        PermissionActivity.start((Context)Utils.getApp(), 3);
    }

    @TargetApi(value=23)
    private static void startOverlayPermissionActivity(Activity activity, int requestCode) {
        Intent intent = new Intent("android.settings.action.MANAGE_OVERLAY_PERMISSION");
        intent.setData(Uri.parse((String)("package:" + Utils.getApp().getPackageName())));
        if (!PermissionUtils.isIntentAvailable(intent)) {
            PermissionUtils.launchAppDetailsSettings();
            return;
        }
        activity.startActivityForResult(intent, requestCode);
    }

    public static void launchAppDetailsSettings() {
        Intent intent = new Intent("android.settings.APPLICATION_DETAILS_SETTINGS");
        intent.setData(Uri.parse((String)("package:" + Utils.getApp().getPackageName())));
        if (!PermissionUtils.isIntentAvailable(intent)) {
            return;
        }
        Utils.getApp().startActivity(intent.addFlags(0x10000000));
    }

    public static PermissionUtils permission(String ... permissions) {
        return new PermissionUtils(permissions);
    }

    private static boolean isIntentAvailable(Intent intent) {
        return Utils.getApp().getPackageManager().queryIntentActivities(intent, 65536).size() > 0;
    }

    private PermissionUtils(String ... permissions) {
        for (String permission2 : permissions) {
            for (String aPermission : PermissionConstants.getPermissions(permission2)) {
                if (!PERMISSIONS.contains(aPermission)) continue;
                this.mPermissions.add(aPermission);
            }
        }
        sInstance = this;
    }

    public PermissionUtils rationale(OnRationaleListener listener) {
        this.mOnRationaleListener = listener;
        return this;
    }

    public PermissionUtils callback(SimpleCallback callback) {
        this.mSimpleCallback = callback;
        return this;
    }

    public PermissionUtils callback(FullCallback callback) {
        this.mFullCallback = callback;
        return this;
    }

    public PermissionUtils theme(ThemeCallback callback) {
        this.mThemeCallback = callback;
        return this;
    }

    public void request() {
        this.mPermissionsGranted = new ArrayList<String>();
        this.mPermissionsRequest = new ArrayList<String>();
        if (Build.VERSION.SDK_INT < 23) {
            this.mPermissionsGranted.addAll(this.mPermissions);
            this.requestCallback();
        } else {
            for (String permission2 : this.mPermissions) {
                if (PermissionUtils.isGranted(permission2)) {
                    this.mPermissionsGranted.add(permission2);
                    continue;
                }
                this.mPermissionsRequest.add(permission2);
            }
            if (this.mPermissionsRequest.isEmpty()) {
                this.requestCallback();
            } else {
                this.startPermissionActivity();
            }
        }
    }

    @RequiresApi(api=23)
    private void startPermissionActivity() {
        this.mPermissionsDenied = new ArrayList<String>();
        this.mPermissionsDeniedForever = new ArrayList<String>();
        PermissionActivity.start((Context)Utils.getApp(), 1);
    }

    @RequiresApi(api=23)
    private boolean rationale(Activity activity) {
        boolean isRationale = false;
        if (this.mOnRationaleListener != null) {
            for (String permission2 : this.mPermissionsRequest) {
                if (!activity.shouldShowRequestPermissionRationale(permission2)) continue;
                this.getPermissionsStatus(activity);
                this.mOnRationaleListener.rationale(new OnRationaleListener.ShouldRequest(){

                    @Override
                    public void again(boolean again) {
                        if (again) {
                            PermissionUtils.this.startPermissionActivity();
                        } else {
                            PermissionUtils.this.requestCallback();
                        }
                    }
                });
                isRationale = true;
                break;
            }
            this.mOnRationaleListener = null;
        }
        return isRationale;
    }

    private void getPermissionsStatus(Activity activity) {
        for (String permission2 : this.mPermissionsRequest) {
            if (PermissionUtils.isGranted(permission2)) {
                this.mPermissionsGranted.add(permission2);
                continue;
            }
            this.mPermissionsDenied.add(permission2);
            if (activity.shouldShowRequestPermissionRationale(permission2)) continue;
            this.mPermissionsDeniedForever.add(permission2);
        }
    }

    private void requestCallback() {
        if (this.mSimpleCallback != null) {
            if (this.mPermissionsRequest.size() == 0 || this.mPermissions.size() == this.mPermissionsGranted.size()) {
                this.mSimpleCallback.onGranted();
            } else if (!this.mPermissionsDenied.isEmpty()) {
                this.mSimpleCallback.onDenied();
            }
            this.mSimpleCallback = null;
        }
        if (this.mFullCallback != null) {
            if (this.mPermissionsRequest.size() == 0 || this.mPermissions.size() == this.mPermissionsGranted.size()) {
                this.mFullCallback.onGranted(this.mPermissionsGranted);
            } else if (!this.mPermissionsDenied.isEmpty()) {
                this.mFullCallback.onDenied(this.mPermissionsDeniedForever, this.mPermissionsDenied);
            }
            this.mFullCallback = null;
        }
        this.mOnRationaleListener = null;
        this.mThemeCallback = null;
    }

    private void onRequestPermissionsResult(Activity activity) {
        this.getPermissionsStatus(activity);
        this.requestCallback();
    }

    public static interface ThemeCallback {
        public void onActivityCreate(Activity var1);
    }

    public static interface FullCallback {
        public void onGranted(List<String> var1);

        public void onDenied(List<String> var1, List<String> var2);
    }

    public static interface SimpleCallback {
        public void onGranted();

        public void onDenied();
    }

    public static interface OnRationaleListener {
        public void rationale(ShouldRequest var1);

        public static interface ShouldRequest {
            public void again(boolean var1);
        }
    }

    @RequiresApi(api=23)
    public static class PermissionActivity
    extends Activity {
        private static final String TYPE = "TYPE";
        public static final int TYPE_RUNTIME = 1;
        public static final int TYPE_WRITE_SETTINGS = 2;
        public static final int TYPE_DRAW_OVERLAYS = 3;

        public static void start(Context context, int type) {
            Intent starter = new Intent(context, PermissionActivity.class);
            starter.addFlags(0x10000000);
            starter.putExtra(TYPE, type);
            context.startActivity(starter);
        }

        protected void onCreate(@Nullable Bundle savedInstanceState) {
            this.getWindow().addFlags(262160);
            int byteExtra = this.getIntent().getIntExtra(TYPE, 1);
            if (byteExtra == 1) {
                if (sInstance == null) {
                    super.onCreate(savedInstanceState);
                    Log.e((String)"PermissionUtils", (String)"request permissions failed");
                    this.finish();
                    return;
                }
                if (sInstance.mThemeCallback != null) {
                    sInstance.mThemeCallback.onActivityCreate(this);
                }
                super.onCreate(savedInstanceState);
                if (sInstance.rationale(this)) {
                    this.finish();
                    return;
                }
                if (sInstance.mPermissionsRequest != null) {
                    int size = sInstance.mPermissionsRequest.size();
                    if (size <= 0) {
                        this.finish();
                        return;
                    }
                    this.requestPermissions(sInstance.mPermissionsRequest.toArray(new String[size]), 1);
                }
            } else if (byteExtra == 2) {
                super.onCreate(savedInstanceState);
                PermissionUtils.startWriteSettingsActivity(this, 2);
            } else if (byteExtra == 3) {
                super.onCreate(savedInstanceState);
                PermissionUtils.startOverlayPermissionActivity(this, 3);
            }
        }

        public void onRequestPermissionsResult(int requestCode, @NonNull String[] permissions, @NonNull int[] grantResults) {
            sInstance.onRequestPermissionsResult(this);
            this.finish();
        }

        public boolean dispatchTouchEvent(MotionEvent ev) {
            this.finish();
            return true;
        }

        protected void onActivityResult(int requestCode, int resultCode, Intent data) {
            if (requestCode == 2) {
                if (sSimpleCallback4WriteSettings == null) {
                    return;
                }
                if (PermissionUtils.isGrantedWriteSettings()) {
                    sSimpleCallback4WriteSettings.onGranted();
                } else {
                    sSimpleCallback4WriteSettings.onDenied();
                }
                sSimpleCallback4WriteSettings = null;
            } else if (requestCode == 3) {
                if (sSimpleCallback4DrawOverlays == null) {
                    return;
                }
                if (PermissionUtils.isGrantedDrawOverlays()) {
                    sSimpleCallback4DrawOverlays.onGranted();
                } else {
                    sSimpleCallback4DrawOverlays.onDenied();
                }
                sSimpleCallback4DrawOverlays = null;
            }
            this.finish();
        }
    }
}

