/*
 * Decompiled with CFR 0.152.
 */
package com.blankj.utilcode.util;

import android.os.Build;
import android.os.Environment;
import com.blankj.utilcode.util.Utils;
import java.io.File;

public class PathUtils {
    private PathUtils() {
        throw new UnsupportedOperationException("u can't instantiate me...");
    }

    public static String getRootPath() {
        return PathUtils.getAbsolutePath(Environment.getRootDirectory());
    }

    public static String getDataPath() {
        return PathUtils.getAbsolutePath(Environment.getDataDirectory());
    }

    public static String getDownloadCachePath() {
        return PathUtils.getAbsolutePath(Environment.getDownloadCacheDirectory());
    }

    public static String getInternalAppDataPath() {
        if (Build.VERSION.SDK_INT < 24) {
            return Utils.getApp().getApplicationInfo().dataDir;
        }
        return PathUtils.getAbsolutePath(Utils.getApp().getDataDir());
    }

    public static String getInternalAppCodeCacheDir() {
        if (Build.VERSION.SDK_INT < 21) {
            return Utils.getApp().getApplicationInfo().dataDir + "/code_cache";
        }
        return PathUtils.getAbsolutePath(Utils.getApp().getCodeCacheDir());
    }

    public static String getInternalAppCachePath() {
        return PathUtils.getAbsolutePath(Utils.getApp().getCacheDir());
    }

    public static String getInternalAppDbsPath() {
        return Utils.getApp().getApplicationInfo().dataDir + "/databases";
    }

    public static String getInternalAppDbPath(String name) {
        return PathUtils.getAbsolutePath(Utils.getApp().getDatabasePath(name));
    }

    public static String getInternalAppFilesPath() {
        return PathUtils.getAbsolutePath(Utils.getApp().getFilesDir());
    }

    public static String getInternalAppSpPath() {
        return Utils.getApp().getApplicationInfo().dataDir + "shared_prefs";
    }

    public static String getInternalAppNoBackupFilesPath() {
        if (Build.VERSION.SDK_INT < 21) {
            return Utils.getApp().getApplicationInfo().dataDir + "no_backup";
        }
        return PathUtils.getAbsolutePath(Utils.getApp().getNoBackupFilesDir());
    }

    public static String getExternalStoragePath() {
        if (PathUtils.isExternalStorageDisable()) {
            return "";
        }
        return PathUtils.getAbsolutePath(Environment.getExternalStorageDirectory());
    }

    public static String getExternalMusicPath() {
        if (PathUtils.isExternalStorageDisable()) {
            return "";
        }
        return PathUtils.getAbsolutePath(Environment.getExternalStoragePublicDirectory((String)Environment.DIRECTORY_MUSIC));
    }

    public static String getExternalPodcastsPath() {
        if (PathUtils.isExternalStorageDisable()) {
            return "";
        }
        return PathUtils.getAbsolutePath(Environment.getExternalStoragePublicDirectory((String)Environment.DIRECTORY_PODCASTS));
    }

    public static String getExternalRingtonesPath() {
        if (PathUtils.isExternalStorageDisable()) {
            return "";
        }
        return PathUtils.getAbsolutePath(Environment.getExternalStoragePublicDirectory((String)Environment.DIRECTORY_RINGTONES));
    }

    public static String getExternalAlarmsPath() {
        if (PathUtils.isExternalStorageDisable()) {
            return "";
        }
        return PathUtils.getAbsolutePath(Environment.getExternalStoragePublicDirectory((String)Environment.DIRECTORY_ALARMS));
    }

    public static String getExternalNotificationsPath() {
        if (PathUtils.isExternalStorageDisable()) {
            return "";
        }
        return PathUtils.getAbsolutePath(Environment.getExternalStoragePublicDirectory((String)Environment.DIRECTORY_NOTIFICATIONS));
    }

    public static String getExternalPicturesPath() {
        if (PathUtils.isExternalStorageDisable()) {
            return "";
        }
        return PathUtils.getAbsolutePath(Environment.getExternalStoragePublicDirectory((String)Environment.DIRECTORY_PICTURES));
    }

    public static String getExternalMoviesPath() {
        if (PathUtils.isExternalStorageDisable()) {
            return "";
        }
        return PathUtils.getAbsolutePath(Environment.getExternalStoragePublicDirectory((String)Environment.DIRECTORY_MOVIES));
    }

    public static String getExternalDownloadsPath() {
        if (PathUtils.isExternalStorageDisable()) {
            return "";
        }
        return PathUtils.getAbsolutePath(Environment.getExternalStoragePublicDirectory((String)Environment.DIRECTORY_DOWNLOADS));
    }

    public static String getExternalDcimPath() {
        if (PathUtils.isExternalStorageDisable()) {
            return "";
        }
        return PathUtils.getAbsolutePath(Environment.getExternalStoragePublicDirectory((String)Environment.DIRECTORY_DCIM));
    }

    public static String getExternalDocumentsPath() {
        if (PathUtils.isExternalStorageDisable()) {
            return "";
        }
        if (Build.VERSION.SDK_INT < 19) {
            return PathUtils.getAbsolutePath(Environment.getExternalStorageDirectory()) + "/Documents";
        }
        return PathUtils.getAbsolutePath(Environment.getExternalStoragePublicDirectory((String)Environment.DIRECTORY_DOCUMENTS));
    }

    public static String getExternalAppDataPath() {
        if (PathUtils.isExternalStorageDisable()) {
            return "";
        }
        File externalCacheDir = Utils.getApp().getExternalCacheDir();
        if (externalCacheDir == null) {
            return "";
        }
        return PathUtils.getAbsolutePath(externalCacheDir.getParentFile());
    }

    public static String getExternalAppCachePath() {
        if (PathUtils.isExternalStorageDisable()) {
            return "";
        }
        return PathUtils.getAbsolutePath(Utils.getApp().getExternalCacheDir());
    }

    public static String getExternalAppFilesPath() {
        if (PathUtils.isExternalStorageDisable()) {
            return "";
        }
        return PathUtils.getAbsolutePath(Utils.getApp().getExternalFilesDir(null));
    }

    public static String getExternalAppMusicPath() {
        if (PathUtils.isExternalStorageDisable()) {
            return "";
        }
        return PathUtils.getAbsolutePath(Utils.getApp().getExternalFilesDir(Environment.DIRECTORY_MUSIC));
    }

    public static String getExternalAppPodcastsPath() {
        if (PathUtils.isExternalStorageDisable()) {
            return "";
        }
        return PathUtils.getAbsolutePath(Utils.getApp().getExternalFilesDir(Environment.DIRECTORY_PODCASTS));
    }

    public static String getExternalAppRingtonesPath() {
        if (PathUtils.isExternalStorageDisable()) {
            return "";
        }
        return PathUtils.getAbsolutePath(Utils.getApp().getExternalFilesDir(Environment.DIRECTORY_RINGTONES));
    }

    public static String getExternalAppAlarmsPath() {
        if (PathUtils.isExternalStorageDisable()) {
            return "";
        }
        return PathUtils.getAbsolutePath(Utils.getApp().getExternalFilesDir(Environment.DIRECTORY_ALARMS));
    }

    public static String getExternalAppNotificationsPath() {
        if (PathUtils.isExternalStorageDisable()) {
            return "";
        }
        return PathUtils.getAbsolutePath(Utils.getApp().getExternalFilesDir(Environment.DIRECTORY_NOTIFICATIONS));
    }

    public static String getExternalAppPicturesPath() {
        if (PathUtils.isExternalStorageDisable()) {
            return "";
        }
        return PathUtils.getAbsolutePath(Utils.getApp().getExternalFilesDir(Environment.DIRECTORY_PICTURES));
    }

    public static String getExternalAppMoviesPath() {
        if (PathUtils.isExternalStorageDisable()) {
            return "";
        }
        return PathUtils.getAbsolutePath(Utils.getApp().getExternalFilesDir(Environment.DIRECTORY_MOVIES));
    }

    public static String getExternalAppDownloadPath() {
        if (PathUtils.isExternalStorageDisable()) {
            return "";
        }
        return PathUtils.getAbsolutePath(Utils.getApp().getExternalFilesDir(Environment.DIRECTORY_DOWNLOADS));
    }

    public static String getExternalAppDcimPath() {
        if (PathUtils.isExternalStorageDisable()) {
            return "";
        }
        return PathUtils.getAbsolutePath(Utils.getApp().getExternalFilesDir(Environment.DIRECTORY_DCIM));
    }

    public static String getExternalAppDocumentsPath() {
        if (PathUtils.isExternalStorageDisable()) {
            return "";
        }
        if (Build.VERSION.SDK_INT < 19) {
            return PathUtils.getAbsolutePath(Utils.getApp().getExternalFilesDir(null)) + "/Documents";
        }
        return PathUtils.getAbsolutePath(Utils.getApp().getExternalFilesDir(Environment.DIRECTORY_DOCUMENTS));
    }

    public static String getExternalAppObbPath() {
        if (PathUtils.isExternalStorageDisable()) {
            return "";
        }
        return PathUtils.getAbsolutePath(Utils.getApp().getObbDir());
    }

    private static boolean isExternalStorageDisable() {
        return !"mounted".equals(Environment.getExternalStorageState());
    }

    private static String getAbsolutePath(File file) {
        if (file == null) {
            return "";
        }
        return file.getAbsolutePath();
    }
}

