/*
 * Decompiled with CFR 0.152.
 */
package com.blankj.utilcode.util;

import android.app.Notification;
import android.app.NotificationManager;
import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import androidx.annotation.Nullable;
import androidx.core.app.NotificationCompat;
import androidx.core.app.NotificationManagerCompat;
import com.blankj.utilcode.util.Utils;

public class NotificationUtils {
    private NotificationUtils() {
        throw new UnsupportedOperationException("u can't instantiate me...");
    }

    public static void create(Context context, int id2, Intent intent, int smallIcon, String contentTitle, String contentText) {
        NotificationManager manager = (NotificationManager)context.getSystemService("notification");
        PendingIntent p = PendingIntent.getActivity((Context)Utils.getApp(), (int)0, (Intent)intent, (int)0x8000000);
        NotificationCompat.Builder builder = new NotificationCompat.Builder(context).setContentIntent(p).setContentTitle((CharSequence)contentTitle).setContentText((CharSequence)contentText).setSmallIcon(smallIcon).setAutoCancel(true);
        Notification n = builder.build();
        manager.notify(id2, n);
    }

    public static void createStackNotification(Context context, int id2, String groupId, Intent intent, int smallIcon, String contentTitle, String contentText) {
        NotificationManager manager = (NotificationManager)context.getSystemService("notification");
        PendingIntent p = intent != null ? PendingIntent.getActivity((Context)Utils.getApp(), (int)0, (Intent)intent, (int)0x8000000) : null;
        NotificationCompat.Builder builder = new NotificationCompat.Builder(context).setContentIntent(p).setContentTitle((CharSequence)contentTitle).setContentText((CharSequence)contentText).setSmallIcon(smallIcon).setGroup(groupId).setAutoCancel(true);
        Notification n = builder.build();
        manager.notify(id2, n);
    }

    public static void create(int smallIcon, String contentTitle, String contentText) {
        NotificationManager manager = (NotificationManager)Utils.getApp().getSystemService("notification");
        NotificationCompat.Builder builder = new NotificationCompat.Builder((Context)Utils.getApp()).setContentTitle((CharSequence)contentTitle).setContentText((CharSequence)contentText).setSmallIcon(smallIcon).setAutoCancel(true);
        Notification n = builder.build();
        manager.notify(0, n);
    }

    public static void cancel(@Nullable String tag, int id2) {
        NotificationManagerCompat.from((Context)Utils.getApp()).cancel(tag, id2);
    }

    public static void cancel(int id2) {
        NotificationManagerCompat.from((Context)Utils.getApp()).cancel(id2);
    }

    public static void cancelAll() {
        NotificationManagerCompat.from((Context)Utils.getApp()).cancelAll();
    }
}

