/*
 * Decompiled with CFR 0.152.
 */
package com.blankj.utilcode.util;

import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.List;

public final class FileIOUtils {
    private static int sBufferSize = 8192;

    private FileIOUtils() {
        throw new UnsupportedOperationException("u can't instantiate me...");
    }

    public static boolean writeFileFromIS(String filePath, InputStream is) {
        return FileIOUtils.writeFileFromIS(FileIOUtils.getFileByPath(filePath), is, false);
    }

    public static boolean writeFileFromIS(String filePath, InputStream is, boolean append) {
        return FileIOUtils.writeFileFromIS(FileIOUtils.getFileByPath(filePath), is, append);
    }

    public static boolean writeFileFromIS(File file, InputStream is) {
        return FileIOUtils.writeFileFromIS(file, is, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean writeFileFromIS(File file, InputStream is, boolean append) {
        if (!FileIOUtils.createOrExistsFile(file) || is == null) {
            return false;
        }
        BufferedOutputStream os = null;
        try {
            int len;
            os = new BufferedOutputStream(new FileOutputStream(file, append));
            byte[] data = new byte[sBufferSize];
            while ((len = is.read(data)) != -1) {
                ((OutputStream)os).write(data, 0, len);
            }
            boolean bl = true;
            return bl;
        }
        catch (IOException e) {
            e.printStackTrace();
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                is.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            try {
                if (os != null) {
                    ((OutputStream)os).close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static boolean writeFileFromBytesByStream(String filePath, byte[] bytes) {
        return FileIOUtils.writeFileFromBytesByStream(FileIOUtils.getFileByPath(filePath), bytes, false);
    }

    public static boolean writeFileFromBytesByStream(String filePath, byte[] bytes, boolean append) {
        return FileIOUtils.writeFileFromBytesByStream(FileIOUtils.getFileByPath(filePath), bytes, append);
    }

    public static boolean writeFileFromBytesByStream(File file, byte[] bytes) {
        return FileIOUtils.writeFileFromBytesByStream(file, bytes, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean writeFileFromBytesByStream(File file, byte[] bytes, boolean append) {
        if (bytes == null || !FileIOUtils.createOrExistsFile(file)) {
            return false;
        }
        FilterOutputStream bos = null;
        try {
            bos = new BufferedOutputStream(new FileOutputStream(file, append));
            bos.write(bytes);
            boolean bl = true;
            return bl;
        }
        catch (IOException e) {
            e.printStackTrace();
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                if (bos != null) {
                    bos.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static boolean writeFileFromBytesByChannel(String filePath, byte[] bytes, boolean isForce) {
        return FileIOUtils.writeFileFromBytesByChannel(FileIOUtils.getFileByPath(filePath), bytes, false, isForce);
    }

    public static boolean writeFileFromBytesByChannel(String filePath, byte[] bytes, boolean append, boolean isForce) {
        return FileIOUtils.writeFileFromBytesByChannel(FileIOUtils.getFileByPath(filePath), bytes, append, isForce);
    }

    public static boolean writeFileFromBytesByChannel(File file, byte[] bytes, boolean isForce) {
        return FileIOUtils.writeFileFromBytesByChannel(file, bytes, false, isForce);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean writeFileFromBytesByChannel(File file, byte[] bytes, boolean append, boolean isForce) {
        if (bytes == null) {
            return false;
        }
        FileChannel fc = null;
        try {
            fc = new FileOutputStream(file, append).getChannel();
            fc.position(fc.size());
            fc.write(ByteBuffer.wrap(bytes));
            if (isForce) {
                fc.force(true);
            }
            boolean bl = true;
            return bl;
        }
        catch (IOException e) {
            e.printStackTrace();
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                if (fc != null) {
                    fc.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static boolean writeFileFromBytesByMap(String filePath, byte[] bytes, boolean isForce) {
        return FileIOUtils.writeFileFromBytesByMap(filePath, bytes, false, isForce);
    }

    public static boolean writeFileFromBytesByMap(String filePath, byte[] bytes, boolean append, boolean isForce) {
        return FileIOUtils.writeFileFromBytesByMap(FileIOUtils.getFileByPath(filePath), bytes, append, isForce);
    }

    public static boolean writeFileFromBytesByMap(File file, byte[] bytes, boolean isForce) {
        return FileIOUtils.writeFileFromBytesByMap(file, bytes, false, isForce);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean writeFileFromBytesByMap(File file, byte[] bytes, boolean append, boolean isForce) {
        if (bytes == null || !FileIOUtils.createOrExistsFile(file)) {
            return false;
        }
        FileChannel fc = null;
        try {
            fc = new FileOutputStream(file, append).getChannel();
            MappedByteBuffer mbb = fc.map(FileChannel.MapMode.READ_WRITE, fc.size(), bytes.length);
            mbb.put(bytes);
            if (isForce) {
                mbb.force();
            }
            boolean bl = true;
            return bl;
        }
        catch (IOException e) {
            e.printStackTrace();
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                if (fc != null) {
                    fc.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static boolean writeFileFromString(String filePath, String content) {
        return FileIOUtils.writeFileFromString(FileIOUtils.getFileByPath(filePath), content, false);
    }

    public static boolean writeFileFromString(String filePath, String content, boolean append) {
        return FileIOUtils.writeFileFromString(FileIOUtils.getFileByPath(filePath), content, append);
    }

    public static boolean writeFileFromString(File file, String content) {
        return FileIOUtils.writeFileFromString(file, content, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean writeFileFromString(File file, String content, boolean append) {
        if (file == null || content == null) {
            return false;
        }
        if (!FileIOUtils.createOrExistsFile(file)) {
            return false;
        }
        BufferedWriter bw = null;
        try {
            bw = new BufferedWriter(new FileWriter(file, append));
            bw.write(content);
            boolean bl = true;
            return bl;
        }
        catch (IOException e) {
            e.printStackTrace();
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                if (bw != null) {
                    bw.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static List<String> readFile2List(String filePath) {
        return FileIOUtils.readFile2List(FileIOUtils.getFileByPath(filePath), null);
    }

    public static List<String> readFile2List(String filePath, String charsetName) {
        return FileIOUtils.readFile2List(FileIOUtils.getFileByPath(filePath), charsetName);
    }

    public static List<String> readFile2List(File file) {
        return FileIOUtils.readFile2List(file, 0, Integer.MAX_VALUE, null);
    }

    public static List<String> readFile2List(File file, String charsetName) {
        return FileIOUtils.readFile2List(file, 0, Integer.MAX_VALUE, charsetName);
    }

    public static List<String> readFile2List(String filePath, int st, int end) {
        return FileIOUtils.readFile2List(FileIOUtils.getFileByPath(filePath), st, end, null);
    }

    public static List<String> readFile2List(String filePath, int st, int end, String charsetName) {
        return FileIOUtils.readFile2List(FileIOUtils.getFileByPath(filePath), st, end, charsetName);
    }

    public static List<String> readFile2List(File file, int st, int end) {
        return FileIOUtils.readFile2List(file, st, end, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<String> readFile2List(File file, int st, int end, String charsetName) {
        if (!FileIOUtils.isFileExists(file)) {
            return null;
        }
        if (st > end) {
            return null;
        }
        BufferedReader reader = null;
        try {
            String line;
            ArrayList<String> list = new ArrayList<String>();
            reader = FileIOUtils.isSpace(charsetName) ? new BufferedReader(new InputStreamReader(new FileInputStream(file))) : new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), charsetName));
            for (int curLine = 1; (line = reader.readLine()) != null && curLine <= end; ++curLine) {
                if (st > curLine || curLine > end) continue;
                list.add(line);
            }
            ArrayList<String> arrayList = list;
            return arrayList;
        }
        catch (IOException e) {
            e.printStackTrace();
            List<String> list = null;
            return list;
        }
        finally {
            try {
                if (reader != null) {
                    reader.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static String readFile2String(String filePath) {
        return FileIOUtils.readFile2String(FileIOUtils.getFileByPath(filePath), null);
    }

    public static String readFile2String(String filePath, String charsetName) {
        return FileIOUtils.readFile2String(FileIOUtils.getFileByPath(filePath), charsetName);
    }

    public static String readFile2String(File file) {
        return FileIOUtils.readFile2String(file, null);
    }

    public static String readFile2String(File file, String charsetName) {
        byte[] bytes = FileIOUtils.readFile2BytesByStream(file);
        if (bytes == null) {
            return null;
        }
        if (FileIOUtils.isSpace(charsetName)) {
            return new String(bytes);
        }
        try {
            return new String(bytes, charsetName);
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return "";
        }
    }

    public static byte[] readFile2BytesByStream(String filePath) {
        return FileIOUtils.readFile2BytesByStream(FileIOUtils.getFileByPath(filePath));
    }

    public static byte[] readFile2BytesByStream(File file) {
        if (!FileIOUtils.isFileExists(file)) {
            return null;
        }
        try {
            return FileIOUtils.is2Bytes(new FileInputStream(file));
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static byte[] readFile2BytesByChannel(String filePath) {
        return FileIOUtils.readFile2BytesByChannel(FileIOUtils.getFileByPath(filePath));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] readFile2BytesByChannel(File file) {
        if (!FileIOUtils.isFileExists(file)) {
            return null;
        }
        FileChannel fc = null;
        try {
            fc = new RandomAccessFile(file, "r").getChannel();
            ByteBuffer byteBuffer = ByteBuffer.allocate((int)fc.size());
            while (fc.read(byteBuffer) > 0) {
            }
            byte[] byArray = byteBuffer.array();
            return byArray;
        }
        catch (IOException e) {
            e.printStackTrace();
            byte[] byArray = null;
            return byArray;
        }
        finally {
            try {
                if (fc != null) {
                    fc.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static byte[] readFile2BytesByMap(String filePath) {
        return FileIOUtils.readFile2BytesByMap(FileIOUtils.getFileByPath(filePath));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] readFile2BytesByMap(File file) {
        if (!FileIOUtils.isFileExists(file)) {
            return null;
        }
        FileChannel fc = null;
        try {
            fc = new RandomAccessFile(file, "r").getChannel();
            int size = (int)fc.size();
            MappedByteBuffer mbb = fc.map(FileChannel.MapMode.READ_ONLY, 0L, size).load();
            byte[] result = new byte[size];
            mbb.get(result, 0, size);
            byte[] byArray = result;
            return byArray;
        }
        catch (IOException e) {
            e.printStackTrace();
            byte[] byArray = null;
            return byArray;
        }
        finally {
            try {
                if (fc != null) {
                    fc.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static void setBufferSize(int bufferSize) {
        sBufferSize = bufferSize;
    }

    private static File getFileByPath(String filePath) {
        return FileIOUtils.isSpace(filePath) ? null : new File(filePath);
    }

    private static boolean createOrExistsFile(String filePath) {
        return FileIOUtils.createOrExistsFile(FileIOUtils.getFileByPath(filePath));
    }

    private static boolean createOrExistsFile(File file) {
        if (file == null) {
            return false;
        }
        if (file.exists()) {
            return file.isFile();
        }
        if (!FileIOUtils.createOrExistsDir(file.getParentFile())) {
            return false;
        }
        try {
            return file.createNewFile();
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
    }

    private static boolean createOrExistsDir(File file) {
        return file != null && (file.exists() ? file.isDirectory() : file.mkdirs());
    }

    private static boolean isFileExists(File file) {
        return file != null && file.exists();
    }

    private static boolean isSpace(String s) {
        if (s == null) {
            return true;
        }
        int len = s.length();
        for (int i = 0; i < len; ++i) {
            if (Character.isWhitespace(s.charAt(i))) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static byte[] is2Bytes(InputStream is) {
        if (is == null) {
            return null;
        }
        ByteArrayOutputStream os = null;
        try {
            int len;
            os = new ByteArrayOutputStream();
            byte[] b = new byte[sBufferSize];
            while ((len = is.read(b, 0, sBufferSize)) != -1) {
                os.write(b, 0, len);
            }
            byte[] byArray = os.toByteArray();
            return byArray;
        }
        catch (IOException e) {
            e.printStackTrace();
            byte[] byArray = null;
            return byArray;
        }
        finally {
            try {
                is.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            try {
                if (os != null) {
                    os.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}

