/*
 * Decompiled with CFR 0.152.
 */
package com.blankj.utilcode.util;

import android.app.Activity;
import android.content.Context;
import android.content.ContextWrapper;
import android.content.res.Resources;
import android.graphics.Point;
import android.os.Build;
import android.util.DisplayMetrics;
import android.util.Log;
import android.util.TypedValue;
import android.view.Display;
import android.view.KeyCharacterMap;
import android.view.View;
import android.view.ViewConfiguration;
import android.view.ViewGroup;
import android.view.Window;
import android.view.WindowManager;
import androidx.annotation.ColorInt;
import androidx.annotation.NonNull;
import androidx.annotation.RequiresApi;
import androidx.annotation.RequiresPermission;
import androidx.drawerlayout.widget.DrawerLayout;
import com.blankj.utilcode.util.Utils;
import java.lang.reflect.Method;

public final class BarUtils {
    private static final String TAG_STATUS_BAR = "TAG_STATUS_BAR";
    private static final String TAG_OFFSET = "TAG_OFFSET";
    private static final int KEY_OFFSET = -123;

    private BarUtils() {
        throw new UnsupportedOperationException("u can't instantiate me...");
    }

    public static int getStatusBarHeight() {
        Resources resources = Resources.getSystem();
        int resourceId = resources.getIdentifier("status_bar_height", "dimen", "android");
        return resources.getDimensionPixelSize(resourceId);
    }

    public static void setStatusBarVisibility(@NonNull Activity activity, boolean isVisible) {
        BarUtils.setStatusBarVisibility(activity.getWindow(), isVisible);
    }

    public static void setStatusBarVisibility(@NonNull Window window, boolean isVisible) {
        if (isVisible) {
            window.clearFlags(1024);
            BarUtils.showStatusBarView(window);
            BarUtils.addMarginTopEqualStatusBarHeight(window);
        } else {
            window.addFlags(1024);
            BarUtils.hideStatusBarView(window);
            BarUtils.subtractMarginTopEqualStatusBarHeight(window);
        }
    }

    public static boolean isStatusBarVisible(@NonNull Activity activity) {
        int flags = activity.getWindow().getAttributes().flags;
        return (flags & 0x400) == 0;
    }

    public static void setStatusBarLightMode(@NonNull Activity activity, boolean isLightMode) {
        BarUtils.setStatusBarLightMode(activity.getWindow(), isLightMode);
    }

    public static void setStatusBarLightMode(@NonNull Window window, boolean isLightMode) {
        View decorView;
        if (Build.VERSION.SDK_INT >= 23 && (decorView = window.getDecorView()) != null) {
            int vis = decorView.getSystemUiVisibility();
            vis = isLightMode ? (vis |= 0x2000) : (vis &= 0xFFFFDFFF);
            decorView.setSystemUiVisibility(vis);
        }
    }

    public static boolean isStatusBarLightMode(@NonNull Activity activity) {
        return BarUtils.isStatusBarLightMode(activity.getWindow());
    }

    public static boolean isStatusBarLightMode(@NonNull Window window) {
        View decorView;
        if (Build.VERSION.SDK_INT >= 23 && (decorView = window.getDecorView()) != null) {
            int vis = decorView.getSystemUiVisibility();
            return (vis & 0x2000) != 0;
        }
        return false;
    }

    public static void addMarginTopEqualStatusBarHeight(@NonNull View view) {
        if (Build.VERSION.SDK_INT < 19) {
            return;
        }
        view.setTag((Object)TAG_OFFSET);
        Object haveSetOffset = view.getTag(-123);
        if (haveSetOffset != null && ((Boolean)haveSetOffset).booleanValue()) {
            return;
        }
        ViewGroup.MarginLayoutParams layoutParams = (ViewGroup.MarginLayoutParams)view.getLayoutParams();
        layoutParams.setMargins(layoutParams.leftMargin, layoutParams.topMargin + BarUtils.getStatusBarHeight(), layoutParams.rightMargin, layoutParams.bottomMargin);
        view.setTag(-123, (Object)true);
    }

    public static void subtractMarginTopEqualStatusBarHeight(@NonNull View view) {
        if (Build.VERSION.SDK_INT < 19) {
            return;
        }
        Object haveSetOffset = view.getTag(-123);
        if (haveSetOffset == null || !((Boolean)haveSetOffset).booleanValue()) {
            return;
        }
        ViewGroup.MarginLayoutParams layoutParams = (ViewGroup.MarginLayoutParams)view.getLayoutParams();
        layoutParams.setMargins(layoutParams.leftMargin, layoutParams.topMargin - BarUtils.getStatusBarHeight(), layoutParams.rightMargin, layoutParams.bottomMargin);
        view.setTag(-123, (Object)false);
    }

    private static void addMarginTopEqualStatusBarHeight(Window window) {
        if (Build.VERSION.SDK_INT < 19) {
            return;
        }
        View withTag = window.getDecorView().findViewWithTag((Object)TAG_OFFSET);
        if (withTag == null) {
            return;
        }
        BarUtils.addMarginTopEqualStatusBarHeight(withTag);
    }

    private static void subtractMarginTopEqualStatusBarHeight(Window window) {
        if (Build.VERSION.SDK_INT < 19) {
            return;
        }
        View withTag = window.getDecorView().findViewWithTag((Object)TAG_OFFSET);
        if (withTag == null) {
            return;
        }
        BarUtils.subtractMarginTopEqualStatusBarHeight(withTag);
    }

    public static View setStatusBarColor(@NonNull Activity activity, @ColorInt int color) {
        return BarUtils.setStatusBarColor(activity, color, false);
    }

    public static View setStatusBarColor(@NonNull Activity activity, @ColorInt int color, boolean isDecor) {
        if (Build.VERSION.SDK_INT < 19) {
            return null;
        }
        BarUtils.transparentStatusBar(activity);
        return BarUtils.applyStatusBarColor(activity, color, isDecor);
    }

    public static void setStatusBarColor(@NonNull View fakeStatusBar, @ColorInt int color) {
        if (Build.VERSION.SDK_INT < 19) {
            return;
        }
        Activity activity = BarUtils.getActivityByView(fakeStatusBar);
        if (activity == null) {
            return;
        }
        BarUtils.transparentStatusBar(activity);
        fakeStatusBar.setVisibility(0);
        ViewGroup.LayoutParams layoutParams = fakeStatusBar.getLayoutParams();
        layoutParams.width = -1;
        layoutParams.height = BarUtils.getStatusBarHeight();
        fakeStatusBar.setBackgroundColor(color);
    }

    public static void setStatusBarCustom(@NonNull View fakeStatusBar) {
        if (Build.VERSION.SDK_INT < 19) {
            return;
        }
        Activity activity = BarUtils.getActivityByView(fakeStatusBar);
        if (activity == null) {
            return;
        }
        BarUtils.transparentStatusBar(activity);
        fakeStatusBar.setVisibility(0);
        ViewGroup.LayoutParams layoutParams = fakeStatusBar.getLayoutParams();
        if (layoutParams == null) {
            layoutParams = new ViewGroup.LayoutParams(-1, BarUtils.getStatusBarHeight());
            fakeStatusBar.setLayoutParams(layoutParams);
        } else {
            layoutParams.width = -1;
            layoutParams.height = BarUtils.getStatusBarHeight();
        }
    }

    public static void setStatusBarColor4Drawer(@NonNull DrawerLayout drawer, @NonNull View fakeStatusBar, @ColorInt int color) {
        BarUtils.setStatusBarColor4Drawer(drawer, fakeStatusBar, color, false);
    }

    public static void setStatusBarColor4Drawer(@NonNull DrawerLayout drawer, @NonNull View fakeStatusBar, @ColorInt int color, boolean isTop) {
        if (Build.VERSION.SDK_INT < 19) {
            return;
        }
        Activity activity = BarUtils.getActivityByView(fakeStatusBar);
        if (activity == null) {
            return;
        }
        BarUtils.transparentStatusBar(activity);
        drawer.setFitsSystemWindows(false);
        BarUtils.setStatusBarColor(fakeStatusBar, color);
        int count = drawer.getChildCount();
        for (int i = 0; i < count; ++i) {
            drawer.getChildAt(i).setFitsSystemWindows(false);
        }
        if (isTop) {
            BarUtils.hideStatusBarView(activity);
        } else {
            BarUtils.setStatusBarColor(activity, color, false);
        }
    }

    private static View applyStatusBarColor(Activity activity, int color, boolean isDecor) {
        ViewGroup parent = isDecor ? (ViewGroup)activity.getWindow().getDecorView() : (ViewGroup)activity.findViewById(0x1020002);
        View fakeStatusBarView = parent.findViewWithTag((Object)TAG_STATUS_BAR);
        if (fakeStatusBarView != null) {
            if (fakeStatusBarView.getVisibility() == 8) {
                fakeStatusBarView.setVisibility(0);
            }
            fakeStatusBarView.setBackgroundColor(color);
        } else {
            fakeStatusBarView = BarUtils.createStatusBarView(activity, color);
            parent.addView(fakeStatusBarView);
        }
        return fakeStatusBarView;
    }

    private static void hideStatusBarView(Activity activity) {
        BarUtils.hideStatusBarView(activity.getWindow());
    }

    private static void hideStatusBarView(Window window) {
        ViewGroup decorView = (ViewGroup)window.getDecorView();
        View fakeStatusBarView = decorView.findViewWithTag((Object)TAG_STATUS_BAR);
        if (fakeStatusBarView == null) {
            return;
        }
        fakeStatusBarView.setVisibility(8);
    }

    private static void showStatusBarView(Window window) {
        ViewGroup decorView = (ViewGroup)window.getDecorView();
        View fakeStatusBarView = decorView.findViewWithTag((Object)TAG_STATUS_BAR);
        if (fakeStatusBarView == null) {
            return;
        }
        fakeStatusBarView.setVisibility(0);
    }

    private static View createStatusBarView(Activity activity, int color) {
        View statusBarView = new View((Context)activity);
        statusBarView.setLayoutParams(new ViewGroup.LayoutParams(-1, BarUtils.getStatusBarHeight()));
        statusBarView.setBackgroundColor(color);
        statusBarView.setTag((Object)TAG_STATUS_BAR);
        return statusBarView;
    }

    private static void transparentStatusBar(Activity activity) {
        if (Build.VERSION.SDK_INT < 19) {
            return;
        }
        Window window = activity.getWindow();
        if (Build.VERSION.SDK_INT >= 21) {
            window.addFlags(Integer.MIN_VALUE);
            int option = 1280;
            if (Build.VERSION.SDK_INT >= 23) {
                int vis = window.getDecorView().getSystemUiVisibility() & 0x2000;
                window.getDecorView().setSystemUiVisibility(option | vis);
            } else {
                window.getDecorView().setSystemUiVisibility(option);
            }
            window.setStatusBarColor(0);
        } else {
            window.addFlags(0x4000000);
        }
    }

    public static int getActionBarHeight() {
        TypedValue tv = new TypedValue();
        if (Utils.getApp().getTheme().resolveAttribute(16843499, tv, true)) {
            return TypedValue.complexToDimensionPixelSize((int)tv.data, (DisplayMetrics)Utils.getApp().getResources().getDisplayMetrics());
        }
        return 0;
    }

    @RequiresPermission(value="android.permission.EXPAND_STATUS_BAR")
    public static void setNotificationBarVisibility(boolean isVisible) {
        String methodName = isVisible ? (Build.VERSION.SDK_INT <= 16 ? "expand" : "expandNotificationsPanel") : (Build.VERSION.SDK_INT <= 16 ? "collapse" : "collapsePanels");
        BarUtils.invokePanels(methodName);
    }

    private static void invokePanels(String methodName) {
        try {
            Object service = Utils.getApp().getSystemService("statusbar");
            Class<?> statusBarManager = Class.forName("android.app.StatusBarManager");
            Method expand = statusBarManager.getMethod(methodName, new Class[0]);
            expand.invoke(service, new Object[0]);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static int getNavBarHeight() {
        Resources res = Resources.getSystem();
        int resourceId = res.getIdentifier("navigation_bar_height", "dimen", "android");
        if (resourceId != 0) {
            return res.getDimensionPixelSize(resourceId);
        }
        return 0;
    }

    public static void setNavBarVisibility(@NonNull Activity activity, boolean isVisible) {
        if (Build.VERSION.SDK_INT < 19) {
            return;
        }
        BarUtils.setNavBarVisibility(activity.getWindow(), isVisible);
    }

    public static void setNavBarVisibility(@NonNull Window window, boolean isVisible) {
        if (Build.VERSION.SDK_INT < 19) {
            return;
        }
        ViewGroup decorView = (ViewGroup)window.getDecorView();
        int count = decorView.getChildCount();
        for (int i = 0; i < count; ++i) {
            String resourceEntryName;
            View child = decorView.getChildAt(i);
            int id2 = child.getId();
            if (id2 == -1 || !"navigationBarBackground".equals(resourceEntryName = Utils.getApp().getResources().getResourceEntryName(id2))) continue;
            child.setVisibility(isVisible ? 0 : 4);
        }
        int uiOptions = 4610;
        if (isVisible) {
            decorView.setSystemUiVisibility(decorView.getSystemUiVisibility() & 0xFFFFEDFD);
        } else {
            decorView.setSystemUiVisibility(decorView.getSystemUiVisibility() | 0x1202);
        }
    }

    public static boolean isNavBarVisible(@NonNull Activity activity) {
        return BarUtils.isNavBarVisible(activity.getWindow());
    }

    public static boolean isNavBarVisible(@NonNull Window window) {
        boolean isVisible = false;
        ViewGroup decorView = (ViewGroup)window.getDecorView();
        int count = decorView.getChildCount();
        for (int i = 0; i < count; ++i) {
            String resourceEntryName;
            View child = decorView.getChildAt(i);
            int id2 = child.getId();
            if (id2 == -1 || !"navigationBarBackground".equals(resourceEntryName = Utils.getApp().getResources().getResourceEntryName(id2)) || child.getVisibility() != 0) continue;
            isVisible = true;
            break;
        }
        if (isVisible) {
            int visibility = decorView.getSystemUiVisibility();
            isVisible = (visibility & 2) == 0;
        }
        return isVisible;
    }

    @RequiresApi(value=21)
    public static void setNavBarColor(@NonNull Activity activity, @ColorInt int color) {
        BarUtils.setNavBarColor(activity.getWindow(), color);
    }

    @RequiresApi(value=21)
    public static void setNavBarColor(@NonNull Window window, @ColorInt int color) {
        window.setNavigationBarColor(color);
    }

    @RequiresApi(value=21)
    public static int getNavBarColor(@NonNull Activity activity) {
        return BarUtils.getNavBarColor(activity.getWindow());
    }

    @RequiresApi(value=21)
    public static int getNavBarColor(@NonNull Window window) {
        return window.getNavigationBarColor();
    }

    public static boolean isSupportNavBar() {
        if (Build.VERSION.SDK_INT >= 17) {
            WindowManager wm = (WindowManager)Utils.getApp().getSystemService("window");
            if (wm == null) {
                return false;
            }
            Display display = wm.getDefaultDisplay();
            Point size = new Point();
            Point realSize = new Point();
            display.getSize(size);
            display.getRealSize(realSize);
            return realSize.y != size.y || realSize.x != size.x;
        }
        boolean menu = ViewConfiguration.get((Context)Utils.getApp()).hasPermanentMenuKey();
        boolean back = KeyCharacterMap.deviceHasKey((int)4);
        return !menu && !back;
    }

    private static Activity getActivityByView(@NonNull View view) {
        Context context = view.getContext();
        while (context instanceof ContextWrapper) {
            if (context instanceof Activity) {
                return (Activity)context;
            }
            context = ((ContextWrapper)context).getBaseContext();
        }
        Log.e((String)"BarUtils", (String)"the view's Context is not an Activity.");
        return null;
    }
}

