/*
 * Decompiled with CFR 0.152.
 */
package com.blankj.utilcode.util;

import android.view.View;
import androidx.annotation.IntRange;
import androidx.annotation.NonNull;

public final class AntiShakeUtils {
    private static final long DEFAULT_DURATION = 200L;
    private static final int TAG_KEY = 0x7EFFFFFF;

    private AntiShakeUtils() {
        throw new UnsupportedOperationException("u can't instantiate me...");
    }

    public static boolean isValid(@NonNull View view) {
        return AntiShakeUtils.isValid(view, 200L);
    }

    public static boolean isValid(@NonNull View view, @IntRange(from=0L) long duration) {
        long curTime = System.currentTimeMillis();
        Object tag = view.getTag(0x7EFFFFFF);
        if (!(tag instanceof Long)) {
            view.setTag(0x7EFFFFFF, (Object)curTime);
            return true;
        }
        long preTime = (Long)tag;
        if (curTime - preTime <= duration) {
            return false;
        }
        view.setTag(0x7EFFFFFF, (Object)curTime);
        return true;
    }
}

